/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.kourend;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.CombatLevelRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KOUREND_HARD)
public class KourendHard
extends ComplexStateQuestHelper {
    ItemRequirement adamantiteOre;
    ItemRequirement coal;
    ItemRequirement bootsOfStone;
    ItemRequirement pickaxe;
    ItemRequirement lightSource;
    ItemRequirement xericsTalisman;
    ItemRequirement lockpick;
    ItemRequirement seedDibber;
    ItemRequirement astralRune;
    ItemRequirement cosmicRune;
    ItemRequirement mindRune;
    ItemRequirement wateringCan;
    ItemRequirement spade;
    ItemRequirement artifact;
    ItemRequirement logavanoSeeds;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement antipoison;
    ItemRequirement kharedstsMemoirs;
    ItemRequirement dramenStaff;
    ItemRequirement skillsNecklace;
    ItemRequirement radasBlessing;
    ItemRequirement shayzienHelmet;
    ItemRequirement shayzienBody;
    ItemRequirement shayzienGreaves;
    ItemRequirement shayzienBoots;
    ItemRequirement shayzienGloves;
    Requirement architecturalAlliance;
    Requirement dreamMentor;
    Requirement theForsakenTower;
    Requirement shayzienFavour;
    Requirement hosidiusFavour75;
    Requirement hosidiusFavour100;
    Requirement lovakengjFavour;
    Requirement piscariliusFavour;
    Requirement lunarBook;
    Requirement notWoodcuttingGuild;
    Requirement notSmeltAddyBar;
    Requirement notKillLizardmanShaman;
    Requirement notMineLovakite;
    Requirement notPlantLogavano;
    Requirement notKillZombie;
    Requirement notTeleportHeart;
    Requirement notDeliverArtifact;
    Requirement notKillWyrm;
    Requirement notExamineMonster;
    QuestStep enterForsakenTower;
    QuestStep smeltAddyBar;
    QuestStep enterLizardmanTemple;
    QuestStep killLizardmanShaman;
    QuestStep mineLovakiteOre;
    QuestStep searchSeedTable;
    QuestStep enterTitheFarm;
    QuestStep plantLogavanoSeed;
    QuestStep entershayzienCrypt;
    QuestStep killZombie;
    QuestStep teleportToHeart;
    QuestStep enterMountKaruulmDungeon;
    QuestStep enterWyrmArea;
    QuestStep killWyrm;
    QuestStep claimReward;
    ObjectStep enterWoodcuttingGuild;
    NpcStep castMonsterExamine;
    NpcStep talkToCaptainKhaled;
    NpcStep deliverArtifact;
    ZoneRequirement inForsakenTower;
    ZoneRequirement inLizardmanTemple;
    ZoneRequirement inTitheFarm;
    ZoneRequirement inshayzienCrypt;
    ZoneRequirement inMountKaruulmDungeon;
    ZoneRequirement inWyrmArea;
    Zone forsakenTower;
    Zone lizardmanTemple;
    Zone titheFarm;
    Zone shayzienCrypt;
    Zone mountKaruulmDungeon;
    Zone wyrmArea;
    ConditionalStep woodcuttingGuildTask;
    ConditionalStep smeltAddyBarTask;
    ConditionalStep killLizardmanShamanTask;
    ConditionalStep mineLovakiteTask;
    ConditionalStep plantLogavanoTask;
    ConditionalStep killZombieTask;
    ConditionalStep teleportHeartTask;
    ConditionalStep deliverArtifactTask;
    ConditionalStep killWyrmTask;
    ConditionalStep examineMonsterTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.deliverArtifactTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToCaptainKhaled, new Requirement[0]);
        this.deliverArtifactTask.addStep(new Conditions(this.artifact), this.deliverArtifact);
        doHard.addStep(this.notDeliverArtifact, this.deliverArtifactTask);
        this.plantLogavanoTask = new ConditionalStep((QuestHelper)this, this.searchSeedTable, new Requirement[0]);
        this.plantLogavanoTask.addStep(this.logavanoSeeds, this.enterTitheFarm);
        this.plantLogavanoTask.addStep(this.inTitheFarm, this.plantLogavanoSeed);
        doHard.addStep(this.notPlantLogavano, this.plantLogavanoTask);
        this.woodcuttingGuildTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWoodcuttingGuild, new Requirement[0]);
        doHard.addStep(this.notWoodcuttingGuild, this.woodcuttingGuildTask);
        this.killZombieTask = new ConditionalStep((QuestHelper)this, this.entershayzienCrypt, new Requirement[0]);
        this.killZombieTask.addStep(this.inshayzienCrypt, this.killZombie);
        doHard.addStep(this.notKillZombie, this.killZombieTask);
        this.mineLovakiteTask = new ConditionalStep((QuestHelper)this, this.mineLovakiteOre, new Requirement[0]);
        doHard.addStep(this.notMineLovakite, this.mineLovakiteTask);
        this.smeltAddyBarTask = new ConditionalStep((QuestHelper)this, this.enterForsakenTower, new Requirement[0]);
        this.smeltAddyBarTask.addStep(this.inForsakenTower, this.smeltAddyBar);
        doHard.addStep(this.notSmeltAddyBar, this.smeltAddyBarTask);
        this.killWyrmTask = new ConditionalStep((QuestHelper)this, this.enterMountKaruulmDungeon, new Requirement[0]);
        this.killWyrmTask.addStep(this.inMountKaruulmDungeon, this.enterWyrmArea);
        this.killWyrmTask.addStep(this.inWyrmArea, this.killWyrm);
        doHard.addStep(this.notKillWyrm, this.killWyrmTask);
        this.killLizardmanShamanTask = new ConditionalStep((QuestHelper)this, this.enterLizardmanTemple, new Requirement[0]);
        this.killLizardmanShamanTask.addStep(this.inLizardmanTemple, this.killLizardmanShaman);
        doHard.addStep(this.notKillLizardmanShaman, this.killLizardmanShamanTask);
        this.examineMonsterTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.castMonsterExamine, new Requirement[0]);
        doHard.addStep(this.notExamineMonster, this.examineMonsterTask);
        this.teleportHeartTask = new ConditionalStep((QuestHelper)this, this.teleportToHeart, new Requirement[0]);
        doHard.addStep(this.notTeleportHeart, this.teleportHeartTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notWoodcuttingGuild = new VarplayerRequirement(2085, false, 26);
        this.notSmeltAddyBar = new VarplayerRequirement(2085, false, 27);
        this.notKillLizardmanShaman = new VarplayerRequirement(2085, false, 28);
        this.notMineLovakite = new VarplayerRequirement(2085, false, 29);
        this.notPlantLogavano = new VarplayerRequirement(2085, false, 31);
        this.notKillZombie = new VarplayerRequirement(2085, false, 30);
        this.notTeleportHeart = new VarplayerRequirement(2086, false, 0);
        this.notDeliverArtifact = new VarplayerRequirement(2086, false, 1);
        this.notKillWyrm = new VarplayerRequirement(2086, false, 2);
        this.notExamineMonster = new VarplayerRequirement(2086, false, 3);
        this.lunarBook = new SpellbookRequirement(Spellbook.LUNAR);
        this.adamantiteOre = new ItemRequirement("Adamantite ore", 449).showConditioned(this.notSmeltAddyBar);
        this.coal = new ItemRequirement("Coal", 453).showConditioned(this.notSmeltAddyBar);
        this.bootsOfStone = new ItemRequirement("Boots of stone", ItemCollections.STONE_BOOTS).showConditioned(this.notKillWyrm).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notMineLovakite).isNotConsumed();
        this.lightSource = new ItemRequirement("Light source", ItemCollections.LIGHT_SOURCES).showConditioned(this.notKillZombie).isNotConsumed();
        this.xericsTalisman = new ItemRequirement("Xeric's Talisman", Arrays.asList(13393, 22708)).showConditioned(this.notTeleportHeart).isNotConsumed();
        this.xericsTalisman.setTooltip("Obtained from Lizardmen as a rare drop and charged with a Lizardman fang");
        this.lockpick = new ItemRequirement("Lockpick", 1523).showConditioned(this.notDeliverArtifact).isNotConsumed();
        this.seedDibber = new ItemRequirement("Seed dibber", 5343).showConditioned(this.notPlantLogavano).isNotConsumed();
        this.astralRune = new ItemRequirement("Astral rune", 9075).showConditioned(this.notExamineMonster);
        this.cosmicRune = new ItemRequirement("Cosmic rune", 564).showConditioned(this.notExamineMonster);
        this.mindRune = new ItemRequirement("Mind rune", 558).showConditioned(this.notExamineMonster);
        this.wateringCan = new ItemRequirement("Watering can", ItemCollections.WATERING_CANS).showConditioned(this.notPlantLogavano).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notPlantLogavano).isNotConsumed();
        this.artifact = new ItemRequirement("Artifact", 11049).showConditioned(this.notDeliverArtifact);
        this.logavanoSeeds = new ItemRequirement("Logavano seeds", 13425).showConditioned(this.notPlantLogavano);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.antipoison = new ItemRequirement("Anti-poison", ItemCollections.ANTIPOISONS, -1).showConditioned(this.notKillLizardmanShaman);
        this.dramenStaff = new ItemRequirement("Dramen or Lunar staff", ItemCollections.FAIRY_STAFF, -1).isNotConsumed();
        this.kharedstsMemoirs = new ItemRequirement("Kharedst's Memoirs or Book of the Dead", Arrays.asList(25818, 21760), -1).isNotConsumed();
        this.radasBlessing = new ItemRequirement("Rada's Blessing", Arrays.asList(22941, 22943), -1).showConditioned(this.notWoodcuttingGuild).isNotConsumed();
        this.skillsNecklace = new ItemRequirement("Skills necklace", ItemCollections.SKILLS_NECKLACES, -1).isNotConsumed();
        this.shayzienHelmet = new ItemRequirement("Shayzien Helmet (5)", 13379).showConditioned(this.notKillLizardmanShaman).isNotConsumed();
        this.shayzienBody = new ItemRequirement("Shayzien Body (5)", 13381).showConditioned(this.notKillLizardmanShaman).isNotConsumed();
        this.shayzienGreaves = new ItemRequirement("Shayzien Greaves (5)", 13380).showConditioned(this.notKillLizardmanShaman).isNotConsumed();
        this.shayzienBoots = new ItemRequirement("Shayzien Boots (5)", 13378).showConditioned(this.notKillLizardmanShaman).isNotConsumed();
        this.shayzienGloves = new ItemRequirement("Shayzien Gloves (5)", 13377).showConditioned(this.notKillLizardmanShaman).isNotConsumed();
        this.architecturalAlliance = new QuestRequirement(QuestHelperQuest.ARCHITECTURAL_ALLIANCE, QuestState.FINISHED);
        this.dreamMentor = new QuestRequirement(QuestHelperQuest.DREAM_MENTOR, QuestState.FINISHED);
        this.theForsakenTower = new QuestRequirement(QuestHelperQuest.THE_FORSAKEN_TOWER, QuestState.FINISHED);
        this.shayzienFavour = new FavourRequirement(Favour.SHAYZIEN, 100);
        this.hosidiusFavour75 = new FavourRequirement(Favour.HOSIDIUS, 100);
        this.hosidiusFavour100 = new FavourRequirement(Favour.HOSIDIUS, 100);
        this.lovakengjFavour = new FavourRequirement(Favour.LOVAKENGJ, 30);
        this.piscariliusFavour = new FavourRequirement(Favour.PISCARILIUS, 75);
        this.inForsakenTower = new ZoneRequirement(this.forsakenTower);
        this.inLizardmanTemple = new ZoneRequirement(this.lizardmanTemple);
        this.inTitheFarm = new ZoneRequirement(this.titheFarm);
        this.inshayzienCrypt = new ZoneRequirement(this.shayzienCrypt);
        this.inMountKaruulmDungeon = new ZoneRequirement(this.mountKaruulmDungeon);
        this.inWyrmArea = new ZoneRequirement(this.wyrmArea);
    }

    public void loadZones() {
        this.forsakenTower = new Zone(new WorldPoint(1377, 3829, 0), new WorldPoint(1388, 3817, 0));
        this.lizardmanTemple = new Zone(new WorldPoint(1289, 10100, 0), new WorldPoint(1333, 10067, 0));
        this.titheFarm = new Zone(new WorldPoint(13596, 4724, 0), new WorldPoint(13632, 4688, 0));
        this.shayzienCrypt = new Zone(new WorldPoint(1473, 9974, 3), new WorldPoint(1516, 9928, 3));
        this.mountKaruulmDungeon = new Zone(new WorldPoint(1303, 10210, 0), new WorldPoint(1320, 10187, 0));
        this.wyrmArea = new Zone(new WorldPoint(1255, 10207, 0), new WorldPoint(1302, 10174, 0));
    }

    public void setupSteps() {
        this.enterWoodcuttingGuild = new ObjectStep((QuestHelper)this, 28851, new WorldPoint(1657, 3505, 0), "Enter the Woodcutting Guild.", true, new Requirement[0]);
        this.enterWoodcuttingGuild.addAlternateObjects(28852);
        this.enterForsakenTower = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1382, 3818, 0), "Enter the Forsaken Tower.", this.adamantiteOre, this.coal.quantity(6));
        this.smeltAddyBar = new ObjectStep((QuestHelper)this, 34591, "Smelt an adamantite bar.", this.adamantiteOre, this.coal.quantity(6));
        this.smeltAddyBar.addSubSteps(this.enterForsakenTower);
        this.enterLizardmanTemple = new ObjectStep((QuestHelper)this, 34405, new WorldPoint(1312, 3686, 0), "Enter the lizardman temple.", this.shayzienHelmet.equipped(), this.shayzienBody.equipped(), this.shayzienGreaves.equipped(), this.shayzienBoots.equipped(), this.shayzienGloves.equipped(), this.antipoison, this.combatGear);
        this.killLizardmanShaman = new NpcStep((QuestHelper)this, 8565, new WorldPoint(1292, 10096, 0), "Kill a Lizardman Shaman.", this.shayzienFavour, this.shayzienHelmet.equipped(), this.shayzienBody.equipped(), this.shayzienGreaves.equipped(), this.shayzienBoots.equipped(), this.shayzienGloves.equipped(), this.antipoison, this.combatGear);
        this.mineLovakiteOre = new ObjectStep((QuestHelper)this, 28597, new WorldPoint(1438, 3816, 0), "Mine some lovakite ore.", this.pickaxe);
        this.searchSeedTable = new ObjectStep((QuestHelper)this, 27430, new WorldPoint(1802, 3503, 0), "Take some logavano seeds from the table in the Tithe Farm entrance.", new Requirement[0]);
        this.searchSeedTable.addDialogStep("Logavano seed (level 74)");
        this.enterTitheFarm = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1806, 3501, 0), "Enter the Tithe Farm.", new Requirement[0]);
        this.plantLogavanoSeed = new ObjectStep((QuestHelper)this, 27383, new WorldPoint(6692, 867, 0), "Plant the logavano seeds in any available farming patch.", true, this.seedDibber, this.spade, this.wateringCan, this.logavanoSeeds);
        this.plantLogavanoSeed.addIcon(13425);
        this.entershayzienCrypt = new ObjectStep((QuestHelper)this, 32403, new WorldPoint(1483, 3548, 0), "Enter the shayzien crypt.", this.lightSource);
        this.killZombie = new NpcStep((QuestHelper)this, 8068, new WorldPoint(1491, 9949, 3), "Kill a zombie in the shayzien crypt.", this.combatGear, this.food);
        this.killZombie.addSubSteps(this.entershayzienCrypt);
        this.teleportToHeart = new ItemStep((QuestHelper)this, "Teleport to Xeric's Heart using the Xeric's Talisman", this.xericsTalisman.highlighted());
        this.talkToCaptainKhaled = new NpcStep((QuestHelper)this, 6971, new WorldPoint(1845, 3753, 0), "Talk to Captain Khaled to receive a job.", this.piscariliusFavour);
        this.talkToCaptainKhaled.addAlternateNpcs(6972);
        this.talkToCaptainKhaled.addDialogStep("Looking for any help?");
        this.talkToCaptainKhaled.addDialogStep("I have what it takes.");
        this.deliverArtifact = new NpcStep((QuestHelper)this, 6971, new WorldPoint(1845, 3753, 0), "Deliver the stolen artifact to Captain Khaled.", this.lockpick, this.artifact);
        this.enterMountKaruulmDungeon = new ObjectStep((QuestHelper)this, 34359, new WorldPoint(1311, 3807, 0), "Enter the Mount Karuulm Slayer Dungeon.", this.bootsOfStone.equipped(), this.combatGear, this.food);
        this.enterWyrmArea = new ObjectStep((QuestHelper)this, 34544, new WorldPoint(1302, 10205, 0), "Enter the wyrm area.", this.bootsOfStone.equipped());
        this.killWyrm = new NpcStep((QuestHelper)this, 8610, new WorldPoint(1282, 10189, 0), "Kill a wyrm.", this.combatGear, this.food);
        this.killWyrm.addSubSteps(this.enterMountKaruulmDungeon, this.enterWyrmArea);
        this.castMonsterExamine = new NpcStep((QuestHelper)this, 936, new WorldPoint(1240, 3515, 0), "Cast Monster Examine on a Mountain Troll.", this.lunarBook, this.astralRune, this.cosmicRune, this.mindRune);
        this.castMonsterExamine.addAlternateNpcs(937, 938, 939, 941);
        this.claimReward = new NpcStep((QuestHelper)this, 8538, new WorldPoint(1647, 3665, 0), "Talk to Elise in the Kourend castle courtyard to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Kill a Lizardman Shaman (level 150)", "Kill a Zombie (level 132)", "Kill a Wyrm (level 99)");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.adamantiteOre, this.coal.quantity(6), this.bootsOfStone, this.pickaxe, this.lightSource, this.xericsTalisman, this.lockpick, this.seedDibber, this.astralRune.quantity(1), this.cosmicRune.quantity(1), this.mindRune.quantity(1), this.wateringCan, this.spade, this.shayzienHelmet, this.shayzienBody, this.shayzienGreaves, this.shayzienBoots, this.shayzienGloves);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.food, this.antipoison, this.kharedstsMemoirs, this.dramenStaff, this.skillsNecklace, this.radasBlessing);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new CombatLevelRequirement(85));
        req.add(new SkillRequirement(Skill.FARMING, 74, true));
        req.add(new SkillRequirement(Skill.MAGIC, 66, true));
        req.add(new SkillRequirement(Skill.MINING, 65, true));
        req.add(new SkillRequirement(Skill.SLAYER, 62, true));
        req.add(new SkillRequirement(Skill.SMITHING, 70, true));
        req.add(new SkillRequirement(Skill.THIEVING, 49));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 60));
        req.add(this.shayzienFavour);
        req.add(this.hosidiusFavour100);
        req.add(this.lovakengjFavour);
        req.add(this.piscariliusFavour);
        req.add(this.architecturalAlliance);
        req.add(this.dreamMentor);
        req.add(this.theForsakenTower);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Rada's Blessing (3)", 22945, 1), new ItemReward("Ash sanctifier", 25781, 1), new ItemReward("15,000 Exp. Lamp (Any skill over 50)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Slayer helmet will work as a shayzien helm (5) after talking to Captain Cleive."), new UnlockReward("5% increased chance to save a harvest life at the Hosidius and Farming Guild herb patches."), new UnlockReward("40 free Dynamite per day from Thirus"), new UnlockReward("Reduced tanning prices at Eodan in Forthos Dungeon to 40%."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails deliverArtifactStep = new PanelDetails("Deliver an artifact", Arrays.asList(this.talkToCaptainKhaled, this.deliverArtifact), new SkillRequirement(Skill.THIEVING, 49), this.piscariliusFavour, this.lockpick);
        deliverArtifactStep.setDisplayCondition(this.notDeliverArtifact);
        deliverArtifactStep.setLockingStep(this.deliverArtifactTask);
        allSteps.add(deliverArtifactStep);
        PanelDetails plantLogavanoStep = new PanelDetails("Plant some logavano seeds", Arrays.asList(this.searchSeedTable, this.enterTitheFarm, this.plantLogavanoSeed), new SkillRequirement(Skill.FARMING, 74), this.hosidiusFavour100, this.seedDibber, this.spade, this.wateringCan, this.logavanoSeeds);
        plantLogavanoStep.setDisplayCondition(this.notPlantLogavano);
        plantLogavanoStep.setLockingStep(this.plantLogavanoTask);
        allSteps.add(plantLogavanoStep);
        PanelDetails woodcuttingGuildStep = new PanelDetails("Enter the woodcutting guild", Collections.singletonList(this.enterWoodcuttingGuild), new SkillRequirement(Skill.WOODCUTTING, 60), this.hosidiusFavour75);
        woodcuttingGuildStep.setDisplayCondition(this.notWoodcuttingGuild);
        woodcuttingGuildStep.setLockingStep(this.woodcuttingGuildTask);
        allSteps.add(woodcuttingGuildStep);
        PanelDetails killZombieStep = new PanelDetails("Kill a zombie in the crypt", Arrays.asList(this.entershayzienCrypt, this.killZombie), this.lightSource, this.combatGear, this.food);
        killZombieStep.setDisplayCondition(this.notKillZombie);
        killZombieStep.setLockingStep(this.killZombieTask);
        allSteps.add(killZombieStep);
        PanelDetails mineLovakiteStep = new PanelDetails("Mine some lovakite", Collections.singletonList(this.mineLovakiteOre), this.lovakengjFavour, this.pickaxe);
        mineLovakiteStep.setDisplayCondition(this.notMineLovakite);
        mineLovakiteStep.setLockingStep(this.mineLovakiteTask);
        allSteps.add(mineLovakiteStep);
        PanelDetails smeltBarStep = new PanelDetails("Smelt some adamantite", Arrays.asList(this.enterForsakenTower, this.smeltAddyBar), new SkillRequirement(Skill.SMITHING, 70), this.theForsakenTower, this.adamantiteOre, this.coal.quantity(6));
        smeltBarStep.setDisplayCondition(this.notSmeltAddyBar);
        smeltBarStep.setLockingStep(this.smeltAddyBarTask);
        allSteps.add(smeltBarStep);
        PanelDetails killWyrmStep = new PanelDetails("Slay a wyrm", Arrays.asList(this.enterMountKaruulmDungeon, this.enterWyrmArea, this.killWyrm), new SkillRequirement(Skill.SLAYER, 62), this.combatGear, this.food, this.bootsOfStone);
        killWyrmStep.setDisplayCondition(this.notKillWyrm);
        killWyrmStep.setLockingStep(this.killWyrmTask);
        allSteps.add(killWyrmStep);
        PanelDetails killShamanStep = new PanelDetails("Kill a lizardman shaman", Arrays.asList(this.enterLizardmanTemple, this.killLizardmanShaman), this.shayzienFavour, this.shayzienHelmet, this.shayzienBody, this.shayzienGreaves, this.shayzienBoots, this.shayzienGloves, this.antipoison, this.combatGear);
        killShamanStep.setDisplayCondition(this.notKillLizardmanShaman);
        killShamanStep.setLockingStep(this.killLizardmanShamanTask);
        allSteps.add(killShamanStep);
        PanelDetails examineMonsterStep = new PanelDetails("Cast Monster Examine", Collections.singletonList(this.castMonsterExamine), new SkillRequirement(Skill.MAGIC, 66), this.dreamMentor, this.lunarBook, this.mindRune, this.astralRune, this.cosmicRune);
        examineMonsterStep.setDisplayCondition(this.notExamineMonster);
        examineMonsterStep.setLockingStep(this.examineMonsterTask);
        allSteps.add(examineMonsterStep);
        PanelDetails teleportHeartStep = new PanelDetails("Teleport to Xeric's Heart", Collections.singletonList(this.teleportToHeart), this.architecturalAlliance, this.xericsTalisman);
        teleportHeartStep.setDisplayCondition(this.notTeleportHeart);
        teleportHeartStep.setLockingStep(this.teleportHeartTask);
        allSteps.add(teleportHeartStep);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

