/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.kourend;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KOUREND_ELITE)
public class KourendElite
extends ComplexStateQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement chisel;
    ItemRequirement axe;
    ItemRequirement darkTotem;
    ItemRequirement totemBase;
    ItemRequirement totemMiddle;
    ItemRequirement totemTop;
    ItemRequirement denseEssenceBlock;
    ItemRequirement bloodRune;
    ItemRequirement lawRune;
    ItemRequirement soulRune;
    ItemRequirement fishingRod;
    ItemRequirement sandworm;
    ItemRequirement celastrusSapling;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement prayerPotion;
    ItemRequirement celastrusBark;
    ItemRequirement darkEssenceBlock;
    ItemRequirement darkEssenceFragment;
    ItemRequirement rawAnglerfish;
    ItemRequirement knife;
    ItemRequirement bootsOfStone;
    ItemRequirement spade;
    ItemRequirement arclight;
    ItemRequirement kharedstsMemoirs;
    ItemRequirement dramenStaff;
    ItemRequirement skillsNecklace;
    ItemRequirement radasBlessing;
    ItemRequirement xericsTalisman;
    ItemRequirement potatoCactus;
    ItemRequirement ultraCompost;
    Requirement hosidiusFavour60;
    Requirement hosidiusFavour75;
    Requirement arceuusFavour;
    Requirement piscariliusFavour;
    Requirement notCraftBloodRune;
    Requirement notChopRedwood;
    Requirement notDefeatSkotizo;
    Requirement notCatchAngler;
    Requirement notKillHydra;
    Requirement notCreateTeleport;
    Requirement notCompleteRaid;
    Requirement notFletchBattlestaff;
    Requirement onArceuusSpellbook;
    Requirement anglerCaught;
    Requirement barkHarvested;
    QuestStep craftBloodRune;
    QuestStep enterCatacombs;
    QuestStep enterSkotizoLair;
    QuestStep defeatSkotizo;
    QuestStep catchAngler;
    QuestStep killHydra;
    QuestStep createTeleportTab;
    QuestStep completeRaid;
    QuestStep plantCelastrusTree;
    QuestStep fletchBattlestaff;
    QuestStep enterHydraArea;
    QuestStep enterMountKaruulmDungeon;
    QuestStep climbRedwoodTree;
    QuestStep cookAnglerfish;
    QuestStep combineDarkTotem;
    QuestStep claimReward;
    QuestStep bloodMineDenseEssence;
    QuestStep bloodVenerateEssenceBlock;
    QuestStep chiselEssenceBlock;
    QuestStep apeMineDenseEssence;
    QuestStep apeVenerateEssenceBlock;
    ObjectStep enterWoodcuttingGuild;
    ObjectStep chopRedwood;
    NpcStep switchSpellbook;
    ZoneRequirement inRedwoodTree;
    ZoneRequirement inCatacombs;
    ZoneRequirement inSkotizoLair;
    ZoneRequirement inWoodcuttingGuild;
    ZoneRequirement inMountKaruulmDungeon;
    ZoneRequirement inHydraArea;
    ZoneRequirement inFish;
    ZoneRequirement inFarming;
    Zone redwoodTree;
    Zone catacombs;
    Zone skotizoLair;
    Zone woodcuttingGuild;
    Zone mountKaruulmDungeon;
    Zone hydraArea;
    Zone fish;
    Zone farming;
    ConditionalStep craftBloodRuneTask;
    ConditionalStep chopRedwoodTask;
    ConditionalStep defeatSkotizoTask;
    ConditionalStep catchAnglerTask;
    ConditionalStep killHydraTask;
    ConditionalStep createTeleportTask;
    ConditionalStep completeRaidTask;
    ConditionalStep fletchBattlestaffTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.fletchBattlestaffTask = new ConditionalStep((QuestHelper)this, this.plantCelastrusTree, new Requirement[0]);
        this.fletchBattlestaffTask.addStep(this.barkHarvested, this.fletchBattlestaff);
        doElite.addStep(this.notFletchBattlestaff, this.fletchBattlestaffTask);
        this.craftBloodRuneTask = new ConditionalStep((QuestHelper)this, this.bloodMineDenseEssence, new Requirement[0]);
        this.craftBloodRuneTask.addStep(this.denseEssenceBlock, this.bloodVenerateEssenceBlock);
        this.craftBloodRuneTask.addStep(this.darkEssenceBlock, this.chiselEssenceBlock);
        this.craftBloodRuneTask.addStep(this.darkEssenceFragment, this.craftBloodRune);
        doElite.addStep(this.notCraftBloodRune, this.craftBloodRuneTask);
        this.createTeleportTask = new ConditionalStep((QuestHelper)this, this.apeMineDenseEssence, new Requirement[0]);
        this.createTeleportTask.addStep(this.denseEssenceBlock, this.apeVenerateEssenceBlock);
        this.createTeleportTask.addStep(this.darkEssenceBlock, this.switchSpellbook);
        this.createTeleportTask.addStep(this.onArceuusSpellbook, this.createTeleportTab);
        doElite.addStep(this.notCreateTeleport, this.createTeleportTask);
        this.killHydraTask = new ConditionalStep((QuestHelper)this, this.enterMountKaruulmDungeon, new Requirement[0]);
        this.killHydraTask.addStep(this.inMountKaruulmDungeon, this.enterHydraArea);
        this.killHydraTask.addStep(this.inHydraArea, this.killHydra);
        doElite.addStep(this.notKillHydra, this.killHydraTask);
        this.chopRedwoodTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWoodcuttingGuild, new Requirement[0]);
        this.chopRedwoodTask.addStep(this.inWoodcuttingGuild, this.climbRedwoodTree);
        this.chopRedwoodTask.addStep(this.inRedwoodTree, this.chopRedwood);
        doElite.addStep(this.notChopRedwood, this.chopRedwoodTask);
        this.catchAnglerTask = new ConditionalStep((QuestHelper)this, this.catchAngler, new Requirement[0]);
        this.catchAnglerTask.addStep(new Conditions(this.rawAnglerfish, this.anglerCaught), this.cookAnglerfish);
        doElite.addStep(this.notCatchAngler, this.catchAnglerTask);
        this.completeRaidTask = new ConditionalStep((QuestHelper)this, this.completeRaid, new Requirement[0]);
        doElite.addStep(this.notCompleteRaid, this.completeRaidTask);
        this.defeatSkotizoTask = new ConditionalStep((QuestHelper)this, this.combineDarkTotem, new Requirement[0]);
        this.defeatSkotizoTask.addStep(this.darkTotem.alsoCheckBank(this.questBank), this.enterCatacombs);
        this.defeatSkotizoTask.addStep(new Conditions(this.darkTotem.alsoCheckBank(this.questBank), this.inCatacombs), this.enterSkotizoLair);
        this.defeatSkotizoTask.addStep(this.inSkotizoLair, this.defeatSkotizo);
        doElite.addStep(this.notDefeatSkotizo, this.defeatSkotizoTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notCraftBloodRune = new VarplayerRequirement(2086, false, 4);
        this.notChopRedwood = new VarplayerRequirement(2086, false, 5);
        this.notDefeatSkotizo = new VarplayerRequirement(2086, false, 6);
        this.notCatchAngler = new VarplayerRequirement(2086, false, 7);
        this.notKillHydra = new VarplayerRequirement(2086, false, 8);
        this.notCreateTeleport = new VarplayerRequirement(2086, false, 9);
        this.notCompleteRaid = new VarplayerRequirement(2086, false, 10);
        this.notFletchBattlestaff = new VarplayerRequirement(2086, false, 11);
        this.onArceuusSpellbook = new SpellbookRequirement(Spellbook.ARCEUUS);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(new Conditions(LogicType.OR, this.notCraftBloodRune, this.notCreateTeleport)).isNotConsumed();
        this.chisel = new ItemRequirement("Chisel", 1755).showConditioned(new Conditions(LogicType.OR, this.notCraftBloodRune, this.notCreateTeleport)).isNotConsumed();
        this.chisel.setTooltip("One can be found in the Arceuus essence mine.");
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notChopRedwood).isNotConsumed();
        this.darkTotem = new ItemRequirement("Dark Totem", 19685).showConditioned(this.notDefeatSkotizo);
        this.totemBase = new ItemRequirement("Dark totem base", 19679);
        this.totemMiddle = new ItemRequirement("Dark totem middle", 19681);
        this.totemTop = new ItemRequirement("Dark totem top", 19683);
        this.denseEssenceBlock = new ItemRequirement("Dense essence block", 13445).showConditioned(new Conditions(LogicType.OR, this.notCraftBloodRune, this.notCreateTeleport));
        this.bloodRune = new ItemRequirement("Blood runes", 565, 2).showConditioned(this.notCreateTeleport);
        this.lawRune = new ItemRequirement("Law runes", 563, 2).showConditioned(this.notCreateTeleport);
        this.soulRune = new ItemRequirement("Soul runes", 566, 2).showConditioned(this.notCreateTeleport);
        this.fishingRod = new ItemRequirement("Fishing rod", 307).showConditioned(this.notCatchAngler).isNotConsumed();
        this.sandworm = new ItemRequirement("Sandworms", 13431).showConditioned(this.notCatchAngler);
        this.celastrusSapling = new ItemRequirement("Celastrus sapling", 22856).showConditioned(this.notFletchBattlestaff);
        this.knife = new ItemRequirement("Knife", 946).showConditioned(this.notFletchBattlestaff).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).showConditioned(new Conditions(LogicType.OR, this.notDefeatSkotizo, this.notKillHydra, this.notCompleteRaid)).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD).showConditioned(new Conditions(LogicType.OR, this.notDefeatSkotizo, this.notKillHydra, this.notCompleteRaid));
        this.prayerPotion = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS).showConditioned(new Conditions(LogicType.OR, this.notDefeatSkotizo, this.notKillHydra, this.notCompleteRaid));
        this.celastrusBark = new ItemRequirement("Celastrus bark", 22935);
        this.darkEssenceBlock = new ItemRequirement("Dark essence block", 13446);
        this.darkEssenceFragment = new ItemRequirement("Dark essence fragments", 7938);
        this.rawAnglerfish = new ItemRequirement("Raw anglerfish", 13439);
        this.bootsOfStone = new ItemRequirement("Boots of stone", ItemCollections.STONE_BOOTS).showConditioned(this.notKillHydra).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notFletchBattlestaff).isNotConsumed();
        this.arclight = new ItemRequirement("Arclight", 19675).showConditioned(this.notDefeatSkotizo).isNotConsumed();
        this.kharedstsMemoirs = new ItemRequirement("Kharedst's Memoirs or Book of the Dead", Arrays.asList(25818, 21760)).isNotConsumed();
        this.xericsTalisman = new ItemRequirement("Xeric's Talisman", 13393).isNotConsumed();
        this.dramenStaff = new ItemRequirement("Dramen or Lunar staff", ItemCollections.FAIRY_STAFF).isNotConsumed();
        this.radasBlessing = new ItemRequirement("Rada's Blessing", Arrays.asList(22941, 22943, 22945)).isNotConsumed();
        this.skillsNecklace = new ItemRequirement("Skills necklace", ItemCollections.SKILLS_NECKLACES).isNotConsumed();
        this.potatoCactus = new ItemRequirement("Potato cactus", 3138, 8);
        this.ultraCompost = new ItemRequirement("Compost", ItemCollections.COMPOST);
        this.arceuusFavour = new FavourRequirement(Favour.ARCEUUS, 100);
        this.hosidiusFavour60 = new FavourRequirement(Favour.HOSIDIUS, 60);
        this.hosidiusFavour75 = new FavourRequirement(Favour.HOSIDIUS, 75);
        this.piscariliusFavour = new FavourRequirement(Favour.PISCARILIUS, 100);
        this.inRedwoodTree = new ZoneRequirement(this.redwoodTree);
        this.inCatacombs = new ZoneRequirement(this.catacombs);
        this.inSkotizoLair = new ZoneRequirement(this.skotizoLair);
        this.inWoodcuttingGuild = new ZoneRequirement(this.woodcuttingGuild);
        this.inMountKaruulmDungeon = new ZoneRequirement(this.mountKaruulmDungeon);
        this.inHydraArea = new ZoneRequirement(this.hydraArea);
        this.inFish = new ZoneRequirement(this.fish);
        this.inFarming = new ZoneRequirement(this.farming);
        this.anglerCaught = new ChatMessageRequirement(this.inFish, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.anglerCaught).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inFish), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.barkHarvested = new ChatMessageRequirement(this.inFarming, "<col=0040ff>Achievement Diary Stage Task - Current stage: 3.</col>");
        ((ChatMessageRequirement)this.barkHarvested).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inFarming), "<col=0040ff>Achievement Diary Stage Task - Current stage: 3.</col>"));
    }

    public void loadZones() {
        this.redwoodTree = new Zone(new WorldPoint(1567, 3496, 1), new WorldPoint(1574, 3479, 1));
        this.catacombs = new Zone(new WorldPoint(1659, 10052, 0), new WorldPoint(1668, 10043, 0));
        this.skotizoLair = new Zone(new WorldPoint(1479, 2415, 0), new WorldPoint(6513, 2384, 0));
        this.woodcuttingGuild = new Zone(new WorldPoint(1563, 3948, 0), new WorldPoint(1581, 3477, 0));
        this.mountKaruulmDungeon = new Zone(new WorldPoint(1303, 10210, 0), new WorldPoint(1320, 10187, 0));
        this.hydraArea = new Zone(new WorldPoint(1310, 10250, 0), new WorldPoint(1330, 10215, 0));
        this.fish = new Zone(new WorldPoint(1810, 3787, 0), new WorldPoint(1852, 3758, 0));
        this.farming = new Zone(new WorldPoint(1220, 3764, 0), new WorldPoint(1274, 3720, 0));
    }

    public void setupSteps() {
        this.bloodMineDenseEssence = new ObjectStep((QuestHelper)this, 8975, new WorldPoint(1764, 3858, 0), "Mine a dense essence block.", this.pickaxe, this.chisel);
        this.bloodVenerateEssenceBlock = new ObjectStep((QuestHelper)this, 27979, new WorldPoint(1716, 3883, 0), "Venerate the essence block on the Dark Altar.", this.denseEssenceBlock);
        this.chiselEssenceBlock = new ItemStep((QuestHelper)this, "Chisel the dark essence block.", this.chisel.highlighted(), this.darkEssenceBlock.highlighted());
        this.craftBloodRune = new ObjectStep((QuestHelper)this, 27978, new WorldPoint(1718, 3828, 0), "Craft some blood runes.", this.darkEssenceFragment);
        this.enterWoodcuttingGuild = new ObjectStep((QuestHelper)this, 28851, new WorldPoint(1657, 3505, 0), "Enter the Woodcutting Guild.", true, new Requirement[0]);
        this.enterWoodcuttingGuild.addAlternateObjects(28852);
        this.climbRedwoodTree = new ObjectStep((QuestHelper)this, 28857, "Climb the redwood tree.", this.axe);
        this.chopRedwood = new ObjectStep((QuestHelper)this, 29668, "Chop the redwood tree.", this.axe);
        this.chopRedwood.addAlternateObjects(29669, 29670, 29671);
        this.combineDarkTotem = new ItemStep((QuestHelper)this, "Collect and combine dark totem pieces.", this.totemTop.highlighted(), this.totemMiddle.highlighted(), this.totemBase.highlighted());
        this.enterCatacombs = new ObjectStep((QuestHelper)this, 27785, "Enter the Catacombs of Kourend.", this.xericsTalisman);
        this.enterSkotizoLair = new ObjectStep((QuestHelper)this, 28900, "Enter Skotizo's Lair.", this.darkTotem.highlighted());
        this.enterSkotizoLair.addIcon(19685);
        this.defeatSkotizo = new NpcStep((QuestHelper)this, 7286, "Defeat Skotizo.", this.combatGear, this.food, this.prayerPotion);
        this.catchAngler = new NpcStep((QuestHelper)this, 6825, "Catch a raw anglerfish.", this.fishingRod, this.sandworm);
        this.cookAnglerfish = new ObjectStep((QuestHelper)this, 27724, new WorldPoint(1795, 3754, 0), "Cook a raw anglerfish in Kourend.", this.rawAnglerfish);
        this.enterMountKaruulmDungeon = new ObjectStep((QuestHelper)this, 34359, new WorldPoint(1311, 3807, 0), "Enter the Mount Karuulm Slayer Dungeon.", new Requirement[0]);
        this.enterHydraArea = new ObjectStep((QuestHelper)this, 34544, new WorldPoint(1312, 10215, 0), "Enter the hydra area.", this.bootsOfStone.equipped());
        this.killHydra = new NpcStep((QuestHelper)this, 8609, new WorldPoint(1312, 10232, 0), "Kill a hydra.", this.combatGear, this.food);
        this.killHydra.addSubSteps(this.enterMountKaruulmDungeon, this.enterHydraArea);
        this.apeMineDenseEssence = new ObjectStep((QuestHelper)this, 8975, new WorldPoint(1764, 3858, 0), "Mine a dense essence block.", this.pickaxe, this.chisel);
        this.apeVenerateEssenceBlock = new ObjectStep((QuestHelper)this, 27979, new WorldPoint(1716, 3883, 0), "Venerate the essence block.", this.denseEssenceBlock);
        this.switchSpellbook = new NpcStep((QuestHelper)this, 7050, new WorldPoint(1712, 3882, 0), "Switch to the Arceuus spellbook via Tyss.", new Requirement[0]);
        this.switchSpellbook.addDialogStep("Can I try the magicks myself?");
        this.createTeleportTab = new ObjectStep((QuestHelper)this, 28802, new WorldPoint(1679, 3765, 0), "Create an Ape Atoll teleport tablet.", this.arceuusFavour, this.bloodRune.quantity(2), this.lawRune.quantity(2), this.soulRune.quantity(2));
        this.completeRaid = new ObjectStep((QuestHelper)this, 29777, new WorldPoint(1232, 3573, 0), "Complete a Chambers of Xeric raid.", new Requirement[0]);
        this.plantCelastrusTree = new ObjectStep((QuestHelper)this, 34629, new WorldPoint(1244, 3750, 0), "Plant a celastrus sapling (Fully grown after 13 hours). When it's fully grown harvest its bark. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.celastrusSapling, this.spade, this.axe);
        this.fletchBattlestaff = new ItemStep((QuestHelper)this, "Fletch a battlestaff.", this.knife.highlighted(), this.celastrusBark.highlighted());
        this.claimReward = new NpcStep((QuestHelper)this, 8538, new WorldPoint(1647, 3665, 0), "Talk to Elise in the Kourend castle courtyard to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Kill Skotizo (level 321)", "Kill a Hydra (level 194)", "Various enemies in Chambers of Xeric");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.pickaxe, this.chisel, this.axe, this.darkTotem, this.bloodRune.quantity(2), this.lawRune.quantity(2), this.soulRune.quantity(2), this.fishingRod, this.sandworm, this.celastrusSapling, this.combatGear, this.food, this.knife, this.bootsOfStone);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.arclight, this.kharedstsMemoirs, this.dramenStaff, this.skillsNecklace, this.radasBlessing, this.xericsTalisman, this.potatoCactus, this.ultraCompost, this.prayerPotion);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.COOKING, 84, true));
        req.add(new SkillRequirement(Skill.CRAFTING, 38));
        req.add(new SkillRequirement(Skill.FARMING, 85));
        req.add(new SkillRequirement(Skill.FISHING, 82, true));
        req.add(new SkillRequirement(Skill.FLETCHING, 40));
        req.add(new SkillRequirement(Skill.MAGIC, 90, true));
        req.add(new SkillRequirement(Skill.MINING, 38));
        req.add(new SkillRequirement(Skill.RUNECRAFT, 77, true));
        req.add(new SkillRequirement(Skill.SLAYER, 95, true));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 90, true));
        req.add(this.arceuusFavour);
        req.add(this.hosidiusFavour75);
        req.add(this.piscariliusFavour);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Rada's Blessing (4)", 22947, 1), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Demonic ashes from the ash sanctifier grant full Prayer experience"), new UnlockReward("Completing a slayer task from Konar quo Maten gives 20 Slayer points (up from 18)"), new UnlockReward("10% reduced burn chance at the city kitchens (up from 5%)"), new UnlockReward("Protection from the burn effect in Karuulm Slayer Dungeon without boots of stone"), new UnlockReward("5% increased chance to save a harvest life at the Hosidius and Farming Guild herb patches."), new UnlockReward("80 free Dynamite per day from Thirus"), new UnlockReward("10% additional blood runes from blood runecrafting (no additional xp)"), new UnlockReward("Reduced tanning prices at Eodan in Forthos Dungeon to 20%."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails battlestaffStep = new PanelDetails("Battlestaff From Scratch", Arrays.asList(this.plantCelastrusTree, this.fletchBattlestaff), new SkillRequirement(Skill.FARMING, 85), new SkillRequirement(Skill.FLETCHING, 40), this.hosidiusFavour60, this.spade, this.celastrusSapling, this.knife, this.axe);
        battlestaffStep.setDisplayCondition(this.notFletchBattlestaff);
        battlestaffStep.setLockingStep(this.fletchBattlestaffTask);
        allSteps.add(battlestaffStep);
        PanelDetails craftBloodRuneStep = new PanelDetails("Craft Blood Rune", Arrays.asList(this.bloodMineDenseEssence, this.bloodVenerateEssenceBlock, this.chiselEssenceBlock, this.craftBloodRune), new SkillRequirement(Skill.RUNECRAFT, 77, true), new SkillRequirement(Skill.MINING, 38), new SkillRequirement(Skill.CRAFTING, 38), this.arceuusFavour, this.chisel, this.pickaxe);
        craftBloodRuneStep.setDisplayCondition(this.notCraftBloodRune);
        craftBloodRuneStep.setLockingStep(this.craftBloodRuneTask);
        allSteps.add(craftBloodRuneStep);
        PanelDetails createTabStep = new PanelDetails("Ape Atoll Teleport Tablet", Arrays.asList(this.apeMineDenseEssence, this.apeVenerateEssenceBlock, this.switchSpellbook, this.createTeleportTab), new SkillRequirement(Skill.MAGIC, 90, true), this.arceuusFavour, this.chisel, this.pickaxe, this.soulRune.quantity(2), this.lawRune.quantity(2), this.bloodRune.quantity(2));
        createTabStep.setDisplayCondition(this.notCreateTeleport);
        createTabStep.setLockingStep(this.createTeleportTask);
        allSteps.add(createTabStep);
        PanelDetails killHydraStep = new PanelDetails("Kill Hydra", Arrays.asList(this.enterMountKaruulmDungeon, this.enterHydraArea, this.killHydra), new SkillRequirement(Skill.SLAYER, 95, true), this.combatGear, this.food, this.prayerPotion, this.bootsOfStone);
        killHydraStep.setDisplayCondition(this.notKillHydra);
        killHydraStep.setLockingStep(this.killHydraTask);
        allSteps.add(killHydraStep);
        PanelDetails chopRedwoodStep = new PanelDetails("Chop Redwood Logs", Arrays.asList(this.enterWoodcuttingGuild, this.climbRedwoodTree, this.chopRedwood), new SkillRequirement(Skill.WOODCUTTING, 90, true), this.hosidiusFavour75, this.axe);
        chopRedwoodStep.setDisplayCondition(this.notChopRedwood);
        chopRedwoodStep.setLockingStep(this.chopRedwoodTask);
        allSteps.add(chopRedwoodStep);
        PanelDetails catchAnglerStep = new PanelDetails("Catch And Cook Anglerfish", Arrays.asList(this.catchAngler, this.cookAnglerfish), new SkillRequirement(Skill.COOKING, 84, true), new SkillRequirement(Skill.FISHING, 82, true), this.piscariliusFavour, this.fishingRod, this.sandworm);
        catchAnglerStep.setDisplayCondition(this.notCatchAngler);
        catchAnglerStep.setLockingStep(this.catchAnglerTask);
        allSteps.add(catchAnglerStep);
        PanelDetails raidStep = new PanelDetails("Complete Chambers Of Xeric Raid", Collections.singletonList(this.completeRaid), new Requirement[0]);
        raidStep.setDisplayCondition(this.notCompleteRaid);
        raidStep.setLockingStep(this.completeRaidTask);
        allSteps.add(raidStep);
        PanelDetails defeatSkotizoStep = new PanelDetails("Defeat Skotizo", Arrays.asList(this.combineDarkTotem, this.enterCatacombs, this.enterSkotizoLair, this.defeatSkotizo), this.darkTotem, this.combatGear, this.food);
        defeatSkotizoStep.setDisplayCondition(this.notDefeatSkotizo);
        defeatSkotizoStep.setLockingStep(this.defeatSkotizoTask);
        allSteps.add(defeatSkotizoStep);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

