/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.kourend;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KOUREND_EASY)
public class KourendEasy
extends ComplexStateQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement spade;
    ItemRequirement coins;
    ItemRequirement medpack;
    ItemRequirement tarrominPotU;
    ItemRequirement limpwurtRoot;
    ItemRequirement flyFishingRod;
    ItemRequirement feathers;
    ItemRequirement libraryBook;
    ItemRequirement combatGear;
    ItemRequirement food;
    Requirement druidicRitual;
    Requirement hosidiusFavour;
    Requirement notMineIron;
    Requirement notSandCrab;
    Requirement notArceuusBook;
    Requirement notStealFruit;
    Requirement notWarrensStore;
    Requirement notBoatLandsEnd;
    Requirement notPrayCastle;
    Requirement notDigSaltpetre;
    Requirement houseInKourend;
    Requirement notEnterPoh;
    Requirement hasMedpack;
    Requirement notHealSoldier;
    Requirement notStrengthPotion;
    Requirement notFishTrout;
    QuestStep sandCrab;
    QuestStep stealFruit;
    QuestStep warrensStore;
    QuestStep enterCastleF1;
    QuestStep enterCastleF2;
    QuestStep prayCastle;
    QuestStep digSaltpetre;
    QuestStep enterPoh;
    QuestStep collectMedpack;
    QuestStep healSoldier;
    QuestStep enterPub;
    QuestStep strengthPotion;
    QuestStep fishTrout;
    QuestStep claimReward;
    ObjectStep enterWarrens;
    ObjectStep mineIron;
    NpcStep arceuusBook;
    NpcStep boatLandsEnd;
    NpcStep relocateHouse;
    ZoneRequirement inPub;
    ZoneRequirement inWarrens;
    ZoneRequirement inCastleF1;
    ZoneRequirement inCastleF2;
    Zone deeperLodePub;
    Zone warrens;
    Zone castleF1;
    Zone castleF2;
    ConditionalStep mineIronTask;
    ConditionalStep sandCrabTask;
    ConditionalStep arceuusBookTask;
    ConditionalStep stealFruitTask;
    ConditionalStep warrensStoreTask;
    ConditionalStep boatLandsEndTask;
    ConditionalStep prayCastleTask;
    ConditionalStep digSaltpetreTask;
    ConditionalStep enterPohTask;
    ConditionalStep healSoldierTask;
    ConditionalStep strengthPotionTask;
    ConditionalStep fishTroutTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.mineIronTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.mineIron, new Requirement[0]);
        doEasy.addStep(this.notMineIron, this.mineIronTask);
        this.fishTroutTask = new ConditionalStep((QuestHelper)this, this.fishTrout, new Requirement[0]);
        doEasy.addStep(this.notFishTrout, this.fishTroutTask);
        this.strengthPotionTask = new ConditionalStep((QuestHelper)this, this.enterPub, new Requirement[0]);
        this.strengthPotionTask.addStep(this.inPub, this.strengthPotion);
        doEasy.addStep(this.notStrengthPotion, this.strengthPotionTask);
        this.arceuusBookTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.arceuusBook, new Requirement[0]);
        doEasy.addStep(this.notArceuusBook, this.arceuusBookTask);
        this.warrensStoreTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWarrens, new Requirement[0]);
        this.warrensStoreTask.addStep(this.inWarrens, this.warrensStore);
        doEasy.addStep(this.notWarrensStore, this.warrensStoreTask);
        this.boatLandsEndTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.boatLandsEnd, new Requirement[0]);
        doEasy.addStep(this.notBoatLandsEnd, this.boatLandsEndTask);
        this.stealFruitTask = new ConditionalStep((QuestHelper)this, this.stealFruit, new Requirement[0]);
        doEasy.addStep(this.notStealFruit, this.stealFruitTask);
        this.digSaltpetreTask = new ConditionalStep((QuestHelper)this, this.digSaltpetre, new Requirement[0]);
        doEasy.addStep(this.notDigSaltpetre, this.digSaltpetreTask);
        this.sandCrabTask = new ConditionalStep((QuestHelper)this, this.sandCrab, new Requirement[0]);
        doEasy.addStep(this.notSandCrab, this.sandCrabTask);
        this.enterPohTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.relocateHouse, new Requirement[0]);
        this.enterPohTask.addStep(this.houseInKourend, this.enterPoh);
        doEasy.addStep(this.notEnterPoh, this.enterPohTask);
        this.prayCastleTask = new ConditionalStep((QuestHelper)this, this.enterCastleF1, new Requirement[0]);
        this.prayCastleTask.addStep(this.inCastleF1, this.enterCastleF2);
        this.prayCastleTask.addStep(this.inCastleF2, this.prayCastle);
        doEasy.addStep(this.notPrayCastle, this.prayCastleTask);
        this.healSoldierTask = new ConditionalStep((QuestHelper)this, this.collectMedpack, new Requirement[0]);
        this.healSoldierTask.addStep(this.hasMedpack, this.healSoldier);
        doEasy.addStep(this.notHealSoldier, this.healSoldierTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notMineIron = new VarplayerRequirement(2085, false, 1);
        this.notSandCrab = new VarplayerRequirement(2085, false, 2);
        this.notArceuusBook = new VarplayerRequirement(2085, false, 3);
        this.notStealFruit = new VarplayerRequirement(2085, false, 4);
        this.notWarrensStore = new VarplayerRequirement(2085, false, 5);
        this.notBoatLandsEnd = new VarplayerRequirement(2085, false, 6);
        this.notPrayCastle = new VarplayerRequirement(2085, false, 7);
        this.notDigSaltpetre = new VarplayerRequirement(2085, false, 8);
        this.notEnterPoh = new VarplayerRequirement(2085, false, 9);
        this.notHealSoldier = new VarplayerRequirement(2085, false, 10);
        this.notStrengthPotion = new VarplayerRequirement(2085, false, 11);
        this.notFishTrout = new VarplayerRequirement(2085, false, 12);
        this.pickaxe = new ItemRequirement("Pickaxe", ItemCollections.PICKAXES).showConditioned(this.notMineIron).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notDigSaltpetre).isNotConsumed();
        this.libraryBook = new ItemRequirement("Arceuus library book", ItemCollections.ARCEUUS_BOOKS).showConditioned(this.notArceuusBook);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 8075).showConditioned(this.notEnterPoh);
        this.medpack = new ItemRequirement("Medpacks", 13382).showConditioned(this.notHealSoldier);
        this.tarrominPotU = new ItemRequirement("Tarromin potion (unf)", 95).showConditioned(this.notStrengthPotion);
        this.limpwurtRoot = new ItemRequirement("Limpwurt root", 225).showConditioned(this.notStrengthPotion);
        this.flyFishingRod = new ItemRequirement("Fly fishing rod", Arrays.asList(309, 22844)).showConditioned(this.notFishTrout).isNotConsumed();
        this.feathers = new ItemRequirement("Feathers", 314, 10).showConditioned(this.notFishTrout);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inPub = new ZoneRequirement(this.deeperLodePub);
        this.inWarrens = new ZoneRequirement(this.warrens);
        this.inCastleF1 = new ZoneRequirement(this.castleF1);
        this.inCastleF2 = new ZoneRequirement(this.castleF2);
        this.druidicRitual = new QuestRequirement(QuestHelperQuest.DRUIDIC_RITUAL, QuestState.FINISHED);
        this.inPub = new ZoneRequirement(this.deeperLodePub);
        this.inWarrens = new ZoneRequirement(this.warrens);
        this.inCastleF1 = new ZoneRequirement(this.castleF1);
        this.inCastleF2 = new ZoneRequirement(this.castleF2);
        this.hasMedpack = this.medpack.alsoCheckBank(this.questBank);
        this.houseInKourend = new VarbitRequirement(2187, 8);
        this.hosidiusFavour = new FavourRequirement(Favour.HOSIDIUS, 15);
    }

    public void loadZones() {
        this.deeperLodePub = new Zone(new WorldPoint(1562, 3765, 0), new WorldPoint(1569, 3752, 0));
        this.warrens = new Zone(new WorldPoint(1728, 10176, 0), new WorldPoint(1816, 10109, 0));
        this.castleF1 = new Zone(new WorldPoint(1592, 3691, 1), new WorldPoint(1627, 3655, 1));
        this.castleF2 = new Zone(new WorldPoint(1592, 3691, 2), new WorldPoint(1627, 3655, 2));
    }

    public void setupSteps() {
        this.mineIron = new ObjectStep((QuestHelper)this, 11364, new WorldPoint(1275, 3817, 0), "Mine some iron ore at the Mount Karuulm mine.", true, this.pickaxe);
        this.mineIron.addAlternateObjects(11365);
        this.sandCrab = new NpcStep((QuestHelper)this, 5935, new WorldPoint(1739, 3468, 0), "Kill a sand crab.", true, this.combatGear, this.food);
        this.arceuusBook = new NpcStep((QuestHelper)this, 7048, new WorldPoint(1625, 3801, 0), "Collect a book for a patron in the Arceuus Library.", this.libraryBook);
        this.arceuusBook.addAlternateNpcs(7049);
        this.arceuusBook.addAlternateNpcs(7047);
        this.stealFruit = new ObjectStep((QuestHelper)this, 28823, new WorldPoint(1767, 3597, 0), "Steal from a Hosidius fruit stall.", new Requirement[0]);
        this.enterWarrens = new ObjectStep((QuestHelper)this, 31707, new WorldPoint(1813, 3745, 0), "Enter the Warrens.", new Requirement[0]);
        this.enterWarrens.addAlternateObjects(31706);
        this.warrensStore = new NpcStep((QuestHelper)this, 7913, new WorldPoint(1775, 10148, 0), "Browse the Warrens General Store.", new Requirement[0]);
        this.boatLandsEnd = new NpcStep((QuestHelper)this, 10932, new WorldPoint(1826, 3691, 0), "Take a boat to Land's End.", true, new Requirement[0]);
        this.boatLandsEnd.addAlternateNpcs(10727);
        this.boatLandsEnd.addDialogStep("Can you take me somewhere?");
        this.boatLandsEnd.addDialogStep("Travel to Land's End.");
        this.enterCastleF1 = new ObjectStep((QuestHelper)this, 11807, new WorldPoint(1616, 3680, 0), "Climb the stairs to the second floor of the Kourend Castle.", new Requirement[0]);
        this.enterCastleF2 = new ObjectStep((QuestHelper)this, 12536, new WorldPoint(1616, 3687, 1), "Climb the stairs to the third floor of the Kourend Castle.", new Requirement[0]);
        this.prayCastle = new ObjectStep((QuestHelper)this, 18258, new WorldPoint(1617, 3673, 2), "Pray at the Kourend Castle altar.", new Requirement[0]);
        this.prayCastle.addSubSteps(this.enterCastleF1, this.enterCastleF2);
        this.digSaltpetre = new ObjectStep((QuestHelper)this, 27436, new WorldPoint(1703, 3526, 0), "Dig up some Saltpetre in Hosidius.", this.spade);
        this.relocateHouse = new NpcStep((QuestHelper)this, 3097, new WorldPoint(1779, 3625, 0), "Relocate your player-owned house to Hosidius.", true, this.coins.quantity(8750));
        this.relocateHouse.addDialogStep(1, "Can you move my house please?");
        this.relocateHouse.addDialogStep(4, "Hosidius (8,750)");
        this.enterPoh = new ObjectStep((QuestHelper)this, 28822, new WorldPoint(1742, 3517, 0), "Enter your player-owned house from Hosidius.", new Requirement[0]);
        this.enterPoh.addSubSteps(this.relocateHouse);
        this.collectMedpack = new ObjectStep((QuestHelper)this, 27205, new WorldPoint(1522, 3615, 0), "Collect a medpack in Shayzien.", true, new Requirement[0]);
        this.healSoldier = new NpcStep((QuestHelper)this, 6826, new WorldPoint(1516, 3621, 0), "Heal a wounded shayzien soldier.", true, this.medpack);
        this.healSoldier.addSubSteps(this.collectMedpack);
        this.enterPub = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1564, 3759, 0), "Enter The Deeper Lode pub in Lovakengj.", new Requirement[0]);
        this.strengthPotion = new ItemStep((QuestHelper)this, "Create a strength Potion in The Deeper Lode pub.", this.tarrominPotU.highlighted(), this.limpwurtRoot.highlighted());
        this.fishTrout = new NpcStep((QuestHelper)this, 8524, new WorldPoint(1267, 3706, 0), "Fish a trout from the River Molch.", this.flyFishingRod, this.feathers);
        this.claimReward = new NpcStep((QuestHelper)this, 8538, new WorldPoint(1647, 3665, 0), "Talk to Elise in the Kourend castle courtyard to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Kill a Sand Crab (level 15)");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(8750), this.pickaxe, this.spade, this.tarrominPotU, this.limpwurtRoot, this.flyFishingRod, this.feathers);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.food);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.CONSTRUCTION, 25));
        req.add(new SkillRequirement(Skill.FISHING, 20));
        req.add(new SkillRequirement(Skill.HERBLORE, 12));
        req.add(new SkillRequirement(Skill.MINING, 15));
        req.add(new SkillRequirement(Skill.THIEVING, 25));
        req.add(this.hosidiusFavour);
        req.add(this.druidicRitual);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Rada's Blessing (1)", 22941, 1), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Halved access cost for Crabclaw Isle."), new UnlockReward("Doubled drop rate of Xeric's talisman, excluding stone chests."), new UnlockReward("Reduced tanning prices at Eodan in Forthos Dungeon to 80%."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails mineIronStep = new PanelDetails("Mine Iron Ore", Collections.singletonList(this.mineIron), this.pickaxe, new SkillRequirement(Skill.MINING, 15, true));
        mineIronStep.setDisplayCondition(this.notMineIron);
        mineIronStep.setLockingStep(this.mineIronTask);
        allSteps.add(mineIronStep);
        PanelDetails fishTroutStep = new PanelDetails("Fish A Trout", Collections.singletonList(this.fishTrout), new SkillRequirement(Skill.FISHING, 20), this.flyFishingRod, this.feathers);
        fishTroutStep.setDisplayCondition(this.notFishTrout);
        fishTroutStep.setLockingStep(this.fishTroutTask);
        allSteps.add(fishTroutStep);
        PanelDetails makePotionStep = new PanelDetails("Make A Strength Potion", Arrays.asList(this.enterPub, this.strengthPotion), new SkillRequirement(Skill.HERBLORE, 12), this.druidicRitual, this.tarrominPotU, this.limpwurtRoot);
        makePotionStep.setDisplayCondition(this.notStrengthPotion);
        makePotionStep.setLockingStep(this.strengthPotionTask);
        allSteps.add(makePotionStep);
        PanelDetails bookStep = new PanelDetails("Hand In A Book", Collections.singletonList(this.arceuusBook), this.libraryBook);
        bookStep.setDisplayCondition(this.notArceuusBook);
        bookStep.setLockingStep(this.arceuusBookTask);
        allSteps.add(bookStep);
        PanelDetails warrensStep = new PanelDetails("Browse The Warrens Store", Arrays.asList(this.enterWarrens, this.warrensStore), new Requirement[0]);
        warrensStep.setDisplayCondition(this.notWarrensStore);
        warrensStep.setLockingStep(this.warrensStoreTask);
        allSteps.add(warrensStep);
        PanelDetails takeBoatStep = new PanelDetails("Boat To Land's End", Collections.singletonList(this.boatLandsEnd), new Requirement[0]);
        takeBoatStep.setDisplayCondition(this.notBoatLandsEnd);
        takeBoatStep.setLockingStep(this.boatLandsEndTask);
        allSteps.add(takeBoatStep);
        PanelDetails stealStallStep = new PanelDetails("Steal Some Fruit", Collections.singletonList(this.stealFruit), new SkillRequirement(Skill.THIEVING, 25, true), this.hosidiusFavour);
        stealStallStep.setDisplayCondition(this.notStealFruit);
        stealStallStep.setLockingStep(this.stealFruitTask);
        allSteps.add(stealStallStep);
        PanelDetails digSaltpetreStep = new PanelDetails("Dig Up Some Saltpetre", Collections.singletonList(this.digSaltpetre), this.spade);
        digSaltpetreStep.setDisplayCondition(this.notDigSaltpetre);
        digSaltpetreStep.setLockingStep(this.digSaltpetreTask);
        allSteps.add(digSaltpetreStep);
        PanelDetails killCrabStep = new PanelDetails("Kill Sand Crab", Collections.singletonList(this.sandCrab), this.combatGear);
        killCrabStep.setDisplayCondition(this.notSandCrab);
        killCrabStep.setLockingStep(this.sandCrabTask);
        allSteps.add(killCrabStep);
        PanelDetails enterPohStep = new PanelDetails("Hosidius House", Arrays.asList(this.relocateHouse, this.enterPoh), new SkillRequirement(Skill.CONSTRUCTION, 25), this.coins.quantity(8750));
        enterPohStep.setDisplayCondition(this.notEnterPoh);
        enterPohStep.setLockingStep(this.enterPohTask);
        allSteps.add(enterPohStep);
        PanelDetails prayStep = new PanelDetails("Pray At Kourend Castle", Arrays.asList(this.enterCastleF1, this.enterCastleF2, this.prayCastle), new Requirement[0]);
        prayStep.setDisplayCondition(this.notPrayCastle);
        prayStep.setLockingStep(this.prayCastleTask);
        allSteps.add(prayStep);
        PanelDetails healSoldierStep = new PanelDetails("Heal A Soldier", Arrays.asList(this.collectMedpack, this.healSoldier), this.medpack);
        healSoldierStep.setDisplayCondition(this.notHealSoldier);
        healSoldierStep.setLockingStep(this.healSoldierTask);
        allSteps.add(healSoldierStep);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

