/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.karamja;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KARAMJA_MEDIUM)
public class KaramjaMedium
extends BasicQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement coins;
    ItemRequirement spiderCarcass;
    ItemRequirement skewerTicksOrArrowShaft;
    ItemRequirement goutTuber;
    ItemRequirement rake;
    ItemRequirement fruitTreeSapling;
    ItemRequirement teasingStick;
    ItemRequirement knife;
    ItemRequirement logs;
    ItemRequirement axe;
    ItemRequirement tradingSticks;
    ItemRequirement opal;
    ItemRequirement smallFishingNet;
    ItemRequirement karambwanVessel;
    ItemRequirement rawKarambwanji;
    ItemRequirement rawKarambwanjiOrSmallFishingNet;
    ItemRequirement spade;
    ItemRequirement machete;
    ItemRequirement spiderOnAStick;
    ItemRequirement food;
    ItemRequirement antipoison;
    Requirement notClaimedTicket;
    Requirement notEnteredWall;
    Requirement notUsedCart;
    Requirement notEarned100;
    Requirement notCookedSpider;
    Requirement notTraveledToKhazard;
    Requirement notCutTeak;
    Requirement notCutMahog;
    Requirement notCaughtKarambwan;
    Requirement notExchangedGems;
    Requirement notUsedGlider;
    Requirement notGrownFruitTree;
    Requirement notEnteredCrandor;
    Requirement notTrappedGraahk;
    Requirement notCutVine;
    Requirement notCrossedLava;
    Requirement notClimbedStairs;
    Requirement notCharteredFromShipyard;
    Requirement notMinedRedRopaz;
    Requirement agility12;
    Requirement cooking16;
    Requirement farming27;
    Requirement fishing65;
    Requirement hunter41;
    Requirement mining40;
    Requirement woodcutting50;
    Requirement grandTree;
    Requirement taiBwoWannaiTrio;
    Requirement dragonSlayerI;
    Requirement shiloVillage;
    Requirement junglePotion;
    QuestStep enterAgilityArena;
    QuestStep tag2Pillars;
    QuestStep enterVolcano;
    QuestStep returnThroughWall;
    QuestStep useCart;
    QuestStep doCleanup;
    QuestStep makeSpiderStick;
    QuestStep cookSpider;
    QuestStep climbUpToBoat;
    QuestStep travelToKhazard;
    QuestStep cutTeak;
    QuestStep cutMahogany;
    QuestStep catchKarambwanji;
    QuestStep catchKarambwan;
    QuestStep getMachete;
    QuestStep flyToKaramja;
    QuestStep growFruitTree;
    QuestStep trapGraahk;
    QuestStep chopVines;
    QuestStep crossLava;
    QuestStep climbBrimhavenStaircase;
    QuestStep charterFromShipyard;
    QuestStep mineRedTopaz;
    QuestStep enterCrandor;
    QuestStep enterBrimDungeonVine;
    QuestStep enterBrimDungeonLava;
    QuestStep enterBrimDungeonStairs;
    QuestStep claimReward;
    Zone cave;
    Zone agilityArena;
    Zone brimhavenDungeon;
    ZoneRequirement inCave;
    ZoneRequirement inAgilityArena;
    ZoneRequirement inBrimhavenDungeon;
    ConditionalStep claimedTicketTask;
    ConditionalStep enteredWallTask;
    ConditionalStep usedCartTask;
    ConditionalStep earned100Task;
    ConditionalStep cookedSpiderTask;
    ConditionalStep traveledToKhazardTask;
    ConditionalStep cutTeakTask;
    ConditionalStep cutMahogTask;
    ConditionalStep caughtKarambwanTask;
    ConditionalStep exchangedGemsTask;
    ConditionalStep usedGliderTask;
    ConditionalStep grownFruitTreeTask;
    ConditionalStep enteredCrandorTask;
    ConditionalStep trappedGraahkTask;
    ConditionalStep cutVineTask;
    ConditionalStep crossedLavaTask;
    ConditionalStep climbedStairsTask;
    ConditionalStep charteredFromShipyardTask;
    ConditionalStep minedRedRopazTask;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep doMedium = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.grownFruitTreeTask = new ConditionalStep((QuestHelper)this, this.growFruitTree, new Requirement[0]);
        doMedium.addStep(this.notGrownFruitTree, this.grownFruitTreeTask);
        this.enteredWallTask = new ConditionalStep((QuestHelper)this, this.enterVolcano, new Requirement[0]);
        this.enteredWallTask.addStep(this.inCave, this.returnThroughWall);
        doMedium.addStep(this.notEnteredWall, this.enteredWallTask);
        this.enteredCrandorTask = new ConditionalStep((QuestHelper)this, this.enterVolcano, new Requirement[0]);
        this.enteredCrandorTask.addStep(this.inCave, this.enterCrandor);
        doMedium.addStep(this.notEnteredCrandor, this.enteredCrandorTask);
        this.claimedTicketTask = new ConditionalStep((QuestHelper)this, this.enterAgilityArena, new Requirement[0]);
        this.claimedTicketTask.addStep(this.inAgilityArena, this.tag2Pillars);
        doMedium.addStep(this.notClaimedTicket, this.claimedTicketTask);
        this.usedCartTask = new ConditionalStep((QuestHelper)this, this.useCart, new Requirement[0]);
        doMedium.addStep(this.notUsedCart, this.usedCartTask);
        this.minedRedRopazTask = new ConditionalStep((QuestHelper)this, this.mineRedTopaz, new Requirement[0]);
        doMedium.addStep(this.notMinedRedRopaz, this.minedRedRopazTask);
        this.traveledToKhazardTask = new ConditionalStep((QuestHelper)this, this.travelToKhazard, new Requirement[0]);
        doMedium.addStep(this.notTraveledToKhazard, this.traveledToKhazardTask);
        this.usedGliderTask = new ConditionalStep((QuestHelper)this, this.flyToKaramja, new Requirement[0]);
        doMedium.addStep(this.notUsedGlider, this.usedGliderTask);
        this.caughtKarambwanTask = new ConditionalStep((QuestHelper)this, this.catchKarambwanji, new Requirement[0]);
        this.caughtKarambwanTask.addStep(this.rawKarambwanji.alsoCheckBank(this.questBank), this.catchKarambwan);
        doMedium.addStep(this.notCaughtKarambwan, this.caughtKarambwanTask);
        this.charteredFromShipyardTask = new ConditionalStep((QuestHelper)this, this.charterFromShipyard, new Requirement[0]);
        doMedium.addStep(this.notCharteredFromShipyard, this.charteredFromShipyardTask);
        this.trappedGraahkTask = new ConditionalStep((QuestHelper)this, this.trapGraahk, new Requirement[0]);
        doMedium.addStep(this.notTrappedGraahk, this.trappedGraahkTask);
        this.earned100Task = new ConditionalStep((QuestHelper)this, this.doCleanup, new Requirement[0]);
        doMedium.addStep(this.notEarned100, this.earned100Task);
        this.cookedSpiderTask = new ConditionalStep((QuestHelper)this, this.makeSpiderStick, new Requirement[0]);
        this.cookedSpiderTask.addStep(this.spiderOnAStick, this.cookSpider);
        doMedium.addStep(this.notCookedSpider, this.cookedSpiderTask);
        this.cutTeakTask = new ConditionalStep((QuestHelper)this, this.cutTeak, new Requirement[0]);
        doMedium.addStep(this.notCutTeak, this.cutTeakTask);
        this.cutMahogTask = new ConditionalStep((QuestHelper)this, this.cutMahogany, new Requirement[0]);
        doMedium.addStep(this.notCutMahog, this.cutMahogTask);
        this.exchangedGemsTask = new ConditionalStep((QuestHelper)this, this.getMachete, new Requirement[0]);
        doMedium.addStep(this.notExchangedGems, this.exchangedGemsTask);
        this.cutVineTask = new ConditionalStep((QuestHelper)this, this.enterBrimDungeonVine, new Requirement[0]);
        this.cutVineTask.addStep(this.inBrimhavenDungeon, this.chopVines);
        doMedium.addStep(this.notCutVine, this.cutVineTask);
        this.crossedLavaTask = new ConditionalStep((QuestHelper)this, this.enterBrimDungeonLava, new Requirement[0]);
        this.crossedLavaTask.addStep(this.inBrimhavenDungeon, this.crossLava);
        doMedium.addStep(this.notCrossedLava, this.crossedLavaTask);
        this.climbedStairsTask = new ConditionalStep((QuestHelper)this, this.enterBrimDungeonStairs, new Requirement[0]);
        this.climbedStairsTask.addStep(this.inBrimhavenDungeon, this.climbBrimhavenStaircase);
        doMedium.addStep(this.notClimbedStairs, this.climbedStairsTask);
        steps.put(0, doMedium);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.notClaimedTicket = new VarbitRequirement(3579, 0);
        this.notEnteredWall = new VarbitRequirement(3580, 0);
        this.notEnteredCrandor = new VarbitRequirement(3581, 0);
        this.notUsedCart = new VarbitRequirement(3582, 0);
        this.notEarned100 = new VarbitRequirement(3583, 0);
        this.notCookedSpider = new VarbitRequirement(3584, 0);
        this.notMinedRedRopaz = new VarbitRequirement(3585, 0);
        this.notCutTeak = new VarbitRequirement(3586, 0);
        this.notCutMahog = new VarbitRequirement(3587, 0);
        this.notCaughtKarambwan = new VarbitRequirement(3588, 0);
        this.notExchangedGems = new VarbitRequirement(3589, 0);
        this.notUsedGlider = new VarbitRequirement(3590, 0);
        this.notGrownFruitTree = new VarbitRequirement(3591, 0);
        this.notTrappedGraahk = new VarbitRequirement(3592, 0);
        this.notCutVine = new VarbitRequirement(3593, 0);
        this.notCrossedLava = new VarbitRequirement(3594, 0);
        this.notClimbedStairs = new VarbitRequirement(3595, 0);
        this.notTraveledToKhazard = new VarbitRequirement(3596, 0);
        this.notCharteredFromShipyard = new VarbitRequirement(3597, 0);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(new Conditions(LogicType.OR, this.notMinedRedRopaz, this.notEarned100)).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(new Conditions(LogicType.OR, this.notClaimedTicket, this.notUsedCart, this.notTraveledToKhazard, this.notCharteredFromShipyard));
        this.smallFishingNet = new ItemRequirement("Small fishing net", 303).showConditioned(this.notCaughtKarambwan).isNotConsumed();
        this.spiderCarcass = new ItemRequirement("Spider carcass", 6291).showConditioned(this.notCookedSpider);
        this.spiderCarcass.setTooltip("You can get one killing a spider during Tai Bwo Wannai Cleanup");
        this.skewerTicksOrArrowShaft = new ItemRequirement("Arrow shaft or skewer stick", 52).showConditioned(this.notCookedSpider);
        this.skewerTicksOrArrowShaft.addAlternates(6305);
        this.goutTuber = new ItemRequirement("Gout tuber", 6311).showConditioned(this.notExchangedGems);
        this.goutTuber.setTooltip("This can be obtained rarely during Tai Bwo Wannai Cleanup. Have a spade to dig it up");
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notGrownFruitTree).isNotConsumed();
        this.fruitTreeSapling = new ItemRequirement("A fruit tree sapling you can plant, preferably Palm Tree for the Elite diary", 5502).showConditioned(this.notGrownFruitTree);
        this.fruitTreeSapling.addAlternates(5496, 5497, 5498, 5499, 5500, 5501, 22866);
        this.teasingStick = new ItemRequirement("Teasing stick", 10029).showConditioned(this.notTrappedGraahk).isNotConsumed();
        this.teasingStick.setTooltip("You can buy one from the hunter shop in Yanille");
        this.knife = new ItemRequirement("Knife", 946).showConditioned(this.notTrappedGraahk).isNotConsumed();
        this.logs = new ItemRequirement("Logs", 1511).showConditioned(this.notTrappedGraahk);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(new Conditions(LogicType.OR, this.notTrappedGraahk, this.notCrossedLava, this.notClimbedStairs, this.notCutVine, this.notCutTeak, this.notCutMahog)).isNotConsumed();
        this.tradingSticks = new ItemRequirement("Trading sticks", 6306).showConditioned(this.notExchangedGems);
        this.tradingSticks.setTooltip("You can get these from villagers when doing Tai Bwo Wannai Cleanup");
        this.opal = new ItemRequirement("Opal", 1609).showConditioned(this.notExchangedGems);
        this.opal.setTooltip("You can bring a jade or red topaz instead for a machete if you also bring more trading sticks");
        this.karambwanVessel = new ItemRequirement("Karambwan vessel", 3157).showConditioned(this.notCaughtKarambwan).isNotConsumed();
        this.karambwanVessel.addAlternates(3159);
        this.rawKarambwanji = new ItemRequirement("Raw karambwanji", 3150).showConditioned(this.notCaughtKarambwan);
        this.rawKarambwanjiOrSmallFishingNet = new ItemRequirement("Raw karambwanji, or a small fishing net to catch some", 3150).showConditioned(this.notCaughtKarambwan);
        this.rawKarambwanjiOrSmallFishingNet.addAlternates(303);
        this.spade = new ItemRequirement("Spade", 952).showConditioned(new Conditions(LogicType.OR, this.notEarned100, this.notGrownFruitTree)).isNotConsumed();
        this.machete = new ItemRequirement("Machete", 6317).showConditioned(this.notEarned100).isNotConsumed();
        this.machete.addAlternates(6315, 6313, 975);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.antipoison = new ItemRequirement("Antipoison", ItemCollections.ANTIPOISONS, -1);
        this.spiderOnAStick = new ItemRequirement("Spider on stick", 6293);
        this.spiderOnAStick.setTooltip("You can get one by using a spider carcass on an arrow shaft");
        this.agility12 = new SkillRequirement(Skill.AGILITY, 12);
        this.cooking16 = new SkillRequirement(Skill.COOKING, 16);
        this.farming27 = new SkillRequirement(Skill.FARMING, 27);
        this.fishing65 = new SkillRequirement(Skill.FISHING, 65, true);
        this.hunter41 = new SkillRequirement(Skill.HUNTER, 41);
        this.mining40 = new SkillRequirement(Skill.MINING, 40);
        this.woodcutting50 = new SkillRequirement(Skill.WOODCUTTING, 50);
        this.grandTree = new QuestRequirement(QuestHelperQuest.THE_GRAND_TREE, QuestState.FINISHED);
        this.taiBwoWannaiTrio = new QuestRequirement(QuestHelperQuest.TAI_BWO_WANNAI_TRIO, QuestState.FINISHED, "Partial completion of Tai Bwo Wannai Trio to fish karambwan");
        this.dragonSlayerI = new QuestRequirement(QuestHelperQuest.DRAGON_SLAYER_I, QuestState.FINISHED, "Partial completion of Dragon Slayer I for access to Crandor");
        this.shiloVillage = new QuestRequirement(QuestHelperQuest.SHILO_VILLAGE, QuestState.FINISHED);
        this.junglePotion = new QuestRequirement(QuestHelperQuest.JUNGLE_POTION, QuestState.FINISHED);
        this.inCave = new ZoneRequirement(this.cave);
        this.inAgilityArena = new ZoneRequirement(this.agilityArena);
        this.inBrimhavenDungeon = new ZoneRequirement(this.brimhavenDungeon);
    }

    public void loadZones() {
        this.cave = new Zone(new WorldPoint(2821, 9545, 0), new WorldPoint(2879, 9663, 0));
        this.agilityArena = new Zone(new WorldPoint(2747, 9531, 0), new WorldPoint(2813, 9601, 3));
        this.brimhavenDungeon = new Zone(new WorldPoint(2560, 9411, 0), new WorldPoint(2752, 9599, 2));
    }

    public void setupSteps() {
        this.enterAgilityArena = new ObjectStep((QuestHelper)this, 3617, new WorldPoint(2809, 3194, 0), "Pay Cap'n Izzy No Beard 200 coins and enter the Agility Arena in Brimhaven.", this.coins.quantity(200));
        this.tag2Pillars = new DetailedQuestStep((QuestHelper)this, "Tag 2 marked pillars in a row.", new Requirement[0]);
        this.enterVolcano = new ObjectStep((QuestHelper)this, 11441, new WorldPoint(2857, 3169, 0), "Enter the Karamja Volcano.", new Requirement[0]);
        this.returnThroughWall = new ObjectStep((QuestHelper)this, 2606, new WorldPoint(2836, 9600, 0), "Return back through the shortcut.", new Requirement[0]);
        this.useCart = new ObjectStep((QuestHelper)this, 2230, new WorldPoint(2778, 3212, 0), "Travel on the cart north of Brimhaven.", this.coins.quantity(200));
        this.doCleanup = new DetailedQuestStep((QuestHelper)this, "Talk to Murcaily in the east of Tai Bwo Wannai to start up the cleanup, then chop the light jungle and repair the rotten fences until 100% favour. Make sure you dig up any gout tuber and mine any gem rocks that may appear.", this.machete, this.spade, this.pickaxe, this.antipoison);
        this.makeSpiderStick = new DetailedQuestStep((QuestHelper)this, "Make a spider on stick by using a spider carcass on an arrow shaft.", this.spiderCarcass.highlighted(), this.skewerTicksOrArrowShaft.highlighted());
        this.cookSpider = new DetailedQuestStep((QuestHelper)this, "Cook a spider on a stick on a fire/range.", this.spiderOnAStick);
        this.climbUpToBoat = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2763, 2952, 0), "Charter the Lady of the Waves from south of Cairn Isle to Port Khazard.", this.coins.quantity(50));
        this.travelToKhazard = new NpcStep((QuestHelper)this, 5364, new WorldPoint(2761, 2959, 1), "Charter the Lady of the Waves from south of Cairn Isle to Port Khazard.", this.coins.quantity(50));
        this.travelToKhazard.addDialogSteps("Yes, I'll buy a ticket for the ship.", "Khazard Port please.");
        this.travelToKhazard.addSubSteps(this.climbUpToBoat);
        this.cutTeak = new ObjectStep((QuestHelper)this, 9036, new WorldPoint(2822, 3078, 0), "Chop a teak tree down either in the Hardwood Grove in Tai Bwo Wannai or in the Kharazi Jungle (requires Legends' Quest started).", this.axe, this.tradingSticks.quantity(100));
        this.cutMahogany = new ObjectStep((QuestHelper)this, 36688, new WorldPoint(2820, 3080, 0), "Chop a mahogany tree down either in the Hardwood Grove in Tai Bwo Wannai or in the Kharazi Jungle (requires Legends' Quest started).", this.axe, this.tradingSticks.quantity(100));
        this.catchKarambwanji = new NpcStep((QuestHelper)this, 4710, new WorldPoint(2791, 3019, 0), "Using your small fishing net, catch some raw karambwanji just south of Tai Bwo Wannai, or buy some from the GE.", this.smallFishingNet);
        this.catchKarambwan = new NpcStep((QuestHelper)this, 4712, new WorldPoint(2899, 3119, 0), "Fish a karambwan from the north east coast of Karamja.", this.karambwanVessel, this.rawKarambwanji);
        this.getMachete = new NpcStep((QuestHelper)this, 6423, new WorldPoint(2790, 3100, 0), "Get a gem machete from Safta Doc. If you want to make a red topaz one, you'll need 1200 trading sticks.", this.goutTuber, this.opal.quantity(3), this.tradingSticks.quantity(300));
        ((NpcStep)this.getMachete).addAlternateNpcs(6422);
        this.getMachete.addDialogSteps("What do you do here?", "Yes, I'd like to get a machete.");
        this.flyToKaramja = new NpcStep((QuestHelper)this, 10452, new WorldPoint(3284, 3213, 0), "Fly on a Gnome Glider to Karamja.", new Requirement[0]);
        this.growFruitTree = new ObjectStep((QuestHelper)this, 7964, new WorldPoint(2765, 3213, 0), "Grow a fruit tree in the Brimhaven patch. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.fruitTreeSapling, this.rake, this.spade);
        this.trapGraahk = new NpcStep((QuestHelper)this, 2909, new WorldPoint(2770, 3003, 0), "Place logs over a pit north of Cairn Isle, and poke a graahk with a teasing stick. Jump over the pits until the graahk falls in and loot it.", this.teasingStick, this.knife, this.logs);
        this.enterBrimDungeonVine = new ObjectStep((QuestHelper)this, 20876, new WorldPoint(2745, 3155, 0), "Enter Brimhaven Dungeon.", this.axe, this.coins.quantity(875));
        this.enterBrimDungeonLava = new ObjectStep((QuestHelper)this, 20876, new WorldPoint(2745, 3155, 0), "Enter Brimhaven Dungeon.", this.coins.quantity(875));
        this.enterBrimDungeonStairs = new ObjectStep((QuestHelper)this, 20876, new WorldPoint(2745, 3155, 0), "Enter Brimhaven Dungeon.", this.coins.quantity(875));
        this.chopVines = new ObjectStep((QuestHelper)this, 21731, new WorldPoint(2690, 9564, 0), "Chop the vines nearby.", this.axe);
        this.crossLava = new ObjectStep((QuestHelper)this, 21738, new WorldPoint(2649, 9561, 0), "Cross the lava to the west of the entrance.", new Requirement[0]);
        this.climbBrimhavenStaircase = new ObjectStep((QuestHelper)this, 21725, new WorldPoint(2637, 9515, 0), "Climb up to the top floor of the Brimhaven Dungeon.", new Requirement[0]);
        this.charterFromShipyard = new NpcStep((QuestHelper)this, 9349, new WorldPoint(3001, 3032, 0), "Travel with the charter ship in the Shipyard. Musa Point is the cheapest destination.", this.coins.quantity(200));
        this.charterFromShipyard.addDialogSteps("Glough sent me.", "Ka.", "Lu.", "Min.");
        this.mineRedTopaz = new ObjectStep((QuestHelper)this, 11380, new WorldPoint(2823, 2999, 0), "Mine gem rocks until you get a red topaz.", this.pickaxe);
        ((ObjectStep)this.mineRedTopaz).addAlternateObjects(11381);
        this.enterCrandor = new ObjectStep((QuestHelper)this, 25213, new WorldPoint(2833, 9657, 0), "Climb the rope to Crandor Isle.", new Requirement[0]);
        this.claimReward = new NpcStep((QuestHelper)this, 7650, new WorldPoint(2810, 3192, 0), "Talk to Pirate Jackie the Fruit in Brimhaven to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(1615), this.spiderCarcass, this.skewerTicksOrArrowShaft, this.goutTuber, this.spade, this.rake, this.fruitTreeSapling, this.teasingStick, this.knife, this.logs, this.axe, this.pickaxe, this.opal.quantity(3), this.tradingSticks.quantity(500), this.karambwanVessel, this.rawKarambwanjiOrSmallFishingNet, this.machete);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.antipoison);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 12));
        reqs.add(new SkillRequirement(Skill.COOKING, 16));
        reqs.add(new SkillRequirement(Skill.FARMING, 27));
        reqs.add(new SkillRequirement(Skill.FISHING, 65, true));
        reqs.add(new SkillRequirement(Skill.HUNTER, 41));
        reqs.add(new SkillRequirement(Skill.MINING, 40));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 50));
        reqs.add(new QuestRequirement(QuestHelperQuest.THE_GRAND_TREE, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.TAI_BWO_WANNAI_TRIO, QuestState.FINISHED, "Partial completion of Tai Bwo Wannai Trio to fish karambwan"));
        reqs.add(new QuestRequirement(QuestHelperQuest.DRAGON_SLAYER_I, QuestState.FINISHED, "Partial completion of Dragon Slayer I for access to Crandor"));
        reqs.add(new QuestRequirement(QuestHelperQuest.SHILO_VILLAGE, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Karamja Gloves (2)", 11138, 1), new ItemReward("5,000 Exp. Lamp (Any skill above level 30)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Increased Agility Experience when redeeming Agility tickets"), new UnlockReward("10% increased Agility experience earned from Brimhaven Agility Arena"), new UnlockReward("Access to the stepping stone shortcut across the river of Shilo Village"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails growFruitTreeSteps = new PanelDetails("Grow a Healthy Fruit Tree", Collections.singletonList(this.growFruitTree), this.farming27, this.fruitTreeSapling, this.rake, this.spade);
        growFruitTreeSteps.setDisplayCondition(this.notGrownFruitTree);
        growFruitTreeSteps.setLockingStep(this.grownFruitTreeTask);
        allSteps.add(growFruitTreeSteps);
        PanelDetails enteredWallSteps = new PanelDetails("Discover Hidden Wall in Volcano", Arrays.asList(this.enterVolcano, this.returnThroughWall), this.dragonSlayerI);
        enteredWallSteps.setDisplayCondition(this.notEnteredWall);
        enteredWallSteps.setLockingStep(this.enteredWallTask);
        allSteps.add(enteredWallSteps);
        PanelDetails enteredCrandorSteps = new PanelDetails("Enter Crandor", Arrays.asList(this.enterVolcano, this.enterCrandor), this.dragonSlayerI, this.food);
        enteredCrandorSteps.setDisplayCondition(this.notEnteredCrandor);
        enteredCrandorSteps.setLockingStep(this.enteredCrandorTask);
        allSteps.add(enteredCrandorSteps);
        PanelDetails enterAgiSteps = new PanelDetails("Claim a ticket in The Agility Arena", Arrays.asList(this.enterAgilityArena, this.tag2Pillars), this.coins.quantity(200));
        enterAgiSteps.setDisplayCondition(this.notClaimedTicket);
        enterAgiSteps.setLockingStep(this.claimedTicketTask);
        allSteps.add(enterAgiSteps);
        PanelDetails usedCartSteps = new PanelDetails("Use Vigroy & Hajedy's Cart Service", Collections.singletonList(this.useCart), this.shiloVillage, this.coins.quantity(200));
        usedCartSteps.setDisplayCondition(this.notUsedCart);
        usedCartSteps.setLockingStep(this.usedCartTask);
        allSteps.add(usedCartSteps);
        PanelDetails mineRedTopazSteps = new PanelDetails("Mine Red Topaz", Collections.singletonList(this.mineRedTopaz), this.shiloVillage, this.mining40, this.pickaxe);
        mineRedTopazSteps.setDisplayCondition(this.notMinedRedRopaz);
        mineRedTopazSteps.setLockingStep(this.minedRedRopazTask);
        allSteps.add(mineRedTopazSteps);
        PanelDetails travelToKhazardSteps = new PanelDetails("Travel to Port Khazard", Collections.singletonList(this.travelToKhazard), this.shiloVillage, this.coins.quantity(50));
        travelToKhazardSteps.setDisplayCondition(this.notTraveledToKhazard);
        travelToKhazardSteps.setLockingStep(this.traveledToKhazardTask);
        allSteps.add(travelToKhazardSteps);
        PanelDetails useGnomeGliderSteps = new PanelDetails("Use Gnome Glider", Collections.singletonList(this.flyToKaramja), this.grandTree);
        useGnomeGliderSteps.setDisplayCondition(this.notUsedGlider);
        useGnomeGliderSteps.setLockingStep(this.usedGliderTask);
        allSteps.add(useGnomeGliderSteps);
        PanelDetails catchAKarambwanSteps = new PanelDetails("Catch a Karambwan", Collections.singletonList(this.catchKarambwan), this.fishing65, this.taiBwoWannaiTrio, this.karambwanVessel, this.rawKarambwanjiOrSmallFishingNet);
        catchAKarambwanSteps.setDisplayCondition(this.notCaughtKarambwan);
        catchAKarambwanSteps.setLockingStep(this.caughtKarambwanTask);
        allSteps.add(catchAKarambwanSteps);
        PanelDetails charteredShipyardSteps = new PanelDetails("Charter a Ship in The Shipyard", Collections.singletonList(this.charterFromShipyard), this.grandTree, this.coins.quantity(200));
        charteredShipyardSteps.setDisplayCondition(this.notCharteredFromShipyard);
        charteredShipyardSteps.setLockingStep(this.charteredFromShipyardTask);
        allSteps.add(charteredShipyardSteps);
        PanelDetails trapAHornedGraahkSteps = new PanelDetails("Trap a Horned Graahk", Collections.singletonList(this.trapGraahk), this.hunter41, this.teasingStick, this.knife, this.logs);
        trapAHornedGraahkSteps.setDisplayCondition(this.notTrappedGraahk);
        trapAHornedGraahkSteps.setLockingStep(this.trappedGraahkTask);
        allSteps.add(trapAHornedGraahkSteps);
        PanelDetails earn100Steps = new PanelDetails("Earn 100% Favour in Tai Bwo Wannai Cleanup", Collections.singletonList(this.doCleanup), this.junglePotion, this.machete, this.spade, this.pickaxe, this.antipoison);
        earn100Steps.setDisplayCondition(this.notEarned100);
        earn100Steps.setLockingStep(this.earned100Task);
        allSteps.add(earn100Steps);
        PanelDetails spiderOnStickSteps = new PanelDetails("Cook a Spider on Stick", Arrays.asList(this.makeSpiderStick, this.cookSpider), this.cooking16, this.spiderCarcass, this.skewerTicksOrArrowShaft);
        spiderOnStickSteps.setDisplayCondition(this.notCookedSpider);
        spiderOnStickSteps.setLockingStep(this.cookedSpiderTask);
        allSteps.add(spiderOnStickSteps);
        PanelDetails cutATeakTreeSteps = new PanelDetails("Cut a Teak Tree", Collections.singletonList(this.cutTeak), new SkillRequirement(Skill.WOODCUTTING, 35), this.junglePotion, this.axe, this.tradingSticks.quantity(100));
        cutATeakTreeSteps.setDisplayCondition(this.notCutTeak);
        cutATeakTreeSteps.setLockingStep(this.cutTeakTask);
        allSteps.add(cutATeakTreeSteps);
        PanelDetails cutAMahoganyTreeSteps = new PanelDetails("Cut a Mahogany Tree", Collections.singletonList(this.cutMahogany), this.junglePotion, this.woodcutting50, this.axe, this.tradingSticks.quantity(100));
        cutAMahoganyTreeSteps.setDisplayCondition(this.notCutMahog);
        cutAMahoganyTreeSteps.setLockingStep(this.cutMahogTask);
        allSteps.add(cutAMahoganyTreeSteps);
        PanelDetails exchangeGemsWithSaftaDocSteps = new PanelDetails("Exchange Gems with Safta Doc", Collections.singletonList(this.getMachete), this.junglePotion, this.goutTuber, this.opal.quantity(3), this.tradingSticks.quantity(300));
        exchangeGemsWithSaftaDocSteps.setDisplayCondition(this.notExchangedGems);
        exchangeGemsWithSaftaDocSteps.setLockingStep(this.exchangedGemsTask);
        allSteps.add(exchangeGemsWithSaftaDocSteps);
        PanelDetails chopVinesSteps = new PanelDetails("Chop Vines in Brimhaven Dungeon", Arrays.asList(this.enterBrimDungeonVine, this.chopVines), new SkillRequirement(Skill.WOODCUTTING, 10), this.axe, this.coins.quantity(875));
        chopVinesSteps.setDisplayCondition(this.notCutVine);
        chopVinesSteps.setLockingStep(this.cutVineTask);
        allSteps.add(chopVinesSteps);
        PanelDetails crossLavaSteps = new PanelDetails("Cross The Lava in Brimhaven Dungeon", Arrays.asList(this.enterBrimDungeonLava, this.crossLava), this.agility12, this.axe, this.coins.quantity(875));
        crossLavaSteps.setDisplayCondition(this.notCrossedLava);
        crossLavaSteps.setLockingStep(this.crossedLavaTask);
        allSteps.add(crossLavaSteps);
        PanelDetails climbStairsSteps = new PanelDetails("Climb The Stairs in Brimhaven Dungeon", Arrays.asList(this.enterBrimDungeonStairs, this.climbBrimhavenStaircase), new SkillRequirement(Skill.WOODCUTTING, 10), this.axe, this.coins.quantity(875));
        climbStairsSteps.setDisplayCondition(this.notClimbedStairs);
        climbStairsSteps.setLockingStep(this.climbedStairsTask);
        allSteps.add(climbStairsSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

