/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.karamja;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarPlayer;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.CombatLevelRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KARAMJA_HARD)
public class KaramjaHard
extends ComplexStateQuestHelper {
    ItemRequirement oomlieWrap;
    ItemRequirement pureEssence;
    ItemRequirement natureTalismanOrAbyss;
    ItemRequirement coins;
    ItemRequirement rawKarambwan;
    ItemRequirement axe;
    ItemRequirement machete;
    ItemRequirement pickaxe;
    ItemRequirement lockpick;
    ItemRequirement crossbow;
    ItemRequirement mithGrapple;
    ItemRequirement antidragonShield;
    ItemRequirement antifirePotions;
    ItemRequirement combatGear;
    ItemRequirement fightCaveCombatGear;
    ItemRequirement food;
    ItemRequirement antipoison;
    Requirement combat100;
    Requirement agility53;
    Requirement cooking30;
    Requirement magic59;
    Requirement mining52;
    Requirement ranged42;
    Requirement runecrafting44;
    Requirement slayer50;
    Requirement smithing40;
    Requirement strength50;
    Requirement thieving50;
    Requirement woodcutting34;
    Requirement taiBwoWannaiTrio;
    Requirement legendsQuest;
    Requirement shiloVillage;
    Requirement notBecomeChampion;
    Requirement notKilledZek;
    Requirement notEatenWrap;
    Requirement notCraftedNature;
    Requirement notCookedKarambwan;
    Requirement notKilledDeathwing;
    Requirement notUsedShortcut;
    Requirement notCollectedLeaves;
    Requirement notAssignedTask;
    Requirement notKilledDragon;
    QuestStep enterHole;
    QuestStep enterTzhaar;
    QuestStep enterHoleChampion;
    QuestStep enterTzhaarChampion;
    QuestStep becomeChampion;
    QuestStep enterFightCaves;
    QuestStep defeatZek;
    QuestStep eatOomlie;
    QuestStep enterNatureAltar;
    QuestStep craftNatureRune;
    QuestStep cookKarambwan;
    QuestStep enterKharaziHole;
    QuestStep enterBookcase;
    QuestStep enterGates;
    QuestStep killDeathwing;
    QuestStep useShortcut;
    QuestStep collectPalmLeaves;
    QuestStep goUpToDuradel;
    QuestStep getTask;
    QuestStep enterBrimhavenDungeon;
    QuestStep killDragon;
    QuestStep claimReward;
    Zone cave;
    Zone tzhaar;
    Zone fightCaves;
    Zone brimhavenDungeon;
    Zone duradelRoom;
    Zone natureAltar;
    Zone deathwingArea1;
    Zone deathwingArea2;
    Zone deathwingArea3;
    ZoneRequirement inCave;
    ZoneRequirement inTzhaar;
    ZoneRequirement inFightCaves;
    ZoneRequirement inBrimhavenDungeon;
    ZoneRequirement atDuradel;
    ZoneRequirement inNatureAltar;
    ZoneRequirement inDeathwingArea1;
    ZoneRequirement inDeathwingArea2;
    ZoneRequirement inDeathwingArea3;
    ConditionalStep becomeChampionTask;
    ConditionalStep killedZekTask;
    ConditionalStep eatenWrapTask;
    ConditionalStep craftedNatureTask;
    ConditionalStep cookedKarambwanTask;
    ConditionalStep killedDeathwingTask;
    ConditionalStep usedShortcutTask;
    ConditionalStep collectedLeavesTask;
    ConditionalStep assignedTaskTask;
    ConditionalStep killedDragonTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.becomeChampionTask = new ConditionalStep((QuestHelper)this, this.enterHoleChampion, new Requirement[0]);
        this.becomeChampionTask.addStep(this.inCave, this.enterTzhaarChampion);
        this.becomeChampionTask.addStep(this.inTzhaar, this.becomeChampion);
        doHard.addStep(this.notBecomeChampion, this.becomeChampionTask);
        this.killedZekTask = new ConditionalStep((QuestHelper)this, this.enterHole, new Requirement[0]);
        this.killedZekTask.addStep(this.inCave, this.enterTzhaar);
        this.killedZekTask.addStep(this.inTzhaar, this.enterFightCaves);
        this.killedZekTask.addStep(this.inFightCaves, this.defeatZek);
        doHard.addStep(this.notKilledZek, this.killedZekTask);
        this.cookedKarambwanTask = new ConditionalStep((QuestHelper)this, this.cookKarambwan, new Requirement[0]);
        doHard.addStep(this.notCookedKarambwan, this.cookedKarambwanTask);
        this.killedDragonTask = new ConditionalStep((QuestHelper)this, this.enterBrimhavenDungeon, new Requirement[0]);
        this.killedDragonTask.addStep(this.inBrimhavenDungeon, this.killDragon);
        doHard.addStep(this.notKilledDragon, this.killedDragonTask);
        this.craftedNatureTask = new ConditionalStep((QuestHelper)this, this.enterNatureAltar, new Requirement[0]);
        this.craftedNatureTask.addStep(this.inNatureAltar, this.craftNatureRune);
        doHard.addStep(this.notCraftedNature, this.craftedNatureTask);
        this.assignedTaskTask = new ConditionalStep((QuestHelper)this, this.goUpToDuradel, new Requirement[0]);
        this.assignedTaskTask.addStep(this.atDuradel, this.getTask);
        doHard.addStep(this.notAssignedTask, this.assignedTaskTask);
        this.collectedLeavesTask = new ConditionalStep((QuestHelper)this, this.collectPalmLeaves, new Requirement[0]);
        doHard.addStep(this.notCollectedLeaves, this.collectedLeavesTask);
        this.killedDeathwingTask = new ConditionalStep((QuestHelper)this, this.enterKharaziHole, new Requirement[0]);
        this.killedDeathwingTask.addStep(this.inDeathwingArea1, this.enterBookcase);
        this.killedDeathwingTask.addStep(this.inDeathwingArea2, this.enterGates);
        this.killedDeathwingTask.addStep(this.inDeathwingArea3, this.killDeathwing);
        doHard.addStep(this.notKilledDeathwing, this.killedDeathwingTask);
        this.usedShortcutTask = new ConditionalStep((QuestHelper)this, this.useShortcut, new Requirement[0]);
        doHard.addStep(this.notUsedShortcut, this.usedShortcutTask);
        this.eatenWrapTask = new ConditionalStep((QuestHelper)this, this.eatOomlie, new Requirement[0]);
        doHard.addStep(this.notEatenWrap, this.eatOomlie);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notBecomeChampion = new VarbitRequirement(3600, 0);
        this.notKilledZek = new VarbitRequirement(3601, 0);
        this.notEatenWrap = new VarbitRequirement(3602, 0);
        this.notCraftedNature = new VarbitRequirement(3603, 0);
        this.notCookedKarambwan = new VarbitRequirement(3604, 0);
        this.notKilledDeathwing = new VarbitRequirement(3605, 0);
        this.notUsedShortcut = new VarbitRequirement(3606, 0);
        this.notCollectedLeaves = new VarbitRequirement(3607, 4, Operation.LESS_EQUAL);
        this.notAssignedTask = new VarbitRequirement(3608, 0);
        this.notKilledDragon = new VarbitRequirement(3609, 0);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notKilledDeathwing).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notKilledDragon);
        this.oomlieWrap = new ItemRequirement("Oomlie wrap", 2343).showConditioned(this.notEatenWrap);
        this.oomlieWrap.setTooltip("You can make one by using a palm leaf on a raw oomlie and cooking it. Both are obtained from the Kharazi Jungle");
        this.pureEssence = new ItemRequirement("Pure essence", 7936).showConditioned(this.notCraftedNature);
        this.natureTalismanOrAbyss = new ItemRequirement("Access to the Nature Altar", 1462).showConditioned(this.notCraftedNature).isNotConsumed();
        this.natureTalismanOrAbyss.addAlternates(5541);
        this.natureTalismanOrAbyss.setTooltip("Nature talisman or tiara");
        this.rawKarambwan = new ItemRequirement("Raw karambwan", 3142).showConditioned(this.notCookedKarambwan);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(new Conditions(LogicType.OR, this.notCollectedLeaves, this.notKilledDeathwing, this.notKilledDragon)).isNotConsumed();
        this.machete = new ItemRequirement("Any machete", 975).showConditioned(new Conditions(LogicType.OR, this.notCollectedLeaves, this.notKilledDeathwing)).isNotConsumed();
        this.machete.addAlternates(6313, 6315, 6317);
        this.lockpick = new ItemRequirement("Lockpick, more in case it breaks", 1523).showConditioned(this.notKilledDeathwing).isNotConsumed();
        this.crossbow = new ItemRequirement("Any crossbow", 837).showConditioned(this.notUsedShortcut).isNotConsumed();
        this.crossbow.addAlternates(9174, 9177, 9179, 9181, 9183, 9185, 21902, 9176, 8880, 11785, 26374);
        this.mithGrapple = new ItemRequirement("Mith grapple", 9419).showConditioned(this.notUsedShortcut).isNotConsumed();
        this.antidragonShield = new ItemRequirement("Anti-dragon shield or DFS", ItemCollections.ANTIFIRE_SHIELDS).showConditioned(this.notKilledDragon).isNotConsumed();
        this.antifirePotions = new ItemRequirement("Antifire potions", ItemCollections.ANTIFIRE).showConditioned(this.notKilledDragon);
        this.combatGear = new ItemRequirement("Combat gear to defeat a deathwing and a metal dragon", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.fightCaveCombatGear = new ItemRequirement("Combat gear to reach wave 31 in the Fight Caves and defeat a Ket-Zek", -1, -1).isNotConsumed();
        this.fightCaveCombatGear.setDisplayItemId(BankSlotIcons.getRangedCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.antipoison = new ItemRequirement("Antipoison", ItemCollections.ANTIPOISONS, -1);
        this.inCave = new ZoneRequirement(this.cave);
        this.inTzhaar = new ZoneRequirement(this.tzhaar);
        this.inFightCaves = new ZoneRequirement(this.fightCaves);
        this.inBrimhavenDungeon = new ZoneRequirement(this.brimhavenDungeon);
        this.atDuradel = new ZoneRequirement(this.duradelRoom);
        this.inNatureAltar = new ZoneRequirement(this.natureAltar);
        this.inDeathwingArea1 = new ZoneRequirement(this.deathwingArea1);
        this.inDeathwingArea2 = new ZoneRequirement(this.deathwingArea2);
        this.inDeathwingArea3 = new ZoneRequirement(this.deathwingArea3);
        this.combat100 = new CombatLevelRequirement(100);
        this.agility53 = new SkillRequirement(Skill.AGILITY, 53);
        this.cooking30 = new SkillRequirement(Skill.COOKING, 30);
        this.magic59 = new SkillRequirement(Skill.MAGIC, 59);
        this.mining52 = new SkillRequirement(Skill.MINING, 52);
        this.ranged42 = new SkillRequirement(Skill.RANGED, 42);
        this.runecrafting44 = new SkillRequirement(Skill.RUNECRAFT, 44);
        this.slayer50 = new SkillRequirement(Skill.SLAYER, 50);
        this.smithing40 = new SkillRequirement(Skill.SMITHING, 40);
        this.strength50 = new SkillRequirement(Skill.STRENGTH, 50);
        this.thieving50 = new SkillRequirement(Skill.THIEVING, 50);
        this.woodcutting34 = new SkillRequirement(Skill.WOODCUTTING, 34);
        this.taiBwoWannaiTrio = new QuestRequirement(QuestHelperQuest.TAI_BWO_WANNAI_TRIO, QuestState.FINISHED);
        this.legendsQuest = new VarplayerRequirement(QuestVarPlayer.QUEST_LEGENDS_QUEST.getId(), 1, Operation.GREATER_EQUAL, "Partial completion of Legends' Quest");
        this.shiloVillage = new QuestRequirement(QuestHelperQuest.SHILO_VILLAGE, QuestState.FINISHED);
    }

    public void loadZones() {
        this.cave = new Zone(new WorldPoint(2821, 9545, 0), new WorldPoint(2879, 9663, 0));
        this.tzhaar = new Zone(new WorldPoint(2360, 5056, 0), new WorldPoint(2560, 5185, 0));
        this.fightCaves = new Zone(new WorldPoint(2368, 5052, 0), new WorldPoint(2430, 5121, 0));
        this.brimhavenDungeon = new Zone(new WorldPoint(2560, 9411, 0), new WorldPoint(2752, 9599, 2));
        this.duradelRoom = new Zone(new WorldPoint(2863, 2964, 1), new WorldPoint(2876, 2986, 1));
        this.natureAltar = new Zone(new WorldPoint(2374, 4809, 0), new WorldPoint(2421, 4859, 0));
        this.deathwingArea1 = new Zone(new WorldPoint(2764, 9316, 0), new WorldPoint(2798, 9345, 0));
        this.deathwingArea2 = new Zone(new WorldPoint(2799, 9314, 0), new WorldPoint(2815, 9343, 0));
        this.deathwingArea3 = new Zone(new WorldPoint(2748, 9272, 0), new WorldPoint(2818, 9313, 0));
    }

    public void setupSteps() {
        this.enterHole = new ObjectStep((QuestHelper)this, 11441, new WorldPoint(2857, 3169, 0), "Enter Mor Ul Rek under the Karamja Volcano.", new Requirement[0]);
        this.enterTzhaar = new ObjectStep((QuestHelper)this, 11835, new WorldPoint(2864, 9572, 0), "Enter Mor Ul Rek under the Karamja Volcano.", new Requirement[0]);
        this.enterFightCaves = new ObjectStep((QuestHelper)this, 11833, new WorldPoint(2438, 5167, 0), "Enter the fight caves in Mor Ul Rek, ready to reach at least wave 31 to defeat a Ket-Zek.", this.fightCaveCombatGear);
        this.enterFightCaves.addSubSteps(this.enterHole, this.enterTzhaar);
        this.enterHoleChampion = new ObjectStep((QuestHelper)this, 11441, new WorldPoint(2857, 3169, 0), "Enter Mor Ul Rek under the Karamja Volcano.", new Requirement[0]);
        this.enterTzhaarChampion = new ObjectStep((QuestHelper)this, 11835, new WorldPoint(2864, 9572, 0), "Enter the cave that leads to Mor Ul Rek under the Karamja Volcano.", new Requirement[0]);
        this.becomeChampion = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2399, 5173, 0), "Win in the Fight Pits in the north west of Mor Ul Rek. You can ask a friend to come lose to you.", new Requirement[0]);
        this.becomeChampion.addSubSteps(this.enterHoleChampion, this.enterTzhaarChampion);
        this.defeatZek = new NpcStep((QuestHelper)this, 3125, "Reach at least wave 31 to defeat Ket-Zek.", new Requirement[0]);
        this.eatOomlie = new DetailedQuestStep((QuestHelper)this, "Eat an oomlie wrap.", this.oomlieWrap.highlighted());
        this.enterNatureAltar = new ObjectStep((QuestHelper)this, 34821, new WorldPoint(2869, 3019, 0), "Enter the nature altar, either from the ruin or through the Abyss.", this.natureTalismanOrAbyss, this.pureEssence);
        this.craftNatureRune = new ObjectStep((QuestHelper)this, 34768, new WorldPoint(2400, 4841, 0), "Craft a nature rune.", this.pureEssence);
        this.cookKarambwan = new DetailedQuestStep((QuestHelper)this, "Cook a raw karambwan.", this.rawKarambwan);
        this.enterKharaziHole = new ObjectStep((QuestHelper)this, 2900, new WorldPoint(2782, 2937, 0), "Search and then enter the Mossy Rocks in the north west of the Kharazi, and follow the cavern to kill a deathwing.", this.machete, this.axe, this.pickaxe, this.lockpick);
        this.enterKharaziHole.addDialogStep("Yes, I'll crawl through, I'm very athletic.");
        this.enterBookcase = new ObjectStep((QuestHelper)this, 2911, new WorldPoint(2796, 9339, 0), "Right-click search the bookcase and slide past it.", new Requirement[0]);
        this.enterBookcase.addDialogStep("Yes please!");
        this.enterGates = new ObjectStep((QuestHelper)this, 2922, new WorldPoint(2810, 9314, 0), "Smash through the boulders and enter the gate at the end of the corridor.", this.pickaxe, this.lockpick);
        this.enterGates.addDialogStep("Yes, I'm very strong, I'll force them open.");
        this.killDeathwing = new NpcStep((QuestHelper)this, 509, new WorldPoint(2810, 9300, 0), "Kill a death wing.", new Requirement[0]);
        this.enterKharaziHole.addSubSteps(this.enterBookcase, this.enterGates, this.killDeathwing);
        this.useShortcut = new ObjectStep((QuestHelper)this, 17074, new WorldPoint(2874, 3135, 0), "Grapple across the shortcut south of Musa Point.", this.crossbow.equipped(), this.mithGrapple.equipped());
        this.collectPalmLeaves = new ObjectStep((QuestHelper)this, 2975, new WorldPoint(2845, 2915, 0), "Shake leafy palm trees in the Kharazi Jungle and pick up 5 palm leaves. You can pick up and drop the same leaf for this task.", this.axe, this.machete, this.pickaxe, this.lockpick);
        this.goUpToDuradel = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2871, 2971, 0), "Climb the ladder to Duradel.", new Requirement[0]);
        this.getTask = new NpcStep((QuestHelper)this, 405, new WorldPoint(2869, 2982, 1), "Get a task from Duradel.", new Requirement[0]);
        this.enterBrimhavenDungeon = new ObjectStep((QuestHelper)this, 20876, new WorldPoint(2745, 3155, 0), "Enter Brimhaven Dungeon.", this.axe, this.coins.quantity(875), this.combatGear, this.antidragonShield);
        this.killDragon = new NpcStep((QuestHelper)this, 270, new WorldPoint(2735, 9488, 0), "Kill any metal dragon in the south of the dungeon.", this.combatGear, this.antidragonShield);
        this.claimReward = new NpcStep((QuestHelper)this, 7650, new WorldPoint(2810, 3192, 0), "Talk to Pirate Jackie the Fruit in Brimhaven to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.oomlieWrap, this.pureEssence, this.natureTalismanOrAbyss, this.coins.quantity(875), this.rawKarambwan, this.axe, this.machete, this.pickaxe, this.lockpick, this.crossbow, this.mithGrapple, this.antidragonShield, this.combatGear, this.fightCaveCombatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.antipoison, this.antifirePotions);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new CombatLevelRequirement(100));
        reqs.add(new SkillRequirement(Skill.AGILITY, 53));
        reqs.add(new SkillRequirement(Skill.COOKING, 30));
        reqs.add(new SkillRequirement(Skill.MINING, 52));
        reqs.add(new SkillRequirement(Skill.RANGED, 42));
        reqs.add(new SkillRequirement(Skill.RUNECRAFT, 44));
        reqs.add(new SkillRequirement(Skill.SLAYER, 50));
        reqs.add(new SkillRequirement(Skill.STRENGTH, 50));
        reqs.add(new SkillRequirement(Skill.THIEVING, 50));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 15));
        reqs.add(new QuestRequirement(QuestHelperQuest.TAI_BWO_WANNAI_TRIO, QuestState.FINISHED));
        reqs.add(new VarplayerRequirement(QuestVarPlayer.QUEST_LEGENDS_QUEST.getId(), 1, Operation.GREATER_EQUAL, "Partial completion of Legends' Quest"));
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Karamja Gloves (3)", 11140, 1), new ItemReward("10,000 Exp. Lamp (Any skill above level 40)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Unlimited Teleports to the underground Shilo Village mine"), new UnlockReward("Access to the underground Shilo Village mine"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails championSteps = new PanelDetails("Fight Pit Champion", Arrays.asList(this.enterHoleChampion, this.enterTzhaarChampion, this.becomeChampion), new Requirement[0]);
        championSteps.setDisplayCondition(this.notBecomeChampion);
        championSteps.setLockingStep(this.becomeChampionTask);
        allSteps.add(championSteps);
        PanelDetails ketZekSteps = new PanelDetails("Kill Ket-Zek", Arrays.asList(this.enterTzhaar, this.enterFightCaves, this.defeatZek), this.fightCaveCombatGear, this.food);
        ketZekSteps.setDisplayCondition(this.notKilledZek);
        ketZekSteps.setLockingStep(this.killedZekTask);
        allSteps.add(ketZekSteps);
        PanelDetails cookedKaramSteps = new PanelDetails("Thoroughly Cook Karambwan", Collections.singletonList(this.cookKarambwan), this.cooking30, this.taiBwoWannaiTrio, this.rawKarambwan);
        cookedKaramSteps.setDisplayCondition(this.notCookedKarambwan);
        cookedKaramSteps.setLockingStep(this.cookedKarambwanTask);
        allSteps.add(cookedKaramSteps);
        PanelDetails killDragonSteps = new PanelDetails("Kill Metal Dragon", Arrays.asList(this.enterBrimhavenDungeon, this.killDragon), this.combatGear, this.antidragonShield, this.axe, this.coins.quantity(875));
        killDragonSteps.setDisplayCondition(this.notKilledDragon);
        killDragonSteps.setLockingStep(this.killedDragonTask);
        allSteps.add(killDragonSteps);
        PanelDetails natureRuneSteps = new PanelDetails("Craft Nature Rune", Arrays.asList(this.enterNatureAltar, this.craftNatureRune), this.runecrafting44, this.pureEssence, this.natureTalismanOrAbyss);
        natureRuneSteps.setDisplayCondition(this.notCraftedNature);
        natureRuneSteps.setLockingStep(this.craftedNatureTask);
        allSteps.add(natureRuneSteps);
        PanelDetails assignedTaskSteps = new PanelDetails("Get Task From Duradel", Arrays.asList(this.goUpToDuradel, this.getTask), this.combat100, this.slayer50, this.shiloVillage);
        assignedTaskSteps.setDisplayCondition(this.notAssignedTask);
        assignedTaskSteps.setLockingStep(this.assignedTaskTask);
        allSteps.add(assignedTaskSteps);
        PanelDetails collectLeavesSteps = new PanelDetails("Collect 5 Palm Leaves", Collections.singletonList(this.collectPalmLeaves), this.legendsQuest, this.axe, this.machete);
        collectLeavesSteps.setDisplayCondition(this.notCollectedLeaves);
        collectLeavesSteps.setLockingStep(this.collectedLeavesTask);
        allSteps.add(collectLeavesSteps);
        PanelDetails deathwingSteps = new PanelDetails("Kill a Deathwing", Arrays.asList(this.enterKharaziHole, this.enterBookcase, this.enterGates, this.killDeathwing), this.woodcutting34, this.strength50, this.agility53, this.thieving50, this.mining52, this.legendsQuest, this.axe, this.machete, this.pickaxe, this.lockpick);
        deathwingSteps.setDisplayCondition(this.notKilledDeathwing);
        deathwingSteps.setLockingStep(this.killedDeathwingTask);
        allSteps.add(deathwingSteps);
        PanelDetails shortcutSteps = new PanelDetails("Use Crossbow Shortcut", Collections.singletonList(this.useShortcut), this.crossbow, this.mithGrapple);
        shortcutSteps.setDisplayCondition(this.notUsedShortcut);
        shortcutSteps.setLockingStep(this.usedShortcutTask);
        allSteps.add(shortcutSteps);
        PanelDetails eatOomlieWrapSteps = new PanelDetails("Eat Oomlie Wrap", Collections.singletonList(this.eatOomlie), this.oomlieWrap);
        eatOomlieWrapSteps.setDisplayCondition(this.notEatenWrap);
        eatOomlieWrapSteps.setLockingStep(this.eatenWrapTask);
        allSteps.add(eatOomlieWrapSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

