/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.karamja;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KARAMJA_ELITE)
public class KaramjaElite
extends ComplexStateQuestHelper {
    ItemRequirement natureTiaraOrAbyss;
    ItemRequirement pureEssence;
    ItemRequirement fireCapeOrInfernal;
    ItemRequirement palmTreeSapling;
    ItemRequirement antidotePlusPlus;
    ItemRequirement zulrahScales;
    ItemRequirement calquatSapling;
    ItemRequirement rake;
    ItemRequirement spade;
    Requirement notCraftedRunes;
    Requirement notEquippedCape;
    Requirement notCheckedPalm;
    Requirement notCheckedCalquat;
    Requirement notMadePotion;
    Requirement farming72;
    Requirement herblore87;
    Requirement runecraft91;
    Requirement inNatureAltar;
    Requirement inHorse;
    Zone natureAltar;
    Zone horse;
    QuestStep enterNatureAltar;
    QuestStep craftRunes;
    QuestStep equipCape;
    QuestStep checkPalm;
    QuestStep checkCalquat;
    QuestStep makePotion;
    QuestStep claimReward;
    QuestStep moveToHorseShoe;
    ConditionalStep craftedRunesTask;
    ConditionalStep equippedCapeTask;
    ConditionalStep checkedPalmTask;
    ConditionalStep checkedCalquatTask;
    ConditionalStep madePotionTask;

    @Override
    public QuestStep loadStep() {
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.checkedCalquatTask = new ConditionalStep((QuestHelper)this, this.checkCalquat, new Requirement[0]);
        doElite.addStep(this.notCheckedCalquat, this.checkedCalquatTask);
        this.checkedPalmTask = new ConditionalStep((QuestHelper)this, this.checkPalm, new Requirement[0]);
        doElite.addStep(this.notCheckedPalm, this.checkedPalmTask);
        this.equippedCapeTask = new ConditionalStep((QuestHelper)this, this.equipCape, new Requirement[0]);
        doElite.addStep(this.notEquippedCape, this.equippedCapeTask);
        this.madePotionTask = new ConditionalStep((QuestHelper)this, this.moveToHorseShoe, new Requirement[0]);
        this.madePotionTask.addStep(this.inHorse, this.makePotion);
        doElite.addStep(this.notMadePotion, this.madePotionTask);
        this.craftedRunesTask = new ConditionalStep((QuestHelper)this, this.enterNatureAltar, new Requirement[0]);
        this.craftedRunesTask.addStep(this.inNatureAltar, this.craftRunes);
        doElite.addStep(this.notCraftedRunes, this.craftedRunesTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notCraftedRunes = new VarplayerRequirement(1200, false, 1);
        this.notEquippedCape = new VarplayerRequirement(1200, false, 2);
        this.notCheckedPalm = new VarplayerRequirement(1200, false, 3);
        this.notMadePotion = new VarplayerRequirement(1200, false, 4);
        this.notCheckedCalquat = new VarplayerRequirement(1200, false, 5);
        this.natureTiaraOrAbyss = new ItemRequirement("Nature tiara, or access to nature altar through the Abyss", 5541).showConditioned(this.notCraftedRunes).isNotConsumed();
        this.pureEssence = new ItemRequirement("Pure essence", 7936).showConditioned(this.notCraftedRunes);
        this.fireCapeOrInfernal = new ItemRequirement("Fire cape or infernal cape", 6570).showConditioned(this.notEquippedCape).isNotConsumed();
        this.fireCapeOrInfernal.addAlternates(21295);
        this.palmTreeSapling = new ItemRequirement("Palm tree sapling", 5502).showConditioned(this.notCheckedPalm);
        this.antidotePlusPlus = new ItemRequirement("Antidote++", 5952).showConditioned(this.notMadePotion);
        this.antidotePlusPlus.addAlternates(5954, 5956, 5958);
        this.zulrahScales = new ItemRequirement("Zulrah scales", 12934).showConditioned(this.notMadePotion);
        this.calquatSapling = new ItemRequirement("Calquat sapling", 5503).showConditioned(this.notCheckedCalquat);
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(new Conditions(LogicType.OR, this.notCheckedCalquat, this.notCheckedPalm)).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(new Conditions(LogicType.OR, this.notCheckedCalquat, this.notCheckedPalm)).isNotConsumed();
        this.farming72 = new SkillRequirement(Skill.FARMING, 72, true);
        this.herblore87 = new SkillRequirement(Skill.HERBLORE, 87, true);
        this.runecraft91 = new SkillRequirement(Skill.RUNECRAFT, 91, true);
        this.natureAltar = new Zone(new WorldPoint(2374, 4809, 0), new WorldPoint(2421, 4859, 0));
        this.horse = new Zone(new WorldPoint(2731, 3227, 0), new WorldPoint(2736, 3222, 0));
        this.inNatureAltar = new ZoneRequirement(this.natureAltar);
        this.inHorse = new ZoneRequirement(this.horse);
    }

    public void setupSteps() {
        this.enterNatureAltar = new ObjectStep((QuestHelper)this, 34821, new WorldPoint(2869, 3019, 0), "Enter the nature altar, either from the ruin or through the Abyss.", this.natureTiaraOrAbyss, this.pureEssence.quantity(28));
        this.craftRunes = new ObjectStep((QuestHelper)this, 34768, new WorldPoint(2400, 4841, 0), "Craft a full inventory of nature runes.", this.pureEssence.quantity(28));
        this.equipCape = new DetailedQuestStep((QuestHelper)this, "Equip a fire or infernal cape.", this.fireCapeOrInfernal.equipped());
        this.checkPalm = new ObjectStep((QuestHelper)this, 7964, new WorldPoint(2765, 3213, 0), "Grow and check the health of a palm tree in the Brimhaven patch. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.palmTreeSapling, this.rake, this.spade);
        this.checkCalquat = new ObjectStep((QuestHelper)this, 7807, new WorldPoint(2796, 3101, 0), "Grow and check the health of a Calquat in Tai Bwo Wannai.If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.calquatSapling, this.rake, this.spade);
        this.moveToHorseShoe = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2734, 3224, 0), "Go to the horse shoe mine north west of Brimhaven.", new Requirement[0]);
        this.makePotion = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2734, 3224, 0), "Make an antivenom potion whilst standing in the horse shoe mine.", this.antidotePlusPlus.highlighted(), this.zulrahScales.quantity(20).highlighted());
        this.claimReward = new NpcStep((QuestHelper)this, 7650, new WorldPoint(2810, 3192, 0), "Talk to Pirate Jackie the Fruit in Brimhaven to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.natureTiaraOrAbyss, this.pureEssence.quantity(28), this.fireCapeOrInfernal, this.palmTreeSapling, this.antidotePlusPlus, this.zulrahScales.quantity(20), this.calquatSapling, this.rake, this.spade);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.FARMING, 72, true));
        reqs.add(new SkillRequirement(Skill.HERBLORE, 87, true));
        reqs.add(new SkillRequirement(Skill.RUNECRAFT, 91, true));
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Karamja Gloves (4)", 13103, 1), new ItemReward("50,000 Exp. Lamp (Any skill above level 70)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("10% chance of receiving 2 Agility arena tickets in the Brimhaven Agility Dungeon"), new UnlockReward("Free usage of Shilo Village's furnace"), new UnlockReward("Free cart rides on Hajedy's cart system"), new UnlockReward("Free access to the Hardwood Grove"), new UnlockReward("Access to the stepping stones shortcut leading to the red dragons in Brimhaven Dungeon"), new UnlockReward("Red and Metal in Brimhaven Dungeon will drop noted dragonhide and bars"), new UnlockReward("One free resurrection per day in the Fight Caves (Not the Inferno)"), new UnlockReward("Double Tokkul from TzHaar Fight Caves, Inferno and Ket-Rak's Challenges"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails palmSteps = new PanelDetails("Check Palm Tree Health", Collections.singletonList(this.checkPalm), new SkillRequirement(Skill.FARMING, 68, true), this.palmTreeSapling, this.rake, this.spade);
        palmSteps.setDisplayCondition(this.notCheckedPalm);
        palmSteps.setLockingStep(this.checkedPalmTask);
        allSteps.add(palmSteps);
        PanelDetails calquatSteps = new PanelDetails("Check Calquat Tree Health", Collections.singletonList(this.checkCalquat), this.farming72, this.calquatSapling, this.rake, this.spade);
        calquatSteps.setDisplayCondition(this.notCheckedCalquat);
        calquatSteps.setLockingStep(this.checkedCalquatTask);
        allSteps.add(calquatSteps);
        PanelDetails equipCapeSteps = new PanelDetails("Equip Fire / Infernal Cape", Collections.singletonList(this.equipCape), this.fireCapeOrInfernal);
        equipCapeSteps.setDisplayCondition(this.notEquippedCape);
        equipCapeSteps.setLockingStep(this.equippedCapeTask);
        allSteps.add(equipCapeSteps);
        PanelDetails potionSteps = new PanelDetails("Create Antivenom Potion", Arrays.asList(this.moveToHorseShoe, this.makePotion), this.herblore87, this.antidotePlusPlus, this.zulrahScales.quantity(20));
        potionSteps.setDisplayCondition(this.notMadePotion);
        potionSteps.setLockingStep(this.madePotionTask);
        allSteps.add(potionSteps);
        PanelDetails craftRunesSteps = new PanelDetails("Craft 56 Nature Runes", Arrays.asList(this.enterNatureAltar, this.craftRunes), this.runecraft91, this.pureEssence.quantity(28), this.natureTiaraOrAbyss);
        craftRunesSteps.setDisplayCondition(this.notCraftedRunes);
        craftRunesSteps.setLockingStep(this.craftedRunesTask);
        allSteps.add(craftRunesSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

