/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.karamja;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KARAMJA_EASY)
public class KaramjaEasy
extends ComplexStateQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement coins;
    ItemRequirement smallFishingNet;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement antipoison;
    ItemRequirement seaweed;
    Requirement notSwungOnRope;
    Requirement notPickedBananas;
    Requirement notMinedGold;
    Requirement notGoneToSarim;
    Requirement notGoneToArdougne;
    Requirement notGoneToCairn;
    Requirement notFished;
    Requirement notPickedUpSeaweed;
    Requirement notEnteredFightCave;
    Requirement notKilledJogre;
    QuestStep swingRope;
    QuestStep pickBananas;
    QuestStep mineGold;
    QuestStep goSarim;
    QuestStep goArdougne;
    QuestStep goCairn;
    QuestStep goFish;
    QuestStep pickupSeaweed;
    QuestStep enterCave;
    QuestStep enterTzhaar;
    QuestStep enterFightCave;
    QuestStep enterPothole;
    QuestStep killJogre;
    QuestStep claimReward;
    Zone cave;
    Zone tzhaar;
    Zone pothole;
    ZoneRequirement inCave;
    ZoneRequirement inTzhaar;
    ZoneRequirement inPothole;
    ConditionalStep swungOnRopeTask;
    ConditionalStep pickedBananasTask;
    ConditionalStep minedGoldTask;
    ConditionalStep goneToSarimTask;
    ConditionalStep goneToArdougneTask;
    ConditionalStep goneToCairnTask;
    ConditionalStep fishedTask;
    ConditionalStep pickedUpSeaweedTask;
    ConditionalStep enteredFightCaveTask;
    ConditionalStep killedJogreTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.goneToSarimTask = new ConditionalStep((QuestHelper)this, this.goSarim, new Requirement[0]);
        doEasy.addStep(this.notGoneToSarim, this.goneToSarimTask);
        this.pickedBananasTask = new ConditionalStep((QuestHelper)this, this.pickBananas, new Requirement[0]);
        doEasy.addStep(this.notPickedBananas, this.pickedBananasTask);
        this.fishedTask = new ConditionalStep((QuestHelper)this, this.goFish, new Requirement[0]);
        doEasy.addStep(this.notFished, this.fishedTask);
        this.enteredFightCaveTask = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        this.enteredFightCaveTask.addStep(this.inCave, this.enterFightCave);
        this.enteredFightCaveTask.addStep(this.inTzhaar, this.enterTzhaar);
        doEasy.addStep(this.notEnteredFightCave, this.enteredFightCaveTask);
        this.goneToArdougneTask = new ConditionalStep((QuestHelper)this, this.goArdougne, new Requirement[0]);
        doEasy.addStep(this.notGoneToArdougne, this.goneToArdougneTask);
        this.minedGoldTask = new ConditionalStep((QuestHelper)this, this.mineGold, new Requirement[0]);
        doEasy.addStep(this.notMinedGold, this.minedGoldTask);
        this.swungOnRopeTask = new ConditionalStep((QuestHelper)this, this.swingRope, new Requirement[0]);
        doEasy.addStep(this.notSwungOnRope, this.swungOnRopeTask);
        this.pickedUpSeaweedTask = new ConditionalStep((QuestHelper)this, this.pickupSeaweed, new Requirement[0]);
        doEasy.addStep(this.notPickedUpSeaweed, this.pickedUpSeaweedTask);
        this.goneToCairnTask = new ConditionalStep((QuestHelper)this, this.goCairn, new Requirement[0]);
        doEasy.addStep(this.notGoneToCairn, this.goneToCairnTask);
        this.killedJogreTask = new ConditionalStep((QuestHelper)this, this.enterPothole, new Requirement[0]);
        this.killedJogreTask.addStep(this.inPothole, this.killJogre);
        doEasy.addStep(this.notKilledJogre, this.killedJogreTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.seaweed = new ItemRequirement("Seaweed", 401);
        this.notPickedBananas = new VarbitRequirement(3566, 4, Operation.LESS_EQUAL);
        this.notSwungOnRope = new VarbitRequirement(3567, 0);
        this.notMinedGold = new VarbitRequirement(3568, 0);
        this.notGoneToSarim = new VarbitRequirement(3569, 0);
        this.notGoneToArdougne = new VarbitRequirement(3570, 0);
        this.notGoneToCairn = new VarbitRequirement(3571, 0);
        this.notFished = new VarbitRequirement(3572, 0);
        this.notPickedUpSeaweed = new VarbitRequirement(3573, 4, Operation.LESS_EQUAL);
        this.notEnteredFightCave = new VarbitRequirement(3574, 0);
        this.notKilledJogre = new VarbitRequirement(3575, 0);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notMinedGold).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(new Conditions(LogicType.OR, this.notGoneToSarim, this.notGoneToArdougne));
        this.smallFishingNet = new ItemRequirement("Small fishing net", 303).showConditioned(this.notFished).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear to defeat a Jogre (level 56)", -1, -1).showConditioned(this.notKilledJogre).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.antipoison = new ItemRequirement("Antipoison", ItemCollections.ANTIPOISONS, -1);
        this.inCave = new ZoneRequirement(this.cave);
        this.inTzhaar = new ZoneRequirement(this.tzhaar);
        this.inPothole = new ZoneRequirement(this.pothole);
    }

    public void loadZones() {
        this.cave = new Zone(new WorldPoint(2821, 9545, 0), new WorldPoint(2879, 9663, 0));
        this.tzhaar = new Zone(new WorldPoint(2360, 5056, 0), new WorldPoint(2560, 5185, 0));
        this.pothole = new Zone(new WorldPoint(2824, 9462, 0), new WorldPoint(2883, 9533, 0));
    }

    public void setupSteps() {
        this.swingRope = new ObjectStep((QuestHelper)this, 23568, new WorldPoint(2708, 3209, 0), "Swing on the ropeswing west of Brimhaven.", new Requirement[0]);
        this.pickBananas = new ObjectStep((QuestHelper)this, 2073, new WorldPoint(2916, 3162, 0), "Pick 5 bananas from the banana plantation.", new Requirement[0]);
        ((ObjectStep)this.pickBananas).addAlternateObjects(2074, 2075, 2076, 2077);
        this.mineGold = new ObjectStep((QuestHelper)this, 11371, new WorldPoint(2732, 3223, 0), "Mine a gold rock north west of Brimhaven.", this.pickaxe);
        this.goSarim = new NpcStep((QuestHelper)this, 3648, new WorldPoint(2954, 3147, 0), "Travel to Port Sarim from Musa Point with the Customs officer.", this.coins.quantity(30));
        this.goArdougne = new NpcStep((QuestHelper)this, 8764, new WorldPoint(2772, 3228, 0), "Travel to Ardougne from Brimhaven with Captain Barnaby.", this.coins.quantity(30));
        this.goCairn = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2770, 2979, 0), "Travel to Cairn Island by climbing up the rocks east of it, then crossing the bridge.", new Requirement[0]);
        this.goFish = new NpcStep((QuestHelper)this, 1521, new WorldPoint(2924, 3178, 0), "Fish north of the banana plantation.", true, this.smallFishingNet);
        this.pickupSeaweed = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2756, 3125, 0), "Pick up 5 seaweed on Karamja's coast. You can just drop a piece and pick it up again 5 times.", this.seaweed);
        this.enterCave = new ObjectStep((QuestHelper)this, 11441, new WorldPoint(2857, 3169, 0), "Enter the fight pits or fight caves in Mor Ul Rek under the Karamja Volcano.", new Requirement[0]);
        this.enterTzhaar = new ObjectStep((QuestHelper)this, 11835, new WorldPoint(2864, 9572, 0), "Enter the fight pits or fight caves in Mor Ul Rek under the Karamja Volcano.", new Requirement[0]);
        this.enterFightCave = new ObjectStep((QuestHelper)this, 11833, new WorldPoint(2438, 5167, 0), "Enter the fight pits or fight caves in Mor Ul Rek under the Karamja Volcano.", new Requirement[0]);
        this.enterFightCave.addSubSteps(this.enterCave, this.enterTzhaar);
        this.enterPothole = new ObjectStep((QuestHelper)this, 2584, new WorldPoint(2825, 3119, 0), "Enter the dungeon east of Tai Bwo Wannai, and kill a Jogre in there.", this.combatGear);
        this.enterPothole.addDialogStep("Yes, I'll enter the cave.");
        this.killJogre = new NpcStep((QuestHelper)this, 2094, new WorldPoint(2832, 9517, 0), "Kill a Jogre.", true, this.combatGear);
        this.enterPothole.addSubSteps(this.killJogre);
        this.claimReward = new NpcStep((QuestHelper)this, 7650, new WorldPoint(2810, 3192, 0), "Talk to Pirate Jackie the Fruit in Brimhaven to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.pickaxe, this.coins.quantity(120), this.smallFishingNet, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.antipoison);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 15, true));
        req.add(new SkillRequirement(Skill.MINING, 40, true));
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Karamja Gloves (1)", 11136, 1), new ItemReward("1,000 Exp. Lamp (Any skill)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Better prices in shops on Karamja and in Tzhaar City."), new UnlockReward("Half price ships from Ardougne to Brimhaven and Musa Point to Port Sarim."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails travelSarimSteps = new PanelDetails("Travel to Port Sarim", Collections.singletonList(this.goSarim), this.coins.quantity(30));
        travelSarimSteps.setDisplayCondition(this.notGoneToSarim);
        travelSarimSteps.setLockingStep(this.goneToSarimTask);
        allSteps.add(travelSarimSteps);
        PanelDetails pickBananasSteps = new PanelDetails("Pick 5 Bananas", Collections.singletonList(this.pickBananas), new Requirement[0]);
        pickBananasSteps.setDisplayCondition(this.notPickedBananas);
        pickBananasSteps.setLockingStep(this.pickedBananasTask);
        allSteps.add(pickBananasSteps);
        PanelDetails goFishSteps = new PanelDetails("Fish North of Banana Plantation", Collections.singletonList(this.goFish), this.smallFishingNet);
        goFishSteps.setDisplayCondition(this.notFished);
        goFishSteps.setLockingStep(this.fishedTask);
        allSteps.add(goFishSteps);
        PanelDetails enterFightCaveSteps = new PanelDetails("Attempt the Fight Cave or TzHaar Fight Pits", Collections.singletonList(this.enterFightCave), new Requirement[0]);
        enterFightCaveSteps.setDisplayCondition(this.notEnteredFightCave);
        enterFightCaveSteps.setLockingStep(this.enteredFightCaveTask);
        allSteps.add(enterFightCaveSteps);
        PanelDetails goArdougneSteps = new PanelDetails("Travel to Ardougne", Collections.singletonList(this.goArdougne), this.coins.quantity(30));
        goArdougneSteps.setDisplayCondition(this.notGoneToArdougne);
        goArdougneSteps.setLockingStep(this.goneToArdougneTask);
        allSteps.add(goArdougneSteps);
        PanelDetails mineGoldSteps = new PanelDetails("Mine gold", Collections.singletonList(this.mineGold), new SkillRequirement(Skill.MINING, 40, true), this.pickaxe);
        mineGoldSteps.setDisplayCondition(this.notMinedGold);
        mineGoldSteps.setLockingStep(this.minedGoldTask);
        allSteps.add(mineGoldSteps);
        PanelDetails swingRopeSteps = new PanelDetails("Swing Rope to Moss Giant Isle", Collections.singletonList(this.swingRope), new SkillRequirement(Skill.AGILITY, 10, true));
        swingRopeSteps.setDisplayCondition(this.notSwungOnRope);
        swingRopeSteps.setLockingStep(this.swungOnRopeTask);
        allSteps.add(swingRopeSteps);
        PanelDetails pickupSeaweedSteps = new PanelDetails("Pickup 5 Seaweed", Collections.singletonList(this.pickupSeaweed), new Requirement[0]);
        pickupSeaweedSteps.setDisplayCondition(this.notPickedUpSeaweed);
        pickupSeaweedSteps.setLockingStep(this.pickedUpSeaweedTask);
        allSteps.add(pickupSeaweedSteps);
        PanelDetails goCairnSteps = new PanelDetails("Explore Cairn Isle", Collections.singletonList(this.goCairn), new SkillRequirement(Skill.AGILITY, 15, true));
        goCairnSteps.setDisplayCondition(this.notGoneToCairn);
        goCairnSteps.setLockingStep(this.goneToCairnTask);
        allSteps.add(goCairnSteps);
        PanelDetails killJogreSteps = new PanelDetails("Kill Jogre in Pothole Dungeon", Collections.singletonList(this.enterPothole), new Requirement[0]);
        killJogreSteps.setDisplayCondition(this.notKilledJogre);
        killJogreSteps.setLockingStep(this.killedJogreTask);
        allSteps.add(killJogreSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

