/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.kandarin;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KANDARIN_MEDIUM)
public class KandarinMedium
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement mithGrap;
    ItemRequirement crossbow;
    ItemRequirement unicornHorn;
    ItemRequirement mortarPest;
    ItemRequirement vialOfWater;
    ItemRequirement dustyKey;
    ItemRequirement bigFishingNet;
    ItemRequirement lawRune;
    ItemRequirement airRune;
    ItemRequirement mapleUnstrung;
    ItemRequirement bowString;
    ItemRequirement limpSeed;
    ItemRequirement rake;
    ItemRequirement seedDib;
    ItemRequirement primedMind;
    ItemRequirement hammer;
    ItemRequirement beatenBook;
    ItemRequirement batteredKey;
    ItemRequirement rope;
    ItemRequirement lockpick;
    ItemRequirement staff;
    ItemRequirement pickaxe;
    ItemRequirement iritLeaf;
    ItemRequirement food;
    ItemRequirement compost;
    ItemRequirement rawBass;
    ItemRequirement unfIrit;
    ItemRequirement hornDust;
    Requirement notBarbAgi;
    Requirement notSuperAnti;
    Requirement notEnterRange;
    Requirement notGrapOb;
    Requirement notCatchCookBass;
    Requirement notTPCam;
    Requirement notStringMaple;
    Requirement notPickLimp;
    Requirement notMindHelm;
    Requirement notFireGiant;
    Requirement notBarbAss;
    Requirement notStealHemen;
    Requirement notTravelMcGrubor;
    Requirement notMineCoal;
    Requirement not70Agility;
    Requirement normalBook;
    Requirement alfredBar;
    Requirement eleWorkII;
    Requirement waterfallQuest;
    Requirement fairyTaleII;
    QuestStep barbAgi;
    QuestStep superAnti;
    QuestStep enterRange;
    QuestStep grapOb;
    QuestStep cookBass;
    QuestStep tpCAM;
    QuestStep stringMaple;
    QuestStep plantAndPickLimp;
    QuestStep makeMindHelmet;
    QuestStep barbAss;
    QuestStep stealHemen;
    QuestStep travelMcGrubor;
    QuestStep mineCoal;
    QuestStep claimReward;
    QuestStep moveToTavDungeon;
    QuestStep moveToBank;
    QuestStep moveToSeersCath;
    QuestStep moveToOb;
    QuestStep moveToWorkshop;
    QuestStep moveToWaterfall;
    QuestStep mixUnf;
    QuestStep crushHorn;
    NpcStep catchBass;
    NpcStep fireGiant;
    Zone bank;
    Zone seersCath;
    Zone tavDungeon;
    Zone workshop;
    Zone obIsland;
    Zone waterfall;
    ZoneRequirement inBank;
    ZoneRequirement inSeersCath;
    ZoneRequirement inTavDungeon;
    ZoneRequirement inWorkshop;
    ZoneRequirement inObIsland;
    ZoneRequirement inWaterfall;
    ConditionalStep barbAgiTask;
    ConditionalStep superAntiTask;
    ConditionalStep enterRangeTask;
    ConditionalStep grapObTask;
    ConditionalStep catchCookBassTask;
    ConditionalStep tpCamTask;
    ConditionalStep stringMapleTask;
    ConditionalStep pickLimpTask;
    ConditionalStep mindHelmTask;
    ConditionalStep fireGiantTask;
    ConditionalStep barbAssTask;
    ConditionalStep stealHemenTask;
    ConditionalStep travelMcGruborTask;
    ConditionalStep mineCoalTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doMedium = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.pickLimpTask = new ConditionalStep((QuestHelper)this, this.plantAndPickLimp, new Requirement[0]);
        doMedium.addStep(this.notPickLimp, this.pickLimpTask);
        this.grapObTask = new ConditionalStep((QuestHelper)this, this.moveToTavDungeon, new Requirement[0]);
        this.grapObTask.addStep(this.inTavDungeon, this.moveToOb);
        this.grapObTask.addStep(this.inObIsland, this.grapOb);
        doMedium.addStep(this.notGrapOb, this.grapObTask);
        this.catchCookBassTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.catchBass, new Requirement[0]);
        this.catchCookBassTask.addStep(this.rawBass, this.cookBass);
        doMedium.addStep(this.notCatchCookBass, this.catchCookBassTask);
        this.stringMapleTask = new ConditionalStep((QuestHelper)this, this.moveToBank, new Requirement[0]);
        this.stringMapleTask.addStep(this.inBank, this.stringMaple);
        doMedium.addStep(this.notStringMaple, this.stringMapleTask);
        this.superAntiTask = new ConditionalStep((QuestHelper)this, this.moveToSeersCath, new Requirement[0]);
        this.superAntiTask.addStep(new Conditions(this.inSeersCath, this.unfIrit, this.hornDust), this.superAnti);
        this.superAntiTask.addStep(new Conditions(this.inSeersCath, this.unfIrit), this.crushHorn);
        this.superAntiTask.addStep(this.inSeersCath, this.mixUnf);
        doMedium.addStep(this.notSuperAnti, this.superAntiTask);
        this.mindHelmTask = new ConditionalStep((QuestHelper)this, this.makeMindHelmet, new Requirement[0]);
        this.mindHelmTask.addStep(this.inWorkshop, this.makeMindHelmet);
        doMedium.addStep(this.notMindHelm, this.mindHelmTask);
        this.enterRangeTask = new ConditionalStep((QuestHelper)this, this.enterRange, new Requirement[0]);
        doMedium.addStep(this.notEnterRange, this.enterRangeTask);
        this.stealHemenTask = new ConditionalStep((QuestHelper)this, this.stealHemen, new Requirement[0]);
        doMedium.addStep(this.notStealHemen, this.stealHemenTask);
        this.mineCoalTask = new ConditionalStep((QuestHelper)this, this.mineCoal, new Requirement[0]);
        doMedium.addStep(this.notMineCoal, this.mineCoalTask);
        this.fireGiantTask = new ConditionalStep((QuestHelper)this, this.moveToWaterfall, new Requirement[0]);
        this.fireGiantTask.addStep(this.inWaterfall, this.fireGiant);
        doMedium.addStep(this.notFireGiant, this.fireGiantTask);
        this.barbAgiTask = new ConditionalStep((QuestHelper)this, this.barbAgi, new Requirement[0]);
        doMedium.addStep(this.notBarbAgi, this.barbAgiTask);
        this.barbAssTask = new ConditionalStep((QuestHelper)this, this.barbAss, new Requirement[0]);
        doMedium.addStep(this.notBarbAss, this.barbAssTask);
        this.travelMcGruborTask = new ConditionalStep((QuestHelper)this, this.travelMcGrubor, new Requirement[0]);
        doMedium.addStep(this.notTravelMcGrubor, this.travelMcGruborTask);
        this.tpCamTask = new ConditionalStep((QuestHelper)this, this.tpCAM, new Requirement[0]);
        doMedium.addStep(this.notTPCam, this.tpCamTask);
        return doMedium;
    }

    @Override
    public void setupRequirements() {
        this.notBarbAgi = new VarplayerRequirement(1178, false, 12);
        this.notSuperAnti = new VarplayerRequirement(1178, false, 13);
        this.notEnterRange = new VarplayerRequirement(1178, false, 14);
        this.notGrapOb = new VarplayerRequirement(1178, false, 15);
        this.notCatchCookBass = new VarplayerRequirement(1178, false, 16);
        this.notTPCam = new VarplayerRequirement(1178, false, 17);
        this.notStringMaple = new VarplayerRequirement(1178, false, 18);
        this.notPickLimp = new VarplayerRequirement(1178, false, 19);
        this.notMindHelm = new VarplayerRequirement(1178, false, 20);
        this.notFireGiant = new VarplayerRequirement(1178, false, 21);
        this.notBarbAss = new VarplayerRequirement(1178, false, 22);
        this.notStealHemen = new VarplayerRequirement(1178, false, 23);
        this.notTravelMcGrubor = new VarplayerRequirement(1178, false, 24);
        this.notMineCoal = new VarplayerRequirement(1178, false, 25);
        this.not70Agility = new Conditions(LogicType.NOR, new SkillRequirement(Skill.AGILITY, 70, true));
        this.mithGrap = new ItemRequirement("Mith grapple", 9419).showConditioned(this.notGrapOb).isNotConsumed();
        this.crossbow = new ItemRequirement("Any crossbow", ItemCollections.CROSSBOWS).showConditioned(this.notGrapOb).isNotConsumed();
        this.unfIrit = new ItemRequirement("Unfinished irit potion", 101, 1).showConditioned(this.notSuperAnti);
        this.unicornHorn = new ItemRequirement("Unicorn horn", 237, 1).showConditioned(this.notSuperAnti);
        this.mortarPest = new ItemRequirement("Pestle and mortar", 233).showConditioned(this.notSuperAnti).isNotConsumed();
        this.hornDust = new ItemRequirement("Horn Dust", 235, 1).showConditioned(this.notSuperAnti);
        this.vialOfWater = new ItemRequirement("Vial of water", 227, 1).showConditioned(this.notSuperAnti);
        this.iritLeaf = new ItemRequirement("Irit leaf", 259, 1).showConditioned(this.notSuperAnti);
        this.dustyKey = new KeyringRequirement("Dusty Key", this.configManager, KeyringCollection.DUSTY_KEY).showConditioned(new Conditions(this.not70Agility, this.notGrapOb)).isNotConsumed();
        this.dustyKey.setTooltip("You can get this by killing the Jailor in the Black Knights Base in Taverley Dungeon and using the key he drops to enter the jail cell there to talk to Velrak for the dusty key");
        this.bigFishingNet = new ItemRequirement("Big fishing net", 305).showConditioned(this.notCatchCookBass).isNotConsumed();
        this.lawRune = new ItemRequirement("Law rune", 563, 1).showConditioned(this.notTPCam);
        this.airRune = new ItemRequirement("Air Rune", 556, 5).showConditioned(this.notTPCam);
        this.mapleUnstrung = new ItemRequirement("Maple shortbow (u)", 64).showConditioned(this.notStringMaple);
        this.bowString = new ItemRequirement("Bow string", 1777).showConditioned(this.notStringMaple);
        this.limpSeed = new ItemRequirement("Limpwurt seed", 5100).showConditioned(this.notPickLimp);
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notPickLimp).isNotConsumed();
        this.seedDib = new ItemRequirement("Seed dibber", 5343).showConditioned(this.notPickLimp).isNotConsumed();
        this.primedMind = new ItemRequirement("Mind bar", 9728).showConditioned(this.notMindHelm);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notMindHelm).isNotConsumed();
        this.beatenBook = new ItemRequirement("Beaten Book", 9717).showConditioned(this.notMindHelm);
        this.batteredKey = new KeyringRequirement("Battered Key", this.configManager, KeyringCollection.BATTERED_KEY).showConditioned(this.notMindHelm);
        this.batteredKey.setTooltip("You can get another by searching the bookcase in the house south of the Elemental Workshop, then reading the book you get from it");
        this.rope = new ItemRequirement("Rope", 954).showConditioned(this.notFireGiant).isNotConsumed();
        this.lockpick = new ItemRequirement("Lockpick", 1523).showConditioned(this.notStealHemen).isNotConsumed();
        this.staff = new ItemRequirement("Dramen or Lunar staff", ItemCollections.FAIRY_STAFF).showConditioned(this.notTravelMcGrubor).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notMineCoal).isNotConsumed();
        this.rawBass = new ItemRequirement("Raw bass", 363).showConditioned(this.notCatchCookBass);
        this.compost = new ItemRequirement("Compost", ItemCollections.COMPOST).showConditioned(this.notPickLimp);
        this.combatGear = new ItemRequirement("Combat gear to kill a fire giant and complete a wave of Barbarian Assault", -1, -1).showConditioned(new Conditions(LogicType.OR, this.notFireGiant, this.notBarbAss)).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.normalBook = new SpellbookRequirement(Spellbook.NORMAL);
        this.inBank = new ZoneRequirement(this.bank);
        this.inSeersCath = new ZoneRequirement(this.seersCath);
        this.inTavDungeon = new ZoneRequirement(this.tavDungeon);
        this.inWorkshop = new ZoneRequirement(this.workshop);
        this.inObIsland = new ZoneRequirement(this.obIsland);
        this.inWaterfall = new ZoneRequirement(this.waterfall);
        this.setupGeneralRequirements();
    }

    public void loadZones() {
        this.bank = new Zone(new WorldPoint(2721, 3495, 0), new WorldPoint(2730, 3490, 0));
        this.seersCath = new Zone(new WorldPoint(2687, 3510, 0), new WorldPoint(2839, 3430, 0));
        this.tavDungeon = new Zone(new WorldPoint(2813, 9857, 0), new WorldPoint(2972, 9669, 0));
        this.obIsland = new Zone(new WorldPoint(2833, 3427, 0), new WorldPoint(2849, 3415, 0));
        this.waterfall = new Zone(new WorldPoint(2534, 9918, 0), new WorldPoint(2613, 9860, 0));
        this.workshop = new Zone(new WorldPoint(2682, 9862, 0), new WorldPoint(2747, 9927, 0));
    }

    public void setupSteps() {
        this.barbAgi = new ObjectStep((QuestHelper)this, 20210, new WorldPoint(2552, 3560, 0), "Complete a lap of the Barbarian Outpost agility course.", new Requirement[0]);
        this.barbAss = new ObjectStep((QuestHelper)this, 20226, new WorldPoint(2534, 3572, 0), "Complete a wave of Barbarian Assault. If it's your first time here, speak with Captain Cain for the tutorial.", new Requirement[0]);
        this.enterRange = new ObjectStep((QuestHelper)this, 11665, new WorldPoint(2658, 3438, 0), "Enter the Ranging Guild.", new Requirement[0]);
        this.stealHemen = new ObjectStep((QuestHelper)this, 11742, new WorldPoint(2639, 3424, 0), "Steal from the chest in Hemenster.", this.lockpick);
        this.mineCoal = new ObjectStep((QuestHelper)this, 11366, new WorldPoint(2590, 3476, 0), "Mine coal near the Coal Trucks.", this.pickaxe);
        this.mineCoal.addIcon(1275);
        this.moveToWaterfall = new ObjectStep((QuestHelper)this, 2010, new WorldPoint(2511, 3464, 0), "Enter the waterfall dungeon.", this.rope, this.combatGear);
        this.fireGiant = new NpcStep((QuestHelper)this, 2080, new WorldPoint(2566, 9887, 0), "Kill a Fire giant.", true, this.combatGear);
        this.fireGiant.addAlternateNpcs(2079, 2078);
        this.moveToWorkshop = new ObjectStep((QuestHelper)this, 3415, new WorldPoint(2711, 3498, 0), "Enter the Elemental Workshop.", this.batteredKey, this.primedMind);
        this.makeMindHelmet = new ObjectStep((QuestHelper)this, 3402, new WorldPoint(2717, 9888, 0), "Make a mind helm.", this.beatenBook, this.primedMind);
        this.moveToBank = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2725, 3492, 0), "Go to Seers' Village bank to string a maple shortbow.", new Requirement[0]);
        this.stringMaple = new DetailedQuestStep((QuestHelper)this, "String a maple shortbow.", this.mapleUnstrung.highlighted(), this.bowString.highlighted());
        this.moveToTavDungeon = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Enter the Taverly Dungeon.", this.dustyKey, this.mithGrap, this.crossbow);
        this.moveToOb = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(2842, 9824, 0), "Make your way through Taverley Dungeon to the end, and climb the ladder there. If you're 70+ Agility, use one of the shortcuts near the entrance to get there quickly.", this.dustyKey, this.mithGrap.equipped(), this.crossbow.equipped());
        this.grapOb = new ObjectStep((QuestHelper)this, 17062, new WorldPoint(2842, 3435, 0), "Grapple across!", this.mithGrap.equipped(), this.crossbow.equipped());
        this.moveToSeersCath = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2755, 3475, 0), "Move to the Seers' Village / Catherby area.", this.iritLeaf, this.vialOfWater, this.unicornHorn, this.mortarPest);
        this.mixUnf = new DetailedQuestStep((QuestHelper)this, "Create an unfinished Irit potion.", this.iritLeaf.highlighted(), this.vialOfWater.highlighted());
        this.crushHorn = new DetailedQuestStep((QuestHelper)this, "Crush a unicorn horn.", this.unicornHorn.highlighted(), this.mortarPest.highlighted());
        this.superAnti = new DetailedQuestStep((QuestHelper)this, "Create a super antipoison potion.", this.hornDust.highlighted(), this.unfIrit.highlighted());
        this.plantAndPickLimp = new ObjectStep((QuestHelper)this, 7848, new WorldPoint(2810, 3464, 0), "Plant a limpwurt seed in the Catherby Flower Patch, wait for it to grow then pick it. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.rake, this.limpSeed, this.seedDib);
        this.catchBass = new NpcStep((QuestHelper)this, 1520, new WorldPoint(2837, 3431, 0), "Catch a bass on Catherby Beach.", this.bigFishingNet);
        this.cookBass = new ObjectStep((QuestHelper)this, 26181, new WorldPoint(2818, 3444, 0), "Cook the bass on the range in Catherby.", this.rawBass);
        this.travelMcGrubor = new DetailedQuestStep((QuestHelper)this, "Take a fairy ring to McGrubor's Woods (ALS)", this.staff.equipped());
        this.tpCAM = new DetailedQuestStep((QuestHelper)this, "Teleport to Camelot.", this.lawRune.quantity(1), this.airRune.quantity(5), this.normalBook);
        this.claimReward = new NpcStep((QuestHelper)this, 5517, new WorldPoint(2760, 3476, 0), "Talk to the 'Wedge' in front of Camelot Castle to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.mithGrap, this.crossbow, this.dustyKey, this.bigFishingNet, this.unicornHorn, this.mortarPest, this.vialOfWater, this.iritLeaf, this.mapleUnstrung, this.bowString, this.lockpick, this.pickaxe, this.lawRune.quantity(1), this.airRune.quantity(5), this.limpSeed, this.seedDib, this.compost, this.rake, this.rope, this.primedMind, this.batteredKey, this.beatenBook, this.hammer, this.staff, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.food);
    }

    private void setupGeneralRequirements() {
        this.alfredBar = new QuestRequirement(QuestHelperQuest.ALFRED_GRIMHANDS_BARCRAWL, QuestState.FINISHED);
        this.eleWorkII = new QuestRequirement(QuestHelperQuest.ELEMENTAL_WORKSHOP_II, QuestState.FINISHED);
        this.waterfallQuest = new QuestRequirement(QuestHelperQuest.WATERFALL_QUEST, QuestState.FINISHED);
        this.fairyTaleII = new VarbitRequirement(QuestVarbits.QUEST_FAIRYTALE_II_CURE_A_QUEEN.getId(), Operation.GREATER_EQUAL, 40, "Partial completion of Fairytale II for access to fairy rings");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        this.setupGeneralRequirements();
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 36));
        req.add(new SkillRequirement(Skill.COOKING, 43));
        req.add(new SkillRequirement(Skill.FARMING, 26));
        req.add(new SkillRequirement(Skill.FISHING, 46));
        req.add(new SkillRequirement(Skill.FLETCHING, 50));
        req.add(new SkillRequirement(Skill.HERBLORE, 48));
        req.add(new SkillRequirement(Skill.MAGIC, 45));
        req.add(new SkillRequirement(Skill.MINING, 30));
        req.add(new SkillRequirement(Skill.RANGED, 40));
        req.add(new SkillRequirement(Skill.STRENGTH, 22));
        req.add(new SkillRequirement(Skill.THIEVING, 47));
        req.add(this.alfredBar);
        req.add(this.eleWorkII);
        req.add(this.waterfallQuest);
        req.add(this.fairyTaleII);
        return req;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Fire giant (Level 86)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Kandarin headgear (2)", 13138, 1), new ItemReward("7,500 Exp. Lamp (Any skill over 40)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Coal trucks can hold up to 280 coal."), new UnlockReward("The Flax keeper will exchange 60 noted flax for 60 noted bow strings daily"), new UnlockReward("10% more marks of grace on Seers' Village Rooftop Course"), new UnlockReward("5% increased chance to save a harvest life from the Catherby herb patch"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails pickLimpSteps = new PanelDetails("Pick Limpwurt in Catherby", Collections.singletonList(this.plantAndPickLimp), new SkillRequirement(Skill.FARMING, 26, true), this.limpSeed, this.seedDib, this.compost, this.rake);
        pickLimpSteps.setDisplayCondition(this.notPickLimp);
        pickLimpSteps.setLockingStep(this.pickLimpTask);
        allSteps.add(pickLimpSteps);
        PanelDetails grappleStep = new PanelDetails("Grapple from Water Obelisk", Arrays.asList(this.moveToTavDungeon, this.moveToOb, this.grapOb), new SkillRequirement(Skill.AGILITY, 36), new SkillRequirement(Skill.STRENGTH, 22), new SkillRequirement(Skill.RANGED, 39), this.mithGrap, this.crossbow, this.dustyKey);
        grappleStep.setDisplayCondition(this.notGrapOb);
        grappleStep.setLockingStep(this.grapObTask);
        allSteps.add(grappleStep);
        PanelDetails catchCookBassSteps = new PanelDetails("Catch and Cook Bass", Arrays.asList(this.catchBass, this.cookBass), new SkillRequirement(Skill.FISHING, 46, true), new SkillRequirement(Skill.COOKING, 43, true), this.bigFishingNet);
        catchCookBassSteps.setDisplayCondition(this.notCatchCookBass);
        catchCookBassSteps.setLockingStep(this.catchCookBassTask);
        allSteps.add(catchCookBassSteps);
        PanelDetails stringMapleShortbow = new PanelDetails("String Maple Shortbow in Seers' Bank", Arrays.asList(this.moveToBank, this.stringMaple), new SkillRequirement(Skill.FLETCHING, 50, true), this.mapleUnstrung, this.bowString);
        stringMapleShortbow.setDisplayCondition(this.notStringMaple);
        stringMapleShortbow.setLockingStep(this.stringMapleTask);
        allSteps.add(stringMapleShortbow);
        PanelDetails mixSuperantiSteps = new PanelDetails("Mix Superantipoison", Arrays.asList(this.moveToSeersCath, this.mixUnf, this.crushHorn, this.superAnti), new SkillRequirement(Skill.HERBLORE, 48, true), this.unicornHorn, this.mortarPest, this.vialOfWater, this.iritLeaf);
        mixSuperantiSteps.setDisplayCondition(this.notSuperAnti);
        mixSuperantiSteps.setLockingStep(this.superAntiTask);
        allSteps.add(mixSuperantiSteps);
        PanelDetails makeMindHelmStep = new PanelDetails("Make a Mind Helm", Arrays.asList(this.moveToWorkshop, this.makeMindHelmet), this.eleWorkII, this.primedMind, this.batteredKey, this.beatenBook, this.hammer);
        makeMindHelmStep.setDisplayCondition(this.notMindHelm);
        makeMindHelmStep.setLockingStep(this.mindHelmTask);
        allSteps.add(makeMindHelmStep);
        PanelDetails enterRangeSteps = new PanelDetails("Enter the Ranging Guild", Collections.singletonList(this.enterRange), new SkillRequirement(Skill.RANGED, 40));
        enterRangeSteps.setDisplayCondition(this.notEnterRange);
        enterRangeSteps.setLockingStep(this.enterRangeTask);
        allSteps.add(enterRangeSteps);
        PanelDetails stealHemSteps = new PanelDetails("Steal from Hemenster Chest", Collections.singletonList(this.stealHemen), new SkillRequirement(Skill.THIEVING, 47), this.lockpick);
        stealHemSteps.setDisplayCondition(this.notStealHemen);
        stealHemSteps.setLockingStep(this.stealHemenTask);
        allSteps.add(stealHemSteps);
        PanelDetails mineCoalSteps = new PanelDetails("Mine Coal", Collections.singletonList(this.mineCoal), new SkillRequirement(Skill.MINING, 30, true), this.pickaxe);
        mineCoalSteps.setDisplayCondition(this.notMineCoal);
        mineCoalSteps.setLockingStep(this.mineCoalTask);
        allSteps.add(mineCoalSteps);
        PanelDetails killFireGiantSteps = new PanelDetails("Kill a Fire Giant", Arrays.asList(this.moveToWaterfall, this.fireGiant), this.waterfallQuest, this.combatGear, this.food, this.rope);
        killFireGiantSteps.setDisplayCondition(this.notFireGiant);
        killFireGiantSteps.setLockingStep(this.fireGiantTask);
        allSteps.add(killFireGiantSteps);
        PanelDetails barbAgiSteps = new PanelDetails("Barbarian Agility Course Lap", Collections.singletonList(this.barbAgi), this.alfredBar, new SkillRequirement(Skill.AGILITY, 35));
        barbAgiSteps.setDisplayCondition(this.notBarbAgi);
        barbAgiSteps.setLockingStep(this.barbAgiTask);
        allSteps.add(barbAgiSteps);
        PanelDetails barbAssSteps = new PanelDetails("Barbarian Assault Wave", Collections.singletonList(this.barbAss), new Requirement[0]);
        barbAssSteps.setDisplayCondition(this.notBarbAss);
        barbAssSteps.setLockingStep(this.barbAssTask);
        allSteps.add(barbAssSteps);
        PanelDetails travelGrubSteps = new PanelDetails("Fairy Ring to McGrubor's Woods", Collections.singletonList(this.travelMcGrubor), this.fairyTaleII, this.staff);
        travelGrubSteps.setDisplayCondition(this.notTravelMcGrubor);
        travelGrubSteps.setLockingStep(this.travelMcGruborTask);
        allSteps.add(travelGrubSteps);
        PanelDetails teleCamSteps = new PanelDetails("Teleport to Camelot", Collections.singletonList(this.tpCAM), new SkillRequirement(Skill.MAGIC, 45, true), this.lawRune.quantity(1), this.airRune.quantity(5), this.normalBook);
        teleCamSteps.setDisplayCondition(this.notTPCam);
        teleCamSteps.setLockingStep(this.tpCamTask);
        allSteps.add(teleCamSteps);
        PanelDetails finishingOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishingOffSteps);
        return allSteps;
    }
}

