/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.kandarin;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Prayer;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KANDARIN_HARD)
public class KandarinHard
extends ComplexStateQuestHelper {
    ItemRequirement barbRod;
    ItemRequirement feather;
    ItemRequirement axe;
    ItemRequirement bowString;
    ItemRequirement knife;
    ItemRequirement cosmicRune;
    ItemRequirement waterRune;
    ItemRequirement unpoweredOrb;
    ItemRequirement dustyKey;
    ItemRequirement mapleLogs;
    ItemRequirement bow;
    ItemRequirement ringOfVis;
    ItemRequirement coins;
    ItemRequirement addyBar;
    ItemRequirement hammer;
    ItemRequirement yewLogs;
    ItemRequirement combatGear;
    ItemRequirement antidragonfire;
    ItemRequirement food;
    ItemRequirement unstrungYewLong;
    Requirement piety;
    Requirement choppedLogs;
    Requirement notCatchStur;
    Requirement notSeersRooftop;
    Requirement notYewLong;
    Requirement notPietyCourt;
    Requirement notWaterOrb;
    Requirement notBurnMaple;
    Requirement notShadowHound;
    Requirement notMithrilDrag;
    Requirement notBuyGranite;
    Requirement notFancyStone;
    Requirement notAddySpear;
    Requirement barbFishing;
    Requirement barbFiremaking;
    Requirement barbSmithing;
    Requirement taiBwoWannai;
    Requirement knightWaves;
    Requirement desertTreasure;
    QuestStep claimReward;
    QuestStep moveToTavDungeon;
    QuestStep moveToOb;
    QuestStep waterOrb;
    QuestStep seersRooftop;
    QuestStep yewLong;
    QuestStep cutLongbow;
    QuestStep stringBow;
    QuestStep pietyCourt;
    QuestStep burnMaple;
    QuestStep moveToSeers;
    QuestStep fancyStone;
    QuestStep moveToShadow;
    QuestStep shadowHound;
    QuestStep catchStur;
    QuestStep addySpear;
    QuestStep moveToWhirl;
    QuestStep moveToAncient2;
    QuestStep moveToAncient3;
    QuestStep mithrilDrag;
    QuestStep buyGranite;
    Zone tavDungeon;
    Zone obIsland;
    Zone seers;
    Zone shadow;
    Zone ancient1;
    Zone ancient2;
    Zone ancient3;
    ZoneRequirement inTavDungeon;
    ZoneRequirement inObIsland;
    ZoneRequirement inSeers;
    ZoneRequirement inShadow;
    ZoneRequirement inAncient1;
    ZoneRequirement inAncient2;
    ZoneRequirement inAncient3;
    ConditionalStep catchSturTask;
    ConditionalStep seersRooftopTask;
    ConditionalStep yewLongTask;
    ConditionalStep pietyCourtTask;
    ConditionalStep waterOrbTask;
    ConditionalStep burnMapleTask;
    ConditionalStep shadowHoundTask;
    ConditionalStep mithrilDragTask;
    ConditionalStep buyGraniteTask;
    ConditionalStep fancyStoneTask;
    ConditionalStep addySpearTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.waterOrbTask = new ConditionalStep((QuestHelper)this, this.moveToTavDungeon, new Requirement[0]);
        this.waterOrbTask.addStep(this.inTavDungeon, this.moveToOb);
        this.waterOrbTask.addStep(this.inObIsland, this.waterOrb);
        doHard.addStep(this.notWaterOrb, this.waterOrbTask);
        this.seersRooftopTask = new ConditionalStep((QuestHelper)this, this.seersRooftop, new Requirement[0]);
        doHard.addStep(this.notSeersRooftop, this.seersRooftopTask);
        this.yewLongTask = new ConditionalStep((QuestHelper)this, this.yewLong, new Requirement[0]);
        this.yewLongTask.addStep(this.unstrungYewLong, this.stringBow);
        this.yewLongTask.addStep(new Conditions(this.yewLogs, this.choppedLogs), this.cutLongbow);
        doHard.addStep(this.notYewLong, this.yewLongTask);
        this.pietyCourtTask = new ConditionalStep((QuestHelper)this, this.pietyCourt, new Requirement[0]);
        doHard.addStep(this.notPietyCourt, this.pietyCourtTask);
        this.burnMapleTask = new ConditionalStep((QuestHelper)this, this.moveToSeers, new Requirement[0]);
        this.burnMapleTask.addStep(this.inSeers, this.burnMaple);
        doHard.addStep(this.notBurnMaple, this.burnMapleTask);
        this.fancyStoneTask = new ConditionalStep((QuestHelper)this, this.fancyStone, new Requirement[0]);
        doHard.addStep(this.notFancyStone, this.fancyStoneTask);
        this.shadowHoundTask = new ConditionalStep((QuestHelper)this, this.moveToShadow, new Requirement[0]);
        this.shadowHoundTask.addStep(this.inShadow, this.shadowHound);
        doHard.addStep(this.notShadowHound, this.shadowHoundTask);
        this.catchSturTask = new ConditionalStep((QuestHelper)this, this.catchStur, new Requirement[0]);
        doHard.addStep(this.notCatchStur, this.catchSturTask);
        this.addySpearTask = new ConditionalStep((QuestHelper)this, this.addySpear, new Requirement[0]);
        doHard.addStep(this.notAddySpear, this.addySpearTask);
        this.mithrilDragTask = new ConditionalStep((QuestHelper)this, this.moveToWhirl, new Requirement[0]);
        this.mithrilDragTask.addStep(this.inAncient1, this.moveToAncient2);
        this.mithrilDragTask.addStep(this.inAncient2, this.moveToAncient3);
        this.mithrilDragTask.addStep(this.inAncient3, this.mithrilDrag);
        doHard.addStep(this.notMithrilDrag, this.mithrilDragTask);
        this.buyGraniteTask = new ConditionalStep((QuestHelper)this, this.buyGranite, new Requirement[0]);
        doHard.addStep(this.notBuyGranite, this.buyGraniteTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notCatchStur = new VarplayerRequirement(1178, false, 26);
        this.notSeersRooftop = new VarplayerRequirement(1178, false, 27);
        this.notYewLong = new VarplayerRequirement(1178, false, 28);
        this.notPietyCourt = new VarplayerRequirement(1178, false, 29);
        this.notWaterOrb = new VarplayerRequirement(1178, false, 30);
        this.notBurnMaple = new VarplayerRequirement(1178, false, 31);
        this.notShadowHound = new VarplayerRequirement(1179, false, 0);
        this.notMithrilDrag = new VarplayerRequirement(1179, false, 1);
        this.notBuyGranite = new VarplayerRequirement(1179, false, 2);
        this.notFancyStone = new VarplayerRequirement(1179, false, 3);
        this.notAddySpear = new VarplayerRequirement(1179, false, 4);
        this.piety = new PrayerRequirement("Piety", Prayer.PIETY);
        this.barbRod = new ItemRequirement("Barbarian fishing rod", 11323).showConditioned(this.notCatchStur).isNotConsumed();
        this.feather = new ItemRequirement("Feathers", 314).showConditioned(this.notCatchStur);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notYewLong).isNotConsumed();
        this.bowString = new ItemRequirement("Bow string", 1777).showConditioned(this.notYewLong);
        this.knife = new ItemRequirement("Knife", 946).showConditioned(this.notYewLong).isNotConsumed();
        this.waterRune = new ItemRequirement("Water rune", 555).showConditioned(this.notWaterOrb);
        this.cosmicRune = new ItemRequirement("Cosmic rune", 564).showConditioned(this.notWaterOrb);
        this.unpoweredOrb = new ItemRequirement("Unpowered orb", 567).showConditioned(this.notWaterOrb);
        Conditions not70Agility = new Conditions(LogicType.NOR, new SkillRequirement(Skill.AGILITY, 70, true));
        this.dustyKey = new KeyringRequirement("Dusty Key", this.configManager, KeyringCollection.DUSTY_KEY).showConditioned(new Conditions(not70Agility, this.notWaterOrb)).isNotConsumed();
        this.dustyKey.setTooltip("You can get this by killing the Jailor in the Black Knights Base in Taverley Dungeon and using the key he drops to enter the jail cell there to talk to Velrak for the dusty key");
        this.mapleLogs = new ItemRequirement("Maple logs", 1517).showConditioned(this.notBurnMaple);
        this.bow = new ItemRequirement("Any bow", ItemCollections.BOWS).showConditioned(this.notBurnMaple).isNotConsumed();
        this.ringOfVis = new ItemRequirement("Ring of Visibility", 4657).showConditioned(this.notShadowHound).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(new Conditions(LogicType.OR, this.notFancyStone, this.notBuyGranite));
        this.addyBar = new ItemRequirement("Adamantite bar", 2361).showConditioned(this.notAddySpear);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notAddySpear).isNotConsumed();
        this.yewLogs = new ItemRequirement("Yew logs", 1515).showConditioned(this.notAddySpear);
        this.unstrungYewLong = new ItemRequirement("Unstrung yew longbow", 66);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).showConditioned(new Conditions(LogicType.OR, this.notShadowHound, this.notMithrilDrag)).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.antidragonfire = new ItemRequirement("An antifire shield", ItemCollections.ANTIFIRE_SHIELDS).isNotConsumed();
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.setupGeneralRequirements();
        this.inTavDungeon = new ZoneRequirement(this.tavDungeon);
        this.inObIsland = new ZoneRequirement(this.obIsland);
        this.inSeers = new ZoneRequirement(this.seers);
        this.inShadow = new ZoneRequirement(this.shadow);
        this.inAncient1 = new ZoneRequirement(this.ancient1);
        this.inAncient2 = new ZoneRequirement(this.ancient2);
        this.inAncient3 = new ZoneRequirement(this.ancient3);
        this.choppedLogs = new ChatMessageRequirement(this.inSeers, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.choppedLogs).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inSeers), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
    }

    public void loadZones() {
        this.tavDungeon = new Zone(new WorldPoint(2813, 9857, 0), new WorldPoint(2972, 9669, 0));
        this.obIsland = new Zone(new WorldPoint(2833, 3427, 0), new WorldPoint(2849, 3415, 0));
        this.seers = new Zone(new WorldPoint(2682, 3510, 0), new WorldPoint(2742, 3455, 0));
        this.shadow = new Zone(new WorldPoint(2621, 5121, 0), new WorldPoint(2754, 5054, 0));
        this.ancient1 = new Zone(new WorldPoint(1761, 5369, 1), new WorldPoint(1770, 5363, 1));
        this.ancient2 = new Zone(new WorldPoint(1733, 5373, 0), new WorldPoint(1792, 5315, 0));
        this.ancient3 = new Zone(new WorldPoint(1734, 5362, 1), new WorldPoint(1792, 5279, 1));
    }

    public void setupSteps() {
        this.moveToTavDungeon = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Enter the Taverley Dungeon.", this.dustyKey, this.waterRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb);
        this.moveToOb = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(2842, 9824, 0), "Make your way through Taverley Dungeon to the end, and climb the ladder there. If you're 70+ Agility, use on of the shortcuts near the entrance to get there quickly.", this.dustyKey, this.waterRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb);
        this.waterOrb = new ObjectStep((QuestHelper)this, 2151, new WorldPoint(2844, 3422, 0), "Use the charge water orb spell on the obelisk.", this.waterRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb);
        this.waterOrb.addIcon(571);
        this.seersRooftop = new ObjectStep((QuestHelper)this, 14927, new WorldPoint(2729, 3489, 0), "Complete a lap of the Seers' village Rooftop course.", new Requirement[0]);
        this.yewLong = new ObjectStep((QuestHelper)this, 10822, new WorldPoint(2715, 3460, 0), "Cut some yew logs near Seers' Village. Make sure to use the knife on the ones you cut.", this.axe);
        this.cutLongbow = new ItemStep((QuestHelper)this, "Use knife on yew logs to make a yew longbow (u)", this.yewLogs.highlighted(), this.knife.highlighted());
        this.stringBow = new ItemStep((QuestHelper)this, "String the bow.", this.bowString.highlighted(), this.unstrungYewLong.highlighted());
        this.pietyCourt = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2735, 3469, 0), "Activate piety then enter the Seers' Village courthouse.", this.piety);
        this.moveToSeers = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2714, 3484, 0), "Go to Seers' Village.", this.bow, this.mapleLogs);
        this.burnMaple = new ItemStep((QuestHelper)this, "Burn some maple logs with a bow.", this.bow.highlighted(), this.mapleLogs.highlighted());
        this.fancyStone = new NpcStep((QuestHelper)this, 3097, new WorldPoint(2735, 3500, 0), "TALK to the estate agent to redecorate your house to Fancy Stone. Must be done through dialog.", this.coins.quantity(25000));
        this.fancyStone.addDialogStep("Can you redecorate my house please?");
        this.moveToShadow = new ObjectStep((QuestHelper)this, 6560, new WorldPoint(2547, 3421, 0), "Climb down the shadow ladder south of Glarial's Tomb.", this.ringOfVis.equipped(), this.combatGear);
        this.shadowHound = new NpcStep((QuestHelper)this, 3449, new WorldPoint(2699, 5095, 0), "Kill a shadow hound.", true, new Requirement[0]);
        this.catchStur = new NpcStep((QuestHelper)this, 1542, new WorldPoint(2501, 3504, 0), "Catch a leaping Sturgeon south of Barbarian Assault.", true, this.barbRod, this.feather.quantity(20));
        this.addySpear = new ObjectStep((QuestHelper)this, 25349, new WorldPoint(2502, 3485, 0), "Smith an adamant spear on the barbarian anvil south of Barbarian Assault.", this.addyBar, this.yewLogs);
        this.addySpear.addIcon(2361);
        this.moveToWhirl = new ObjectStep((QuestHelper)this, 25274, new WorldPoint(2512, 3508, 0), "Jump in the whirlpool south of Barbarian Assault.", this.combatGear, this.antidragonfire.equipped());
        this.moveToAncient2 = new ObjectStep((QuestHelper)this, 25338, new WorldPoint(1770, 5366, 1), "Go down the stairs.", new Requirement[0]);
        this.moveToAncient3 = new ObjectStep((QuestHelper)this, 25339, new WorldPoint(1778, 5345, 0), "Go up the stairs in the east of the cavern.", new Requirement[0]);
        this.mithrilDrag = new NpcStep((QuestHelper)this, 2919, new WorldPoint(1779, 5344, 1), "Kill a mithril dragon.", true, this.combatGear, this.antidragonfire.equipped(), this.food);
        this.buyGranite = new NpcStep((QuestHelper)this, 1656, new WorldPoint(2535, 3576, 0), "Buy and equip a granite body from Commander Connad. (Requires at least 1 Penance Queen kill)", this.coins.quantity(95000));
        this.claimReward = new NpcStep((QuestHelper)this, 5517, new WorldPoint(2760, 3476, 0), "Talk to the 'Wedge' in front of Camelot Castle to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.barbRod, this.feather, this.axe, this.bowString, this.knife, this.cosmicRune.quantity(3), this.waterRune.quantity(30), this.unpoweredOrb, this.dustyKey, this.mapleLogs, this.bow, this.ringOfVis, this.coins, this.addyBar, this.hammer, this.yewLogs, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.food);
    }

    private void setupGeneralRequirements() {
        this.barbFishing = new ItemRequirement("Completed Barbarian fishing", 1, -1);
        this.barbFiremaking = new ItemRequirement("Unlocked the Ancient Caverns through Barbarian Firemaking", 1, -1);
        this.barbSmithing = new ItemRequirement("Completed Barbarian Smithing", 1, -1);
        this.taiBwoWannai = new QuestRequirement(QuestHelperQuest.TAI_BWO_WANNAI_TRIO, QuestState.FINISHED);
        this.knightWaves = new QuestRequirement(QuestHelperQuest.KNIGHT_WAVES_TRAINING_GROUNDS, QuestState.FINISHED);
        this.desertTreasure = new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.FINISHED);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        this.setupGeneralRequirements();
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 60, true));
        req.add(new SkillRequirement(Skill.CONSTRUCTION, 50));
        req.add(new SkillRequirement(Skill.DEFENCE, 70));
        req.add(new SkillRequirement(Skill.FIREMAKING, 65, true));
        req.add(new SkillRequirement(Skill.FISHING, 70, true));
        req.add(new SkillRequirement(Skill.FLETCHING, 70, true));
        req.add(new SkillRequirement(Skill.PRAYER, 70));
        req.add(new SkillRequirement(Skill.MAGIC, 56));
        req.add(new SkillRequirement(Skill.SMITHING, 75, true));
        req.add(new SkillRequirement(Skill.STRENGTH, 50));
        req.add(new SkillRequirement(Skill.THIEVING, 53));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 60, true));
        req.add(this.taiBwoWannai);
        req.add(this.desertTreasure);
        req.add(this.barbFishing);
        req.add(this.barbFiremaking);
        req.add(this.barbSmithing);
        req.add(this.knightWaves);
        return req;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Shadow Hound (Level 63), Mithril Dragon (level 304)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Kandarin headgear (3)", 13139, 1), new ItemReward("15,500 Exp. Lamp (Any skill over 50)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Coal trucks can hold up to 308 coal."), new UnlockReward("Thormac will enchant battlestaves for 30,000 coins each"), new UnlockReward("The Flax keeper will exchange 120 noted flax for 120 noted bow strings daily"), new UnlockReward("15% more marks of grace on Seers' Village Rooftop Course"), new UnlockReward("10% increased chance to save a harvest life from the Catherby herb patch"), new UnlockReward("10% increased reward points from Barbarian Assault"), new UnlockReward("10% increased activation chance (multiplicative) for the special effect from enchanted bolts (Including PvP)"), new UnlockReward("Ability to toggle Camelot Teleport to outside Seers' Village bank"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails chargeOrbSteps = new PanelDetails("Charge Water Orb", Arrays.asList(this.moveToTavDungeon, this.moveToOb, this.waterOrb), this.waterRune.quantity(30), this.cosmicRune.quantity(3), this.unpoweredOrb, this.dustyKey);
        chargeOrbSteps.setDisplayCondition(this.notWaterOrb);
        chargeOrbSteps.setLockingStep(this.waterOrbTask);
        allSteps.add(chargeOrbSteps);
        PanelDetails agilitySteps = new PanelDetails("Seers' Village Rooftop", Collections.singletonList(this.seersRooftop), new SkillRequirement(Skill.AGILITY, 60, true));
        agilitySteps.setDisplayCondition(this.notSeersRooftop);
        agilitySteps.setLockingStep(this.seersRooftopTask);
        allSteps.add(agilitySteps);
        PanelDetails yewLongSteps = new PanelDetails("Yew Longbow from Scratch", Arrays.asList(this.yewLong, this.cutLongbow, this.stringBow), new SkillRequirement(Skill.FLETCHING, 70, true), new SkillRequirement(Skill.WOODCUTTING, 60, true), this.axe, this.bowString, this.knife);
        yewLongSteps.setDisplayCondition(this.notYewLong);
        yewLongSteps.setLockingStep(this.yewLongTask);
        allSteps.add(yewLongSteps);
        PanelDetails pietySteps = new PanelDetails("Piety in the Courthouse", Collections.singletonList(this.pietyCourt), new QuestRequirement(QuestHelperQuest.KINGS_RANSOM, QuestState.FINISHED), this.knightWaves, new SkillRequirement(Skill.PRAYER, 70), new SkillRequirement(Skill.DEFENCE, 70));
        pietySteps.setDisplayCondition(this.notPietyCourt);
        pietySteps.setLockingStep(this.pietyCourtTask);
        allSteps.add(pietySteps);
        PanelDetails burnMapleSteps = new PanelDetails("Burn Maple logs with a bow", Arrays.asList(this.moveToSeers, this.burnMaple), new SkillRequirement(Skill.FIREMAKING, 65, true), this.barbFiremaking, this.mapleLogs, this.bow);
        burnMapleSteps.setDisplayCondition(this.notBurnMaple);
        burnMapleSteps.setLockingStep(this.burnMapleTask);
        allSteps.add(burnMapleSteps);
        PanelDetails fancyStoneSteps = new PanelDetails("Fancy Stone Decoration", Collections.singletonList(this.fancyStone), new SkillRequirement(Skill.CONSTRUCTION, 50), this.coins.quantity(25000));
        fancyStoneSteps.setDisplayCondition(this.notFancyStone);
        fancyStoneSteps.setLockingStep(this.fancyStoneTask);
        allSteps.add(fancyStoneSteps);
        PanelDetails killHoundSteps = new PanelDetails("Kill a Shadow Hound", Arrays.asList(this.moveToShadow, this.shadowHound), this.desertTreasure, this.ringOfVis, this.combatGear, this.food);
        killHoundSteps.setDisplayCondition(this.notShadowHound);
        killHoundSteps.setLockingStep(this.shadowHoundTask);
        allSteps.add(killHoundSteps);
        PanelDetails fishSturgeonSteps = new PanelDetails("Fish a Leaping Sturgeon", Collections.singletonList(this.catchStur), new SkillRequirement(Skill.FISHING, 70, true), new SkillRequirement(Skill.AGILITY, 45), new SkillRequirement(Skill.STRENGTH, 45), this.barbFishing, this.barbRod, this.feather.quantity(20));
        fishSturgeonSteps.setDisplayCondition(this.notCatchStur);
        fishSturgeonSteps.setLockingStep(this.catchSturTask);
        allSteps.add(fishSturgeonSteps);
        PanelDetails smithSpearSteps = new PanelDetails("Smith an Adamant Spear", Collections.singletonList(this.addySpear), new SkillRequirement(Skill.SMITHING, 75, true), this.barbSmithing, this.taiBwoWannai, this.yewLogs, this.addyBar, this.hammer);
        smithSpearSteps.setDisplayCondition(this.notAddySpear);
        smithSpearSteps.setLockingStep(this.addySpearTask);
        allSteps.add(smithSpearSteps);
        PanelDetails killMithSteps = new PanelDetails("Kill a Mithril Dragon", Arrays.asList(this.moveToWhirl, this.moveToAncient2, this.moveToAncient3, this.mithrilDrag), this.barbFiremaking, this.combatGear, this.antidragonfire, this.food);
        killMithSteps.setDisplayCondition(this.notMithrilDrag);
        killMithSteps.setLockingStep(this.mithrilDragTask);
        allSteps.add(killMithSteps);
        PanelDetails buyGraniteSteps = new PanelDetails("Purchase Granite Body", Collections.singletonList(this.buyGranite), this.coins.quantity(95000), this.combatGear);
        buyGraniteSteps.setDisplayCondition(this.notBuyGranite);
        buyGraniteSteps.setLockingStep(this.buyGraniteTask);
        allSteps.add(buyGraniteSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

