/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.kandarin;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KANDARIN_ELITE)
public class KandarinElite
extends ComplexStateQuestHelper {
    ItemRequirement dwarfSeed;
    ItemRequirement seedDib;
    ItemRequirement spade;
    ItemRequirement rake;
    ItemRequirement compost;
    ItemRequirement harpoon;
    ItemRequirement cookingGaunt;
    ItemRequirement stamPot;
    ItemRequirement caviar;
    ItemRequirement runiteBar;
    ItemRequirement magicLogs1;
    ItemRequirement magicLogs2;
    ItemRequirement magicLogs;
    ItemRequirement hammer;
    ItemRequirement chewedBone;
    ItemRequirement tinderbox;
    ItemRequirement axe;
    ItemRequirement lawRune;
    ItemRequirement astralRune;
    ItemRequirement waterRune;
    ItemRequirement combatGear;
    ItemRequirement rawShark;
    Requirement notbarb5;
    Requirement notPickDwarf;
    Requirement not5Shark;
    Requirement notStamMix;
    Requirement notRuneHasta;
    Requirement notPyre;
    Requirement notTPCath;
    Requirement notHeal;
    Requirement notAtk;
    Requirement notDef;
    Requirement notCol;
    Requirement bothLogs;
    Requirement barbSmith;
    Requirement barbFire;
    Requirement barbHerb;
    Requirement familyCrest;
    Requirement lunarDip;
    Requirement fishedSharks;
    QuestStep claimReward;
    QuestStep tpCath;
    QuestStep plantAndPickDwarf;
    QuestStep moveToSeersRooftop;
    QuestStep stamMix;
    QuestStep runeHasta;
    QuestStep pyre;
    QuestStep barb5;
    QuestStep barb52;
    QuestStep barb5Heal;
    QuestStep barb5Atk;
    QuestStep barb5Def;
    QuestStep barb5Col;
    QuestStep cook5Sharks;
    NpcStep catch5Sharks;
    Zone bankRoof;
    Zone barbUnder;
    Zone catherby;
    ZoneRequirement inBankRoof;
    ZoneRequirement inBarbUnder;
    ZoneRequirement inCatherby;
    Requirement lunarBook;
    ConditionalStep barb5Task;
    ConditionalStep pickDwarfTask;
    ConditionalStep sharkTask;
    ConditionalStep stamMixTask;
    ConditionalStep runeHastaTask;
    ConditionalStep pyreTask;
    ConditionalStep tpCathTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.pickDwarfTask = new ConditionalStep((QuestHelper)this, this.plantAndPickDwarf, new Requirement[0]);
        doElite.addStep(this.notPickDwarf, this.pickDwarfTask);
        this.tpCathTask = new ConditionalStep((QuestHelper)this, this.tpCath, new Requirement[0]);
        doElite.addStep(this.notTPCath, this.tpCathTask);
        this.sharkTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.catch5Sharks, new Requirement[0]);
        this.sharkTask.addStep(new Conditions(this.fishedSharks, this.rawShark.quantity(5)), this.cook5Sharks);
        doElite.addStep(this.not5Shark, this.sharkTask);
        this.stamMixTask = new ConditionalStep((QuestHelper)this, this.moveToSeersRooftop, new Requirement[0]);
        this.stamMixTask.addStep(this.inBankRoof, this.stamMix);
        doElite.addStep(this.notStamMix, this.stamMixTask);
        this.runeHastaTask = new ConditionalStep((QuestHelper)this, this.runeHasta, new Requirement[0]);
        doElite.addStep(this.notRuneHasta, this.runeHastaTask);
        this.pyreTask = new ConditionalStep((QuestHelper)this, this.pyre, new Requirement[0]);
        doElite.addStep(this.notPyre, this.pyreTask);
        this.barb5Task = new ConditionalStep((QuestHelper)this, this.barb5, new Requirement[0]);
        this.barb5Task.addStep(this.inBarbUnder, this.barb52);
        this.barb5Task.addStep(this.notCol, this.barb5Col);
        this.barb5Task.addStep(this.notDef, this.barb5Def);
        this.barb5Task.addStep(this.notAtk, this.barb5Atk);
        this.barb5Task.addStep(this.notHeal, this.barb5Heal);
        doElite.addStep(this.notbarb5, this.barb5Task);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notbarb5 = new VarplayerRequirement(1179, false, 5);
        this.notPickDwarf = new VarplayerRequirement(1179, false, 6);
        this.not5Shark = new VarplayerRequirement(1179, false, 7);
        this.notStamMix = new VarplayerRequirement(1179, false, 8);
        this.notRuneHasta = new VarplayerRequirement(1179, false, 9);
        this.notPyre = new VarplayerRequirement(1179, false, 10);
        this.notTPCath = new VarplayerRequirement(1179, false, 11);
        this.bothLogs = new ComplexRequirement(LogicType.AND, "Magic logs", this.notRuneHasta, this.notPyre);
        this.notHeal = new VarbitRequirement(3255, 4, Operation.LESS_EQUAL);
        this.notAtk = new VarbitRequirement(3251, 4, Operation.LESS_EQUAL);
        this.notDef = new VarbitRequirement(3252, 4, Operation.LESS_EQUAL);
        this.notCol = new VarbitRequirement(3254, 4, Operation.LESS_EQUAL);
        this.dwarfSeed = new ItemRequirement("Dwarf weed seed", 5303).showConditioned(this.notPickDwarf);
        this.seedDib = new ItemRequirement("Seed dibber", 5343).showConditioned(this.notPickDwarf).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notPickDwarf).isNotConsumed();
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notPickDwarf).isNotConsumed();
        this.compost = new ItemRequirement("Any compost", ItemCollections.COMPOST).showConditioned(this.notPickDwarf);
        this.harpoon = new ItemRequirement("Harpoon", 311).showConditioned(this.not5Shark).isNotConsumed();
        this.cookingGaunt = new ItemRequirement("Cooking gauntlets", 775).showConditioned(this.not5Shark).isNotConsumed();
        this.stamPot = new ItemRequirement("Stamina potion (2)", 12629).showConditioned(this.notStamMix);
        this.caviar = new ItemRequirement("Caviar", 11326).showConditioned(this.notStamMix);
        this.runiteBar = new ItemRequirement("Runite bar", 2363).showConditioned(this.notRuneHasta);
        this.magicLogs1 = new ItemRequirement("Magic logs", 1513, 1).showConditioned(new Conditions(new Conditions(LogicType.OR, this.notRuneHasta, this.notPyre), new Conditions(LogicType.NOR, this.bothLogs)));
        this.magicLogs2 = new ItemRequirement("Magic logs", 1513, 2).showConditioned(new Conditions(LogicType.OR, this.notRuneHasta, this.notPyre));
        this.magicLogs = new ItemRequirement("Magic logs", 1513, 1);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notRuneHasta).isNotConsumed();
        this.chewedBone = new ItemRequirement("Chewed bones", 11338).showConditioned(this.notPyre);
        this.chewedBone.setTooltip("These are a rare drop from mithril dragons");
        this.tinderbox = new ItemRequirement("Tinderbox", 590).showConditioned(this.notPyre).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notPyre).isNotConsumed();
        this.lawRune = new ItemRequirement("Law runes", 563).showConditioned(this.notTPCath);
        this.astralRune = new ItemRequirement("Astral runes", 9075).showConditioned(this.notTPCath);
        this.waterRune = new ItemRequirement("Water runes", 555).showConditioned(this.notTPCath);
        this.rawShark = new ItemRequirement("Raw shark", 383).showConditioned(this.not5Shark);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).showConditioned(this.notbarb5).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.lunarBook = new SpellbookRequirement(Spellbook.LUNAR);
        this.setupGeneralRequirements();
        this.inBankRoof = new ZoneRequirement(this.bankRoof);
        this.inBarbUnder = new ZoneRequirement(this.barbUnder);
        this.inCatherby = new ZoneRequirement(this.catherby);
        this.fishedSharks = new ChatMessageRequirement(this.inCatherby, "<col=0040ff>Achievement Diary Stage Task - Current stage: 5 caught, 0 cooked.</col>");
        ((ChatMessageRequirement)this.fishedSharks).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inCatherby), "<col=0040ff>Achievement Diary Stage Task - Current stage: 5 caught, 0 cooked.</col>"));
    }

    private void setupGeneralRequirements() {
        this.barbHerb = new ItemRequirement("Completed Barbarian herblore", 1, -1).showConditioned(this.notStamMix);
        this.barbFire = new ItemRequirement("Unlocked the Ancient Caverns through Barbarian Firemaking", 1, -1).showConditioned(this.notPyre);
        this.barbSmith = new ItemRequirement("Completed Barbarian Smithing", 1, -1).showConditioned(this.notRuneHasta);
        this.familyCrest = new QuestRequirement(QuestHelperQuest.FAMILY_CREST, QuestState.FINISHED);
        this.lunarDip = new QuestRequirement(QuestHelperQuest.LUNAR_DIPLOMACY, QuestState.FINISHED);
    }

    public void loadZones() {
        this.bankRoof = new Zone(new WorldPoint(2721, 3495, 3), new WorldPoint(2730, 3490, 3));
        this.barbUnder = new Zone(new WorldPoint(2572, 53202, 0), new WorldPoint(2614, 5258, 0));
        this.catherby = new Zone(new WorldPoint(2801, 3457, 0), new WorldPoint(2864, 3416, 0));
    }

    public void setupSteps() {
        this.tpCath = new DetailedQuestStep((QuestHelper)this, "Teleport to Catherby.", this.lunarBook, this.waterRune.quantity(10), this.astralRune.quantity(3), this.lawRune.quantity(3));
        this.plantAndPickDwarf = new ObjectStep((QuestHelper)this, 8151, new WorldPoint(2814, 3464, 0), "Plant and harvest the dwarf weed from the Catherby patch. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.rake, this.dwarfSeed, this.seedDib);
        this.catch5Sharks = new NpcStep((QuestHelper)this, 1520, new WorldPoint(2837, 3431, 0), "Catch 5 sharks in Catherby.", this.harpoon, this.cookingGaunt.equipped());
        this.cook5Sharks = new ObjectStep((QuestHelper)this, 26181, new WorldPoint(2817, 3444, 0), "Successfully cook 5 on the range in Catherby.", this.cookingGaunt.equipped());
        this.moveToSeersRooftop = new ObjectStep((QuestHelper)this, 14927, new WorldPoint(2729, 3489, 0), "Climb on top of Seers' Bank.", this.stamPot, this.caviar);
        this.stamMix = new ItemStep((QuestHelper)this, "Create a stamina mix.", this.stamPot.highlighted(), this.caviar.highlighted());
        this.runeHasta = new ObjectStep((QuestHelper)this, 25349, new WorldPoint(2502, 3485, 0), "Smith a rune hasta on the barbarian anvil near Otto.", this.runiteBar, this.magicLogs, this.hammer);
        this.runeHasta.addIcon(2363);
        this.pyre = new ObjectStep((QuestHelper)this, 25286, new WorldPoint(2519, 3519, 0), "Construct a pyre ship from magic logs.", this.magicLogs, this.chewedBone, this.tinderbox, this.axe);
        this.barb5Heal = new DetailedQuestStep((QuestHelper)this, "Get to level 5 in the healer role at Barbarian Assault.", new Requirement[0]);
        this.barb5Atk = new DetailedQuestStep((QuestHelper)this, "Get to level 5 in the attacker role at Barbarian Assault.", new Requirement[0]);
        this.barb5Def = new DetailedQuestStep((QuestHelper)this, "Get to level 5 in the defender role at Barbarian Assault.", new Requirement[0]);
        this.barb5Col = new DetailedQuestStep((QuestHelper)this, "Get to level 5 in the collector role at Barbarian Assault.", new Requirement[0]);
        this.barb5 = new ObjectStep((QuestHelper)this, 20134, new WorldPoint(2535, 3569, 0), "Click one of the blackboards around Barbarian Assault!", new Requirement[0]);
        this.barb52 = new ObjectStep((QuestHelper)this, 20134, new WorldPoint(2587, 5264, 0), "Click one of the blackboards around Barbarian Assault!", new Requirement[0]);
        this.barb5.addSubSteps(this.barb52);
        this.claimReward = new NpcStep((QuestHelper)this, 5517, new WorldPoint(2760, 3476, 0), "Talk to the 'Wedge' in front of Camelot Castle to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.dwarfSeed, this.seedDib, this.spade, this.rake, this.compost, this.harpoon, this.cookingGaunt, this.stamPot, this.caviar, this.runiteBar, this.magicLogs1, this.magicLogs2, this.hammer, this.chewedBone, this.tinderbox, this.axe, this.lawRune.quantity(3), this.astralRune.quantity(3), this.waterRune.quantity(10), this.combatGear);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        this.setupGeneralRequirements();
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 60, true));
        req.add(new SkillRequirement(Skill.COOKING, 80));
        req.add(new SkillRequirement(Skill.CRAFTING, 85));
        req.add(new SkillRequirement(Skill.FARMING, 79));
        req.add(new SkillRequirement(Skill.FIREMAKING, 85));
        req.add(new SkillRequirement(Skill.FISHING, 76));
        req.add(new SkillRequirement(Skill.HERBLORE, 86));
        req.add(new SkillRequirement(Skill.MAGIC, 87));
        req.add(new SkillRequirement(Skill.SMITHING, 90));
        req.add(this.barbHerb);
        req.add(this.barbFire);
        req.add(this.barbSmith);
        req.add(this.familyCrest);
        req.add(this.lunarDip);
        return req;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Mithril Dragons (level 304) for chewed bones");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Kandarin headgear (4)", 13140, 1), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Thormac will enchant battlestaves for 20,000 coins each"), new UnlockReward("The Flax keeper will exchange 250 noted flax for 250 noted bow strings daily"), new UnlockReward("15% increased chance to save a harvest life from the Catherby herb patch"), new UnlockReward("The first 200 Coal placed into coal trucks every day will be automatically transported to your bank"), new UnlockReward("Otto Godblessed will turn a Zamorakian spear into Zamorakian hasta for 150,000 Coins"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails dwarfWeedSteps = new PanelDetails("Dwarf Weed in Catherby", Collections.singletonList(this.plantAndPickDwarf), new SkillRequirement(Skill.FARMING, 79, true), this.dwarfSeed, this.seedDib, this.rake, this.spade, this.compost);
        dwarfWeedSteps.setDisplayCondition(this.notPickDwarf);
        dwarfWeedSteps.setLockingStep(this.pickDwarfTask);
        allSteps.add(dwarfWeedSteps);
        PanelDetails teleCathSteps = new PanelDetails("Teleport to Catherby", Collections.singletonList(this.tpCath), new SkillRequirement(Skill.MAGIC, 87, true), this.lunarDip, this.waterRune.quantity(10), this.lawRune.quantity(3), this.astralRune.quantity(3));
        teleCathSteps.setDisplayCondition(this.notTPCath);
        teleCathSteps.setLockingStep(this.tpCathTask);
        allSteps.add(teleCathSteps);
        PanelDetails catchSharkSteps = new PanelDetails("5 Sharks Caught and Cooked in Catherby", Arrays.asList(this.catch5Sharks, this.cook5Sharks), new SkillRequirement(Skill.FISHING, 76, true), new SkillRequirement(Skill.COOKING, 80, true), this.familyCrest, this.harpoon, this.cookingGaunt);
        catchSharkSteps.setDisplayCondition(this.not5Shark);
        catchSharkSteps.setLockingStep(this.sharkTask);
        allSteps.add(catchSharkSteps);
        PanelDetails staminaSteps = new PanelDetails("Stamina Mix on the Bank", Arrays.asList(this.moveToSeersRooftop, this.stamMix), new SkillRequirement(Skill.HERBLORE, 86, true), new SkillRequirement(Skill.AGILITY, 60, true), this.barbHerb, this.stamPot, this.caviar);
        staminaSteps.setDisplayCondition(this.notStamMix);
        staminaSteps.setLockingStep(this.stamMixTask);
        allSteps.add(staminaSteps);
        PanelDetails smithRuneHastaSteps = new PanelDetails("Smith Rune Hasta", Collections.singletonList(this.runeHasta), new SkillRequirement(Skill.SMITHING, 90, true), this.barbSmith, this.magicLogs, this.runiteBar, this.hammer);
        smithRuneHastaSteps.setDisplayCondition(this.notRuneHasta);
        smithRuneHastaSteps.setLockingStep(this.runeHastaTask);
        allSteps.add(smithRuneHastaSteps);
        PanelDetails magicPyreSteps = new PanelDetails("Magic Pyre Ship", Collections.singletonList(this.pyre), new SkillRequirement(Skill.FIREMAKING, 85, true), new SkillRequirement(Skill.CRAFTING, 85, true), this.barbFire, this.axe, this.tinderbox, this.magicLogs, this.chewedBone);
        magicPyreSteps.setDisplayCondition(this.notPyre);
        magicPyreSteps.setLockingStep(this.pyreTask);
        allSteps.add(magicPyreSteps);
        PanelDetails level5RolesSteps = new PanelDetails("Level 5 each Role", Arrays.asList(this.barb5Heal, this.barb5Atk, this.barb5Def, this.barb5Col, this.barb5), new Requirement[0]);
        level5RolesSteps.setDisplayCondition(this.notbarb5);
        level5RolesSteps.setLockingStep(this.barb5Task);
        allSteps.add(level5RolesSteps);
        PanelDetails finishingOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishingOffSteps);
        return allSteps;
    }
}

