/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.kandarin;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.statemanagement.AchievementDiaryStepManager;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.KANDARIN_EASY)
public class KandarinEasy
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement bigFishingNet;
    ItemRequirement coins;
    ItemRequirement juteSeed;
    ItemRequirement seedDibber;
    ItemRequirement rake;
    ItemRequirement batteredKey;
    ItemRequirement emptyFishbowl;
    ItemRequirement fishBowl;
    ItemRequirement seaweed;
    ItemRequirement fishBowlSeaweed;
    ItemRequirement tinyNet;
    ItemRequirement genericFishbowl;
    ItemRequirement food;
    Requirement notCatchMackerel;
    Requirement notBuyCandle;
    Requirement notCollectFlax;
    Requirement notPlayOrgan;
    Requirement notPlantJute;
    Requirement notCupTea;
    Requirement notKillEle;
    Requirement notPetFish;
    Requirement notBuyStew;
    Requirement notTalkSherlock;
    Requirement notLogShortcut;
    Requirement eleWorkI;
    QuestStep buyCandle;
    QuestStep collectFlax;
    QuestStep playOrgan;
    QuestStep plantJute;
    QuestStep cupTea;
    QuestStep petFish;
    QuestStep fillFishbowl;
    QuestStep buyStew;
    QuestStep talkSherlock;
    QuestStep logShortcut;
    QuestStep claimReward;
    QuestStep moveToWorkshop;
    QuestStep petFishMix;
    QuestStep petFishFish;
    QuestStep killFire;
    QuestStep killEarth;
    QuestStep killWater;
    QuestStep killAir;
    NpcStep catchMackerel;
    NpcStep killEle;
    Zone workshop;
    Requirement inWorkshop;
    ConditionalStep catchMackerelTask;
    ConditionalStep buyCandleTask;
    ConditionalStep collectFlaxTask;
    ConditionalStep playOrganTask;
    ConditionalStep plantJuteTask;
    ConditionalStep cupTeaTask;
    ConditionalStep killEleTask;
    ConditionalStep petFishTask;
    ConditionalStep buyStewTask;
    ConditionalStep talkSherlockTask;
    ConditionalStep logShortcutTask;
    RuneliteRequirement killedFire;
    RuneliteRequirement killedEarth;
    RuneliteRequirement killedWater;
    RuneliteRequirement killedAir;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.plantJuteTask = new ConditionalStep((QuestHelper)this, this.plantJute, new Requirement[0]);
        doEasy.addStep(this.notPlantJute, this.plantJuteTask);
        this.catchMackerelTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.catchMackerel, new Requirement[0]);
        doEasy.addStep(this.notCatchMackerel, this.catchMackerelTask);
        this.petFishTask = new ConditionalStep((QuestHelper)this, this.fillFishbowl, new Requirement[0]);
        this.petFishTask.addStep(new Conditions(this.fishBowlSeaweed, this.tinyNet), this.petFishFish);
        this.petFishTask.addStep(this.fishBowlSeaweed, this.petFish);
        this.petFishTask.addStep(this.fishBowl, this.petFishMix);
        doEasy.addStep(new Conditions(this.notPetFish), this.petFishTask);
        this.buyCandleTask = new ConditionalStep((QuestHelper)this, this.buyCandle, new Requirement[0]);
        doEasy.addStep(this.notBuyCandle, this.buyCandleTask);
        this.collectFlaxTask = new ConditionalStep((QuestHelper)this, this.collectFlax, new Requirement[0]);
        doEasy.addStep(this.notCollectFlax, this.collectFlaxTask);
        this.talkSherlockTask = new ConditionalStep((QuestHelper)this, this.talkSherlock, new Requirement[0]);
        doEasy.addStep(this.notTalkSherlock, this.talkSherlockTask);
        this.killEleTask = new ConditionalStep((QuestHelper)this, this.moveToWorkshop, new Requirement[0]);
        this.killEleTask.addStep(new Conditions(this.inWorkshop, this.killedFire, this.killedEarth, this.killedWater), this.killAir);
        this.killEleTask.addStep(new Conditions(this.inWorkshop, this.killedFire, this.killedEarth), this.killWater);
        this.killEleTask.addStep(new Conditions(this.inWorkshop, this.killedFire), this.killEarth);
        this.killEleTask.addStep(new Conditions(this.inWorkshop), this.killFire);
        this.killEleTask.addStep(this.inWorkshop, this.killEle);
        doEasy.addStep(this.notKillEle, this.killEleTask);
        this.playOrganTask = new ConditionalStep((QuestHelper)this, this.playOrgan, new Requirement[0]);
        doEasy.addStep(this.notPlayOrgan, this.playOrganTask);
        this.buyStewTask = new ConditionalStep((QuestHelper)this, this.buyStew, new Requirement[0]);
        doEasy.addStep(this.notBuyStew, this.buyStewTask);
        this.cupTeaTask = new ConditionalStep((QuestHelper)this, this.cupTea, new Requirement[0]);
        doEasy.addStep(this.notCupTea, this.cupTeaTask);
        this.logShortcutTask = new ConditionalStep((QuestHelper)this, this.logShortcut, new Requirement[0]);
        doEasy.addStep(this.notLogShortcut, this.logShortcutTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notCatchMackerel = new VarplayerRequirement(1178, false, 1);
        this.notBuyCandle = new VarplayerRequirement(1178, false, 2);
        this.notCollectFlax = new VarplayerRequirement(1178, false, 3);
        this.notPlayOrgan = new VarplayerRequirement(1178, false, 4);
        this.notPlantJute = new VarplayerRequirement(1178, false, 5);
        this.notCupTea = new VarplayerRequirement(1178, false, 6);
        this.notKillEle = new VarplayerRequirement(1178, false, 7);
        this.notPetFish = new VarplayerRequirement(1178, false, 8);
        this.notBuyStew = new VarplayerRequirement(1178, false, 9);
        this.notTalkSherlock = new VarplayerRequirement(1178, false, 10);
        this.notLogShortcut = new VarplayerRequirement(1178, false, 11);
        this.killedFire = AchievementDiaryStepManager.getKilledFire();
        this.killedEarth = AchievementDiaryStepManager.getKilledEarth();
        this.killedWater = AchievementDiaryStepManager.getKilledWater();
        this.killedAir = AchievementDiaryStepManager.getKilledAir();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(new Conditions(LogicType.OR, this.notPetFish, this.notBuyCandle, this.notBuyStew));
        this.bigFishingNet = new ItemRequirement("Big fishing net", 305).showConditioned(this.notCatchMackerel).isNotConsumed();
        this.emptyFishbowl = new ItemRequirement("Empty fishbowl", 6667).showConditioned(this.notPetFish);
        this.fishBowl = new ItemRequirement("Filled fishbowl", 6668).showConditioned(this.notPetFish);
        this.fishBowlSeaweed = new ItemRequirement("Fishbowl with seaweed", 6669).showConditioned(this.notPetFish);
        this.tinyNet = new ItemRequirement("Tiny net", 6674).showConditioned(this.notPetFish);
        this.genericFishbowl = new ItemRequirements(LogicType.OR, "Fishbowl", this.emptyFishbowl, this.fishBowl, this.fishBowlSeaweed).showConditioned(this.notPetFish);
        this.seaweed = new ItemRequirement("Seaweed", 401).showConditioned(this.notPetFish);
        this.juteSeed = new ItemRequirement("Jute seeds", 5306).showConditioned(this.notPlantJute);
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notPlantJute).isNotConsumed();
        this.seedDibber = new ItemRequirement("Seed dibber", 5343).showConditioned(this.notPlantJute).isNotConsumed();
        this.batteredKey = new KeyringRequirement("Battered Key", this.configManager, KeyringCollection.BATTERED_KEY).showConditioned(this.notKillEle).isNotConsumed();
        this.batteredKey.setTooltip("You can get another by searching the bookcase in the house south of the Elemental Workshop, then reading the book you get from it");
        this.combatGear = new ItemRequirement("Combat gear to defeat all types of elementals (level 35)", -1, -1).showConditioned(this.notKillEle).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inWorkshop = AchievementDiaryStepManager.getInWorkshop();
        this.setupGenericRequirements();
    }

    public void setupGenericRequirements() {
        this.eleWorkI = new Conditions(LogicType.OR, new VarplayerRequirement(299, true, 15), new QuestRequirement(QuestHelperQuest.ELEMENTAL_WORKSHOP_I, QuestState.FINISHED));
        ((Conditions)this.eleWorkI).setText("Partial completion of Elemental Workshop I");
    }

    public void loadZones() {
        this.workshop = new Zone(new WorldPoint(2682, 9862, 0), new WorldPoint(2747, 9927, 0));
    }

    public void setupSteps() {
        this.catchMackerel = new NpcStep((QuestHelper)this, 1520, new WorldPoint(2841, 3432, 0), "Fish on Catherby beach at the Big Net fishing spots for a mackerel.", true, this.bigFishingNet);
        this.buyCandle = new NpcStep((QuestHelper)this, 3199, new WorldPoint(2799, 3439, 0), "Buy a candle from the candle maker in Catherby.", this.coins.quantity(3));
        this.fillFishbowl = new ObjectStep((QuestHelper)this, 874, new WorldPoint(2830, 3441, 0), "Fill an empty fish bowl at a sink.", this.emptyFishbowl.highlighted(), this.seaweed, this.coins.quantity(10));
        this.fillFishbowl.addIcon(6667);
        this.petFish = new NpcStep((QuestHelper)this, 3213, new WorldPoint(2833, 3443, 0), "Speak with Harry in the Catherby Fishing Shop to get a tiny net.", this.fishBowlSeaweed, this.coins.quantity(10));
        this.petFish.addDialogSteps("Can I get a fish for this bowl?", "I'll take it!");
        this.petFishMix = new ItemStep((QuestHelper)this, "Put seaweed into the fishbowl.", this.fishBowl.highlighted(), this.seaweed.highlighted());
        this.petFishFish = new ObjectStep((QuestHelper)this, 10091, new WorldPoint(2831, 3445, 0), "Fish in the aquarium near Harry.", this.tinyNet);
        this.collectFlax = new ObjectStep((QuestHelper)this, 14896, new WorldPoint(2742, 3446, 0), "Pick 5 flax at the flax field west of Catherby.", new Requirement[0]);
        this.talkSherlock = new NpcStep((QuestHelper)this, 6586, new WorldPoint(2735, 3413, 0), "Speak with Sherlock west of Catherby.", new Requirement[0]);
        this.moveToWorkshop = new ObjectStep((QuestHelper)this, 3415, new WorldPoint(2711, 3498, 0), "Enter the Elemental Workshop in Seers' Village.", this.batteredKey, this.combatGear, this.food);
        this.killEle = new NpcStep((QuestHelper)this, 1365, new WorldPoint(2719, 9889, 0), "Kill one of each of the 4 elementals.", this.combatGear, this.food);
        this.killEle.addAlternateNpcs(1370, 1369, 1366);
        this.killFire = new NpcStep((QuestHelper)this, 1365, new WorldPoint(2719, 9877, 0), "Kill one of each of the 4 elementals.", true, this.combatGear, this.food);
        this.killEarth = new NpcStep((QuestHelper)this, 1366, new WorldPoint(2700, 9903, 0), "Kill one of each of the 4 elementals.", true, this.combatGear, this.food);
        this.killWater = new NpcStep((QuestHelper)this, 1370, new WorldPoint(2719, 9903, 0), "Kill one of each of the 4 elementals.", true, this.combatGear, this.food);
        this.killAir = new NpcStep((QuestHelper)this, 1369, new WorldPoint(2735, 9891, 0), "Kill one of each of the 4 elementals.", true, this.combatGear, this.food);
        this.killEle.addSubSteps(this.killFire, this.killEarth, this.killWater, this.killAir);
        this.buyStew = new NpcStep((QuestHelper)this, 1318, new WorldPoint(2691, 3494, 0), "Talk with the bartender in Seers' Village and buy a stew.", this.coins.quantity(20));
        this.buyStew.addDialogSteps("What do you have?", "Could I have some stew please?");
        this.playOrgan = new ObjectStep((QuestHelper)this, 25818, new WorldPoint(2692, 3463, 0), "Play the organ in Seers' Village Church.", new Requirement[0]);
        this.plantJute = new ObjectStep((QuestHelper)this, 8176, new WorldPoint(2669, 3523, 0), "Plant 3 jute seeds in the hops patch north west of Seers' Village.", this.juteSeed.quantity(3), this.seedDibber, this.rake);
        this.plantJute.addIcon(5306);
        this.cupTea = new NpcStep((QuestHelper)this, 4064, new WorldPoint(2612, 3474, 0), "Talk with Galahad west of McGrubor's Wood until he gives you some tea.", new Requirement[0]);
        this.cupTea.addDialogStep("Do you get lonely here on your own?");
        this.logShortcut = new ObjectStep((QuestHelper)this, 23274, new WorldPoint(2602, 3477, 0), "Cross the log shortcut near to Galahad.", new Requirement[0]);
        this.claimReward = new NpcStep((QuestHelper)this, 5517, new WorldPoint(2760, 3476, 0), "Talk to the 'Wedge' in front of Camelot Castle to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(33), this.bigFishingNet, this.juteSeed.quantity(3), this.seedDibber, this.rake, this.batteredKey, this.genericFishbowl, this.seaweed, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.food);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("4 level 35 elementals");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        this.setupGenericRequirements();
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 20, true));
        req.add(new SkillRequirement(Skill.FARMING, 13, true));
        req.add(new SkillRequirement(Skill.FISHING, 16, true));
        req.add(this.eleWorkI);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Kandarin headgear (1)", 13137, 1), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Coal trucks can hold up to 140 coal."), new UnlockReward("The Flax keeper will exchange 30 noted flax for 30 noted bow strings daily"), new UnlockReward("5% more marks of grace on Seers' Village Rooftop Course"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails plantJuteSteps = new PanelDetails("Plant Jute", Collections.singletonList(this.plantJute), new SkillRequirement(Skill.FARMING, 13, true), this.juteSeed.quantity(3), this.seedDibber, this.rake);
        plantJuteSteps.setDisplayCondition(this.notPlantJute);
        plantJuteSteps.setLockingStep(this.plantJuteTask);
        allSteps.add(plantJuteSteps);
        PanelDetails catchMackSteps = new PanelDetails("Catch a Mackerel", Collections.singletonList(this.catchMackerel), new SkillRequirement(Skill.FISHING, 16, true), this.bigFishingNet);
        catchMackSteps.setDisplayCondition(this.notCatchMackerel);
        catchMackSteps.setLockingStep(this.catchMackerelTask);
        allSteps.add(catchMackSteps);
        PanelDetails getPetFishSteps = new PanelDetails("Get a Pet Fish", Arrays.asList(this.fillFishbowl, this.petFishMix, this.petFish, this.petFishFish), this.coins.quantity(10), this.genericFishbowl, this.seaweed);
        getPetFishSteps.setDisplayCondition(this.notPetFish);
        getPetFishSteps.setLockingStep(this.petFishTask);
        allSteps.add(getPetFishSteps);
        PanelDetails buyCandleSteps = new PanelDetails("Buy a Candle", Collections.singletonList(this.buyCandle), this.coins.quantity(3));
        buyCandleSteps.setDisplayCondition(this.notBuyCandle);
        buyCandleSteps.setLockingStep(this.buyCandleTask);
        allSteps.add(buyCandleSteps);
        PanelDetails collectFlaxSteps = new PanelDetails("Collect 5 Flax", Collections.singletonList(this.collectFlax), new Requirement[0]);
        collectFlaxSteps.setDisplayCondition(this.notCollectFlax);
        collectFlaxSteps.setLockingStep(this.collectFlaxTask);
        allSteps.add(collectFlaxSteps);
        PanelDetails talkSherlockSteps = new PanelDetails("Talk to Sherlock", Collections.singletonList(this.talkSherlock), new Requirement[0]);
        talkSherlockSteps.setDisplayCondition(this.notTalkSherlock);
        talkSherlockSteps.setLockingStep(this.talkSherlockTask);
        allSteps.add(talkSherlockSteps);
        PanelDetails killElesSteps = new PanelDetails("Defeat Elementals", Arrays.asList(this.moveToWorkshop, this.killEle), this.eleWorkI, this.batteredKey, this.combatGear, this.food);
        killElesSteps.setDisplayCondition(this.notKillEle);
        killElesSteps.setLockingStep(this.killEleTask);
        allSteps.add(killElesSteps);
        PanelDetails playOrganSteps = new PanelDetails("Play the Church Organ", Collections.singletonList(this.playOrgan), new Requirement[0]);
        playOrganSteps.setDisplayCondition(this.notPlayOrgan);
        playOrganSteps.setLockingStep(this.playOrganTask);
        allSteps.add(playOrganSteps);
        PanelDetails buyStewSteps = new PanelDetails("Buy Stew", Collections.singletonList(this.buyStew), this.coins.quantity(20));
        buyStewSteps.setDisplayCondition(this.notBuyStew);
        buyStewSteps.setLockingStep(this.buyStewTask);
        allSteps.add(buyStewSteps);
        PanelDetails getTeaSteps = new PanelDetails("Cup of Tea with Galahad", Collections.singletonList(this.cupTea), new Requirement[0]);
        getTeaSteps.setDisplayCondition(this.notCupTea);
        getTeaSteps.setLockingStep(this.cupTeaTask);
        allSteps.add(getTeaSteps);
        PanelDetails takeShortcutSteps = new PanelDetails("Log Shortcut", Collections.singletonList(this.logShortcut), new SkillRequirement(Skill.AGILITY, 20, true));
        takeShortcutSteps.setDisplayCondition(this.notLogShortcut);
        takeShortcutSteps.setLockingStep(this.logShortcutTask);
        allSteps.add(takeShortcutSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

