/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.fremennik;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FREMENNIK_HARD)
public class FremennikHard
extends ComplexStateQuestHelper {
    ItemRequirement bronzeNail;
    ItemRequirement rope;
    ItemRequirement lawRune;
    ItemRequirement lawRune2;
    ItemRequirement astralRune;
    ItemRequirement waterRune;
    ItemRequirement fireRune;
    ItemRequirement teasingStick;
    ItemRequirement knife;
    ItemRequirement axe;
    ItemRequirement pickaxe;
    ItemRequirement hammer;
    ItemRequirement arcticLog;
    ItemRequirement whiteBerries;
    ItemRequirement log;
    ItemRequirement cadantineUnfPot;
    ItemRequirement rake;
    Requirement notTPTroll;
    Requirement notCatchKyatt;
    Requirement notMixSuperDef;
    Requirement notStealGem;
    Requirement notCraftShield;
    Requirement notMineAddy;
    Requirement notMiscSupport;
    Requirement notTPWaterbirth;
    Requirement notFreeBlast;
    Requirement giantDwarf;
    Requirement fremIsles;
    Requirement throneOfMisc;
    Requirement eadgarsRuse;
    Requirement lunarDiplomacy;
    Requirement normalBook;
    Requirement lunarBook;
    QuestStep tpTroll;
    QuestStep catchKyatt;
    QuestStep mixSuperDef;
    QuestStep stealGem;
    QuestStep craftShield;
    QuestStep mineAddy;
    QuestStep tpWaterbirth;
    QuestStep freeBlast;
    QuestStep moveToRiverGem;
    QuestStep moveToCaveGem;
    QuestStep moveToKeldagrimGem;
    QuestStep moveToKeldagrimVarrockGem;
    QuestStep moveToRiverBlast;
    QuestStep moveToCaveBlast;
    QuestStep moveToKeldagrimBlast;
    QuestStep moveToKeldagrimVarrockBlast;
    QuestStep moveToNeitiznot;
    QuestStep moveToJatizso;
    QuestStep moveToMisc;
    QuestStep moveToMine;
    QuestStep moveToBlast;
    QuestStep claimReward;
    QuestStep moveToRellekka;
    ObjectStep miscSupport;
    Zone misc;
    Zone neitiznot;
    Zone keldagrim;
    Zone jatizso;
    Zone caveArea;
    Zone riverArea;
    Zone varrockArea;
    Zone hunterArea;
    Zone rellekkaArea;
    Zone mineArea;
    Zone blastArea;
    ZoneRequirement inMisc;
    ZoneRequirement inNeitiznot;
    ZoneRequirement inKeldagrim;
    ZoneRequirement inJatizso;
    ZoneRequirement inCaveArea;
    ZoneRequirement inRiverArea;
    ZoneRequirement inVarrockArea;
    ZoneRequirement inHunterArea;
    ZoneRequirement inRellekka;
    ZoneRequirement inMineArea;
    ZoneRequirement inBlastArea;
    ConditionalStep tpTrollTask;
    ConditionalStep catchKyattTask;
    ConditionalStep mixSuperDefTask;
    ConditionalStep stealGemTask;
    ConditionalStep craftShieldTask;
    ConditionalStep mineAddyTask;
    ConditionalStep miscSupportTask;
    ConditionalStep tpWaterbirthTask;
    ConditionalStep freeBlastTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.miscSupportTask = new ConditionalStep((QuestHelper)this, this.moveToMisc, new Requirement[0]);
        this.miscSupportTask.addStep(this.inMisc, this.miscSupport);
        doHard.addStep(this.notMiscSupport, this.miscSupportTask);
        this.mineAddyTask = new ConditionalStep((QuestHelper)this, this.moveToJatizso, new Requirement[0]);
        this.mineAddyTask.addStep(this.inJatizso, this.moveToMine);
        this.mineAddyTask.addStep(this.inMineArea, this.mineAddy);
        doHard.addStep(this.notMineAddy, this.mineAddyTask);
        this.craftShieldTask = new ConditionalStep((QuestHelper)this, this.moveToNeitiznot, new Requirement[0]);
        this.craftShieldTask.addStep(this.inNeitiznot, this.craftShield);
        doHard.addStep(this.notCraftShield, this.craftShieldTask);
        this.mixSuperDefTask = new ConditionalStep((QuestHelper)this, this.moveToRellekka, new Requirement[0]);
        this.mixSuperDefTask.addStep(this.inRellekka, this.mixSuperDef);
        doHard.addStep(this.notMixSuperDef, this.mixSuperDefTask);
        this.catchKyattTask = new ConditionalStep((QuestHelper)this, this.catchKyatt, new Requirement[0]);
        doHard.addStep(this.notCatchKyatt, this.catchKyattTask);
        this.stealGemTask = new ConditionalStep((QuestHelper)this, this.moveToCaveGem, new Requirement[0]);
        this.stealGemTask.addStep(this.inVarrockArea, this.moveToKeldagrimVarrockGem);
        this.stealGemTask.addStep(this.inCaveArea, this.moveToRiverGem);
        this.stealGemTask.addStep(this.inRiverArea, this.moveToKeldagrimGem);
        this.stealGemTask.addStep(this.inKeldagrim, this.stealGem);
        doHard.addStep(this.notStealGem, this.stealGemTask);
        this.freeBlastTask = new ConditionalStep((QuestHelper)this, this.moveToCaveBlast, new Requirement[0]);
        this.freeBlastTask.addStep(this.inVarrockArea, this.moveToKeldagrimVarrockBlast);
        this.freeBlastTask.addStep(this.inCaveArea, this.moveToRiverBlast);
        this.freeBlastTask.addStep(this.inRiverArea, this.moveToKeldagrimBlast);
        this.freeBlastTask.addStep(this.inKeldagrim, this.moveToBlast);
        this.freeBlastTask.addStep(this.inBlastArea, this.freeBlast);
        doHard.addStep(this.notFreeBlast, this.freeBlastTask);
        this.tpTrollTask = new ConditionalStep((QuestHelper)this, this.tpTroll, new Requirement[0]);
        doHard.addStep(this.notTPTroll, this.tpTrollTask);
        this.tpWaterbirthTask = new ConditionalStep((QuestHelper)this, this.tpWaterbirth, new Requirement[0]);
        doHard.addStep(this.notTPWaterbirth, this.tpWaterbirthTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notTPTroll = new VarplayerRequirement(1184, false, 21);
        this.notCatchKyatt = new VarplayerRequirement(1184, false, 23);
        this.notMixSuperDef = new VarplayerRequirement(1184, false, 24);
        this.notStealGem = new VarplayerRequirement(1184, false, 25);
        this.notCraftShield = new VarplayerRequirement(1184, false, 26);
        this.notMineAddy = new VarplayerRequirement(1184, false, 27);
        this.notMiscSupport = new VarplayerRequirement(1184, false, 28);
        this.notTPWaterbirth = new VarplayerRequirement(1184, false, 29);
        this.notFreeBlast = new VarplayerRequirement(1184, false, 30);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notMineAddy).isNotConsumed();
        this.bronzeNail = new ItemRequirement("Bronze nails", 4819).showConditioned(this.notCraftShield);
        this.rope = new ItemRequirement("Rope", 954).showConditioned(this.notCraftShield).isNotConsumed();
        this.lawRune = new ItemRequirement("Law rune", 563).showConditioned(this.notTPTroll);
        this.lawRune2 = new ItemRequirement("Law rune", 563).showConditioned(this.notTPWaterbirth);
        this.astralRune = new ItemRequirement("Astral rune", 9075).showConditioned(this.notTPWaterbirth);
        this.waterRune = new ItemRequirement("Water rune", 555).showConditioned(this.notTPWaterbirth);
        this.fireRune = new ItemRequirement("Fire rune", 554).showConditioned(this.notTPTroll);
        this.teasingStick = new ItemRequirement("Teasing Stick", 10029).showConditioned(this.notCatchKyatt).isNotConsumed();
        this.knife = new ItemRequirement("Knife", 946).showConditioned(this.notCatchKyatt).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notCraftShield).isNotConsumed();
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notCraftShield).isNotConsumed();
        this.arcticLog = new ItemRequirement("Arctic pine logs", 10810).showConditioned(this.notCraftShield);
        this.cadantineUnfPot = new ItemRequirement("Cadantine unf pot", 107).showConditioned(this.notMixSuperDef);
        this.whiteBerries = new ItemRequirement("White berries", 239).showConditioned(this.notMixSuperDef);
        this.log = new ItemRequirement("Logs", 1511).showConditioned(this.notCatchKyatt);
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notMiscSupport).isNotConsumed();
        this.normalBook = new SpellbookRequirement(Spellbook.NORMAL);
        this.lunarBook = new SpellbookRequirement(Spellbook.LUNAR);
        this.giantDwarf = new QuestRequirement(QuestHelperQuest.THE_GIANT_DWARF, QuestState.IN_PROGRESS);
        this.fremIsles = new QuestRequirement(QuestHelperQuest.THE_FREMENNIK_ISLES, QuestState.FINISHED);
        this.throneOfMisc = new QuestRequirement(QuestHelperQuest.THRONE_OF_MISCELLANIA, QuestState.FINISHED);
        this.eadgarsRuse = new QuestRequirement(QuestHelperQuest.EADGARS_RUSE, QuestState.FINISHED);
        this.lunarDiplomacy = new QuestRequirement(QuestHelperQuest.LUNAR_DIPLOMACY, QuestState.FINISHED);
        this.inMisc = new ZoneRequirement(this.misc);
        this.inNeitiznot = new ZoneRequirement(this.neitiznot);
        this.inKeldagrim = new ZoneRequirement(this.keldagrim);
        this.inJatizso = new ZoneRequirement(this.jatizso);
        this.inCaveArea = new ZoneRequirement(this.caveArea);
        this.inRiverArea = new ZoneRequirement(this.riverArea);
        this.inHunterArea = new ZoneRequirement(this.hunterArea);
        this.inVarrockArea = new ZoneRequirement(this.varrockArea);
        this.inRellekka = new ZoneRequirement(this.rellekkaArea);
        this.inMineArea = new ZoneRequirement(this.mineArea);
        this.inBlastArea = new ZoneRequirement(this.blastArea);
    }

    public void loadZones() {
        this.misc = new Zone(new WorldPoint(2492, 3922, 0), new WorldPoint(2629, 3814, 0));
        this.neitiznot = new Zone(new WorldPoint(2306, 3825, 0), new WorldPoint(2367, 3779, 0));
        this.jatizso = new Zone(new WorldPoint(2369, 3838, 0), new WorldPoint(2434, 3778, 0));
        this.caveArea = new Zone(new WorldPoint(2767, 10165, 0), new WorldPoint(2802, 10127, 0));
        this.riverArea = new Zone(new WorldPoint(2816, 10148, 0), new WorldPoint(2893, 10114, 0));
        this.varrockArea = new Zone(new WorldPoint(3076, 3617, 0), new WorldPoint(3290, 3374, 0));
        this.keldagrim = new Zone(new WorldPoint(2816, 10238, 0), new WorldPoint(2943, 10158, 0));
        this.hunterArea = new Zone(new WorldPoint(2690, 3838, 0), new WorldPoint(2748, 3767, 0));
        this.rellekkaArea = new Zone(new WorldPoint(2616, 3728, 0), new WorldPoint(2754, 3607, 0));
        this.mineArea = new Zone(new WorldPoint(2373, 10234, 0), new WorldPoint(2429, 10179, 0));
        this.blastArea = new Zone(new WorldPoint(1933, 4975, 0), new WorldPoint(1958, 4955, 0));
    }

    public void setupSteps() {
        this.tpTroll = new DetailedQuestStep((QuestHelper)this, "Teleport to Trollheim.", this.lawRune.quantity(2), this.fireRune.quantity(2), this.normalBook);
        this.catchKyatt = new NpcStep((QuestHelper)this, 2907, new WorldPoint(2725, 3770, 0), "Place logs over a pit in the hunter area, and poke a kyatt with a teasing stick. Jump over the pits until the kyatt falls in and loot it.", this.teasingStick, this.log, this.knife);
        this.moveToRellekka = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2659, 3671, 0), "Enter the Relleka province.", new Requirement[0]);
        this.mixSuperDef = new ItemStep((QuestHelper)this, new WorldPoint(2662, 3657, 0), "Mix a Super defence potion within the Fremennik Province (only near Rellekka).", this.cadantineUnfPot.highlighted(), this.whiteBerries.highlighted());
        this.moveToCaveGem = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Enter the tunnel that leads to Keldagrim. Alternatively teleport to Varrock and take a minecart near the Grand Exchange.", new Requirement[0]);
        this.moveToRiverGem = new ObjectStep((QuestHelper)this, 5973, new WorldPoint(2781, 10161, 0), "Go through the cave entrance.", new Requirement[0]);
        this.moveToKeldagrimGem = new NpcStep((QuestHelper)this, 7726, new WorldPoint(2842, 10129, 0), "Speak with the Dwarven Boatman to go to Keldagrim.", new Requirement[0]);
        this.moveToKeldagrimGem.addDialogStep("Yes, please take me.");
        this.moveToKeldagrimVarrockGem = new ObjectStep((QuestHelper)this, 16168, new WorldPoint(3140, 3504, 0), "Enter the trapdoor near the Grand Exchange.", new Requirement[0]);
        this.moveToCaveBlast = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Enter the tunnel that leads to Keldagrim. Alternatively teleport to Varrock and take a minecart near the Grand Exchange.", new Requirement[0]);
        this.moveToRiverBlast = new ObjectStep((QuestHelper)this, 5973, new WorldPoint(2781, 10161, 0), "Go through the cave entrance.", new Requirement[0]);
        this.moveToKeldagrimBlast = new NpcStep((QuestHelper)this, 7726, new WorldPoint(2842, 10129, 0), "Speak with the Dwarven Boatman to go to Keldagrim.", new Requirement[0]);
        this.moveToKeldagrimBlast.addDialogStep("Yes, please take me.");
        this.moveToKeldagrimVarrockBlast = new ObjectStep((QuestHelper)this, 16168, new WorldPoint(3140, 3504, 0), "Enter the trapdoor near the Grand Exchange.", new Requirement[0]);
        this.stealGem = new ObjectStep((QuestHelper)this, 6162, new WorldPoint(2888, 10211, 0), "Steal from the gem stall.", new Requirement[0]);
        this.moveToNeitiznot = new NpcStep((QuestHelper)this, 1883, new WorldPoint(2644, 3710, 0), "Speak with Maria Gunnars to travel to Neitiznot.", new Requirement[0]);
        this.craftShield = new ObjectStep((QuestHelper)this, 21305, new WorldPoint(2342, 3807, 0), "Craft a shield on the woodcutting stump.", this.axe, this.arcticLog.quantity(2), this.hammer, this.rope, this.bronzeNail);
        this.craftShield.addIcon(10826);
        this.moveToJatizso = new NpcStep((QuestHelper)this, 1900, new WorldPoint(2644, 3709, 0), "Speak with Mord Gunnars to go to Jatizso.", new Requirement[0]);
        this.moveToJatizso.addDialogStep("Can you ferry me to Jatizso?");
        this.moveToMine = new ObjectStep((QuestHelper)this, 21455, new WorldPoint(2398, 3813, 0), "Go down the staircase.", new Requirement[0]);
        this.mineAddy = new ObjectStep((QuestHelper)this, 11374, new WorldPoint(2402, 10189, 0), "Mine 5 Adamantite ores.", this.pickaxe);
        this.mineAddy.addIcon(1275);
        this.moveToMisc = new NpcStep((QuestHelper)this, 3936, new WorldPoint(2630, 3692, 0), "Speak to the sailor to go to Miscellania.", new Requirement[0]);
        this.miscSupport = new ObjectStep((QuestHelper)this, 15084, new WorldPoint(2527, 3849, 0), "Rake the herb and flax patch until 100% support.", true, this.rake);
        this.miscSupport.addAlternateObjects(15079);
        this.tpWaterbirth = new DetailedQuestStep((QuestHelper)this, "Teleport to Waterbirth.", this.waterRune.quantity(1), this.astralRune.quantity(2), this.lawRune2.quantity(1), this.lunarBook);
        this.moveToBlast = new ObjectStep((QuestHelper)this, 9084, new WorldPoint(2930, 10197, 0), "Enter the blast furnace.", new Requirement[0]);
        this.freeBlast = new NpcStep((QuestHelper)this, 2923, new WorldPoint(1942, 4958, 0), "Speak with the Foreman.", new Requirement[0]);
        this.freeBlast.addDialogSteps("What?", "Can I use the furnace to smelt ore?", "I have level 60!");
        this.claimReward = new NpcStep((QuestHelper)this, 5526, new WorldPoint(2658, 3627, 0), "Talk to Thorodin south of Rellekka to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.rake, this.pickaxe, this.axe, this.arcticLog.quantity(2), this.hammer, this.rope, this.bronzeNail, this.cadantineUnfPot, this.whiteBerries, this.teasingStick, this.log, this.knife, this.fireRune.quantity(2), this.lawRune.quantity(3), this.astralRune.quantity(2), this.waterRune.quantity(1));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.HERBLORE, 66, true));
        req.add(new SkillRequirement(Skill.HUNTER, 55, true));
        req.add(new SkillRequirement(Skill.MAGIC, 72));
        req.add(new SkillRequirement(Skill.MINING, 70, true));
        req.add(new SkillRequirement(Skill.SMITHING, 60, false));
        req.add(new SkillRequirement(Skill.THIEVING, 75, true));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 56, true));
        req.add(new ItemRequirement("Normal and Lunar spellbooks", -1, -1));
        req.add(this.eadgarsRuse);
        req.add(this.lunarDiplomacy);
        req.add(this.giantDwarf);
        req.add(this.fremIsles);
        req.add(this.throneOfMisc);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Fremennik Sea Boots (3)", 13131, 1), new ItemReward("15,000 Exp. Lamp (Any skill over 50)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to change enchanted lyre teleport destination to Waterbirth Island."), new UnlockReward("Aviansies in the God Wars Dungeon will drop noted adamantite bars."), new UnlockReward("Shortcut to roof on the Troll Stronghold"), new UnlockReward("Stony Basalt teleport destination can be changed to the roof of Troll Stronghold"), new UnlockReward("Access to 2 new Lunar Spells, Charge Dragonstone and Tan Leather"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails miscSupportSteps = new PanelDetails("Miscellania 100% Support", Arrays.asList(this.moveToMisc, this.miscSupport), this.throneOfMisc, this.rake);
        miscSupportSteps.setDisplayCondition(this.notMiscSupport);
        miscSupportSteps.setLockingStep(this.miscSupportTask);
        allSteps.add(miscSupportSteps);
        PanelDetails mineAdamantiteOnJatizsoSteps = new PanelDetails("Mine Adamantite on Jatizso", Arrays.asList(this.moveToJatizso, this.moveToMine, this.mineAddy), this.fremIsles, new SkillRequirement(Skill.MINING, 70, true), this.pickaxe);
        mineAdamantiteOnJatizsoSteps.setDisplayCondition(this.notMineAddy);
        mineAdamantiteOnJatizsoSteps.setLockingStep(this.mineAddyTask);
        allSteps.add(mineAdamantiteOnJatizsoSteps);
        PanelDetails shieldOnNeitiznotSteps = new PanelDetails("Craft Shield on Neitiznot", Arrays.asList(this.moveToNeitiznot, this.craftShield), this.fremIsles, new SkillRequirement(Skill.WOODCUTTING, 56, true), this.axe, this.arcticLog.quantity(2), this.hammer, this.rope, this.bronzeNail);
        shieldOnNeitiznotSteps.setDisplayCondition(this.notCraftShield);
        shieldOnNeitiznotSteps.setLockingStep(this.craftShieldTask);
        allSteps.add(shieldOnNeitiznotSteps);
        PanelDetails superDefenseSteps = new PanelDetails("Mix a Super Defense", Arrays.asList(this.moveToRellekka, this.mixSuperDef), new SkillRequirement(Skill.HERBLORE, 66, true), this.cadantineUnfPot, this.whiteBerries);
        superDefenseSteps.setDisplayCondition(this.notMixSuperDef);
        superDefenseSteps.setLockingStep(this.mixSuperDefTask);
        allSteps.add(superDefenseSteps);
        PanelDetails kyattSteps = new PanelDetails("Catch a saber-toothed kyatt", Collections.singletonList(this.catchKyatt), new SkillRequirement(Skill.HUNTER, 55, true), this.teasingStick, this.log, this.knife);
        kyattSteps.setDisplayCondition(this.notCatchKyatt);
        kyattSteps.setLockingStep(this.catchKyattTask);
        allSteps.add(kyattSteps);
        PanelDetails gemStallSteps = new PanelDetails("Steal from Gem Stall", Arrays.asList(this.moveToCaveGem, this.moveToRiverGem, this.moveToKeldagrimGem, this.moveToKeldagrimVarrockGem, this.stealGem), this.giantDwarf, new SkillRequirement(Skill.THIEVING, 75, true));
        gemStallSteps.setDisplayCondition(this.notStealGem);
        gemStallSteps.setLockingStep(this.stealGemTask);
        allSteps.add(gemStallSteps);
        PanelDetails freeBlastFurnaceSteps = new PanelDetails("Free Blast Furnace", Arrays.asList(this.moveToCaveBlast, this.moveToRiverBlast, this.moveToKeldagrimBlast, this.moveToKeldagrimVarrockBlast, this.moveToBlast, this.freeBlast), this.giantDwarf, new SkillRequirement(Skill.SMITHING, 60, false));
        freeBlastFurnaceSteps.setDisplayCondition(this.notFreeBlast);
        freeBlastFurnaceSteps.setLockingStep(this.freeBlastTask);
        allSteps.add(freeBlastFurnaceSteps);
        PanelDetails teleportToTrollheimSteps = new PanelDetails("Teleport to Trollheim", Collections.singletonList(this.tpTroll), this.eadgarsRuse, new SkillRequirement(Skill.MAGIC, 61), this.normalBook, this.fireRune.quantity(2), this.lawRune.quantity(2));
        teleportToTrollheimSteps.setDisplayCondition(this.notTPTroll);
        teleportToTrollheimSteps.setLockingStep(this.tpTrollTask);
        allSteps.add(teleportToTrollheimSteps);
        PanelDetails teleportToWaterbirthSteps = new PanelDetails("Teleport to Waterbirth", Collections.singletonList(this.tpWaterbirth), this.lunarDiplomacy, new SkillRequirement(Skill.MAGIC, 72), this.lunarBook, this.waterRune.quantity(1), this.astralRune.quantity(2), this.lawRune2.quantity(1));
        teleportToWaterbirthSteps.setDisplayCondition(this.notTPWaterbirth);
        teleportToWaterbirthSteps.setLockingStep(this.tpWaterbirthTask);
        allSteps.add(teleportToWaterbirthSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

