/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.fremennik;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FREMENNIK_EASY)
public class FremennikEasy
extends ComplexStateQuestHelper {
    ItemRequirement birdSnare;
    ItemRequirement coins;
    ItemRequirement tiaraMould;
    ItemRequirement pickaxe;
    ItemRequirement bucket;
    ItemRequirement climbingBoots;
    ItemRequirement axe;
    ItemRequirement tinderbox;
    ItemRequirement combatGear;
    ItemRequirement oakLogs;
    ItemRequirement food;
    ItemRequirement silverOre;
    ItemRequirement silverBar;
    ItemRequirement snapeGrass;
    Requirement notCatchCerulean;
    Requirement notChangeBoots;
    Requirement notKilledCrabs;
    Requirement notCraftTiara;
    Requirement notBrowseStonemason;
    Requirement notCollectSnapeGrass;
    Requirement notStealStall;
    Requirement notFillBucket;
    Requirement notEnterTrollStronghold;
    Requirement notChopAndBurnOak;
    Requirement fremennikTrials;
    Requirement giantDwarf;
    Requirement trollStronghold;
    Requirement deathPlateau;
    Requirement choppedLogs;
    Requirement minedSilver;
    NpcStep killedCrabs;
    ObjectStep fillBucket;
    ObjectStep chopOak;
    ObjectStep mineSilver;
    ObjectStep smeltSilver;
    ObjectStep craftTiara;
    QuestStep catchCerulean;
    QuestStep changeBoots;
    QuestStep browseStonemason;
    QuestStep collectSnapeGrass;
    QuestStep stealStall;
    QuestStep enterTrollStronghold;
    QuestStep goneToWaterbirth;
    QuestStep claimReward;
    QuestStep burnOak;
    QuestStep goneToKeldagrimStone;
    QuestStep goneToCaveStone;
    QuestStep goneToRiverStone;
    QuestStep goneToVarrockStone;
    QuestStep goneToKeldagrimStall;
    QuestStep goneToCaveStall;
    QuestStep goneToRiverStall;
    QuestStep goneToVarrockStall;
    Zone waterbirth;
    Zone keldagrim;
    Zone hunterArea;
    Zone caveArea;
    Zone riverArea;
    Zone varrockArea;
    Zone mine;
    ZoneRequirement inWaterbirth;
    ZoneRequirement inKeldagrim;
    ZoneRequirement inHunterArea;
    ZoneRequirement inCaveArea;
    ZoneRequirement inRiverArea;
    ZoneRequirement inVarrockArea;
    ZoneRequirement inMine;
    ConditionalStep catchCeruleanTask;
    ConditionalStep changeBootsTask;
    ConditionalStep killedCrabsTask;
    ConditionalStep craftTiaraTask;
    ConditionalStep browseStonemasonTask;
    ConditionalStep collectSnapeGrassTask;
    ConditionalStep stealStallTask;
    ConditionalStep fillBucketTask;
    ConditionalStep enterTrollStrongholdTask;
    ConditionalStep chopAndBurnOakTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.catchCeruleanTask = new ConditionalStep((QuestHelper)this, this.catchCerulean, new Requirement[0]);
        this.catchCeruleanTask.addStep(this.inHunterArea, this.catchCerulean);
        doEasy.addStep(this.notCatchCerulean, this.catchCeruleanTask);
        this.killedCrabsTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.killedCrabs, new Requirement[0]);
        doEasy.addStep(this.notKilledCrabs, this.killedCrabsTask);
        this.chopAndBurnOakTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.chopOak, new Requirement[0]);
        this.chopAndBurnOakTask.addStep(new Conditions(this.oakLogs, this.choppedLogs), this.burnOak);
        doEasy.addStep(this.notChopAndBurnOak, this.chopAndBurnOakTask);
        this.fillBucketTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.fillBucket, new Requirement[0]);
        doEasy.addStep(this.notFillBucket, this.fillBucketTask);
        this.changeBootsTask = new ConditionalStep((QuestHelper)this, this.changeBoots, new Requirement[0]);
        doEasy.addStep(this.notChangeBoots, this.changeBootsTask);
        this.craftTiaraTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.mineSilver, new Requirement[0]);
        this.craftTiaraTask.addStep(new Conditions(this.silverOre, this.minedSilver), this.smeltSilver);
        this.craftTiaraTask.addStep(this.silverBar, this.craftTiara);
        doEasy.addStep(this.notCraftTiara, this.craftTiaraTask);
        this.collectSnapeGrassTask = new ConditionalStep((QuestHelper)this, this.goneToWaterbirth, new Requirement[0]);
        this.collectSnapeGrassTask.addStep(this.inWaterbirth, this.collectSnapeGrass);
        doEasy.addStep(this.notCollectSnapeGrass, this.collectSnapeGrassTask);
        this.enterTrollStrongholdTask = new ConditionalStep((QuestHelper)this, this.enterTrollStronghold, new Requirement[0]);
        doEasy.addStep(this.notEnterTrollStronghold, this.enterTrollStrongholdTask);
        this.browseStonemasonTask = new ConditionalStep((QuestHelper)this, this.goneToKeldagrimStone, new Requirement[0]);
        this.browseStonemasonTask.addStep(this.inVarrockArea, this.goneToVarrockStone);
        this.browseStonemasonTask.addStep(this.inRiverArea, this.goneToRiverStone);
        this.browseStonemasonTask.addStep(this.inCaveArea, this.goneToCaveStone);
        this.browseStonemasonTask.addStep(this.inKeldagrim, this.browseStonemason);
        doEasy.addStep(this.notBrowseStonemason, this.browseStonemasonTask);
        this.stealStallTask = new ConditionalStep((QuestHelper)this, this.goneToKeldagrimStall, new Requirement[0]);
        this.stealStallTask.addStep(this.inVarrockArea, this.goneToVarrockStall);
        this.stealStallTask.addStep(this.inCaveArea, this.goneToCaveStall);
        this.stealStallTask.addStep(this.inRiverArea, this.goneToRiverStall);
        this.stealStallTask.addStep(this.inKeldagrim, this.stealStall);
        doEasy.addStep(this.notStealStall, this.stealStallTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notCatchCerulean = new VarplayerRequirement(1184, false, 1);
        this.notChangeBoots = new VarplayerRequirement(1184, false, 2);
        this.notKilledCrabs = new VarplayerRequirement(1184, false, 3);
        this.notCraftTiara = new VarplayerRequirement(1184, false, 4);
        this.notBrowseStonemason = new VarplayerRequirement(1184, false, 5);
        this.notCollectSnapeGrass = new VarplayerRequirement(1184, false, 6);
        this.notStealStall = new VarplayerRequirement(1184, false, 7);
        this.notFillBucket = new VarplayerRequirement(1184, false, 8);
        this.notEnterTrollStronghold = new VarplayerRequirement(1184, false, 9);
        this.notChopAndBurnOak = new VarplayerRequirement(1184, false, 10);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notCraftTiara).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notChangeBoots);
        this.birdSnare = new ItemRequirement("Bird snare", 10006).showConditioned(this.notCatchCerulean).isNotConsumed();
        this.tinderbox = new ItemRequirement("Tinderbox", 590).showConditioned(this.notChopAndBurnOak).isNotConsumed();
        this.tiaraMould = new ItemRequirement("Tiara mould", 5523).showConditioned(this.notCraftTiara).isNotConsumed();
        this.bucket = new ItemRequirement("Bucket", 1925).showConditioned(this.notFillBucket).isNotConsumed();
        this.climbingBoots = new ItemRequirement("Climbing boots", 1925).showConditioned(this.notEnterTrollStronghold).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notChopAndBurnOak).isNotConsumed();
        this.silverBar = new ItemRequirement("Silver bar", 2355);
        this.silverOre = new ItemRequirement("Silver ore", 442);
        this.snapeGrass = new ItemRequirement("Snape grass", 231);
        this.oakLogs = new ItemRequirement("Oak logs", 1521);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).showConditioned(this.notKilledCrabs).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.fremennikTrials = new QuestRequirement(QuestHelperQuest.THE_FREMENNIK_TRIALS, QuestState.FINISHED);
        this.giantDwarf = new QuestRequirement(QuestHelperQuest.THE_GIANT_DWARF, QuestState.FINISHED);
        this.trollStronghold = new QuestRequirement(QuestHelperQuest.TROLL_STRONGHOLD, QuestState.FINISHED);
        this.deathPlateau = new QuestRequirement(QuestHelperQuest.DEATH_PLATEAU, QuestState.FINISHED);
        this.choppedLogs = new ChatMessageRequirement("<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        this.minedSilver = new ChatMessageRequirement("<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.minedSilver).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inMine), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.inMine = new ZoneRequirement(this.mine);
        this.inKeldagrim = new ZoneRequirement(this.keldagrim);
        this.inWaterbirth = new ZoneRequirement(this.waterbirth);
        this.inHunterArea = new ZoneRequirement(this.hunterArea);
        this.inCaveArea = new ZoneRequirement(this.caveArea);
        this.inRiverArea = new ZoneRequirement(this.riverArea);
        this.inVarrockArea = new ZoneRequirement(this.varrockArea);
    }

    public void loadZones() {
        this.keldagrim = new Zone(new WorldPoint(2816, 10238, 0), new WorldPoint(2943, 10158, 0));
        this.mine = new Zone(new WorldPoint(2675, 3712, 0), new WorldPoint(2690, 3697, 0));
        this.waterbirth = new Zone(new WorldPoint(2499, 3770, 0), new WorldPoint(2557, 3713, 0));
        this.hunterArea = new Zone(new WorldPoint(2690, 3838, 0), new WorldPoint(2748, 3767, 0));
        this.caveArea = new Zone(new WorldPoint(2767, 10165, 0), new WorldPoint(2802, 10127, 0));
        this.riverArea = new Zone(new WorldPoint(2816, 10148, 0), new WorldPoint(2893, 10114, 0));
        this.varrockArea = new Zone(new WorldPoint(3076, 3617, 0), new WorldPoint(3290, 3374, 0));
    }

    public void setupSteps() {
        this.catchCerulean = new ObjectStep((QuestHelper)this, 9375, new WorldPoint(2724, 3773, 0), "Catch a Cerulean Twitch in the Rellekka Hunter area.", this.birdSnare.highlighted());
        this.killedCrabs = new NpcStep((QuestHelper)this, 100, new WorldPoint(2707, 3723, 0), "Kill 5 Rock crabs.", true, this.combatGear);
        this.killedCrabs.addAlternateNpcs(102);
        this.chopOak = new ObjectStep((QuestHelper)this, 10820, new WorldPoint(2714, 3664, 0), "Chop some oak logs in Rellekka.", this.axe, this.tinderbox);
        this.chopOak.addIcon(6739);
        this.burnOak = new ItemStep((QuestHelper)this, "Burn the oak logs you've chopped.", this.tinderbox.highlighted(), this.oakLogs.highlighted());
        this.fillBucket = new ObjectStep((QuestHelper)this, 8927, new WorldPoint(2669, 3661, 0), "Fill a bucket at the Rellekka well.", this.bucket);
        this.fillBucket.addIcon(1925);
        this.mineSilver = new ObjectStep((QuestHelper)this, 11368, new WorldPoint(2685, 3702, 0), "Mine a silver ore in Rellekka.", this.pickaxe, this.fremennikTrials);
        this.mineSilver.addIcon(1275);
        this.smeltSilver = new ObjectStep((QuestHelper)this, 4304, new WorldPoint(2617, 3667, 0), "Smelt a silver bar in Rellekka.", this.silverOre.highlighted(), this.fremennikTrials);
        this.smeltSilver.addIcon(442);
        this.craftTiara = new ObjectStep((QuestHelper)this, 4304, new WorldPoint(2617, 3667, 0), "Craft a tiara in Rellekka.", this.silverBar.highlighted(), this.fremennikTrials);
        this.craftTiara.addIcon(2355);
        this.changeBoots = new NpcStep((QuestHelper)this, 3933, new WorldPoint(2625, 3674, 0), "Change your boots at Yrsa's Shoe Store.", this.coins.quantity(500));
        this.goneToWaterbirth = new NpcStep((QuestHelper)this, new int[]{5937, 7205}, new WorldPoint(2620, 3686, 0), "Speak with Jarvald to travel to Waterbirth Island.", new Requirement[0]);
        this.goneToWaterbirth.addDialogStep("What Jarvald is doing.");
        this.goneToWaterbirth.addDialogStep("Can I come?");
        this.goneToWaterbirth.addDialogStep("YES");
        this.collectSnapeGrass = new NpcStep((QuestHelper)this, 231, new WorldPoint(2551, 3754, 0), "Collect 5 snape grass on Waterbirth Island. Speak with Jarvald to return to Rellekka when complete.", this.snapeGrass.highlighted().quantity(5));
        this.enterTrollStronghold = new ObjectStep((QuestHelper)this, 3762, new WorldPoint(2828, 3647, 0), "Enter the Troll Stronghold.", new Requirement[0]);
        this.goneToKeldagrimStone = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Enter the tunnel that leads to Keldagrim. Alternatively Teleport to Varrock and take a minecart near the Grand Exchange.", new Requirement[0]);
        this.goneToCaveStone = new ObjectStep((QuestHelper)this, 5973, new WorldPoint(2781, 10161, 0), "Go through the cave entrance.", new Requirement[0]);
        this.goneToRiverStone = new NpcStep((QuestHelper)this, 7726, new WorldPoint(2842, 10129, 0), "Speak with the Dwarven Boatman to go to Keldagrim.", new Requirement[0]);
        this.goneToRiverStone.addDialogStep("Yes, please take me.");
        this.goneToVarrockStone = new ObjectStep((QuestHelper)this, 16168, new WorldPoint(3140, 3504, 0), "Enter the trapdoor near the Grand Exchange.", new Requirement[0]);
        this.goneToKeldagrimStall = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Enter the tunnel that leads to Keldagrim. Alternatively Teleport to Varrock and take a minecart near the Grand Exchange.", new Requirement[0]);
        this.goneToCaveStall = new ObjectStep((QuestHelper)this, 5973, new WorldPoint(2781, 10161, 0), "Go through the cave entrance.", new Requirement[0]);
        this.goneToRiverStall = new NpcStep((QuestHelper)this, 7726, new WorldPoint(2842, 10129, 0), "Speak with the Dwarven Boatman to go to Keldagrim.", new Requirement[0]);
        this.goneToRiverStall.addDialogStep("Yes, please take me.");
        this.goneToVarrockStall = new ObjectStep((QuestHelper)this, 16168, new WorldPoint(3140, 3504, 0), "Enter the trapdoor near the Grand Exchange.", new Requirement[0]);
        this.stealStall = new ObjectStep((QuestHelper)this, 6163, new WorldPoint(2892, 10211, 0), "Steal from the bakery stall.", new Requirement[0]);
        this.browseStonemason = new NpcStep((QuestHelper)this, 3098, new WorldPoint(2848, 10185, 0), "Browse the Stonemason's Shop.", new Requirement[0]);
        this.claimReward = new NpcStep((QuestHelper)this, 5526, new WorldPoint(2658, 3627, 0), "Talk to Thorodin south of Rellekka to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.pickaxe, this.coins.quantity(500), this.birdSnare, this.tiaraMould, this.axe, this.bucket, this.climbingBoots, this.tinderbox, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.food);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("5 Rock Crabs (Level 13)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.CRAFTING, 23));
        req.add(new SkillRequirement(Skill.FIREMAKING, 15));
        req.add(new SkillRequirement(Skill.HUNTER, 11));
        req.add(new SkillRequirement(Skill.MINING, 20));
        req.add(new SkillRequirement(Skill.SMITHING, 20));
        req.add(new SkillRequirement(Skill.THIEVING, 5));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 15));
        req.add(this.fremennikTrials);
        req.add(this.giantDwarf);
        req.add(this.trollStronghold);
        req.add(this.deathPlateau);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Fremennik Sea Boots (1)", 13129, 1), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Peer the Seer will act as a bank deposit box."), new UnlockReward("Fossegrimen will give your enchanted lyre an extra charge when making a sacrifice."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails ceruleanTwitchSteps = new PanelDetails("Catch a Cerulean Twitch", Collections.singletonList(this.catchCerulean), this.birdSnare);
        ceruleanTwitchSteps.setDisplayCondition(this.notCatchCerulean);
        ceruleanTwitchSteps.setLockingStep(this.catchCeruleanTask);
        allSteps.add(ceruleanTwitchSteps);
        PanelDetails rockCrabSteps = new PanelDetails("Kill 5 Rock Crabs", Collections.singletonList(this.killedCrabs), this.combatGear, this.food);
        rockCrabSteps.setDisplayCondition(this.notKilledCrabs);
        rockCrabSteps.setLockingStep(this.killedCrabsTask);
        allSteps.add(rockCrabSteps);
        PanelDetails oakSteps = new PanelDetails("Chop and burn", Arrays.asList(this.chopOak, this.burnOak), new SkillRequirement(Skill.FIREMAKING, 15), new SkillRequirement(Skill.WOODCUTTING, 15), this.axe, this.tinderbox);
        oakSteps.setDisplayCondition(this.notChopAndBurnOak);
        oakSteps.setLockingStep(this.chopAndBurnOakTask);
        allSteps.add(oakSteps);
        PanelDetails bucketSteps = new PanelDetails("Fill bucket", Collections.singletonList(this.fillBucket), this.bucket);
        bucketSteps.setDisplayCondition(this.notFillBucket);
        bucketSteps.setLockingStep(this.fillBucketTask);
        allSteps.add(bucketSteps);
        PanelDetails changeBootsSteps = new PanelDetails("Change boots", Collections.singletonList(this.changeBoots), this.fremennikTrials, this.coins.quantity(500));
        changeBootsSteps.setDisplayCondition(this.notChangeBoots);
        changeBootsSteps.setLockingStep(this.changeBootsTask);
        allSteps.add(changeBootsSteps);
        PanelDetails tiaraSteps = new PanelDetails("Craft Tiara", Arrays.asList(this.mineSilver, this.smeltSilver, this.craftTiara), new SkillRequirement(Skill.CRAFTING, 23), new SkillRequirement(Skill.MINING, 20), new SkillRequirement(Skill.SMITHING, 20), this.fremennikTrials, this.pickaxe, this.tiaraMould);
        tiaraSteps.setDisplayCondition(this.notCraftTiara);
        tiaraSteps.setLockingStep(this.craftTiaraTask);
        allSteps.add(tiaraSteps);
        PanelDetails snapeGrassSteps = new PanelDetails("Collect snape grass", Arrays.asList(this.goneToWaterbirth, this.collectSnapeGrass), this.fremennikTrials);
        snapeGrassSteps.setDisplayCondition(this.notCollectSnapeGrass);
        snapeGrassSteps.setLockingStep(this.collectSnapeGrassTask);
        allSteps.add(snapeGrassSteps);
        PanelDetails trollStrongholdSteps = new PanelDetails("Enter troll stronghold", Collections.singletonList(this.enterTrollStronghold), this.trollStronghold, this.deathPlateau, this.climbingBoots);
        trollStrongholdSteps.setDisplayCondition(this.notEnterTrollStronghold);
        trollStrongholdSteps.setLockingStep(this.enterTrollStrongholdTask);
        allSteps.add(trollStrongholdSteps);
        PanelDetails browseStonemasonSteps = new PanelDetails("Browse Stonemason's store", Arrays.asList(this.goneToKeldagrimStone, this.goneToCaveStone, this.goneToRiverStone, this.browseStonemason), this.giantDwarf);
        browseStonemasonSteps.setDisplayCondition(this.notBrowseStonemason);
        browseStonemasonSteps.setLockingStep(this.browseStonemasonTask);
        allSteps.add(browseStonemasonSteps);
        PanelDetails bakersStallSteps = new PanelDetails("Steal from baker's stall", Arrays.asList(this.goneToKeldagrimStall, this.goneToCaveStall, this.goneToRiverStall, this.stealStall), this.giantDwarf);
        bakersStallSteps.setDisplayCondition(this.notStealStall);
        bakersStallSteps.setLockingStep(this.stealStallTask);
        allSteps.add(bakersStallSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

