/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.fremennik;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.achievementdiaries.fremennik.DagRoute;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Prayer;
import net.runelite.api.QuestState;

@QuestDescriptor(quest=QuestHelperQuest.DAG_ROUTE)
public class DagRouteHelper
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement prayerPot;
    ItemRequirement petRock;
    ItemRequirement thrownaxe;
    ItemRequirement stamPot;
    Requirement protectMelee;
    DagRoute dagRoute;

    @Override
    public QuestStep loadStep() {
        this.setupRequirements();
        this.setupSteps();
        return new ConditionalStep((QuestHelper)this, (QuestStep)this.dagRoute, new Requirement[0]);
    }

    @Override
    public void setupRequirements() {
        this.thrownaxe = new ItemRequirement("Rune thrownaxe", 805);
        this.petRock = new ItemRequirement("Pet rock", 3695);
        this.petRock.setTooltip("Can be substituted by having a friend");
        this.combatGear = new ItemRequirement("Combat gear", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.prayerPot = new ItemRequirement("Prayer Potions", ItemCollections.PRAYER_POTIONS, -1);
        this.stamPot = new ItemRequirement("Stamina Potions", ItemCollections.STAMINA_POTIONS, -1);
        this.protectMelee = new PrayerRequirement("Protect from Melee", Prayer.PROTECT_FROM_MELEE);
    }

    public void setupSteps() {
        this.dagRoute = new DagRoute(this);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.petRock, this.thrownaxe, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.prayerPot, this.stamPot);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Tank many hits in the Waterbirth Island Dungeon");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.HORROR_FROM_THE_DEEP, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.THE_FREMENNIK_TRIALS, QuestState.IN_PROGRESS));
        return reqs;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails fullRoute = new PanelDetails("Travel to the Kings", this.dagRoute.getDisplaySteps(), this.combatGear, this.thrownaxe, this.petRock);
        allSteps.add(fullRoute);
        return allSteps;
    }
}

