/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.falador;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.WarriorsGuildAccessRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FALADOR_HARD)
public class FaladorHard
extends ComplexStateQuestHelper {
    ItemRequirement pureEss28;
    ItemRequirement mindTiara;
    ItemRequirement coins10000;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement lightSource;
    ItemRequirement spade;
    ItemRequirement wyvernProtection;
    ItemRequirement prospectorHelm;
    ItemRequirement prospectorChest;
    ItemRequirement prospectorLegs;
    ItemRequirement prospectorBoots;
    ItemRequirement prosyHelm;
    ItemRequirement prosyChest;
    ItemRequirement prosyLegs;
    ItemRequirement dwarvenHelmet;
    ItemRequirement dragonfireProtection;
    ItemRequirement faladorTeleport;
    ItemRequirement combatBracelet;
    ItemRequirements prosySet;
    ItemRequirements prospectorSet;
    Requirement herosQuest;
    Requirement slugMenace;
    Requirement grimTales;
    Requirement notCraftedMindRunes;
    Requirement notChangedFamilyCrest;
    Requirement notKilledMole;
    Requirement notKilledWyvern;
    Requirement notCompleteAgiCourse;
    Requirement notEnterMiningGuildWithProspector;
    Requirement notKilledBlueDragon;
    Requirement notCrackedWallSafe;
    Requirement notPraySarimAltarProsy;
    Requirement notEnterWarriorsGuild;
    Requirement notDwarvenHelmetDwarvenMines;
    QuestStep claimReward;
    QuestStep enterMindAltar;
    QuestStep craftMindRunes;
    QuestStep climbLadderWhiteKnightCastle;
    QuestStep changeFamilyCrest;
    QuestStep goToGiantMole;
    QuestStep killGiantMole;
    QuestStep goToIceDungeon;
    QuestStep enterWyvernCavern;
    QuestStep killWyvern;
    QuestStep completeAgiCourse;
    QuestStep enterDwarvenMines;
    QuestStep enterDwarvenMinesHelmet;
    QuestStep enterMiningGuild;
    QuestStep enterHerosGuild;
    QuestStep enterHerosGuildBasement;
    QuestStep killBlueDragon;
    QuestStep enterRoguesDen;
    QuestStep crackWallSafe;
    QuestStep getProsySet;
    QuestStep prayAtAltarSarim;
    QuestStep enterWarriorsGuild;
    QuestStep equipDwarvenHelmet;
    Zone mindAltar;
    Zone iceDungeon;
    Zone wyvernCavern;
    Zone faladorCastle1;
    Zone herosGuild;
    Zone herosGuildBasement;
    Zone portSarimChurch;
    Zone dwarvenMine;
    Zone miningGuild;
    Zone herosGuildEntranceway;
    Zone herosGuildMainHall;
    Zone roguesDen;
    Zone moleDen;
    ZoneRequirement inMindAltar;
    ZoneRequirement inWyvernCavern;
    ZoneRequirement inIceDungeon;
    ZoneRequirement inFaladorCastle1;
    ZoneRequirement inHerosGuild;
    ZoneRequirement inHerosGuildBasement;
    ZoneRequirement inPortSarimChurch;
    ZoneRequirement inDwarvenMine;
    ZoneRequirement inMiningGuild;
    ZoneRequirement inRoguesDen;
    ZoneRequirement inMoleDen;
    ConditionalStep craftedMindRunesTask;
    ConditionalStep changedFamilyCrestTask;
    ConditionalStep killedMoleTask;
    ConditionalStep killedWyvernTask;
    ConditionalStep completeAgiCourseTask;
    ConditionalStep enterMiningGuildWithProspectorTask;
    ConditionalStep killedBlueDragonTask;
    ConditionalStep crackedWallSafeTask;
    ConditionalStep praySarimAltarProsyTask;
    ConditionalStep enterWarriorsGuildTask;
    ConditionalStep dwarvenHelmetDwarvenMinesTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.changedFamilyCrestTask = new ConditionalStep((QuestHelper)this, this.climbLadderWhiteKnightCastle, new Requirement[0]);
        this.changedFamilyCrestTask.addStep(this.inFaladorCastle1, this.changeFamilyCrest);
        doHard.addStep(this.notChangedFamilyCrest, this.changedFamilyCrestTask);
        this.killedMoleTask = new ConditionalStep((QuestHelper)this, this.goToGiantMole, new Requirement[0]);
        this.killedMoleTask.addStep(this.inMoleDen, this.killGiantMole);
        doHard.addStep(this.notKilledMole, this.killedMoleTask);
        this.completeAgiCourseTask = new ConditionalStep((QuestHelper)this, this.completeAgiCourse, new Requirement[0]);
        doHard.addStep(this.notCompleteAgiCourse, this.completeAgiCourseTask);
        this.dwarvenHelmetDwarvenMinesTask = new ConditionalStep((QuestHelper)this, this.enterDwarvenMinesHelmet, new Requirement[0]);
        this.dwarvenHelmetDwarvenMinesTask.addStep(this.inDwarvenMine, this.equipDwarvenHelmet);
        doHard.addStep(this.notDwarvenHelmetDwarvenMines, this.dwarvenHelmetDwarvenMinesTask);
        this.enterMiningGuildWithProspectorTask = new ConditionalStep((QuestHelper)this, this.enterDwarvenMines, new Requirement[0]);
        this.enterMiningGuildWithProspectorTask.addStep(this.inDwarvenMine, this.enterMiningGuild);
        doHard.addStep(this.notEnterMiningGuildWithProspector, this.enterMiningGuildWithProspectorTask);
        this.enterWarriorsGuildTask = new ConditionalStep((QuestHelper)this, this.enterWarriorsGuild, new Requirement[0]);
        doHard.addStep(this.notEnterWarriorsGuild, this.enterWarriorsGuildTask);
        this.killedBlueDragonTask = new ConditionalStep((QuestHelper)this, this.enterHerosGuild, new Requirement[0]);
        this.killedBlueDragonTask.addStep(this.inHerosGuild, this.enterHerosGuildBasement);
        this.killedBlueDragonTask.addStep(this.inHerosGuildBasement, this.killBlueDragon);
        doHard.addStep(this.notKilledBlueDragon, this.killedBlueDragonTask);
        this.crackedWallSafeTask = new ConditionalStep((QuestHelper)this, this.enterRoguesDen, new Requirement[0]);
        this.crackedWallSafeTask.addStep(this.inRoguesDen, this.crackWallSafe);
        doHard.addStep(this.notCrackedWallSafe, this.crackedWallSafeTask);
        this.craftedMindRunesTask = new ConditionalStep((QuestHelper)this, this.enterMindAltar, new Requirement[0]);
        this.craftedMindRunesTask.addStep(this.inMindAltar, this.craftMindRunes);
        doHard.addStep(this.notCraftedMindRunes, this.craftedMindRunesTask);
        this.praySarimAltarProsyTask = new ConditionalStep((QuestHelper)this, this.getProsySet, new Requirement[0]);
        this.praySarimAltarProsyTask.addStep(new Conditions(this.notPraySarimAltarProsy, this.prosyHelm.alsoCheckBank(this.questBank), this.prosyLegs.alsoCheckBank(this.questBank), this.prosyChest.alsoCheckBank(this.questBank)), this.prayAtAltarSarim);
        doHard.addStep(this.notPraySarimAltarProsy, this.praySarimAltarProsyTask);
        this.killedWyvernTask = new ConditionalStep((QuestHelper)this, this.goToIceDungeon, new Requirement[0]);
        this.killedWyvernTask.addStep(this.inIceDungeon, this.enterWyvernCavern);
        this.killedWyvernTask.addStep(this.inWyvernCavern, this.killWyvern);
        doHard.addStep(this.notKilledWyvern, this.killedWyvernTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notCraftedMindRunes = new VarplayerRequirement(1186, false, 26);
        this.notChangedFamilyCrest = new VarplayerRequirement(1186, false, 27);
        this.notKilledMole = new VarplayerRequirement(1186, false, 28);
        this.notKilledWyvern = new VarplayerRequirement(1186, false, 29);
        this.notCompleteAgiCourse = new VarplayerRequirement(1186, false, 30);
        this.notEnterMiningGuildWithProspector = new VarplayerRequirement(1186, false, 31);
        this.notKilledBlueDragon = new VarplayerRequirement(1187, false, 0);
        this.notCrackedWallSafe = new VarplayerRequirement(1187, false, 1);
        this.notPraySarimAltarProsy = new VarplayerRequirement(1187, false, 2);
        this.notEnterWarriorsGuild = new VarplayerRequirement(1187, false, 3);
        this.notDwarvenHelmetDwarvenMines = new VarplayerRequirement(1187, false, 4);
        this.pureEss28 = new ItemRequirement("Pure Essence", 7936, 28).showConditioned(this.notCraftedMindRunes);
        this.mindTiara = new ItemRequirement("Mind Tiara", 5529, 1, true).showConditioned(this.notCraftedMindRunes);
        this.coins10000 = new ItemRequirement("Coins", ItemCollections.COINS, 10000).showConditioned(this.notChangedFamilyCrest);
        this.combatGear = new ItemRequirement("Combat Gear", -1, -1).isNotConsumed();
        this.food = new ItemRequirement("Good healing food.", ItemCollections.GOOD_EATING_FOOD, -1);
        this.lightSource = new ItemRequirement("Light Source", ItemCollections.LIGHT_SOURCES, -1).showConditioned(this.notKilledMole).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notKilledMole).isNotConsumed();
        this.wyvernProtection = new ItemRequirement("Wyvern Protection", ItemCollections.ANTI_WYVERN_SHIELDS).showConditioned(this.notKilledWyvern).isNotConsumed();
        this.prospectorHelm = new ItemRequirement("Prospector Helm", 12013, 1, true).showConditioned(this.notEnterMiningGuildWithProspector).isNotConsumed();
        this.prospectorChest = new ItemRequirement("Prospector Chest", 12014, 1, true).showConditioned(this.notEnterMiningGuildWithProspector).isNotConsumed();
        this.prospectorLegs = new ItemRequirement("Prospector Legs", 12015, 1, true).showConditioned(this.notEnterMiningGuildWithProspector).isNotConsumed();
        this.prospectorBoots = new ItemRequirement("Prospector Boots", 12016, 1, true).showConditioned(this.notEnterMiningGuildWithProspector).isNotConsumed();
        this.dragonfireProtection = new ItemRequirement("Protection from Dragonfire", ItemCollections.ANTIFIRE_SHIELDS).showConditioned(this.notKilledBlueDragon).isNotConsumed();
        this.prosyHelm = new ItemRequirement("Proselyte Helmet", 9672).showConditioned(this.notPraySarimAltarProsy).isNotConsumed();
        this.prosyChest = new ItemRequirement("Proselyte Chest", 9674).showConditioned(this.notPraySarimAltarProsy).isNotConsumed();
        this.prosyLegs = new ItemRequirement("Proselyte Legs", 9676).showConditioned(this.notPraySarimAltarProsy).isNotConsumed();
        this.prosyLegs.addAlternates(9678);
        this.dwarvenHelmet = new ItemRequirement("Dwarven Helmet", 11200, 1).showConditioned(this.notDwarvenHelmetDwarvenMines).isNotConsumed();
        this.faladorTeleport = new ItemRequirement("Multiple teleports to Falador", 8009, -1);
        this.combatBracelet = new ItemRequirement("Combat Bracelet", ItemCollections.COMBAT_BRACELETS);
        this.combatBracelet.addAlternates(ItemCollections.GAMES_NECKLACES);
        this.prosySet = new ItemRequirements(this.prosyHelm, this.prosyLegs, this.prosyChest);
        this.prospectorSet = new ItemRequirements(this.prospectorBoots, this.prospectorChest, this.prospectorHelm, this.prospectorLegs);
        this.inMindAltar = new ZoneRequirement(this.mindAltar);
        this.inWyvernCavern = new ZoneRequirement(this.wyvernCavern);
        this.inIceDungeon = new ZoneRequirement(this.iceDungeon);
        this.inFaladorCastle1 = new ZoneRequirement(this.faladorCastle1);
        this.inHerosGuild = new ZoneRequirement(this.herosGuild);
        this.inHerosGuildBasement = new ZoneRequirement(this.herosGuildBasement);
        this.inPortSarimChurch = new ZoneRequirement(this.portSarimChurch);
        this.inDwarvenMine = new ZoneRequirement(this.dwarvenMine);
        this.inMiningGuild = new ZoneRequirement(this.miningGuild);
        this.inHerosGuildBasement = new ZoneRequirement(this.herosGuildBasement);
        this.inHerosGuild = new ZoneRequirement(this.herosGuildEntranceway, this.herosGuildMainHall);
        this.inRoguesDen = new ZoneRequirement(this.roguesDen);
        this.inMoleDen = new ZoneRequirement(this.moleDen);
        this.slugMenace = new QuestRequirement(QuestHelperQuest.THE_SLUG_MENACE, QuestState.FINISHED);
        this.herosQuest = new QuestRequirement(QuestHelperQuest.HEROES_QUEST, QuestState.FINISHED);
        this.grimTales = new QuestRequirement(QuestHelperQuest.GRIM_TALES, QuestState.FINISHED);
    }

    public void loadZones() {
        this.mindAltar = new Zone(new WorldPoint(2805, 4819, 0), new WorldPoint(2760, 4855, 0));
        this.iceDungeon = new Zone(new WorldPoint(2979, 9538, 0), new WorldPoint(3029, 9602, 0));
        this.wyvernCavern = new Zone(new WorldPoint(3030, 9602, 0), new WorldPoint(3083, 9556, 0));
        this.faladorCastle1 = new Zone(new WorldPoint(2954, 3328, 1), new WorldPoint(2997, 3353, 1));
        this.dwarvenMine = new Zone(new WorldPoint(3011, 9856, 0), new WorldPoint(3069, 9730, 0));
        this.miningGuild = new Zone(new WorldPoint(3008, 9730, 0), new WorldPoint(3060, 9698, 0));
        this.herosGuildBasement = new Zone(new WorldPoint(2883, 9919, 0), new WorldPoint(2943, 9881, 0));
        this.herosGuildEntranceway = new Zone(new WorldPoint(2899, 3512, 0), new WorldPoint(2901, 3509, 0));
        this.herosGuildMainHall = new Zone(new WorldPoint(2892, 3507, 0), new WorldPoint(2892, 3514, 0));
        this.roguesDen = new Zone(new WorldPoint(3067, 4991, 1), new WorldPoint(3036, 4956, 1));
        this.moleDen = new Zone(new WorldPoint(1731, 5132, 0), new WorldPoint(1789, 5248, 0));
    }

    public void setupSteps() {
        this.enterMindAltar = new ObjectStep((QuestHelper)this, 29094, new WorldPoint(2982, 3514, 0), "Click on the Mysterious Ruins, with the Mind Tiara equipped to access the Mind Altar.", this.mindTiara, this.pureEss28);
        this.craftMindRunes = new ObjectStep((QuestHelper)this, 34761, new WorldPoint(2786, 4841, 0), "Click the altar to craft the mind runes.", this.mindTiara, this.pureEss28);
        this.craftMindRunes.addIcon(7936);
        this.enterMindAltar.addSubSteps(this.craftMindRunes);
        this.climbLadderWhiteKnightCastle = new ObjectStep((QuestHelper)this, 24070, new WorldPoint(2994, 3341, 0), "Climb the ladder in The White Knights Castle.", this.coins10000);
        this.changeFamilyCrest = new NpcStep((QuestHelper)this, 3100, new WorldPoint(2982, 3341, 1), "Speak to Sir Renitee to change your family crest to Saradomin.", this.coins10000);
        this.changeFamilyCrest.addDialogStep("I don't know, what can you do for me?");
        this.changeFamilyCrest.addDialogStep("Can you see if I have a family crest?");
        this.changeFamilyCrest.addDialogStep("I don't like that crest. Can I have a different one?");
        this.changeFamilyCrest.addDialogStepWithExclusion("More...", "Saradomin");
        this.changeFamilyCrest.addDialogStep("Saradomin");
        this.goToGiantMole = new ObjectStep((QuestHelper)this, 12202, new WorldPoint(2989, 3378, 0), "Use a spade on one of the Mole Hills in Falador Park", this.combatGear, this.food, this.lightSource, this.spade);
        this.killGiantMole = new NpcStep((QuestHelper)this, 5779, "Kill the Giant Mole.", this.combatGear, this.food, this.lightSource);
        this.goToIceDungeon = new ObjectStep((QuestHelper)this, 1738, new WorldPoint(3008, 3150, 0), "Go down the ladder south of Port Sarim.", this.combatGear, this.food, this.wyvernProtection);
        this.enterWyvernCavern = new ObjectStep((QuestHelper)this, 10596, new WorldPoint(3055, 9560, 0), "Enter the Icy Cavern at the back of the dungeon.", this.combatGear, this.food, this.wyvernProtection);
        this.killWyvern = new NpcStep((QuestHelper)this, 465, "Kill a Skeletal Wyvern.", this.combatGear, this.food, this.wyvernProtection);
        this.completeAgiCourse = new ObjectStep((QuestHelper)this, 14898, new WorldPoint(3036, 3341, 0), "Complete a lap of the Falador Agility Course", new Requirement[0]);
        this.enterDwarvenMines = new ObjectStep((QuestHelper)this, 16664, new WorldPoint(3059, 3376, 0), "Go to the Dwarven Mines.", this.prospectorBoots, this.prospectorChest, this.prospectorLegs, this.prospectorHelm);
        this.enterMiningGuild = new ObjectStep((QuestHelper)this, 30364, new WorldPoint(3046, 9756, 0), "Equip your prospector set and then enter the Mining Guild", this.prospectorBoots, this.prospectorChest, this.prospectorLegs, this.prospectorHelm);
        this.enterHerosGuild = new ObjectStep((QuestHelper)this, 2624, new WorldPoint(2902, 3501, 0), "Go to the Hero's Guild south of Burthorpe. You can get here faster by teleporting with a Combat Bracelet to the Warriors Guild.", this.combatGear, this.food, this.dragonfireProtection);
        this.enterHerosGuildBasement = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2892, 3507, 0), "Climb down the ladder in the Hero's Guild.", new Requirement[0]);
        this.killBlueDragon = new NpcStep((QuestHelper)this, 266, "Kill the Blue Dragon to complete your task.", new Requirement[0]);
        this.enterRoguesDen = new ObjectStep((QuestHelper)this, 7257, new WorldPoint(2905, 3537, 0), "Go to the Rogues Den in Burthorpe.", new Requirement[0]);
        this.crackWallSafe = new ObjectStep((QuestHelper)this, 7236, new WorldPoint(3055, 4977, 1), "Crack the Wall Safe inside of the Rogues Den.", new Requirement[0]);
        this.getProsySet = new NpcStep((QuestHelper)this, 4687, new WorldPoint(2997, 3373, 0), "Speak to Sir Tiffy Cashien to purchase a set of Proselyte Armor for 28,000 Coins for a full set.", new Requirement[0]);
        this.getProsySet.addDialogStep("Can I buy some armor?");
        this.prayAtAltarSarim = new ObjectStep((QuestHelper)this, 409, new WorldPoint(2995, 3177, 0), "Equip your Proselyte armor and pray at the altar in Port Sarim.", this.prosyHelm, this.prosyChest, this.prosyLegs);
        this.enterWarriorsGuild = new ObjectStep((QuestHelper)this, 24318, new WorldPoint(2896, 3510, 0), "Enter the Warriors Guild, in Burthorpe. You can get here faster by teleporting with a combat bracelet or a games necklace.", new Requirement[0]);
        this.enterDwarvenMinesHelmet = new ObjectStep((QuestHelper)this, 16664, new WorldPoint(3059, 3376, 0), "Go to the Dwarven Mines.", this.dwarvenHelmet);
        this.equipDwarvenHelmet = new DetailedQuestStep((QuestHelper)this, "Equip the Dwarven Helmet.", this.dwarvenHelmet.equipped());
        this.claimReward = new NpcStep((QuestHelper)this, 5524, new WorldPoint(2977, 3346, 0), "Congratulations! Talk to Sir Rebral in the courtyard of The White Knight Castle to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Giant Mole (lvl 230)", "Skeletal Wyvern (lvl 140)", "Blue dragon (lvl 111)");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.pureEss28, this.mindTiara, this.coins10000, this.combatGear, this.lightSource, this.spade, this.wyvernProtection, this.prospectorHelm, this.prospectorBoots, this.prospectorChest, this.prospectorLegs, this.prosyHelm, this.prosyChest, this.prosyLegs, this.dwarvenHelmet);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.faladorTeleport, this.combatBracelet);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 50));
        req.add(new SkillRequirement(Skill.DEFENCE, 50));
        req.add(new SkillRequirement(Skill.MINING, 60, true));
        req.add(new SkillRequirement(Skill.PRAYER, 70));
        req.add(new ComplexRequirement(LogicType.OR, "56 Runecraft or 42 with Raiments of the Eye set", new SkillRequirement(Skill.RUNECRAFT, 56, true, "56 Runecraft"), new ItemRequirements("42 with Raiments of the Eye set", new ItemRequirement("Hat", ItemCollections.EYE_HAT), new ItemRequirement("Top", ItemCollections.EYE_TOP), new ItemRequirement("Bottom", ItemCollections.EYE_BOTTOM), new ItemRequirement("Boot", 26856))));
        req.add(new SkillRequirement(Skill.SLAYER, 72, true));
        req.add(new SkillRequirement(Skill.THIEVING, 50, true));
        req.add(new WarriorsGuildAccessRequirement());
        req.add(this.grimTales);
        req.add(this.herosQuest);
        req.add(this.slugMenace);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Falador Shield (3)", 13119, 1), new ItemReward("15,000 Exp. Lamp (Any skill over 50)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the bank in the Crafting Guild"), new UnlockReward("Giant Moles primary drops are now noted"), new UnlockReward("Access to shortcut to Fountain of Heroes"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails changeCrestSteps = new PanelDetails("To Saradomin!", Arrays.asList(this.climbLadderWhiteKnightCastle, this.changeFamilyCrest), new SkillRequirement(Skill.PRAYER, 70), this.coins10000);
        changeCrestSteps.setDisplayCondition(this.notChangedFamilyCrest);
        changeCrestSteps.setLockingStep(this.changedFamilyCrestTask);
        allSteps.add(changeCrestSteps);
        PanelDetails moleSteps = new PanelDetails("Holy Moley!", Arrays.asList(this.goToGiantMole, this.killGiantMole), this.lightSource, this.spade, this.combatGear, this.food);
        moleSteps.setDisplayCondition(this.notKilledMole);
        moleSteps.setLockingStep(this.killedMoleTask);
        allSteps.add(moleSteps);
        PanelDetails fallyRoofSteps = new PanelDetails("Make sure to stretch!", Collections.singletonList(this.completeAgiCourse), new SkillRequirement(Skill.AGILITY, 50));
        fallyRoofSteps.setDisplayCondition(this.notCompleteAgiCourse);
        fallyRoofSteps.setLockingStep(this.completeAgiCourseTask);
        allSteps.add(fallyRoofSteps);
        PanelDetails dwarvenHelmSteps = new PanelDetails("A snug fit", Arrays.asList(this.enterDwarvenMinesHelmet, this.equipDwarvenHelmet), new SkillRequirement(Skill.DEFENCE, 50), this.dwarvenHelmet, this.grimTales);
        dwarvenHelmSteps.setDisplayCondition(this.notDwarvenHelmetDwarvenMines);
        dwarvenHelmSteps.setLockingStep(this.dwarvenHelmetDwarvenMinesTask);
        allSteps.add(dwarvenHelmSteps);
        PanelDetails miningGuildSteps = new PanelDetails("Gold Rush!", Arrays.asList(this.enterDwarvenMines, this.enterMiningGuild), new SkillRequirement(Skill.MINING, 60, true), this.prospectorHelm, this.prospectorBoots, this.prospectorChest, this.prospectorLegs);
        miningGuildSteps.setDisplayCondition(this.notEnterMiningGuildWithProspector);
        miningGuildSteps.setLockingStep(this.enterMiningGuildWithProspectorTask);
        allSteps.add(miningGuildSteps);
        PanelDetails warriorsGuildSteps = new PanelDetails("The Dragon Defender", Collections.singletonList(this.enterWarriorsGuild), new WarriorsGuildAccessRequirement());
        warriorsGuildSteps.setDisplayCondition(this.notEnterWarriorsGuild);
        warriorsGuildSteps.setLockingStep(this.enterWarriorsGuildTask);
        allSteps.add(warriorsGuildSteps);
        PanelDetails blueDragonSteps = new PanelDetails("The Dragon Slayer", Arrays.asList(this.enterHerosGuild, this.enterHerosGuildBasement, this.killBlueDragon), this.herosQuest, this.combatGear, this.food, this.dragonfireProtection);
        blueDragonSteps.setDisplayCondition(this.notKilledBlueDragon);
        blueDragonSteps.setLockingStep(this.killedBlueDragonTask);
        allSteps.add(blueDragonSteps);
        PanelDetails crackSafeSteps = new PanelDetails("The cat burglar", Arrays.asList(this.enterRoguesDen, this.crackWallSafe), new SkillRequirement(Skill.THIEVING, 50, true));
        crackSafeSteps.setDisplayCondition(this.notCrackedWallSafe);
        crackSafeSteps.setLockingStep(this.crackedWallSafeTask);
        allSteps.add(crackSafeSteps);
        PanelDetails mindRunesSteps = new PanelDetails("Do you mind?", Arrays.asList(this.enterMindAltar, this.craftMindRunes), new SkillRequirement(Skill.RUNECRAFT, 56, true), this.mindTiara, this.pureEss28);
        mindRunesSteps.setDisplayCondition(this.notCraftedMindRunes);
        mindRunesSteps.setLockingStep(this.craftedMindRunesTask);
        allSteps.add(mindRunesSteps);
        PanelDetails praySteps = new PanelDetails("Praise the Lord!", Arrays.asList(this.getProsySet, this.prayAtAltarSarim), new SkillRequirement(Skill.DEFENCE, 30), this.slugMenace, this.prosyHelm, this.prosyChest, this.prosyLegs);
        praySteps.setDisplayCondition(this.notPraySarimAltarProsy);
        praySteps.setLockingStep(this.praySarimAltarProsyTask);
        allSteps.add(praySteps);
        PanelDetails wyvernSteps = new PanelDetails("This ain't no dragon!", Arrays.asList(this.goToIceDungeon, this.enterWyvernCavern, this.killWyvern), new SkillRequirement(Skill.SLAYER, 72, true), this.combatGear, this.food, this.wyvernProtection);
        wyvernSteps.setDisplayCondition(this.notKilledWyvern);
        wyvernSteps.setLockingStep(this.killedWyvernTask);
        allSteps.add(wyvernSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

