/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.falador;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.EmoteStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.emote.QuestEmote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FALADOR_ELITE)
public class FaladorElite
extends ComplexStateQuestHelper {
    ItemRequirement pureEss28;
    ItemRequirement airTiara;
    ItemRequirement coins1920;
    ItemRequirement spade;
    ItemRequirement axe;
    ItemRequirement skillCape;
    ItemRequirement toadflaxPotionUnf;
    ItemRequirement crushedNest;
    ItemRequirement rake;
    ItemRequirement magicTreeSapling;
    ItemRequirement faladorTeleport;
    Requirement wanted;
    Requirement notCraftedAirRunes;
    Requirement notPurchasedWhite2hSword;
    Requirement notGotMagicRoots;
    Requirement notPerformedSkillCapeEmote;
    Requirement notJumpedOverStrangeFloor;
    Requirement notMadeSaraBrew;
    Requirement magicTreeNearbyNotCheckedVar;
    Requirement stumpNearbyVar;
    Requirement magicTreeNearbyCheckedVar;
    QuestStep claimReward;
    QuestStep enterAirAltar;
    QuestStep craftAirRunes;
    QuestStep goUpFaladorCastle2;
    QuestStep goUpFaladorCastle1;
    QuestStep purchaseWhite2hSword;
    QuestStep chopMagicTree;
    QuestStep goUpFaladorCastle1Emote;
    QuestStep goUpFaladorCastle2Emote;
    QuestStep goUpFaladorCastle3Emote;
    QuestStep performEmote;
    QuestStep goToTavDungeon;
    QuestStep crossStrangeFloor;
    QuestStep goToEastBank;
    QuestStep craftSaraBrew;
    QuestStep growMagicTree;
    QuestStep digUpStumpForRoots;
    Zone airAltar;
    Zone faladorCastle1;
    Zone faladorCastle2;
    Zone faladorCastle3;
    Zone tavDungeon;
    Zone eastBank;
    ZoneRequirement inAirAltar;
    ZoneRequirement inFaladorCastle1;
    ZoneRequirement inFaladorCastle2;
    ZoneRequirement inFaladorCastle3;
    ZoneRequirement inTavDungeon;
    ZoneRequirement inEastBank;
    ConditionalStep craftedAirRunesTask;
    ConditionalStep purchasedWhite2hSwordTask;
    ConditionalStep gotMagicRootsTask;
    ConditionalStep performedSkillCapeEmoteTask;
    ConditionalStep jumpedOverStrangeFloorTask;
    ConditionalStep madeSaraBrewTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.gotMagicRootsTask = new ConditionalStep((QuestHelper)this, this.growMagicTree, new Requirement[0]);
        this.gotMagicRootsTask.addStep(this.magicTreeNearbyNotCheckedVar, this.chopMagicTree);
        this.gotMagicRootsTask.addStep(this.magicTreeNearbyCheckedVar, this.chopMagicTree);
        this.gotMagicRootsTask.addStep(this.stumpNearbyVar, this.digUpStumpForRoots);
        doElite.addStep(this.notGotMagicRoots, this.gotMagicRootsTask);
        this.craftedAirRunesTask = new ConditionalStep((QuestHelper)this, this.enterAirAltar, new Requirement[0]);
        this.craftedAirRunesTask.addStep(this.inAirAltar, this.craftAirRunes);
        doElite.addStep(this.notCraftedAirRunes, this.craftedAirRunesTask);
        this.performedSkillCapeEmoteTask = new ConditionalStep((QuestHelper)this, this.goUpFaladorCastle1Emote, new Requirement[0]);
        this.performedSkillCapeEmoteTask.addStep(this.inFaladorCastle1, this.goUpFaladorCastle2Emote);
        this.performedSkillCapeEmoteTask.addStep(this.inFaladorCastle2, this.goUpFaladorCastle3Emote);
        this.performedSkillCapeEmoteTask.addStep(this.inFaladorCastle3, this.performEmote);
        doElite.addStep(this.notPerformedSkillCapeEmote, this.performedSkillCapeEmoteTask);
        this.jumpedOverStrangeFloorTask = new ConditionalStep((QuestHelper)this, this.goToTavDungeon, new Requirement[0]);
        this.jumpedOverStrangeFloorTask.addStep(this.inTavDungeon, this.crossStrangeFloor);
        doElite.addStep(this.notJumpedOverStrangeFloor, this.jumpedOverStrangeFloorTask);
        this.madeSaraBrewTask = new ConditionalStep((QuestHelper)this, this.goToEastBank, new Requirement[0]);
        this.madeSaraBrewTask.addStep(this.inEastBank, this.craftSaraBrew);
        doElite.addStep(new Conditions(this.notMadeSaraBrew), this.madeSaraBrewTask);
        this.purchasedWhite2hSwordTask = new ConditionalStep((QuestHelper)this, this.goUpFaladorCastle1, new Requirement[0]);
        this.purchasedWhite2hSwordTask.addStep(this.inFaladorCastle1, this.goUpFaladorCastle2);
        this.purchasedWhite2hSwordTask.addStep(this.inFaladorCastle2, this.purchaseWhite2hSword);
        doElite.addStep(this.notPurchasedWhite2hSword, this.purchasedWhite2hSwordTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notCraftedAirRunes = new VarplayerRequirement(1187, false, 5);
        this.notPurchasedWhite2hSword = new VarplayerRequirement(1187, false, 6);
        this.notGotMagicRoots = new VarplayerRequirement(1187, false, 7);
        this.notPerformedSkillCapeEmote = new VarplayerRequirement(1187, false, 8);
        this.notJumpedOverStrangeFloor = new VarplayerRequirement(1187, false, 9);
        this.notMadeSaraBrew = new VarplayerRequirement(1187, false, 10);
        this.pureEss28 = new ItemRequirement("Pure Essence", 7936, 28).showConditioned(this.notCraftedAirRunes);
        this.airTiara = new ItemRequirement("Air Tiara", 5527, 1, true).showConditioned(this.notCraftedAirRunes).isNotConsumed();
        this.coins1920 = new ItemRequirement("Coins", ItemCollections.COINS, 1920).showConditioned(this.notPurchasedWhite2hSword);
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notGotMagicRoots).isNotConsumed();
        this.axe = new ItemRequirement("Axe", ItemCollections.AXES).showConditioned(this.notGotMagicRoots).isNotConsumed();
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notGotMagicRoots).isNotConsumed();
        this.magicTreeSapling = new ItemRequirement("Magic Sapling", 5374).showConditioned(this.notGotMagicRoots);
        this.skillCape = new ItemRequirement("Any Skill Cape or Quest Cape", ItemCollections.SKILLCAPE).showConditioned(this.notPerformedSkillCapeEmote);
        this.toadflaxPotionUnf = new ItemRequirement("Toadflax Potion (unf)", 3002).showConditioned(this.notMadeSaraBrew);
        this.crushedNest = new ItemRequirement("Crushed Nest", 6693).showConditioned(this.notMadeSaraBrew);
        this.faladorTeleport = new ItemRequirement("Multiple Teleports to Falador", 8009, -1);
        this.magicTreeNearbyNotCheckedVar = new VarbitRequirement(4471, 60);
        this.magicTreeNearbyCheckedVar = new VarbitRequirement(4471, 61);
        this.stumpNearbyVar = new VarbitRequirement(4471, 62);
        this.inAirAltar = new ZoneRequirement(this.airAltar);
        this.inFaladorCastle1 = new ZoneRequirement(this.faladorCastle1);
        this.inFaladorCastle2 = new ZoneRequirement(this.faladorCastle2);
        this.inFaladorCastle3 = new ZoneRequirement(this.faladorCastle3);
        this.inTavDungeon = new ZoneRequirement(this.tavDungeon);
        this.inEastBank = new ZoneRequirement(this.eastBank);
        this.wanted = new QuestRequirement(QuestHelperQuest.WANTED, QuestState.FINISHED);
    }

    public void loadZones() {
        this.airAltar = new Zone(new WorldPoint(2895, 4851, 0), new WorldPoint(2859, 4819, 0));
        this.faladorCastle1 = new Zone(new WorldPoint(2954, 3328, 1), new WorldPoint(2997, 3353, 1));
        this.faladorCastle2 = new Zone(new WorldPoint(2954, 3328, 2), new WorldPoint(2997, 3353, 2));
        this.faladorCastle3 = new Zone(new WorldPoint(2954, 3328, 3), new WorldPoint(2997, 3353, 3));
        this.tavDungeon = new Zone(new WorldPoint(2809, 9846, 0), new WorldPoint(2949, 9786, 0));
        this.eastBank = new Zone(new WorldPoint(3009, 3358, 0), new WorldPoint(3018, 3355, 0));
    }

    public void setupSteps() {
        this.enterAirAltar = new ObjectStep((QuestHelper)this, 29090, new WorldPoint(2985, 3292, 0), "Go to the Air Altar south of Falador", this.pureEss28, this.airTiara);
        this.craftAirRunes = new ObjectStep((QuestHelper)this, 34760, new WorldPoint(2843, 4833, 0), "Use your essence on the Altar to craft the Air Runes.", this.pureEss28);
        this.craftAirRunes.addIcon(7936);
        this.enterAirAltar.addSubSteps(this.craftAirRunes);
        this.goUpFaladorCastle1 = new ObjectStep((QuestHelper)this, 24070, new WorldPoint(2994, 3341, 0), "Climb up the east ladder in Falador Castle.", this.coins1920);
        this.goUpFaladorCastle2 = new ObjectStep((QuestHelper)this, 24077, new WorldPoint(2985, 3338, 1), "Go up the staircase west of the ladder on the 1st floor.", this.coins1920);
        this.purchaseWhite2hSword = new NpcStep((QuestHelper)this, 4736, new WorldPoint(2981, 3338, 2), "Speak to Sir Vyvin to purchase a White 2H Sword.", this.coins1920);
        this.purchaseWhite2hSword.addDialogStep("Do you have anything to trade?");
        this.growMagicTree = new ObjectStep((QuestHelper)this, 8389, new WorldPoint(3004, 3373, 0), "Grow and check the health of a magic tree in Falador Park, afterwards dig up the stump to get the Magic Roots. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.magicTreeSapling, this.rake, this.spade);
        this.chopMagicTree = new ObjectStep((QuestHelper)this, 8389, new WorldPoint(3004, 3373, 0), "Chop the magic tree that you grew in Falador Park, afterwards dig up the stump to get the Magic Roots.", this.axe, this.spade);
        this.digUpStumpForRoots = new ObjectStep((QuestHelper)this, 8389, new WorldPoint(3004, 3373, 0), "Dig up the stump to get the magic roots.", this.spade);
        this.goUpFaladorCastle1Emote = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2954, 3338, 0), "Climb the staircase to the First Floor of the White Knights Castle.", this.skillCape);
        this.goUpFaladorCastle2Emote = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2960, 3338, 1), "Climb the staircase to the Second Floor of the White Knights Castle.", this.skillCape);
        this.goUpFaladorCastle3Emote = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2957, 3338, 2), "Climb the staircase to the Top Floor of the White Knights Castle", this.skillCape);
        this.performEmote = new EmoteStep((QuestHelper)this, QuestEmote.SKILL_CAPE, new WorldPoint(2960, 3338, 3), "Equip your skill cape and perform its emote!", this.skillCape);
        this.goToTavDungeon = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Go to the Taverly dungeon.", new Requirement[0]);
        this.crossStrangeFloor = new ObjectStep((QuestHelper)this, 16510, new WorldPoint(2879, 9813, 0), "Cross the Strange Floor to complete the task!", new Requirement[0]);
        this.goToEastBank = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3013, 3356, 0), "Go to the Falador East Bank", new Requirement[0]);
        this.craftSaraBrew = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3013, 3356, 0), "Craft a Saradomin Brew while inside the Falador East Bank.", this.toadflaxPotionUnf.highlighted(), this.crushedNest.highlighted());
        this.claimReward = new NpcStep((QuestHelper)this, 5524, new WorldPoint(2977, 3346, 0), "Congratulations! Talk to Sir Rebral in the courtyard of The White Knight Castle to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Giant Mole (level 230)");
        reqs.add("Skeletal Wyvern (level 140)");
        reqs.add("Blue dragon (level 140)");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.pureEss28, this.airTiara, this.coins1920, this.spade, this.axe, this.skillCape, this.toadflaxPotionUnf, this.crushedNest);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.faladorTeleport);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 80, true));
        req.add(new SkillRequirement(Skill.FARMING, 91, true));
        req.add(new SkillRequirement(Skill.HERBLORE, 81, true));
        req.add(new ComplexRequirement(LogicType.OR, "88 Runecraft or 55 with Raiments of the Eye set", new SkillRequirement(Skill.RUNECRAFT, 88, true, "88 Runecraft"), new ItemRequirements("55 with Raiments of the Eye set", new ItemRequirement("Hat", ItemCollections.EYE_HAT), new ItemRequirement("Top", ItemCollections.EYE_TOP), new ItemRequirement("Bottom", ItemCollections.EYE_BOTTOM), new ItemRequirement("Boot", 26856))));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 75, true));
        req.add(this.wanted);
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Falador Shield (4)", 13120, 1), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Tree patch in Falador is now disease free."), new UnlockReward("Increased chance at higher level ores when clearing pay-dirt in the Motherlode Mine."), new UnlockReward("Access to the alternative Amethyst mining spot."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails magicRootsSteps = new PanelDetails("Root of all magic", Arrays.asList(this.growMagicTree, this.chopMagicTree, this.digUpStumpForRoots), new SkillRequirement(Skill.FARMING, 91, true), new SkillRequirement(Skill.WOODCUTTING, 75, true), this.axe, this.spade);
        magicRootsSteps.setDisplayCondition(this.notGotMagicRoots);
        magicRootsSteps.setLockingStep(this.gotMagicRootsTask);
        allSteps.add(magicRootsSteps);
        PanelDetails airRunesSteps = new PanelDetails("One with the wind..", Arrays.asList(this.enterAirAltar, this.craftAirRunes), new SkillRequirement(Skill.RUNECRAFT, 88, true), this.airTiara, this.pureEss28);
        airRunesSteps.setDisplayCondition(this.notCraftedAirRunes);
        airRunesSteps.setLockingStep(this.craftedAirRunesTask);
        allSteps.add(airRunesSteps);
        PanelDetails capeEmoteSteps = new PanelDetails("Peak Efficiency", Arrays.asList(this.goUpFaladorCastle1Emote, this.goUpFaladorCastle2Emote, this.goUpFaladorCastle3Emote, this.performEmote), this.skillCape);
        capeEmoteSteps.setDisplayCondition(this.notPerformedSkillCapeEmote);
        capeEmoteSteps.setLockingStep(this.performedSkillCapeEmoteTask);
        allSteps.add(capeEmoteSteps);
        PanelDetails strangeFloorSteps = new PanelDetails("The River Styx", Arrays.asList(this.goToTavDungeon, this.crossStrangeFloor), new SkillRequirement(Skill.AGILITY, 80, true));
        strangeFloorSteps.setDisplayCondition(this.notJumpedOverStrangeFloor);
        strangeFloorSteps.setLockingStep(this.jumpedOverStrangeFloorTask);
        allSteps.add(strangeFloorSteps);
        PanelDetails saraBrewSteps = new PanelDetails("Pot Head", Arrays.asList(this.goToEastBank, this.craftSaraBrew), new SkillRequirement(Skill.HERBLORE, 81, true), this.toadflaxPotionUnf, this.crushedNest);
        saraBrewSteps.setDisplayCondition(this.notMadeSaraBrew);
        saraBrewSteps.setLockingStep(this.madeSaraBrewTask);
        allSteps.add(saraBrewSteps);
        PanelDetails swordSteps = new PanelDetails("*Tips Fedora*", Arrays.asList(this.goUpFaladorCastle1, this.goUpFaladorCastle2, this.purchaseWhite2hSword), this.wanted, this.coins1920);
        swordSteps.setDisplayCondition(this.notPurchasedWhite2hSword);
        swordSteps.setLockingStep(this.purchasedWhite2hSwordTask);
        allSteps.add(swordSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

