/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.falador;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FALADOR_EASY)
public class FaladorEasy
extends ComplexStateQuestHelper {
    ItemRequirement coins2000;
    ItemRequirement bucket;
    ItemRequirement tiara;
    ItemRequirement mindTalisman;
    ItemRequirement hammer;
    ItemRequirement pickaxe;
    ItemRequirement combatGear;
    ItemRequirement teleportFalador;
    ItemRequirement teleportMindAltar;
    ItemRequirement explorersRing;
    ItemRequirement bluriteBar;
    ItemRequirement bluriteOre;
    Requirement doricsQuest;
    Requirement knightSword;
    Requirement notFilledWater;
    Requirement notKilledDuck;
    Requirement notClimbedWall;
    Requirement notGotHaircut;
    Requirement notMotherloadMine;
    Requirement notEntrana;
    Requirement notMindTiara;
    Requirement notBluriteLimbs;
    Requirement notGotSecurityBook;
    Requirement notSarahFarmingShop;
    Requirement notFamilyCrest;
    Requirement hasBluriteOre;
    Requirement hasBluriteBar;
    QuestStep claimReward;
    QuestStep fillWater;
    QuestStep climbWall;
    QuestStep getHaircut;
    QuestStep enterDwarvenMines;
    QuestStep enterCaveToMotherlodeMine;
    QuestStep fixMotherloadMine;
    QuestStep goEntrana;
    QuestStep enterMindAltar;
    QuestStep getMindTiara;
    QuestStep getPickaxe;
    QuestStep enterDungeon;
    QuestStep mineBlurite;
    QuestStep smeltBlurite;
    QuestStep smithBluriteLimbs;
    QuestStep climbLadderPortSarimJail;
    QuestStep getSecurityBook;
    QuestStep browseSarahFarmingShop;
    QuestStep climbLadderWhiteKnightCastle;
    QuestStep discoverFamilyCrest;
    NpcStep killDuck;
    Zone mindAltar;
    Zone bluriteDungeon;
    Zone faladorCastle1;
    Zone portSarimJail1;
    Zone motherlodeMine;
    Zone dwarvenMine;
    ZoneRequirement inMindAltar;
    ZoneRequirement inBluriteDungeon;
    ZoneRequirement inFaladorCastle1;
    ZoneRequirement inPortSarimJail1;
    ZoneRequirement inMotherlodeMine;
    ZoneRequirement inDwarvenMine;
    ConditionalStep filledWaterTask;
    ConditionalStep killedDuckTask;
    ConditionalStep climbedWallTask;
    ConditionalStep gotHaircutTask;
    ConditionalStep motherloadMineTask;
    ConditionalStep entranaTask;
    ConditionalStep mindTiaraTask;
    ConditionalStep bluriteLimbsTask;
    ConditionalStep gotSecurityBookTask;
    ConditionalStep sarahFarmingShopTask;
    ConditionalStep familyCrestTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.filledWaterTask = new ConditionalStep((QuestHelper)this, this.fillWater, new Requirement[0]);
        doEasy.addStep(this.notFilledWater, this.filledWaterTask);
        this.gotHaircutTask = new ConditionalStep((QuestHelper)this, this.getHaircut, new Requirement[0]);
        doEasy.addStep(this.notGotHaircut, this.gotHaircutTask);
        this.climbedWallTask = new ConditionalStep((QuestHelper)this, this.climbWall, new Requirement[0]);
        doEasy.addStep(this.notClimbedWall, this.climbedWallTask);
        this.killedDuckTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.killDuck, new Requirement[0]);
        doEasy.addStep(this.notKilledDuck, this.killedDuckTask);
        this.motherloadMineTask = new ConditionalStep((QuestHelper)this, this.enterDwarvenMines, new Requirement[0]);
        this.motherloadMineTask.addStep(this.inDwarvenMine, this.enterCaveToMotherlodeMine);
        this.motherloadMineTask.addStep(this.inMotherlodeMine, this.fixMotherloadMine);
        doEasy.addStep(this.notMotherloadMine, this.motherloadMineTask);
        this.sarahFarmingShopTask = new ConditionalStep((QuestHelper)this, this.browseSarahFarmingShop, new Requirement[0]);
        doEasy.addStep(this.notSarahFarmingShop, this.sarahFarmingShopTask);
        this.entranaTask = new ConditionalStep((QuestHelper)this, this.goEntrana, new Requirement[0]);
        doEasy.addStep(this.notEntrana, this.entranaTask);
        this.gotSecurityBookTask = new ConditionalStep((QuestHelper)this, this.climbLadderPortSarimJail, new Requirement[0]);
        this.gotSecurityBookTask.addStep(this.inPortSarimJail1, this.getSecurityBook);
        doEasy.addStep(this.notGotSecurityBook, this.gotSecurityBookTask);
        this.bluriteLimbsTask = new ConditionalStep((QuestHelper)this, this.getPickaxe, new Requirement[0]);
        this.bluriteLimbsTask.addStep(this.hasBluriteBar, this.smithBluriteLimbs);
        this.bluriteLimbsTask.addStep(this.hasBluriteOre, this.smeltBlurite);
        this.bluriteLimbsTask.addStep(new Conditions(this.pickaxe, this.inBluriteDungeon), this.mineBlurite);
        this.bluriteLimbsTask.addStep(this.pickaxe, this.enterDungeon);
        doEasy.addStep(this.notBluriteLimbs, this.bluriteLimbsTask);
        this.mindTiaraTask = new ConditionalStep((QuestHelper)this, this.enterMindAltar, new Requirement[0]);
        this.mindTiaraTask.addStep(this.inMindAltar, this.getMindTiara);
        doEasy.addStep(this.notMindTiara, this.mindTiaraTask);
        this.familyCrestTask = new ConditionalStep((QuestHelper)this, this.climbLadderWhiteKnightCastle, new Requirement[0]);
        this.familyCrestTask.addStep(this.inFaladorCastle1, this.discoverFamilyCrest);
        doEasy.addStep(this.notFamilyCrest, this.familyCrestTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notFamilyCrest = new VarplayerRequirement(1186, false, 0);
        this.notClimbedWall = new VarplayerRequirement(1186, false, 1);
        this.notSarahFarmingShop = new VarplayerRequirement(1186, false, 2);
        this.notGotHaircut = new VarplayerRequirement(1186, false, 3);
        this.notFilledWater = new VarplayerRequirement(1186, false, 4);
        this.notKilledDuck = new VarplayerRequirement(1186, false, 5);
        this.notMindTiara = new VarplayerRequirement(1186, false, 6);
        this.notEntrana = new VarplayerRequirement(1186, false, 7);
        this.notMotherloadMine = new VarplayerRequirement(1186, false, 8);
        this.notGotSecurityBook = new VarplayerRequirement(1186, false, 9);
        this.notBluriteLimbs = new VarplayerRequirement(1186, false, 10);
        this.coins2000 = new ItemRequirement("Coins", ItemCollections.COINS, 2000).showConditioned(this.notGotHaircut);
        this.bucket = new ItemRequirement("Bucket", 1925).showConditioned(this.notFilledWater).isNotConsumed();
        this.tiara = new ItemRequirement("Silver Tiara", 5525).showConditioned(this.notMindTiara);
        this.mindTalisman = new ItemRequirement("Mind Talisman", 1448).showConditioned(this.notMindTiara);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(new Conditions(LogicType.OR, this.notMotherloadMine, this.notBluriteLimbs)).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any Pickaxe", ItemCollections.PICKAXES).showConditioned(new Conditions(LogicType.OR, this.notMotherloadMine, this.notBluriteLimbs)).isNotConsumed();
        this.combatGear = new ItemRequirement("A range or mage attack to kill a Duck (Level 1)", -1, -1).showConditioned(this.notKilledDuck).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getRangedCombatGear());
        this.teleportFalador = new ItemRequirement("Multiple teleports to Falador", 8009, -1);
        this.teleportMindAltar = new ItemRequirement("A Teleport to the Mind Altar", 19617);
        this.explorersRing = new ItemRequirement("Explorers Ring (2) or above.", 13126).isNotConsumed();
        this.explorersRing.addAlternates(13127, 13128);
        this.bluriteOre = new ItemRequirement("Blurite Ore", 668);
        this.bluriteBar = new ItemRequirement("Blurite Bar", 9467);
        this.hasBluriteOre = this.bluriteOre.alsoCheckBank(this.questBank);
        this.hasBluriteBar = this.bluriteBar.alsoCheckBank(this.questBank);
        this.inMindAltar = new ZoneRequirement(this.mindAltar);
        this.inBluriteDungeon = new ZoneRequirement(this.bluriteDungeon);
        this.inFaladorCastle1 = new ZoneRequirement(this.faladorCastle1);
        this.inPortSarimJail1 = new ZoneRequirement(this.portSarimJail1);
        this.inDwarvenMine = new ZoneRequirement(this.dwarvenMine);
        this.inMotherlodeMine = new ZoneRequirement(this.motherlodeMine);
        this.doricsQuest = new QuestRequirement(QuestHelperQuest.DORICS_QUEST, QuestState.FINISHED);
        this.knightSword = new QuestRequirement(QuestHelperQuest.THE_KNIGHTS_SWORD, QuestState.FINISHED);
    }

    public void loadZones() {
        this.mindAltar = new Zone(new WorldPoint(2805, 4819, 0), new WorldPoint(2760, 4855, 0));
        this.bluriteDungeon = new Zone(new WorldPoint(2979, 9538, 0), new WorldPoint(3069, 9602, 0));
        this.faladorCastle1 = new Zone(new WorldPoint(2954, 3328, 1), new WorldPoint(2997, 3353, 1));
        this.dwarvenMine = new Zone(new WorldPoint(2979, 9855, 0), new WorldPoint(3069, 9698, 0));
        this.motherlodeMine = new Zone(new WorldPoint(3712, 5695, 0), new WorldPoint(3780, 5636, 0));
        this.portSarimJail1 = new Zone(new WorldPoint(3009, 3197, 1), new WorldPoint(3021, 3178, 1));
    }

    public void setupSteps() {
        this.fillWater = new ObjectStep((QuestHelper)this, 24004, new WorldPoint(2947, 3382, 0), "Use the bucket on the Waterpump outside the Hairdressers in west Falador.", this.bucket.highlighted());
        this.fillWater.addIcon(1925);
        this.getHaircut = new NpcStep((QuestHelper)this, 1305, new WorldPoint(2945, 3380, 0), "Visit the hairdresser in west Falador for a well deserved shave.", this.coins2000);
        this.getHaircut.addDialogStep("Go Ahead.");
        this.climbWall = new ObjectStep((QuestHelper)this, 24222, new WorldPoint(2935, 3355, 0), "Climb over the Crumbled Wall west of the West Falador Bank.", new Requirement[0]);
        this.killDuck = new NpcStep((QuestHelper)this, 1839, new WorldPoint(2989, 3379, 0), "Kill a Duck (Level 1) in the Falador Park", true, this.combatGear);
        this.killDuck.addAlternateNpcs(1838);
        this.enterDwarvenMines = new ObjectStep((QuestHelper)this, 16664, new WorldPoint(3058, 3376, 0), "Enter the Dwarven Mines, you can get there quickly by going down the stairs near the Party Room.", this.pickaxe);
        this.enterDwarvenMines.addIcon(1275);
        this.enterCaveToMotherlodeMine = new ObjectStep((QuestHelper)this, 26654, new WorldPoint(3059, 9764, 0), "Go through the Cave entrance to the Motherlode Mines.", this.pickaxe);
        this.enterCaveToMotherlodeMine.addIcon(1275);
        this.fixMotherloadMine = new ObjectStep((QuestHelper)this, 26670, new WorldPoint(3743, 5662, 0), "Repair a broken strut on the Waterwheel in the Motherlode mine. It may take a few minutes for it to break.", this.hammer.highlighted());
        this.fixMotherloadMine.addIcon(2347);
        this.climbLadderWhiteKnightCastle = new ObjectStep((QuestHelper)this, 24070, new WorldPoint(2994, 3341, 0), "Climb the ladder in The White Knights Castle!", new Requirement[0]);
        this.discoverFamilyCrest = new NpcStep((QuestHelper)this, 3100, new WorldPoint(2982, 3341, 1), "Speak to Sir Renitee to find out your family crest.", new Requirement[0]);
        this.discoverFamilyCrest.addDialogStep("I don't know, what can you do for me?");
        this.discoverFamilyCrest.addDialogStep("Can you see if I have a family crest?");
        this.discoverFamilyCrest.addDialogStep("Thanks!");
        this.browseSarahFarmingShop = new NpcStep((QuestHelper)this, 501, new WorldPoint(3039, 3292, 0), "Trade Sarah in the Farming Shop south of Falador and browse her goods.", new Requirement[0]);
        this.goEntrana = new NpcStep((QuestHelper)this, 1165, new WorldPoint(3046, 3235, 0), "Deposit all your combat gear and talk to the Monk of Entrana in Port Sarim to take the boat.", new Requirement[0]);
        this.goEntrana.addDialogStep("Yes, okay, I'm ready to go.");
        this.climbLadderPortSarimJail = new ObjectStep((QuestHelper)this, 9558, new WorldPoint(3010, 3184, 0), "Climb in the Port Sarim Jail to speak to the Security Guard.", new Requirement[0]);
        this.getSecurityBook = new NpcStep((QuestHelper)this, 5442, new WorldPoint(3013, 3192, 1), "Speak to the Security Guard in the Port Sarim Jail to get a Security Book.", new Requirement[0]);
        this.getPickaxe = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2963, 3216, 0), "Get a pickaxe in Rimmington if you do not have one.", new Requirement[0]);
        this.enterDungeon = new ObjectStep((QuestHelper)this, 1738, new WorldPoint(3008, 3150, 0), "Go down the ladder south of Port Sarim. Be prepared for ice giants and ice warriors to attack you.", this.pickaxe, this.hammer);
        this.mineBlurite = new ObjectStep((QuestHelper)this, 11378, new WorldPoint(3049, 9566, 0), "Mine a blurite ore in the eastern cavern.", this.pickaxe, this.hammer);
        this.smeltBlurite = new ObjectStep((QuestHelper)this, 24009, new WorldPoint(2976, 3369, 0), "Smelt the blurite ore into a blurite bar.", this.hammer, this.bluriteOre);
        this.smeltBlurite.addWidgetHighlightWithItemIdRequirement(270, 15, 9467, true);
        this.smithBluriteLimbs = new ObjectStep((QuestHelper)this, 2031, new WorldPoint(2950, 3451, 0), "Smith the blurite bar into blurite limbs on Doric's Anvil, north of Falador.", this.hammer, this.bluriteBar);
        this.smithBluriteLimbs.addSubSteps(this.enterDungeon, this.mineBlurite, this.smeltBlurite);
        this.smithBluriteLimbs.addWidgetHighlightWithItemIdRequirement(270, 13, 9422, true);
        this.enterMindAltar = new ObjectStep((QuestHelper)this, 29094, new WorldPoint(2982, 3514, 0), "Use the mind talisman on the Mysterious Ruins to access the Mind Altar.", this.mindTalisman.highlighted(), this.tiara);
        this.getMindTiara = new ObjectStep((QuestHelper)this, 34761, new WorldPoint(2786, 4841, 0), "Use the mind talisman on the Altar", this.mindTalisman.highlighted(), this.tiara);
        this.getMindTiara.addIcon(1448);
        this.enterMindAltar.addSubSteps(this.getMindTiara);
        this.claimReward = new NpcStep((QuestHelper)this, 5524, new WorldPoint(2977, 3346, 0), "Congratulations! Talk to Sir Rebral in the courtyard of The White Knight Castle to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins2000, this.pickaxe, this.hammer, this.bucket, this.tiara, this.mindTalisman, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.teleportFalador, this.teleportMindAltar, this.explorersRing);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 5, true));
        req.add(new SkillRequirement(Skill.CONSTRUCTION, 16));
        req.add(new SkillRequirement(Skill.MINING, 10, true));
        req.add(new SkillRequirement(Skill.SMITHING, 13, true));
        req.add(this.doricsQuest);
        req.add(this.knightSword);
        req.add(new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED));
        return req;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Falador Shield (1)", 13117, 1), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Tight-gap shortcut to the Chaos Temple from Burthorpe."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails fillBucketSteps = new PanelDetails("Fill Water Bucket", Collections.singletonList(this.fillWater), this.bucket);
        fillBucketSteps.setDisplayCondition(this.notFilledWater);
        fillBucketSteps.setLockingStep(this.filledWaterTask);
        allSteps.add(fillBucketSteps);
        PanelDetails haircutSteps = new PanelDetails("Get A Haircut", Collections.singletonList(this.getHaircut), this.coins2000);
        haircutSteps.setDisplayCondition(this.notGotHaircut);
        haircutSteps.setLockingStep(this.gotHaircutTask);
        allSteps.add(haircutSteps);
        PanelDetails westWallSteps = new PanelDetails("Climb West Wall", Collections.singletonList(this.climbWall), new SkillRequirement(Skill.AGILITY, 5, true));
        westWallSteps.setDisplayCondition(this.notClimbedWall);
        westWallSteps.setLockingStep(this.climbedWallTask);
        allSteps.add(westWallSteps);
        PanelDetails duckSteps = new PanelDetails("Kill The Duck", Collections.singletonList(this.killDuck), this.combatGear);
        duckSteps.setDisplayCondition(this.notKilledDuck);
        duckSteps.setLockingStep(this.killedDuckTask);
        allSteps.add(duckSteps);
        PanelDetails motherlodeRepairsSteps = new PanelDetails("Motherlode Repairs", Arrays.asList(this.enterDwarvenMines, this.enterCaveToMotherlodeMine, this.fixMotherloadMine), this.pickaxe, this.hammer);
        motherlodeRepairsSteps.setDisplayCondition(this.notMotherloadMine);
        motherlodeRepairsSteps.setLockingStep(this.motherloadMineTask);
        allSteps.add(motherlodeRepairsSteps);
        PanelDetails sarahsFarmingSteps = new PanelDetails("Sarah's Farming Shop", Collections.singletonList(this.browseSarahFarmingShop), new Requirement[0]);
        sarahsFarmingSteps.setDisplayCondition(this.notSarahFarmingShop);
        sarahsFarmingSteps.setLockingStep(this.sarahFarmingShopTask);
        allSteps.add(sarahsFarmingSteps);
        PanelDetails holyLandSteps = new PanelDetails("To the Holy Land!", Collections.singletonList(this.goEntrana), new Requirement[0]);
        holyLandSteps.setDisplayCondition(this.notEntrana);
        holyLandSteps.setLockingStep(this.entranaTask);
        allSteps.add(holyLandSteps);
        PanelDetails securityBookSteps = new PanelDetails("Get A Security Book", Arrays.asList(this.climbLadderPortSarimJail, this.getSecurityBook), new Requirement[0]);
        securityBookSteps.setDisplayCondition(this.notGotSecurityBook);
        securityBookSteps.setLockingStep(this.gotSecurityBookTask);
        allSteps.add(securityBookSteps);
        PanelDetails bluriteLimbsSteps = new PanelDetails("Blurite Limbs", Arrays.asList(this.getPickaxe, this.enterDungeon, this.mineBlurite, this.smeltBlurite, this.smithBluriteLimbs), this.doricsQuest, this.knightSword, new SkillRequirement(Skill.MINING, 10, true), new SkillRequirement(Skill.SMITHING, 13, true), this.hammer, this.pickaxe);
        bluriteLimbsSteps.setDisplayCondition(this.notBluriteLimbs);
        bluriteLimbsSteps.setLockingStep(this.bluriteLimbsTask);
        allSteps.add(bluriteLimbsSteps);
        PanelDetails mindTiaraSteps = new PanelDetails("Mind Tiara", Arrays.asList(this.enterMindAltar, this.getMindTiara), new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED), this.tiara, this.mindTalisman);
        mindTiaraSteps.setDisplayCondition(this.notMindTiara);
        mindTiaraSteps.setLockingStep(this.mindTiaraTask);
        allSteps.add(mindTiaraSteps);
        PanelDetails familyCrestSteps = new PanelDetails("Family Crest", Arrays.asList(this.climbLadderWhiteKnightCastle, this.discoverFamilyCrest), new SkillRequirement(Skill.CONSTRUCTION, 16));
        familyCrestSteps.setDisplayCondition(this.notFamilyCrest);
        familyCrestSteps.setLockingStep(this.familyCrestTask);
        allSteps.add(familyCrestSteps);
        PanelDetails finishOffSteps = new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]);
        allSteps.add(finishOffSteps);
        return allSteps;
    }
}

