/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.desert;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.IronmanRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import com.questhelper.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DESERT_MEDIUM)
public class DesertMedium
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement coins;
    ItemRequirement rope;
    ItemRequirement smallFishingNet;
    ItemRequirement axe;
    ItemRequirement lightSource;
    ItemRequirement scrollOfRedir;
    ItemRequirement teleToHouse;
    ItemRequirement harraPot;
    ItemRequirement goatHornDust;
    ItemRequirement camulet;
    ItemRequirement iceCooler;
    ItemRequirement food;
    ItemRequirement desertBoots;
    ItemRequirement desertRobe;
    ItemRequirement desertShirt;
    ItemRequirement waterskin;
    Requirement theGolem;
    Requirement eaglesPeak;
    Requirement spiritsOfTheElid;
    Requirement enakhrasLament;
    Requirement notAgiPyramid;
    Requirement notDesertLizard;
    Requirement notOrangeSally;
    Requirement notPhoenixFeather;
    Requirement notMagicCarpet;
    Requirement notEagleTravel;
    Requirement notPrayElidinis;
    Requirement notCombatPot;
    Requirement notTPEnakhra;
    Requirement notIronman;
    Requirement notVisitGenie;
    Requirement notTPPollnivneach;
    Requirement notChopTeak;
    Requirement talkedToSimon;
    QuestStep claimReward;
    QuestStep agiPyramid;
    QuestStep orangeSally;
    QuestStep phoenixFeather;
    QuestStep magicCarpet;
    QuestStep eagleTravel;
    QuestStep prayElidinis;
    QuestStep combatPot;
    QuestStep tpEnakhra;
    QuestStep visitGenie;
    QuestStep tpPollnivneach;
    QuestStep chopTeak;
    QuestStep moveToEagle;
    QuestStep moveToDesert;
    QuestStep moveToGenie;
    QuestStep moveToPyramid;
    QuestStep talkToSimon;
    NpcStep desertLizard;
    Zone desert;
    Zone eagleArea;
    Zone genie;
    Zone pyramid;
    ZoneRequirement inDesert;
    ZoneRequirement inEagleArea;
    ZoneRequirement inGenie;
    ZoneRequirement inPyramid;
    ConditionalStep agiPyramidTask;
    ConditionalStep desertLizardTask;
    ConditionalStep orangeSallyTask;
    ConditionalStep phoenixFeatherTask;
    ConditionalStep magicCarpetTask;
    ConditionalStep eagleTravelTask;
    ConditionalStep prayElidinisTask;
    ConditionalStep combatPotTask;
    ConditionalStep tpEnakhraTask;
    ConditionalStep visitGenieTask;
    ConditionalStep tpPollnivneachTask;
    ConditionalStep chopTeakTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doMedium = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.combatPotTask = new ConditionalStep((QuestHelper)this, this.moveToDesert, new Requirement[0]);
        this.combatPotTask.addStep(this.inDesert, this.combatPot);
        doMedium.addStep(this.notCombatPot, this.combatPotTask);
        this.phoenixFeatherTask = new ConditionalStep((QuestHelper)this, this.phoenixFeather, new Requirement[0]);
        doMedium.addStep(this.notPhoenixFeather, this.phoenixFeatherTask);
        this.orangeSallyTask = new ConditionalStep((QuestHelper)this, this.orangeSally, new Requirement[0]);
        doMedium.addStep(this.notOrangeSally, this.orangeSallyTask);
        this.magicCarpetTask = new ConditionalStep((QuestHelper)this, this.magicCarpet, new Requirement[0]);
        doMedium.addStep(this.notMagicCarpet, this.magicCarpetTask);
        this.chopTeakTask = new ConditionalStep((QuestHelper)this, this.chopTeak, new Requirement[0]);
        doMedium.addStep(this.notChopTeak, this.chopTeakTask);
        this.desertLizardTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.desertLizard, new Requirement[0]);
        doMedium.addStep(this.notDesertLizard, this.desertLizardTask);
        this.prayElidinisTask = new ConditionalStep((QuestHelper)this, this.prayElidinis, new Requirement[0]);
        doMedium.addStep(this.notPrayElidinis, this.prayElidinisTask);
        this.visitGenieTask = new ConditionalStep((QuestHelper)this, this.moveToGenie, new Requirement[0]);
        this.visitGenieTask.addStep(this.inGenie, this.visitGenie);
        doMedium.addStep(this.notVisitGenie, this.visitGenieTask);
        this.agiPyramidTask = new ConditionalStep((QuestHelper)this, this.moveToPyramid, new Requirement[0]);
        this.agiPyramidTask.addStep(new Conditions(this.inPyramid, this.talkedToSimon), this.agiPyramid);
        this.agiPyramidTask.addStep(this.inPyramid, this.talkToSimon);
        doMedium.addStep(this.notAgiPyramid, this.agiPyramidTask);
        this.tpEnakhraTask = new ConditionalStep((QuestHelper)this, this.tpEnakhra, new Requirement[0]);
        doMedium.addStep(this.notTPEnakhra, this.tpEnakhraTask);
        this.eagleTravelTask = new ConditionalStep((QuestHelper)this, this.moveToEagle, new Requirement[0]);
        this.eagleTravelTask.addStep(this.inEagleArea, this.eagleTravel);
        doMedium.addStep(this.notEagleTravel, this.eagleTravelTask);
        this.tpPollnivneachTask = new ConditionalStep((QuestHelper)this, this.tpPollnivneach, new Requirement[0]);
        doMedium.addStep(this.notTPPollnivneach, this.tpPollnivneachTask);
        return doMedium;
    }

    @Override
    public void setupRequirements() {
        this.notAgiPyramid = new VarplayerRequirement(1198, false, 12);
        this.notDesertLizard = new VarplayerRequirement(1198, false, 13);
        this.notOrangeSally = new VarplayerRequirement(1198, false, 14);
        this.notPhoenixFeather = new VarplayerRequirement(1198, false, 15);
        this.notMagicCarpet = new VarplayerRequirement(1198, false, 16);
        this.notEagleTravel = new VarplayerRequirement(1198, false, 17);
        this.notPrayElidinis = new VarplayerRequirement(1198, false, 18);
        this.notCombatPot = new VarplayerRequirement(1198, false, 19);
        this.notTPEnakhra = new VarplayerRequirement(1198, false, 20);
        this.notVisitGenie = new VarplayerRequirement(1198, false, 21);
        this.notTPPollnivneach = new VarplayerRequirement(1198, false, 22);
        this.notChopTeak = new VarplayerRequirement(1198, false, 23);
        this.notIronman = new IronmanRequirement(false);
        this.talkedToSimon = new VarbitRequirement(1558, 1, Operation.EQUAL);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notMagicCarpet);
        this.rope = new ItemRequirement("Rope", 954).showConditioned(new Conditions(LogicType.OR, this.notOrangeSally, this.notEagleTravel, this.notVisitGenie)).isNotConsumed();
        this.smallFishingNet = new ItemRequirement("Small fishing net", 303).showConditioned(this.notOrangeSally).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).showConditioned(this.notChopTeak).isNotConsumed();
        this.lightSource = new ItemRequirement("Light source", ItemCollections.LIGHT_SOURCES).showConditioned(this.notVisitGenie).isNotConsumed();
        this.scrollOfRedir = new ItemRequirement("Scroll of redirection", 11740).showConditioned(new Conditions(this.notTPPollnivneach, this.notIronman));
        this.teleToHouse = new ItemRequirement("Teleport to house", 8013).showConditioned(new Conditions(this.notTPPollnivneach, this.notIronman));
        this.harraPot = new ItemRequirement("Harralander potion (unf)", 97).showConditioned(this.notCombatPot);
        this.goatHornDust = new ItemRequirement("Goat horn dust", 9736).showConditioned(this.notCombatPot);
        this.camulet = new ItemRequirement("Camulet", 6707).showConditioned(this.notTPEnakhra);
        this.iceCooler = new ItemRequirement("Ice cooler (bring multiple just in case)", 6696).showConditioned(this.notDesertLizard);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.desertBoots = new ItemRequirement("Desert boots", 1837).isNotConsumed();
        this.desertRobe = new ItemRequirement("Desert robe", 1835).isNotConsumed();
        this.desertShirt = new ItemRequirement("Desert shirt", 1833).isNotConsumed();
        this.waterskin = new ItemRequirement("Waterskin", ItemCollections.WATERSKIN).isNotConsumed();
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inDesert = new ZoneRequirement(this.desert);
        this.inEagleArea = new ZoneRequirement(this.eagleArea);
        this.inGenie = new ZoneRequirement(this.genie);
        this.inPyramid = new ZoneRequirement(this.pyramid);
        this.theGolem = new QuestRequirement(QuestHelperQuest.THE_GOLEM, QuestState.FINISHED);
        this.eaglesPeak = new QuestRequirement(QuestHelperQuest.EAGLES_PEAK, QuestState.FINISHED);
        this.spiritsOfTheElid = new QuestRequirement(QuestHelperQuest.SPIRITS_OF_THE_ELID, QuestState.FINISHED);
        this.enakhrasLament = new QuestRequirement(QuestHelperQuest.ENAKHRAS_LAMENT, QuestState.FINISHED);
    }

    public void loadZones() {
        this.desert = new Zone(new WorldPoint(3127, 3115, 0), new WorldPoint(3519, 2749, 0));
        this.eagleArea = new Zone(new WorldPoint(1986, 4985, 3), new WorldPoint(2030, 4944, 3));
        this.genie = new Zone(new WorldPoint(3367, 9324, 0), new WorldPoint(3378, 9298, 0));
        this.pyramid = new Zone(new WorldPoint(3334, 2861, 0), new WorldPoint(3384, 2820, 0));
    }

    public void setupSteps() {
        this.moveToEagle = new ObjectStep((QuestHelper)this, 19790, new WorldPoint(2329, 3495, 0), "Enter the cave at the top of Eagles' Peak. You can use a fairy ring to (AKQ), then head south to get there easily.", new Requirement[0]);
        this.eagleTravel = new NpcStep((QuestHelper)this, 1487, new WorldPoint(2027, 4964, 3), "Use a rope on the Desert Eagle to travel to the Desert area.", this.rope.highlighted());
        this.magicCarpet = new NpcStep((QuestHelper)this, 17, new WorldPoint(3310, 3108, 0), "Talk to the rug merchant and travel to Uzer.", this.coins.quantity(200));
        this.magicCarpet.addDialogSteps("Yes please.", "I want to travel to Uzer.", "Uzer");
        this.phoenixFeather = new NpcStep((QuestHelper)this, 5137, new WorldPoint(3417, 3154, 0), "Pluck a feather from a Desert Phoenix.", new Requirement[0]);
        this.orangeSally = new ObjectStep((QuestHelper)this, 8732, new WorldPoint(3404, 3134, 0), "Setup a net trap and catch an Orange Salamander in the Uzer hunting area.", this.rope, this.smallFishingNet);
        this.combatPot = new ItemStep((QuestHelper)this, "Create a combat potion in the desert. Note: Do not be within a city.", this.harraPot.highlighted(), this.goatHornDust.highlighted());
        this.moveToDesert = new TileStep((QuestHelper)this, new WorldPoint(3305, 3112, 0), "Enter the desert and be out of any city limits (You must be losing health or water from the heat).", new Requirement[0]);
        this.chopTeak = new ObjectStep((QuestHelper)this, 9036, new WorldPoint(3510, 3073, 0), "Chop some teak logs near Uzer.", this.axe);
        this.desertLizard = new NpcStep((QuestHelper)this, 462, new WorldPoint(3437, 3067, 0), "Use an Ice cooler on a low hp Lizard in the desert.", this.iceCooler, this.combatGear);
        this.prayElidinis = new ObjectStep((QuestHelper)this, 10439, new WorldPoint(3427, 2930, 0), "Pray at the Elidinis Statuette in Nardah. If it doesn't complete expend some prayer points then try again.", new Requirement[0]);
        this.visitGenie = new NpcStep((QuestHelper)this, 4738, new WorldPoint(3371, 9320, 0), "Visit the genie.", new Requirement[0]);
        this.moveToGenie = new ObjectStep((QuestHelper)this, 10478, new WorldPoint(3374, 2904, 0), "Climb down the crevice west of Nardah.", this.rope, this.lightSource);
        this.talkToSimon = new NpcStep((QuestHelper)this, 5786, new WorldPoint(3346, 2827, 0), "Talk to Simon Templeton.", new Requirement[0]);
        this.moveToPyramid = new ObjectStep((QuestHelper)this, 11948, new WorldPoint(3335, 2829, 0), "Go to the Agility Pyramid.", new Requirement[0]);
        this.agiPyramid = new ObjectStep((QuestHelper)this, 10857, new WorldPoint(3355, 2832, 0), "Climb the Agility Pyramid and collect the pyramid top. Be sure to click continue in the dialog.", new Requirement[0]);
        this.tpEnakhra = new DetailedQuestStep((QuestHelper)this, "Teleport to Enakhra's Temple with the Camulet.", this.camulet);
        this.tpPollnivneach = Utils.getAccountType(this.client).isAnyIronman() ? new DetailedQuestStep((QuestHelper)this, "Move your house to Pollnivneach, then enter your house there.", this.coins.quantity(7500)) : new DetailedQuestStep((QuestHelper)this, "Teleport to Pollnivneach with a redirected house tablet.", this.scrollOfRedir, this.teleToHouse);
        this.claimReward = new NpcStep((QuestHelper)this, 5520, new WorldPoint(3303, 3124, 0), "Talk to Jarr at the Shantay pass to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.coins.quantity(200), this.rope, this.smallFishingNet, this.axe, this.lightSource, this.scrollOfRedir, this.teleToHouse, this.harraPot, this.goatHornDust, this.camulet, this.iceCooler);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.desertBoots, this.desertRobe, this.desertShirt, this.waterskin);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 30));
        reqs.add(new SkillRequirement(Skill.CONSTRUCTION, 20));
        reqs.add(new SkillRequirement(Skill.HERBLORE, 36));
        reqs.add(new SkillRequirement(Skill.HUNTER, 47));
        reqs.add(new SkillRequirement(Skill.SLAYER, 22));
        reqs.add(new SkillRequirement(Skill.THIEVING, 25));
        reqs.add(new SkillRequirement(Skill.WOODCUTTING, 35));
        reqs.add(this.theGolem);
        reqs.add(this.eaglesPeak);
        reqs.add(this.spiritsOfTheElid);
        reqs.add(this.enakhrasLament);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Kill a Desert lizard (lvl 24)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Desert amulet 2", 13134, 1), new ItemReward("7,500 Exp. Lamp (Any skill over 40)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Pharaoh's sceptre can hold up to 25 charges"), new UnlockReward("One teleport to Nardah per day on desert amulet"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails combatPotionSteps = new PanelDetails("Combat Potion", Arrays.asList(this.moveToDesert, this.combatPot), new SkillRequirement(Skill.HERBLORE, 36), this.harraPot, this.goatHornDust);
        combatPotionSteps.setDisplayCondition(this.notCombatPot);
        combatPotionSteps.setLockingStep(this.combatPotTask);
        allSteps.add(combatPotionSteps);
        PanelDetails phoenixFeatherSteps = new PanelDetails("Phoenix Feather", Collections.singletonList(this.phoenixFeather), new SkillRequirement(Skill.THIEVING, 25));
        phoenixFeatherSteps.setDisplayCondition(this.notPhoenixFeather);
        phoenixFeatherSteps.setLockingStep(this.phoenixFeatherTask);
        allSteps.add(phoenixFeatherSteps);
        PanelDetails orangeSalamanderSteps = new PanelDetails("Orange Salamander", Collections.singletonList(this.orangeSally), new SkillRequirement(Skill.HUNTER, 47), this.rope, this.smallFishingNet);
        orangeSalamanderSteps.setDisplayCondition(this.notOrangeSally);
        orangeSalamanderSteps.setLockingStep(this.orangeSallyTask);
        allSteps.add(orangeSalamanderSteps);
        PanelDetails magicCarpetSteps = new PanelDetails("Magic Carpet to Uzer", Collections.singletonList(this.magicCarpet), this.theGolem, this.coins.quantity(200));
        magicCarpetSteps.setDisplayCondition(this.notMagicCarpet);
        magicCarpetSteps.setLockingStep(this.magicCarpetTask);
        allSteps.add(magicCarpetSteps);
        PanelDetails chopTeakAtUzerSteps = new PanelDetails("Chop Teak at Uzer", Collections.singletonList(this.chopTeak), new SkillRequirement(Skill.WOODCUTTING, 35), this.axe);
        chopTeakAtUzerSteps.setDisplayCondition(this.notChopTeak);
        chopTeakAtUzerSteps.setLockingStep(this.chopTeakTask);
        allSteps.add(chopTeakAtUzerSteps);
        PanelDetails desertLizardSteps = new PanelDetails("Desert Lizard", Collections.singletonList(this.desertLizard), this.combatGear, this.iceCooler);
        desertLizardSteps.setDisplayCondition(this.notDesertLizard);
        desertLizardSteps.setLockingStep(this.desertLizardTask);
        allSteps.add(desertLizardSteps);
        PanelDetails elidinisStatuetteSteps = new PanelDetails("Pray at Elidinis Statuette", Collections.singletonList(this.prayElidinis), this.spiritsOfTheElid);
        elidinisStatuetteSteps.setDisplayCondition(this.notPrayElidinis);
        elidinisStatuetteSteps.setLockingStep(this.prayElidinisTask);
        allSteps.add(elidinisStatuetteSteps);
        PanelDetails visitTheGenieSteps = new PanelDetails("Visit the Genie", Arrays.asList(this.moveToGenie, this.visitGenie), this.spiritsOfTheElid, this.rope, this.lightSource);
        visitTheGenieSteps.setDisplayCondition(this.notVisitGenie);
        visitTheGenieSteps.setLockingStep(this.visitGenieTask);
        allSteps.add(visitTheGenieSteps);
        PanelDetails agilityPyramidSteps = new PanelDetails("Agility Pyramid", Arrays.asList(this.moveToPyramid, this.talkToSimon, this.agiPyramid), new SkillRequirement(Skill.AGILITY, 30));
        agilityPyramidSteps.setDisplayCondition(this.notAgiPyramid);
        agilityPyramidSteps.setLockingStep(this.agiPyramidTask);
        allSteps.add(agilityPyramidSteps);
        PanelDetails tpEnakhraSteps = new PanelDetails("Camulet to Enakhra's Temple", Collections.singletonList(this.tpEnakhra), this.enakhrasLament, this.camulet);
        tpEnakhraSteps.setDisplayCondition(this.notTPEnakhra);
        tpEnakhraSteps.setLockingStep(this.tpEnakhraTask);
        allSteps.add(tpEnakhraSteps);
        PanelDetails eagleSteps = new PanelDetails("Eagle Travel to Desert", Arrays.asList(this.moveToEagle, this.eagleTravel), this.rope);
        eagleSteps.setDisplayCondition(this.notEagleTravel);
        eagleSteps.setLockingStep(this.eagleTravelTask);
        allSteps.add(eagleSteps);
        PanelDetails teleportToPollnivneachSteps = new PanelDetails("Pollnivneach House", Collections.singletonList(this.tpPollnivneach), new SkillRequirement(Skill.CONSTRUCTION, 20), this.teleToHouse, this.scrollOfRedir);
        teleportToPollnivneachSteps.setDisplayCondition(this.notTPPollnivneach);
        teleportToPollnivneachSteps.setLockingStep(this.tpPollnivneachTask);
        allSteps.add(teleportToPollnivneachSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

