/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.desert;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DESERT_HARD)
public class DesertHard
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement blackjack;
    ItemRequirement pickaxe;
    ItemRequirement fireRune;
    ItemRequirement waterRune;
    ItemRequirement astralRune;
    ItemRequirement emptyWaterskin;
    ItemRequirement slayerHelm;
    ItemRequirement keris;
    ItemRequirement lightsource;
    ItemRequirement yewLog;
    ItemRequirement tinderbox;
    ItemRequirement mithBar;
    ItemRequirement hammer;
    ItemRequirement food;
    ItemRequirement waterskin;
    ItemRequirement desertBoots;
    ItemRequirement desertRobe;
    ItemRequirement desertShirt;
    ItemRequirement rope;
    ItemRequirement nardahTP;
    Requirement theFued;
    Requirement dreamMentor;
    Requirement desertTreasure;
    Requirement contact;
    Requirement lunarBook;
    Requirement notMenaThug;
    Requirement notGranite;
    Requirement notRefillWaterskin;
    Requirement notKalphQueen;
    Requirement notPollRooftop;
    Requirement notKillDust;
    Requirement notAncientMagicks;
    Requirement notKillLocustRider;
    Requirement notBurnYew;
    Requirement notMithPlatebody;
    QuestStep claimReward;
    QuestStep menaThug;
    QuestStep granite;
    QuestStep refillWaterskin;
    QuestStep pollRooftop;
    QuestStep killDust;
    QuestStep ancientMagicks;
    QuestStep burnYew;
    QuestStep mithPlatebody;
    QuestStep moveToSmoke;
    QuestStep moveToPyramid;
    QuestStep moveToMayor;
    QuestStep moveToSoph;
    QuestStep moveToSoph2;
    ObjectStep moveToKalph;
    ObjectStep kalphQueen;
    NpcStep killLocustRider;
    Zone kalph;
    Zone smoke;
    Zone soph1;
    Zone soph2;
    Zone pyramid;
    Zone mayor;
    ZoneRequirement inKalph;
    ZoneRequirement inSmoke;
    ZoneRequirement inPyramid;
    ZoneRequirement inSoph1;
    ZoneRequirement inSoph2;
    ZoneRequirement inMayor;
    ConditionalStep menaThugTask;
    ConditionalStep graniteTask;
    ConditionalStep refillWaterskinTask;
    ConditionalStep kalphQueenTask;
    ConditionalStep pollRooftopTask;
    ConditionalStep killDustTask;
    ConditionalStep ancientMagicksTask;
    ConditionalStep killLocustRiderTask;
    ConditionalStep burnYewTask;
    ConditionalStep mithPlatebodyTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.kalphQueenTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.moveToKalph, new Requirement[0]);
        this.kalphQueenTask.addStep(this.inKalph, this.kalphQueen);
        doHard.addStep(this.notKalphQueen, this.kalphQueenTask);
        this.pollRooftopTask = new ConditionalStep((QuestHelper)this, this.pollRooftop, new Requirement[0]);
        doHard.addStep(this.notPollRooftop, this.pollRooftopTask);
        this.menaThugTask = new ConditionalStep((QuestHelper)this, this.menaThug, new Requirement[0]);
        doHard.addStep(this.notMenaThug, this.menaThugTask);
        this.refillWaterskinTask = new ConditionalStep((QuestHelper)this, this.refillWaterskin, new Requirement[0]);
        doHard.addStep(this.notRefillWaterskin, this.refillWaterskinTask);
        this.killDustTask = new ConditionalStep((QuestHelper)this, this.moveToSmoke, new Requirement[0]);
        this.killDustTask.addStep(this.inSmoke, this.killDust);
        doHard.addStep(this.notKillDust, this.killDustTask);
        this.ancientMagicksTask = new ConditionalStep((QuestHelper)this, this.moveToPyramid, new Requirement[0]);
        this.ancientMagicksTask.addStep(this.inPyramid, this.ancientMagicks);
        doHard.addStep(this.notAncientMagicks, this.ancientMagicksTask);
        this.graniteTask = new ConditionalStep((QuestHelper)this, this.granite, new Requirement[0]);
        doHard.addStep(this.notGranite, this.graniteTask);
        this.burnYewTask = new ConditionalStep((QuestHelper)this, this.moveToMayor, new Requirement[0]);
        this.burnYewTask.addStep(this.inMayor, this.burnYew);
        doHard.addStep(this.notBurnYew, this.burnYewTask);
        this.mithPlatebodyTask = new ConditionalStep((QuestHelper)this, this.mithPlatebody, new Requirement[0]);
        doHard.addStep(this.notMithPlatebody, this.mithPlatebodyTask);
        this.killLocustRiderTask = new ConditionalStep((QuestHelper)this, this.moveToSoph, new Requirement[0]);
        this.killLocustRiderTask.addStep(this.inSoph1, this.moveToSoph2);
        this.killLocustRiderTask.addStep(this.inSoph2, this.killLocustRider);
        doHard.addStep(this.notKillLocustRider, this.killLocustRiderTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notMenaThug = new VarplayerRequirement(1198, false, 24);
        this.notGranite = new VarplayerRequirement(1198, false, 25);
        this.notRefillWaterskin = new VarplayerRequirement(1198, false, 26);
        this.notKalphQueen = new VarplayerRequirement(1198, false, 27);
        this.notPollRooftop = new VarplayerRequirement(1198, false, 28);
        this.notKillDust = new VarplayerRequirement(1198, false, 29);
        this.notAncientMagicks = new VarplayerRequirement(1198, false, 30);
        this.notKillLocustRider = new VarplayerRequirement(1198, false, 31);
        this.notBurnYew = new VarplayerRequirement(1199, false, 0);
        this.notMithPlatebody = new VarplayerRequirement(1199, false, 1);
        this.lunarBook = new SpellbookRequirement(Spellbook.LUNAR);
        this.blackjack = new ItemRequirement("Blackjack", ItemCollections.BLACKJACKS).showConditioned(this.notMenaThug).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).showConditioned(this.notGranite).isNotConsumed();
        this.fireRune = new ItemRequirement("Fire rune", 554).showConditioned(this.notRefillWaterskin);
        this.waterRune = new ItemRequirement("Water rune", 555).showConditioned(this.notRefillWaterskin);
        this.astralRune = new ItemRequirement("Astral rune", 9075).showConditioned(this.notRefillWaterskin);
        this.emptyWaterskin = new ItemRequirement("Empty waterskin", 1831).showConditioned(this.notRefillWaterskin).isNotConsumed();
        this.slayerHelm = new ItemRequirement("Slayer Helmet", ItemCollections.SLAYER_HELMETS).showConditioned(this.notKillDust).isNotConsumed();
        this.keris = new ItemRequirement("Keris", ItemCollections.KERIS).showConditioned(this.notKillLocustRider).isNotConsumed();
        this.lightsource = new ItemRequirement("Light source", ItemCollections.LIGHT_SOURCES).showConditioned(this.notKillLocustRider).isNotConsumed();
        this.yewLog = new ItemRequirement("Yew log", 1515).showConditioned(this.notBurnYew);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).showConditioned(this.notBurnYew).isNotConsumed();
        this.mithBar = new ItemRequirement("Mithril bar", 2359).showConditioned(this.notMithPlatebody);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notMithPlatebody).isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954).showConditioned(this.notKalphQueen);
        this.nardahTP = new ItemRequirement("Nardah teleport", 12402);
        this.desertBoots = new ItemRequirement("Desert boots", 1837).isNotConsumed();
        this.desertRobe = new ItemRequirement("Desert robe", 1835).isNotConsumed();
        this.desertShirt = new ItemRequirement("Desert shirt", 1833).isNotConsumed();
        this.waterskin = new ItemRequirement("Waterskin", ItemCollections.WATERSKIN).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inKalph = new ZoneRequirement(this.kalph);
        this.inSmoke = new ZoneRequirement(this.smoke);
        this.inPyramid = new ZoneRequirement(this.pyramid);
        this.inSoph1 = new ZoneRequirement(this.soph1);
        this.inSoph2 = new ZoneRequirement(this.soph2);
        this.inMayor = new ZoneRequirement(this.mayor);
        this.theFued = new QuestRequirement(QuestHelperQuest.THE_FEUD, QuestState.FINISHED);
        this.dreamMentor = new QuestRequirement(QuestHelperQuest.DREAM_MENTOR, QuestState.FINISHED);
        this.desertTreasure = new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.FINISHED);
        this.contact = new QuestRequirement(QuestHelperQuest.CONTACT, QuestState.FINISHED);
    }

    public void loadZones() {
        this.kalph = new Zone(new WorldPoint(3454, 9531, 0), new WorldPoint(3520, 9473, 2));
        this.smoke = new Zone(new WorldPoint(3166, 9408, 0), new WorldPoint(3332, 9344, 0));
        this.soph1 = new Zone(new WorldPoint(2792, 5174, 0), new WorldPoint(2807, 5158, 0));
        this.soph2 = new Zone(new WorldPoint(3264, 9281, 2), new WorldPoint(3327, 9216, 2));
        this.pyramid = new Zone(new WorldPoint(3199, 9340, 0), new WorldPoint(3265, 9282, 0));
        this.mayor = new Zone(new WorldPoint(3436, 2924, 1), new WorldPoint(3452, 2907, 1));
    }

    public void setupSteps() {
        this.moveToKalph = new ObjectStep((QuestHelper)this, 3827, new WorldPoint(3228, 3109, 0), "Use the rope on the entrance and enter the Kalphite Hive.", this.rope.highlighted().quantity(2));
        this.moveToKalph.addAlternateObjects(3828);
        this.moveToKalph.addIcon(954);
        this.kalphQueen = new ObjectStep((QuestHelper)this, 23609, new WorldPoint(3510, 9498, 2), "Climb down the tunnel entrance that leads to the Kalphite Queen and kill her.", this.rope);
        this.kalphQueen.addAlternateObjects(10230);
        this.kalphQueen.addIcon(954);
        this.pollRooftop = new ObjectStep((QuestHelper)this, 14935, new WorldPoint(3351, 2962, 0), "Climb on the basket and complete a lap of the Pollnivneach Rooftop course.", new Requirement[0]);
        this.menaThug = new NpcStep((QuestHelper)this, 3549, new WorldPoint(3347, 2959, 0), "Knockout and pickpocket a Menaphite thug.", this.blackjack);
        this.refillWaterskin = new ItemStep((QuestHelper)this, "Refill an empty waterskin using the Lunar spell Humidify in the Desert (You must be losing health or water from the heat).", this.lunarBook, this.fireRune.quantity(1), this.waterRune.quantity(3), this.astralRune.quantity(1));
        this.moveToSmoke = new ObjectStep((QuestHelper)this, 6279, new WorldPoint(3310, 2962, 0), "Go down the Smokey well.", new Requirement[0]);
        this.killDust = new NpcStep((QuestHelper)this, 423, new WorldPoint(3219, 9370, 0), "Kill a Dust devil with a slayer helm equipped.", this.slayerHelm.equipped());
        this.moveToPyramid = new ObjectStep((QuestHelper)this, 6481, new WorldPoint(3233, 2889, 0), "Enter the Jaldraocht Pyramid.", new Requirement[0]);
        this.ancientMagicks = new ObjectStep((QuestHelper)this, 6552, new WorldPoint(3233, 9311, 0), "Pray at the altar.", new Requirement[0]);
        this.granite = new ObjectStep((QuestHelper)this, 11387, new WorldPoint(3167, 2911, 0), "Mine granite in the mine south of the Bandit Camp.", this.pickaxe);
        this.moveToMayor = new ObjectStep((QuestHelper)this, 10525, new WorldPoint(3447, 2912, 0), "Climb the staircase in the Nardah Mayor's house.", new Requirement[0]);
        this.burnYew = new TileStep((QuestHelper)this, new WorldPoint(3440, 2913, 1), "Burn yew logs on the balcony. ", this.yewLog.highlighted(), this.tinderbox.highlighted());
        this.mithPlatebody = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(3409, 2921, 0), "Make a Mithril platebody in Nardah.", this.mithBar.quantity(5), this.hammer);
        this.moveToSoph = new ObjectStep((QuestHelper)this, 20275, new WorldPoint(3315, 2797, 0), "Climb down the ladder to enter the Sophanem Dungeon.", this.combatGear, this.lightsource);
        this.moveToSoph2 = new ObjectStep((QuestHelper)this, 20278, new WorldPoint(2800, 5159, 0), "Climb down the ladder again.", this.combatGear, this.lightsource);
        this.killLocustRider = new NpcStep((QuestHelper)this, 796, new WorldPoint(3296, 9267, 2), "Kill a Locust rider with keris.", true, this.combatGear, this.keris.equipped());
        this.killLocustRider.addAlternateNpcs(795, 800, 801);
        this.claimReward = new NpcStep((QuestHelper)this, 5520, new WorldPoint(3303, 3124, 0), "Talk to Jarr at the Shantay pass to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.blackjack, this.pickaxe, this.fireRune.quantity(1), this.waterRune.quantity(3), this.astralRune.quantity(1), this.emptyWaterskin, this.slayerHelm, this.keris, this.lightsource, this.yewLog, this.tinderbox, this.mithBar.quantity(5), this.hammer, this.rope.quantity(2));
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.waterskin, this.desertBoots, this.desertRobe, this.desertShirt, this.nardahTP);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 70));
        reqs.add(new SkillRequirement(Skill.ATTACK, 50));
        reqs.add(new SkillRequirement(Skill.DEFENCE, 10));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 60));
        reqs.add(new SkillRequirement(Skill.MAGIC, 68));
        reqs.add(new SkillRequirement(Skill.MINING, 45));
        reqs.add(new SkillRequirement(Skill.SMITHING, 68));
        reqs.add(new SkillRequirement(Skill.SLAYER, 65));
        reqs.add(new SkillRequirement(Skill.THIEVING, 65));
        reqs.add(this.contact);
        reqs.add(this.dreamMentor);
        reqs.add(this.desertTreasure);
        reqs.add(this.theFued);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Kill a Dust devil (lvl 93), Locust rider (lvl 98), Kalphite Queen (lvl 333)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Desert amulet 3", 13135, 1), new ItemReward("15,000 Exp. Lamp (Any skill over 50)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Pharaoh's sceptre can hold up to 50 charges"), new UnlockReward("Access to the big window shortcut in Al Kharid Palace that takes you to the south of the palace, just north of the Shantay Pass, requiring 70 Agility"), new UnlockReward("Unlocked the ability to toggle the Camulet teleport location between the inside and outside of Enakhra's Temple"), new UnlockReward("All carpet rides are free"), new UnlockReward("Zahur will create unfinished potions for 200 coins per potion from a vial of water and a clean herb. Items can be noted or unnoted"), new UnlockReward("Zahur will now clean noted grimy herbs for 200 coins each"), new UnlockReward("Ropes placed at both the Kalphite Lair entrance and the Kalphite Queen tunnel entrance become permanent"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails kalphiteQueenSteps = new PanelDetails("Kalphite Queen", Arrays.asList(this.moveToKalph, this.kalphQueen), this.combatGear, this.food, this.rope.quantity(2));
        kalphiteQueenSteps.setDisplayCondition(this.notKalphQueen);
        kalphiteQueenSteps.setLockingStep(this.kalphQueenTask);
        allSteps.add(kalphiteQueenSteps);
        PanelDetails pollRooftopSteps = new PanelDetails("Pollnivneach Rooftops", Collections.singletonList(this.pollRooftop), new SkillRequirement(Skill.AGILITY, 70));
        pollRooftopSteps.setDisplayCondition(this.notPollRooftop);
        pollRooftopSteps.setLockingStep(this.pollRooftopTask);
        allSteps.add(pollRooftopSteps);
        PanelDetails menaphiteThugSteps = new PanelDetails("Menaphite Thug", Collections.singletonList(this.menaThug), new SkillRequirement(Skill.THIEVING, 65), this.theFued, this.blackjack);
        menaphiteThugSteps.setDisplayCondition(this.notMenaThug);
        menaphiteThugSteps.setLockingStep(this.menaThugTask);
        allSteps.add(menaphiteThugSteps);
        PanelDetails refillWaterskinsSteps = new PanelDetails("Refill Waterskins", Collections.singletonList(this.refillWaterskin), new SkillRequirement(Skill.MAGIC, 68), this.dreamMentor, this.lunarBook, this.fireRune.quantity(1), this.waterRune.quantity(3), this.astralRune.quantity(1), this.emptyWaterskin);
        refillWaterskinsSteps.setDisplayCondition(this.notRefillWaterskin);
        refillWaterskinsSteps.setLockingStep(this.refillWaterskinTask);
        allSteps.add(refillWaterskinsSteps);
        PanelDetails dustDevilSteps = new PanelDetails("Dust Devil", Arrays.asList(this.moveToSmoke, this.killDust), new SkillRequirement(Skill.CRAFTING, 55), new SkillRequirement(Skill.DEFENCE, 10), new SkillRequirement(Skill.SLAYER, 65), this.desertTreasure, this.combatGear, this.food, this.slayerHelm);
        dustDevilSteps.setDisplayCondition(this.notKillDust);
        dustDevilSteps.setLockingStep(this.killDustTask);
        allSteps.add(dustDevilSteps);
        PanelDetails ancientMagicksSteps = new PanelDetails("Activate Ancient Magicks", Arrays.asList(this.moveToPyramid, this.ancientMagicks), this.desertTreasure);
        ancientMagicksSteps.setDisplayCondition(this.notAncientMagicks);
        ancientMagicksSteps.setLockingStep(this.ancientMagicksTask);
        allSteps.add(ancientMagicksSteps);
        PanelDetails mineGraniteSteps = new PanelDetails("Mine Granite", Collections.singletonList(this.granite), new SkillRequirement(Skill.MINING, 45), this.pickaxe);
        mineGraniteSteps.setDisplayCondition(this.notGranite);
        mineGraniteSteps.setLockingStep(this.graniteTask);
        allSteps.add(mineGraniteSteps);
        PanelDetails burnYewSteps = new PanelDetails("Burn Yew on Nardah Mayor's Balcony", Arrays.asList(this.moveToMayor, this.burnYew), new SkillRequirement(Skill.FIREMAKING, 60), this.yewLog, this.tinderbox);
        burnYewSteps.setDisplayCondition(this.notBurnYew);
        burnYewSteps.setLockingStep(this.burnYewTask);
        allSteps.add(burnYewSteps);
        PanelDetails mithrilPlatebodySteps = new PanelDetails("Mithril Platebody", Collections.singletonList(this.mithPlatebody), new SkillRequirement(Skill.SMITHING, 68), this.mithBar.quantity(5), this.hammer);
        mithrilPlatebodySteps.setDisplayCondition(this.notMithPlatebody);
        mithrilPlatebodySteps.setLockingStep(this.mithPlatebodyTask);
        allSteps.add(mithrilPlatebodySteps);
        PanelDetails locusRiderSteps = new PanelDetails("Kill Locus Rider with Keris", Arrays.asList(this.moveToSoph, this.killLocustRider), new SkillRequirement(Skill.ATTACK, 50), this.contact, this.keris, this.combatGear, this.lightsource, this.food);
        locusRiderSteps.setDisplayCondition(this.notKillLocustRider);
        locusRiderSteps.setLockingStep(this.killLocustRiderTask);
        allSteps.add(locusRiderSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

