/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.desert;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DESERT_ELITE)
public class DesertElite
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement rawPie;
    ItemRequirement waterRune;
    ItemRequirement bloodRune;
    ItemRequirement deathRune;
    ItemRequirement dragonDartTip;
    ItemRequirement feather;
    ItemRequirement mahoganyPlank;
    ItemRequirement goldLeaves;
    ItemRequirement coins;
    ItemRequirement saw;
    ItemRequirement hammer;
    ItemRequirement kqHead;
    ItemRequirement food;
    ItemRequirement pharaohSceptre;
    ItemRequirement desertRobe;
    ItemRequirement waterskin;
    ItemRequirement desertBoots;
    ItemRequirement desertShirt;
    Requirement desertTreasure;
    Requirement icthlarinsLittleHelper;
    Requirement touristTrap;
    Requirement priestInPeril;
    Requirement notWildPie;
    Requirement notIceBarrage;
    Requirement notDragonDarts;
    Requirement notTalkKQHead;
    Requirement notGrandGoldChest;
    Requirement notRestorePrayer;
    Requirement ancientBook;
    QuestStep claimReward;
    QuestStep wildPie;
    QuestStep dragonDarts;
    QuestStep talkKQHead;
    QuestStep grandGoldChest;
    QuestStep restorePrayer;
    QuestStep moveToPyramidPlunder;
    QuestStep startPyramidPlunder;
    QuestStep traversePyramid;
    QuestStep moveToBed;
    NpcStep iceBarrage;
    Zone bed;
    Zone pyramidPlunderLobby;
    Zone lastRoom;
    Zone pyramidRooms;
    ZoneRequirement inBed;
    ZoneRequirement inPyramidPlunderLobby;
    ZoneRequirement inPyramidRooms;
    ZoneRequirement inLastRoom;
    ConditionalStep wildPieTask;
    ConditionalStep iceBarrageTask;
    ConditionalStep dragonDartsTask;
    ConditionalStep talkKQHeadTask;
    ConditionalStep grandGoldChestTask;
    ConditionalStep restorePrayerTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.wildPieTask = new ConditionalStep((QuestHelper)this, this.wildPie, new Requirement[0]);
        doElite.addStep(this.notWildPie, this.wildPieTask);
        this.iceBarrageTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.iceBarrage, new Requirement[0]);
        doElite.addStep(this.notIceBarrage, this.iceBarrageTask);
        this.grandGoldChestTask = new ConditionalStep((QuestHelper)this, this.moveToPyramidPlunder, new Requirement[0]);
        this.grandGoldChestTask.addStep(this.inPyramidPlunderLobby, this.startPyramidPlunder);
        this.grandGoldChestTask.addStep(this.inPyramidRooms, this.traversePyramid);
        this.grandGoldChestTask.addStep(this.inLastRoom, this.grandGoldChest);
        doElite.addStep(this.notGrandGoldChest, this.grandGoldChestTask);
        this.restorePrayerTask = new ConditionalStep((QuestHelper)this, this.restorePrayer, new Requirement[0]);
        doElite.addStep(this.notRestorePrayer, this.restorePrayerTask);
        this.dragonDartsTask = new ConditionalStep((QuestHelper)this, this.moveToBed, new Requirement[0]);
        this.dragonDartsTask.addStep(this.inBed, this.dragonDarts);
        doElite.addStep(this.notDragonDarts, this.dragonDartsTask);
        this.talkKQHeadTask = new ConditionalStep((QuestHelper)this, this.talkKQHead, new Requirement[0]);
        doElite.addStep(this.notTalkKQHead, this.talkKQHeadTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notWildPie = new VarplayerRequirement(1199, false, 2);
        this.notIceBarrage = new VarplayerRequirement(1199, false, 4);
        this.notDragonDarts = new VarplayerRequirement(1199, false, 5);
        this.notTalkKQHead = new VarplayerRequirement(1199, false, 6);
        this.notGrandGoldChest = new VarplayerRequirement(1199, false, 7);
        this.notRestorePrayer = new VarplayerRequirement(1199, false, 8);
        this.ancientBook = new SpellbookRequirement(Spellbook.ANCIENT);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notTalkKQHead);
        this.rawPie = new ItemRequirement("Raw wild pie", 7206).showConditioned(this.notWildPie);
        this.waterRune = new ItemRequirement("Water rune", 555).showConditioned(this.notIceBarrage);
        this.bloodRune = new ItemRequirement("Blood rune", 565).showConditioned(this.notIceBarrage);
        this.deathRune = new ItemRequirement("Death rune", 560).showConditioned(this.notIceBarrage);
        this.dragonDartTip = new ItemRequirement("Dragon dart tip", 11232).showConditioned(this.notDragonDarts);
        this.feather = new ItemRequirement("Feather", 314).showConditioned(this.notDragonDarts);
        this.mahoganyPlank = new ItemRequirement("Mahogany plank", 8782).showConditioned(this.notTalkKQHead);
        this.goldLeaves = new ItemRequirement("Gold leaf", 8784).showConditioned(this.notTalkKQHead);
        this.saw = new ItemRequirement("Saw", 8794).showConditioned(this.notTalkKQHead).isNotConsumed();
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notTalkKQHead).isNotConsumed();
        this.kqHead = new ItemRequirement("Stuffed KQ head", ItemCollections.STUFFED_KQ_HEAD).showConditioned(this.notTalkKQHead);
        this.pharaohSceptre = new ItemRequirement("Pharaoh's sceptre", ItemCollections.PHAROAH_SCEPTRE).isNotConsumed();
        this.desertBoots = new ItemRequirement("Desert boots", 1837).isNotConsumed();
        this.desertRobe = new ItemRequirement("Desert robe", 1835).isNotConsumed();
        this.desertShirt = new ItemRequirement("Desert shirt", 1833).isNotConsumed();
        this.waterskin = new ItemRequirement("Waterskin", ItemCollections.WATERSKIN).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inBed = new ZoneRequirement(this.bed);
        this.inLastRoom = new ZoneRequirement(this.lastRoom);
        this.inPyramidPlunderLobby = new ZoneRequirement(this.pyramidPlunderLobby);
        this.inPyramidRooms = new ZoneRequirement(this.pyramidRooms);
        this.desertTreasure = new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.FINISHED);
        this.icthlarinsLittleHelper = new QuestRequirement(QuestHelperQuest.ICTHLARINS_LITTLE_HELPER, QuestState.IN_PROGRESS);
        this.touristTrap = new QuestRequirement(QuestHelperQuest.THE_TOURIST_TRAP, QuestState.FINISHED);
        this.priestInPeril = new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED);
    }

    public void loadZones() {
        this.bed = new Zone(new WorldPoint(3163, 3049, 0), new WorldPoint(3181, 3024, 0));
        this.pyramidPlunderLobby = new Zone(new WorldPoint(1926, 4465, 2), new WorldPoint(1976, 4419, 3));
        this.lastRoom = new Zone(new WorldPoint(1966, 4437, 0), new WorldPoint(1980, 4419, 0));
        this.pyramidRooms = new Zone(new WorldPoint(1922, 4417, 0), new WorldPoint(1984, 4480, 0));
    }

    public void setupSteps() {
        this.moveToPyramidPlunder = new ObjectStep((QuestHelper)this, 26622, new WorldPoint(3289, 2800, 0), "Enter the Pyramid plunder minigame. If you don't see a Guardian mummy exit and try a different entrance.", true, new Requirement[0]);
        ((ObjectStep)this.moveToPyramidPlunder).addAlternateObjects(26623, 26624, 26625);
        this.startPyramidPlunder = new NpcStep((QuestHelper)this, 1779, new WorldPoint(1934, 4427, 3), "Talk to the guardian mummy to start the minigame.", new Requirement[0]);
        this.startPyramidPlunder.addDialogStep("I know what I'm doing - let's get on with it.");
        this.traversePyramid = new ObjectStep((QuestHelper)this, 26618, new WorldPoint(1951, 4452, 0), "Go through each of the pyramid rooms until the final room.", true, new Requirement[0]);
        ((ObjectStep)this.traversePyramid).setMaxObjectDistance(40);
        ((ObjectStep)this.traversePyramid).setMaxRenderDistance(10);
        for (int i = 26619; i < 26651; ++i) {
            if (i == 26626) continue;
            ((ObjectStep)this.traversePyramid).addAlternateObjects(i);
        }
        this.grandGoldChest = new ObjectStep((QuestHelper)this, 20946, new WorldPoint(1973, 4431, 0), "Loot the grand gold chest.", true, new Requirement[0]);
        this.restorePrayer = new ObjectStep((QuestHelper)this, 20377, new WorldPoint(3281, 2774, 0), "Pray at the altar in Sophanem restoring at least 85 prayer points.", new Requirement[0]);
        this.iceBarrage = new NpcStep((QuestHelper)this, 1267, new WorldPoint(3334, 2865, 0), "Cast Ice barrage against any foe in the Desert (away from any city). You must not splash.", true, this.waterRune.quantity(6), this.bloodRune.quantity(2), this.deathRune.quantity(4));
        this.iceBarrage.addAlternateNpcs(1268);
        this.wildPie = new ObjectStep((QuestHelper)this, 10377, new WorldPoint(3434, 2886, 0), "Cook a wild pie on the clay oven in Nardah.", this.rawPie);
        this.moveToBed = new TileStep((QuestHelper)this, new WorldPoint(3175, 3041, 0), "Go to Bedabin Camp south-west of Al Kharid.", new Requirement[0]);
        this.dragonDarts = new ItemStep((QuestHelper)this, "Fletch a dragon dart.", this.dragonDartTip.highlighted(), this.feather.highlighted());
        this.talkKQHead = new DetailedQuestStep((QuestHelper)this, "Mount and then talk to a Kalphite Queen head in your POH. The 50k is necessary to stuff the KQ head at the taxidermist in Canifis.", this.kqHead, this.mahoganyPlank.quantity(2), this.goldLeaves.quantity(2), this.saw, this.hammer, this.coins.quantity(50000));
        this.claimReward = new NpcStep((QuestHelper)this, 5520, new WorldPoint(3303, 3124, 0), "Talk to Jarr at the Shantay pass to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.rawPie, this.waterRune.quantity(6), this.bloodRune.quantity(2), this.deathRune.quantity(4), this.dragonDartTip, this.feather, this.kqHead, this.mahoganyPlank.quantity(2), this.goldLeaves.quantity(2), this.coins.quantity(50000), this.saw, this.hammer, this.kqHead);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.pharaohSceptre, this.desertRobe, this.desertBoots, this.desertShirt, this.waterskin);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Desert amulet 4", 13136), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Unlimited teleports to Nardah and the Kalphite Cave on the desert amulet"), new UnlockReward("The Nardah teleport on the desert amulet now takes players directly inside the Elidinis shrine"), new UnlockReward("100% protection against desert heat when the desert amulet is worn"), new UnlockReward("Pharaoh's sceptre can hold up to 100 charges"), new UnlockReward("Free pass-through of the Shantay Pass"), new UnlockReward("Access to a crevice shortcut, requiring 86 Agility, in the Kalphite Lair from the entrance to the antechamber before the Kalphite Queen boss room."));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.CONSTRUCTION, 78));
        reqs.add(new SkillRequirement(Skill.COOKING, 85));
        reqs.add(new SkillRequirement(Skill.FLETCHING, 95));
        reqs.add(new SkillRequirement(Skill.MAGIC, 94));
        reqs.add(new SkillRequirement(Skill.PRAYER, 85));
        reqs.add(new SkillRequirement(Skill.THIEVING, 91));
        reqs.add(this.desertTreasure);
        reqs.add(this.icthlarinsLittleHelper);
        reqs.add(this.priestInPeril);
        reqs.add(this.touristTrap);
        return reqs;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails wildPieSteps = new PanelDetails("Bake Wild Pie", Collections.singletonList(this.wildPie), new SkillRequirement(Skill.COOKING, 85), this.rawPie);
        wildPieSteps.setDisplayCondition(this.notWildPie);
        wildPieSteps.setLockingStep(this.wildPieTask);
        allSteps.add(wildPieSteps);
        PanelDetails iceBarrageSteps = new PanelDetails("Ice Barrage", Collections.singletonList(this.iceBarrage), new SkillRequirement(Skill.MAGIC, 94), this.desertTreasure, this.ancientBook, this.waterRune.quantity(6), this.bloodRune.quantity(2), this.deathRune.quantity(4));
        iceBarrageSteps.setDisplayCondition(this.notIceBarrage);
        iceBarrageSteps.setLockingStep(this.iceBarrageTask);
        allSteps.add(iceBarrageSteps);
        PanelDetails grandGoldChestSteps = new PanelDetails("Grand Gold Chest", Arrays.asList(this.moveToPyramidPlunder, this.startPyramidPlunder, this.grandGoldChest), new SkillRequirement(Skill.THIEVING, 91), this.icthlarinsLittleHelper);
        grandGoldChestSteps.setDisplayCondition(this.notGrandGoldChest);
        grandGoldChestSteps.setLockingStep(this.grandGoldChestTask);
        allSteps.add(grandGoldChestSteps);
        PanelDetails restorePrayerSteps = new PanelDetails("Restore 85 Prayer", Collections.singletonList(this.restorePrayer), new SkillRequirement(Skill.PRAYER, 85), this.icthlarinsLittleHelper);
        restorePrayerSteps.setDisplayCondition(this.notRestorePrayer);
        restorePrayerSteps.setLockingStep(this.restorePrayerTask);
        allSteps.add(restorePrayerSteps);
        PanelDetails dragonDartsSteps = new PanelDetails("Dragon Darts", Arrays.asList(this.moveToBed, this.dragonDarts), new SkillRequirement(Skill.FLETCHING, 95), this.touristTrap, this.dragonDartTip, this.feather);
        dragonDartsSteps.setDisplayCondition(this.notDragonDarts);
        dragonDartsSteps.setLockingStep(this.dragonDartsTask);
        allSteps.add(dragonDartsSteps);
        PanelDetails kqHeadSteps = new PanelDetails("Kalphite Queen Head", Collections.singletonList(this.talkKQHead), new SkillRequirement(Skill.CONSTRUCTION, 78), this.priestInPeril, this.kqHead, this.coins.quantity(50000), this.mahoganyPlank.quantity(2), this.goldLeaves.quantity(2), this.saw, this.hammer);
        kqHeadSteps.setDisplayCondition(this.notTalkKQHead);
        kqHeadSteps.setLockingStep(this.talkKQHeadTask);
        allSteps.add(kqHeadSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

