/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.desert;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DESERT_EASY)
public class DesertEasy
extends ComplexStateQuestHelper {
    ItemRequirement coins;
    ItemRequirement shantayPass;
    ItemRequirement birdSnare;
    ItemRequirement pickaxe;
    ItemRequirement rope;
    ItemRequirement knife;
    ItemRequirement desertShirt;
    ItemRequirement desertRobe;
    ItemRequirement desertBoots;
    ItemRequirement grimyHerb;
    ItemRequirement pyramidPlunderArtefact;
    ItemRequirement emptyWaterskin;
    ItemRequirement potatoCacti;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement antipoison;
    ItemRequirement waterskin;
    ItemRequirement pharaohSceptre;
    ItemRequirement necklaceOfPassage;
    Requirement icthlarinsLittleHelper;
    Requirement notGoldWarbler;
    Requirement notFiveClay;
    Requirement notEnterKalph;
    Requirement notEnterDesert;
    Requirement notKillVulture;
    Requirement notNardahHerb;
    Requirement notCollectCacti;
    Requirement notSellArtefact;
    Requirement notOpenSarc;
    Requirement notCutCactus;
    Requirement notMagicCarpet;
    QuestStep claimReward;
    QuestStep goldWarbler;
    QuestStep fiveClay;
    QuestStep enterDesert;
    QuestStep nardahHerb;
    QuestStep collectCacti;
    QuestStep sellArtefact;
    QuestStep openSarc;
    QuestStep cutCactus;
    QuestStep magicCarpet;
    QuestStep moveToPyramidPlunder;
    QuestStep startPyramidPlunder;
    ObjectStep enterKalph;
    ObjectStep enterKalphForCacti;
    NpcStep killVulture;
    Zone pyramidPlunderLobby;
    Zone firstRoom;
    Zone kalphHive;
    ZoneRequirement inPyramidPlunderLobby;
    ZoneRequirement inFirstRoom;
    ZoneRequirement inKalphHive;
    ConditionalStep goldWarblerTask;
    ConditionalStep fiveClayTask;
    ConditionalStep enterKalphTask;
    ConditionalStep enterDesertTask;
    ConditionalStep killVultureTask;
    ConditionalStep nardahHerbTask;
    ConditionalStep collectCactiTask;
    ConditionalStep sellArtefactTask;
    ConditionalStep openSarcTask;
    ConditionalStep cutCactusTask;
    ConditionalStep magicCarpetTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.enterDesertTask = new ConditionalStep((QuestHelper)this, this.enterDesert, new Requirement[0]);
        doEasy.addStep(this.notEnterDesert, this.enterDesertTask);
        this.cutCactusTask = new ConditionalStep((QuestHelper)this, this.cutCactus, new Requirement[0]);
        doEasy.addStep(this.notCutCactus, this.cutCactusTask);
        this.enterKalphTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterKalph, new Requirement[0]);
        doEasy.addStep(this.notEnterKalph, this.enterKalphTask);
        this.collectCactiTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterKalphForCacti, new Requirement[0]);
        this.collectCactiTask.addStep(this.inKalphHive, this.collectCacti);
        doEasy.addStep(this.notCollectCacti, this.collectCactiTask);
        this.goldWarblerTask = new ConditionalStep((QuestHelper)this, this.goldWarbler, new Requirement[0]);
        doEasy.addStep(this.notGoldWarbler, this.goldWarblerTask);
        this.fiveClayTask = new ConditionalStep((QuestHelper)this, this.fiveClay, new Requirement[0]);
        doEasy.addStep(this.notFiveClay, this.fiveClayTask);
        this.magicCarpetTask = new ConditionalStep((QuestHelper)this, this.magicCarpet, new Requirement[0]);
        doEasy.addStep(this.notMagicCarpet, this.magicCarpetTask);
        this.nardahHerbTask = new ConditionalStep((QuestHelper)this, this.nardahHerb, new Requirement[0]);
        doEasy.addStep(this.notNardahHerb, this.nardahHerbTask);
        this.killVultureTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.killVulture, new Requirement[0]);
        doEasy.addStep(this.notKillVulture, this.killVultureTask);
        this.openSarcTask = new ConditionalStep((QuestHelper)this, this.moveToPyramidPlunder, new Requirement[0]);
        this.openSarcTask.addStep(this.inPyramidPlunderLobby, this.startPyramidPlunder);
        this.openSarcTask.addStep(this.inFirstRoom, this.openSarc);
        doEasy.addStep(this.notOpenSarc, this.openSarcTask);
        this.sellArtefactTask = new ConditionalStep((QuestHelper)this, this.sellArtefact, new Requirement[0]);
        doEasy.addStep(this.notSellArtefact, this.sellArtefactTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notGoldWarbler = new VarplayerRequirement(1198, false, 1);
        this.notFiveClay = new VarplayerRequirement(1198, false, 2);
        this.notEnterKalph = new VarplayerRequirement(1198, false, 3);
        this.notEnterDesert = new VarplayerRequirement(1198, false, 4);
        this.notKillVulture = new VarplayerRequirement(1198, false, 5);
        this.notNardahHerb = new VarplayerRequirement(1198, false, 6);
        this.notCollectCacti = new VarplayerRequirement(1198, false, 7);
        this.notSellArtefact = new VarplayerRequirement(1198, false, 8);
        this.notOpenSarc = new VarplayerRequirement(1198, false, 9);
        this.notCutCactus = new VarplayerRequirement(1198, false, 10);
        this.notMagicCarpet = new VarplayerRequirement(1198, false, 11);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(new Conditions(LogicType.OR, this.notNardahHerb, this.notMagicCarpet));
        this.potatoCacti = new ItemRequirement("Potato Cacti", 3138).showConditioned(this.notCollectCacti);
        this.rope = new ItemRequirement("Rope", 954).showConditioned(new Conditions(LogicType.OR, this.notEnterKalph, this.notCollectCacti));
        this.shantayPass = new ItemRequirement("Shantay pass", 1854).showConditioned(this.notEnterDesert);
        this.birdSnare = new ItemRequirement("Bird snare", 10006).showConditioned(this.notGoldWarbler).isNotConsumed();
        this.pickaxe = new ItemRequirement("Pickaxe", ItemCollections.PICKAXES).showConditioned(this.notFiveClay).isNotConsumed();
        this.knife = new ItemRequirement("Knife", 946).showConditioned(this.notCutCactus).isNotConsumed();
        this.desertBoots = new ItemRequirement("Desert boots", 1837).showConditioned(this.notEnterDesert).isNotConsumed();
        this.desertRobe = new ItemRequirement("Desert robe", 1835).showConditioned(this.notEnterDesert).isNotConsumed();
        this.desertShirt = new ItemRequirement("Desert shirt", 1833).showConditioned(this.notEnterDesert).isNotConsumed();
        this.pyramidPlunderArtefact = new ItemRequirement("Any Artefact from Pyramid Plunder", ItemCollections.PLUNDER_ARTEFACTS).showConditioned(this.notSellArtefact);
        this.emptyWaterskin = new ItemRequirement("Empty waterskin", 1831).showConditioned(this.notCutCactus).isNotConsumed();
        this.grimyHerb = new ItemRequirement("Grimy herb", ItemCollections.GRIMY_HERB);
        this.antipoison = new ItemRequirement("Antipoison", ItemCollections.ANTIPOISONS);
        this.waterskin = new ItemRequirement("Waterskin", ItemCollections.WATERSKIN).isNotConsumed();
        this.pharaohSceptre = new ItemRequirement("Pharaoh's sceptre", ItemCollections.PHAROAH_SCEPTRE).isNotConsumed();
        this.necklaceOfPassage = new ItemRequirement("Necklace of passage", ItemCollections.NECKLACE_OF_PASSAGES);
        this.combatGear = new ItemRequirement("Combat gear and ranged weapon or runes for multiple spell casts", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inFirstRoom = new ZoneRequirement(this.firstRoom);
        this.inPyramidPlunderLobby = new ZoneRequirement(this.pyramidPlunderLobby);
        this.inKalphHive = new ZoneRequirement(this.kalphHive);
        this.icthlarinsLittleHelper = new QuestRequirement(QuestHelperQuest.ICTHLARINS_LITTLE_HELPER, 2, "Icthlarin's Little Helper Started");
    }

    public void loadZones() {
        this.pyramidPlunderLobby = new Zone(new WorldPoint(1926, 4465, 2), new WorldPoint(1976, 4419, 3));
        this.firstRoom = new Zone(new WorldPoint(1920, 4478, 0), new WorldPoint(1934, 4462, 0));
        this.kalphHive = new Zone(new WorldPoint(3454, 9531, 2), new WorldPoint(3520, 9473, 2));
    }

    public void setupSteps() {
        this.enterDesert = new ObjectStep((QuestHelper)this, 4031, new WorldPoint(3304, 3116, 0), "Enter the desert.", this.desertBoots.equipped(), this.desertRobe.equipped(), this.desertShirt.equipped(), this.shantayPass);
        this.goldWarbler = new ObjectStep((QuestHelper)this, 9375, new WorldPoint(3404, 3148, 0), "Catch a Golden Warbler in the Uzer hunter area.", this.birdSnare.highlighted());
        this.magicCarpet = new NpcStep((QuestHelper)this, 17, new WorldPoint(3310, 3108, 0), "Talk to the rug merchant and travel to Pollnivneach.", this.coins.quantity(200));
        this.magicCarpet.addDialogSteps("Yes please.", "I want to travel to Pollnivneach.");
        this.cutCactus = new ObjectStep((QuestHelper)this, 2670, new WorldPoint(3290, 3103, 0), "Cut Kharidian cacti and fill up your waterskin. You may need to cut multiple cacti before you successfully get water.", true, this.knife, this.emptyWaterskin);
        ((ObjectStep)this.cutCactus).setMaxObjectDistance(5000);
        this.fiveClay = new ObjectStep((QuestHelper)this, 11362, new WorldPoint(3420, 3163, 0), "Mine five clay in the north east of the desert.", new Requirement[0]);
        this.nardahHerb = new NpcStep((QuestHelper)this, 4753, new WorldPoint(3425, 2906, 0), "Have Zahur in Nardah clean a grimy herb for you.", this.grimyHerb, this.coins.quantity(200));
        this.nardahHerb.addDialogStep("Please clean all my herbs.");
        this.killVulture = new NpcStep((QuestHelper)this, 1267, new WorldPoint(3334, 2865, 0), "Kill a vulture.", true, new Requirement[0]);
        this.killVulture.addAlternateNpcs(1268);
        this.moveToPyramidPlunder = new ObjectStep((QuestHelper)this, 26622, new WorldPoint(3289, 2800, 0), "Enter the Pyramid plunder minigame. If you don't see a Guardian mummy exit and try a different entrance.", new Requirement[0]);
        this.startPyramidPlunder = new NpcStep((QuestHelper)this, 1779, new WorldPoint(1934, 4427, 3), "Talk to the guardian mummy to start the minigame. If you don't see a Guardian mummy exit and try a different entrance.", new Requirement[0]);
        this.startPyramidPlunder.addDialogStep("I know what I'm doing - let's get on with it.");
        this.openSarc = new ObjectStep((QuestHelper)this, 26626, new WorldPoint(1928, 4465, 0), "Open the sarcophagus in the first room.", new Requirement[0]);
        this.sellArtefact = new NpcStep((QuestHelper)this, 5786, new WorldPoint(3346, 2827, 0), "Talk to Simon Templeton and sell your artefact.", this.pyramidPlunderArtefact);
        this.sellArtefact.addDialogStep("Yes, show me the money.");
        this.enterKalph = new ObjectStep((QuestHelper)this, 3827, new WorldPoint(3228, 3109, 0), "Use the rope on the entrance and enter the Kalphite Hive.", this.rope.highlighted());
        this.enterKalph.addAlternateObjects(3828);
        this.enterKalph.addIcon(954);
        this.enterKalphForCacti = new ObjectStep((QuestHelper)this, 3827, new WorldPoint(3228, 3109, 0), "Use the rope on the entrance and enter the Kalphite Hive.", this.rope.highlighted());
        this.enterKalphForCacti.addAlternateObjects(3828);
        this.enterKalphForCacti.addIcon(954);
        this.collectCacti = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3463, 9482, 2), "Pickup and drop cacti until task is completed", this.potatoCacti);
        this.claimReward = new NpcStep((QuestHelper)this, 5520, new WorldPoint(3303, 3124, 0), "Talk to Jarr at the Shantay pass to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(405), this.shantayPass, this.birdSnare, this.pickaxe, this.rope, this.knife, this.desertBoots, this.desertRobe, this.desertShirt, this.grimyHerb, this.pyramidPlunderArtefact, this.emptyWaterskin, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.necklaceOfPassage, this.antipoison, this.waterskin, this.pharaohSceptre);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.HUNTER, 5));
        reqs.add(new SkillRequirement(Skill.THIEVING, 21));
        reqs.add(this.icthlarinsLittleHelper);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Kill a Vulture (lvl 31), tank hits from Kalphite Soldier (lvl 85)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Desert amulet 1", 13133), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Pharaoh's sceptre can hold up to 10 charges"), new UnlockReward("Goats will always drop noted desert goat horn"), new UnlockReward("Simon Templeton will now buy your noted artefacts too"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails enterSteps = new PanelDetails("Enter the Desert Dressed Appropriately", Collections.singletonList(this.enterDesert), this.desertBoots.equipped(), this.desertShirt.equipped(), this.desertRobe.equipped(), this.shantayPass);
        enterSteps.setDisplayCondition(this.notEnterDesert);
        enterSteps.setLockingStep(this.enterDesertTask);
        allSteps.add(enterSteps);
        PanelDetails cutDesertCactiSteps = new PanelDetails("Cut Desert Cacti", Collections.singletonList(this.cutCactus), this.knife, this.emptyWaterskin);
        cutDesertCactiSteps.setDisplayCondition(this.notCutCactus);
        cutDesertCactiSteps.setLockingStep(this.cutCactusTask);
        allSteps.add(cutDesertCactiSteps);
        PanelDetails kalphiteHiveSteps = new PanelDetails("Kalphite Hive", Collections.singletonList(this.enterKalph), this.rope);
        kalphiteHiveSteps.setDisplayCondition(this.notEnterKalph);
        kalphiteHiveSteps.setLockingStep(this.enterKalphTask);
        allSteps.add(kalphiteHiveSteps);
        PanelDetails kalphiteCactiSteps = new PanelDetails("Kalphite Cacti", Arrays.asList(this.enterKalphForCacti, this.collectCacti), this.rope, this.combatGear, this.food, this.antipoison);
        kalphiteCactiSteps.setDisplayCondition(this.notCollectCacti);
        kalphiteCactiSteps.setLockingStep(this.collectCactiTask);
        allSteps.add(kalphiteCactiSteps);
        PanelDetails goldenWarblerSteps = new PanelDetails("Golden Warbler", Collections.singletonList(this.goldWarbler), new SkillRequirement(Skill.HUNTER, 5), this.birdSnare);
        goldenWarblerSteps.setDisplayCondition(this.notGoldWarbler);
        goldenWarblerSteps.setLockingStep(this.goldWarblerTask);
        allSteps.add(goldenWarblerSteps);
        PanelDetails fiveClaySteps = new PanelDetails("Five clay", Collections.singletonList(this.fiveClay), this.pickaxe);
        fiveClaySteps.setDisplayCondition(this.notFiveClay);
        fiveClaySteps.setLockingStep(this.fiveClayTask);
        allSteps.add(fiveClaySteps);
        PanelDetails magicCarpetRideSteps = new PanelDetails("Magic Carpet Ride", Collections.singletonList(this.magicCarpet), this.coins.quantity(200));
        magicCarpetRideSteps.setDisplayCondition(this.notMagicCarpet);
        magicCarpetRideSteps.setLockingStep(this.magicCarpetTask);
        allSteps.add(magicCarpetRideSteps);
        PanelDetails nardahHerbCleanerSteps = new PanelDetails("Nardah Herb Cleaner", Collections.singletonList(this.nardahHerb), this.grimyHerb, this.coins.quantity(200));
        nardahHerbCleanerSteps.setDisplayCondition(this.notNardahHerb);
        nardahHerbCleanerSteps.setLockingStep(this.nardahHerbTask);
        allSteps.add(nardahHerbCleanerSteps);
        PanelDetails vultureSteps = new PanelDetails("Kill a Vulture", Collections.singletonList(this.killVulture), this.combatGear);
        vultureSteps.setDisplayCondition(this.notKillVulture);
        vultureSteps.setLockingStep(this.killVultureTask);
        allSteps.add(vultureSteps);
        PanelDetails openSarcSteps = new PanelDetails("First Sarcophagus", Arrays.asList(this.moveToPyramidPlunder, this.startPyramidPlunder, this.openSarc), new SkillRequirement(Skill.THIEVING, 21), this.icthlarinsLittleHelper);
        openSarcSteps.setDisplayCondition(this.notOpenSarc);
        openSarcSteps.setLockingStep(this.openSarcTask);
        allSteps.add(openSarcSteps);
        PanelDetails sellArtefactSteps = new PanelDetails("Sell Artefact", Collections.singletonList(this.sellArtefact), this.pyramidPlunderArtefact);
        sellArtefactSteps.setDisplayCondition(this.notSellArtefact);
        sellArtefactSteps.setLockingStep(this.sellArtefactTask);
        allSteps.add(sellArtefactSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

