/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.ardougne;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.domain.AccountType;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.FishingSpot;

@QuestDescriptor(quest=QuestHelperQuest.ARDOUGNE_MEDIUM)
public class ArdougneMedium
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement fairyAccess;
    ItemRequirement mithGrap;
    ItemRequirement crossbow;
    ItemRequirement strawSeeds;
    ItemRequirement rake;
    ItemRequirement seedDib;
    ItemRequirement basketOrCompost;
    ItemRequirement waterRune;
    ItemRequirement lawRune;
    ItemRequirement yewLog1;
    ItemRequirement smallFishingNet;
    ItemRequirement lightSource;
    ItemRequirement rawChick;
    ItemRequirement rawSword;
    ItemRequirement ibanStaff;
    ItemRequirement skavMap;
    ItemRequirement nightshade;
    ItemRequirement bucket;
    ItemRequirement ibanStaffU;
    ItemRequirement coins;
    ItemRequirement basket;
    ItemRequirement compost;
    ItemRequirement spade;
    ItemRequirement yewLog11;
    ItemRequirement food;
    Requirement fairyTaleII;
    Requirement enlightenedJourney;
    Requirement handInSand;
    Requirement watchtower;
    Requirement seaSlug;
    Requirement towerOfLife;
    Requirement undergroundPass;
    Requirement plagueCity;
    Requirement grapUp;
    Requirement notCWBallon;
    Requirement notCWBallon2;
    Requirement normalBook;
    Requirement notUniPen;
    Requirement notGrapYan;
    Requirement notArdyStraw;
    Requirement notTPArdy;
    Requirement notBalloonCW;
    Requirement notClaimSand;
    Requirement notFishOnPlatform;
    Requirement notPickMasterFarmer;
    Requirement notCaveNightshade;
    Requirement notKillSwordchick;
    Requirement notIbanUpgrade;
    Requirement notNecroTower;
    QuestStep claimReward;
    QuestStep uniPen;
    QuestStep grapYan;
    QuestStep ardyStraw;
    QuestStep tPArdy;
    QuestStep balloonCW;
    QuestStep claimSand;
    QuestStep fishOnPlatform;
    QuestStep pickMasterFarmer;
    QuestStep caveNightshade;
    QuestStep killSwordchick;
    QuestStep ibanUpgrade;
    QuestStep necroTower;
    QuestStep moveToSkavid;
    QuestStep moveToPlatform;
    QuestStep moveToBasement;
    QuestStep grapYan2;
    QuestStep talkToAug;
    QuestStep equipIban;
    NpcStep moveToEntrana;
    Zone skavidCaves;
    Zone platform;
    Zone basement;
    Zone entrana;
    Zone wall;
    ZoneRequirement inSkavidCaves;
    ZoneRequirement inPlatform;
    ZoneRequirement inBasement;
    ZoneRequirement inEntrana;
    ZoneRequirement inWall;
    ConditionalStep uniPenTask;
    ConditionalStep grapYanTask;
    ConditionalStep ardyStrawTask;
    ConditionalStep tpArdyTask;
    ConditionalStep balloonCWTask;
    ConditionalStep claimSandTask;
    ConditionalStep fishOnPlatformTask;
    ConditionalStep pickMasterFarmerTask;
    ConditionalStep caveNightshadeTask;
    ConditionalStep killSwordchickTask;
    ConditionalStep ibanUpgradeTask;
    ConditionalStep necroTowerTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doMedium = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.ardyStrawTask = new ConditionalStep((QuestHelper)this, this.ardyStraw, new Requirement[0]);
        doMedium.addStep(this.notArdyStraw, this.ardyStrawTask);
        this.balloonCWTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.moveToEntrana, new Requirement[0]);
        this.balloonCWTask.addStep(this.inEntrana, this.talkToAug);
        this.balloonCWTask.addStep(this.notCWBallon, this.balloonCW);
        doMedium.addStep(this.notBalloonCW, this.balloonCWTask);
        this.caveNightshadeTask = new ConditionalStep((QuestHelper)this, this.moveToSkavid, new Requirement[0]);
        this.caveNightshadeTask.addStep(this.inSkavidCaves, this.caveNightshade);
        doMedium.addStep(this.notCaveNightshade, this.caveNightshadeTask);
        this.grapYanTask = new ConditionalStep((QuestHelper)this, this.grapYan, new Requirement[0]);
        this.grapYanTask.addStep(new Conditions(this.grapUp, this.inWall), this.grapYan2);
        doMedium.addStep(this.notGrapYan, this.grapYanTask);
        this.claimSandTask = new ConditionalStep((QuestHelper)this, this.claimSand, new Requirement[0]);
        doMedium.addStep(this.notClaimSand, this.claimSandTask);
        this.tpArdyTask = new ConditionalStep((QuestHelper)this, this.tPArdy, new Requirement[0]);
        doMedium.addStep(this.notTPArdy, this.tpArdyTask);
        this.killSwordchickTask = new ConditionalStep((QuestHelper)this, this.moveToBasement, new Requirement[0]);
        this.killSwordchickTask.addStep(this.inBasement, this.killSwordchick);
        doMedium.addStep(this.notKillSwordchick, this.killSwordchickTask);
        this.fishOnPlatformTask = new ConditionalStep((QuestHelper)this, this.moveToPlatform, new Requirement[0]);
        this.fishOnPlatformTask.addStep(this.inPlatform, this.fishOnPlatform);
        doMedium.addStep(this.notFishOnPlatform, this.fishOnPlatformTask);
        this.pickMasterFarmerTask = new ConditionalStep((QuestHelper)this, this.pickMasterFarmer, new Requirement[0]);
        doMedium.addStep(this.notPickMasterFarmer, this.pickMasterFarmerTask);
        this.ibanUpgradeTask = new ConditionalStep((QuestHelper)this, this.ibanUpgrade, new Requirement[0]);
        this.ibanUpgradeTask.addStep(this.ibanStaffU.alsoCheckBank(this.questBank), this.equipIban);
        doMedium.addStep(this.notIbanUpgrade, this.ibanUpgradeTask);
        this.uniPenTask = new ConditionalStep((QuestHelper)this, this.uniPen, new Requirement[0]);
        doMedium.addStep(this.notUniPen, this.uniPenTask);
        this.necroTowerTask = new ConditionalStep((QuestHelper)this, this.necroTower, new Requirement[0]);
        doMedium.addStep(this.notNecroTower, this.necroTowerTask);
        return doMedium;
    }

    @Override
    public void setupRequirements() {
        this.notUniPen = new VarplayerRequirement(1196, false, 13);
        this.notGrapYan = new VarplayerRequirement(1196, false, 14);
        this.notArdyStraw = new VarplayerRequirement(1196, false, 15);
        this.notTPArdy = new VarplayerRequirement(1196, false, 16);
        this.notBalloonCW = new VarplayerRequirement(1196, false, 17);
        this.notClaimSand = new VarplayerRequirement(1196, false, 18);
        this.notFishOnPlatform = new VarplayerRequirement(1196, false, 19);
        this.notPickMasterFarmer = new VarplayerRequirement(1196, false, 20);
        this.notCaveNightshade = new VarplayerRequirement(1196, false, 21);
        this.notKillSwordchick = new VarplayerRequirement(1196, false, 23);
        this.notIbanUpgrade = new VarplayerRequirement(1196, false, 24);
        this.notNecroTower = new VarplayerRequirement(1196, false, 25);
        this.notCWBallon = new VarbitRequirement(2869, 1);
        this.notCWBallon2 = new VarbitRequirement(2869, 0);
        this.normalBook = new SpellbookRequirement(Spellbook.NORMAL);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.fairyAccess = new ItemRequirement("Dramen or Lunar staff", ItemCollections.FAIRY_STAFF).showConditioned(new Conditions(LogicType.OR, this.notNecroTower, this.notUniPen)).isNotConsumed();
        this.skavMap = new ItemRequirement("Skavid map", 2376).showConditioned(this.notCaveNightshade).isNotConsumed();
        this.lightSource = new ItemRequirement("Any light source", ItemCollections.LIGHT_SOURCES).showConditioned(this.notCaveNightshade).isNotConsumed();
        this.nightshade = new ItemRequirement("Cave nightshade", 2398);
        this.mithGrap = new ItemRequirement("Mith grapple", 9419).showConditioned(this.notGrapYan).isNotConsumed();
        this.crossbow = new ItemRequirement("Any crossbow", ItemCollections.CROSSBOWS).showConditioned(this.notGrapYan).isNotConsumed();
        this.bucket = new ItemRequirement("Bucket", 1925).showConditioned(new Conditions(this.notClaimSand)).isNotConsumed();
        this.lawRune = new ItemRequirement("Law rune", 563).showConditioned(this.notTPArdy);
        this.waterRune = new ItemRequirement("Water rune", 555).showConditioned(this.notTPArdy);
        this.rawChick = new ItemRequirement("Raw chicken", 2138).showConditioned(this.notKillSwordchick);
        this.rawSword = new ItemRequirement("Raw swordfish", 371).showConditioned(this.notKillSwordchick);
        this.ibanStaff = new ItemRequirement("Iban staff", 1409).showConditioned(this.notIbanUpgrade).isNotConsumed();
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notIbanUpgrade);
        this.ibanStaffU = new ItemRequirement("Iban staff Upgraded", 12658).showConditioned(this.notIbanUpgrade);
        this.seedDib = new ItemRequirement("Seed dibber", 5343).showConditioned(this.notArdyStraw).isNotConsumed();
        this.strawSeeds = new ItemRequirement("Strawberry seeds", 5323).showConditioned(this.notArdyStraw);
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notArdyStraw).isNotConsumed();
        this.smallFishingNet = new ItemRequirement("Small fishing net", 303).showConditioned(this.notFishOnPlatform).isNotConsumed();
        this.yewLog1 = new ItemRequirement("Yew logs", 1515, 1).showConditioned(new Conditions(this.notBalloonCW, this.notCWBallon));
        this.yewLog11 = new ItemRequirement("Yew logs", 1515, 11).showConditioned(new Conditions(this.notBalloonCW, this.notCWBallon2));
        this.basket = new ItemRequirement("Basket of apples", 5386).showConditioned(this.notArdyStraw);
        this.compost = new ItemRequirement("Compost", ItemCollections.COMPOST).showConditioned(this.notArdyStraw);
        this.basketOrCompost = new ItemRequirements(LogicType.OR, "Basket of apples or compost", this.compost, this.basket).showConditioned(this.notArdyStraw);
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notArdyStraw).isNotConsumed();
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inSkavidCaves = new ZoneRequirement(this.skavidCaves);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inPlatform = new ZoneRequirement(this.platform);
        this.inEntrana = new ZoneRequirement(this.entrana);
        this.inWall = new ZoneRequirement(this.wall);
        this.grapUp = new ChatMessageRequirement(this.inWall, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.grapUp).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inWall), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.fairyTaleII = new VarbitRequirement(QuestVarbits.QUEST_FAIRYTALE_II_CURE_A_QUEEN.getId(), Operation.GREATER_EQUAL, 40, "Partial completion of Fairytale II for access to fairy rings");
        this.enlightenedJourney = new QuestRequirement(QuestHelperQuest.ENLIGHTENED_JOURNEY, QuestState.FINISHED);
        this.handInSand = new QuestRequirement(QuestHelperQuest.THE_HAND_IN_THE_SAND, QuestState.FINISHED);
        this.watchtower = new QuestRequirement(QuestHelperQuest.WATCHTOWER, QuestState.IN_PROGRESS);
        this.seaSlug = new QuestRequirement(QuestHelperQuest.SEA_SLUG, QuestState.IN_PROGRESS);
        this.towerOfLife = new QuestRequirement(QuestHelperQuest.TOWER_OF_LIFE, QuestState.FINISHED);
        this.undergroundPass = new QuestRequirement(QuestHelperQuest.UNDERGROUND_PASS, QuestState.FINISHED);
        this.plagueCity = new QuestRequirement(QuestHelperQuest.PLAGUE_CITY, QuestState.FINISHED);
    }

    public void loadZones() {
        this.skavidCaves = new Zone(new WorldPoint(2527, 9470, 0), new WorldPoint(2536, 9460, 0));
        this.platform = new Zone(new WorldPoint(2760, 3293, 0), new WorldPoint(2795, 3271, 0));
        this.basement = new Zone(new WorldPoint(3008, 4415, 0), new WorldPoint(3070, 4352, 0));
        this.entrana = new Zone(new WorldPoint(2800, 3394, 0), new WorldPoint(2878, 3325, 0));
        this.wall = new Zone(new WorldPoint(2539, 3077, 1), new WorldPoint(2581, 3070, 1));
    }

    public void setupSteps() {
        this.uniPen = new DetailedQuestStep((QuestHelper)this, "Enter the unicorn pen in Ardougne Zoo using Fairy rings (BIS).", this.fairyAccess);
        this.necroTower = new DetailedQuestStep((QuestHelper)this, "Visit the island east of the Necromancer Tower (AIR).", this.fairyAccess);
        this.grapYan = new ObjectStep((QuestHelper)this, 17047, new WorldPoint(2556, 3072, 0), "Grapple up Yanille's south wall.", this.crossbow.equipped(), this.mithGrap);
        this.grapYan2 = new ObjectStep((QuestHelper)this, 17048, new WorldPoint(2556, 3075, 1), "Jump off the opposite side!", new Requirement[0]);
        this.claimSand = Utils.getAccountType(this.client) == AccountType.ULTIMATE_IRONMAN ? new ObjectStep((QuestHelper)this, 10814, new WorldPoint(2543, 3104, 0), "Fill a bucket with sand using Bert's sand pit.", this.bucket) : new NpcStep((QuestHelper)this, 5819, new WorldPoint(2551, 3100, 0), "Claim buckets of sand from Bert in Yanille.", new Requirement[0]);
        this.balloonCW = new DetailedQuestStep((QuestHelper)this, "Use a nearby Hot Air Ballon to travel to Castle Wars.", this.yewLog1);
        this.moveToEntrana = new NpcStep((QuestHelper)this, 1167, new WorldPoint(3048, 3236, 0), "Speak with a monk to travel to Entrana.", true, this.yewLog11);
        this.moveToEntrana.addAlternateNpcs(1166, 1165);
        this.talkToAug = new NpcStep((QuestHelper)this, 4715, new WorldPoint(2810, 3356, 0), "Speak with Augustine and travel to Castle Wars.", this.yewLog11);
        this.tPArdy = new DetailedQuestStep((QuestHelper)this, "Cast Teleport to Ardougne spell.", this.lawRune.quantity(2), this.waterRune.quantity(2));
        this.moveToBasement = new ObjectStep((QuestHelper)this, 21922, new WorldPoint(2648, 3212, 0), "Enter the basement of the Tower of Life.", this.combatGear, this.food, this.rawChick, this.rawSword);
        this.killSwordchick = new ObjectStep((QuestHelper)this, 21893, new WorldPoint(3034, 4362, 0), "Activate the Symbol of Life and kill the Swordchick.", this.combatGear, this.food, this.rawChick, this.rawSword);
        this.moveToSkavid = new ObjectStep((QuestHelper)this, 2806, new WorldPoint(2524, 3069, 0), "Enter the Cave.", this.lightSource, this.skavMap);
        this.caveNightshade = new ItemStep((QuestHelper)this, "Pickup the Cave nightshade.", this.nightshade);
        this.moveToPlatform = new NpcStep((QuestHelper)this, 4803, new WorldPoint(2719, 3305, 0), "Talk to Jeb or Holgart to travel to the Fishing Platform.", this.smallFishingNet);
        ((NpcStep)this.moveToPlatform).addAlternateNpcs(7789);
        this.fishOnPlatform = new NpcStep((QuestHelper)this, FishingSpot.SHRIMP.getIds(), new WorldPoint(2790, 3276, 0), "Catch any fish on the Fishing Platform.", this.smallFishingNet);
        this.pickMasterFarmer = new NpcStep((QuestHelper)this, 5730, new WorldPoint(2637, 3362, 0), "Pickpocket the master farmer north of East Ardougne.", new Requirement[0]);
        this.ibanUpgrade = new NpcStep((QuestHelper)this, 7753, new WorldPoint(2455, 3312, 0), "Talk to the Dark mage in West Ardougne to upgrade your staff.", this.ibanStaff, this.coins.quantity(200000));
        this.ibanUpgrade.addDialogSteps("Can you upgrade my Staff of Iban?", "Here's 200,000 coins. Please upgrade the staff.");
        this.equipIban = new ItemStep((QuestHelper)this, "Equip Iban's staff (u).", this.ibanStaffU);
        this.ardyStraw = new ObjectStep((QuestHelper)this, 8555, new WorldPoint(2667, 3371, 0), "Plant and harvest the strawberries from the north Ardougne allotment. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", true, this.rake, this.spade, this.seedDib, this.strawSeeds.quantity(3));
        this.claimReward = new NpcStep((QuestHelper)this, 5519, new WorldPoint(2574, 3323, 0), "Talk to Two-pints in the Flying Horse Inn at East Ardougne to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.crossbow, this.mithGrap, this.rake, this.strawSeeds.quantity(3), this.seedDib, this.ibanStaff, this.coins.quantity(200000), this.skavMap, this.lawRune.quantity(2), this.waterRune.quantity(2), this.lightSource, this.smallFishingNet, this.rawChick, this.rawSword, this.yewLog1, this.yewLog11, this.fairyAccess, this.spade);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.basketOrCompost);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 39));
        reqs.add(new SkillRequirement(Skill.FARMING, 31));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 50));
        reqs.add(new SkillRequirement(Skill.MAGIC, 51));
        reqs.add(new SkillRequirement(Skill.STRENGTH, 38));
        reqs.add(new SkillRequirement(Skill.RANGED, 21));
        reqs.add(new SkillRequirement(Skill.THIEVING, 38));
        reqs.add(this.fairyTaleII);
        reqs.add(this.enlightenedJourney);
        reqs.add(this.handInSand);
        reqs.add(this.watchtower);
        reqs.add(this.seaSlug);
        reqs.add(this.towerOfLife);
        reqs.add(this.undergroundPass);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Swordchick (lvl 46)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Ardougne Cloak 2", 13122), new ItemReward("7,500 Exp. Lamp (Any skill over 40)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Three daily teleports to Ardougne farm patch with the Ardougne cloak 2"), new UnlockReward("100 free noted pure essence every day from Wizard Cromperty"), new UnlockReward("Unicow, Newtroost, and Spidine drops will be noted at the Tower of Life"), new UnlockReward("10% increased chance to pickpocket in Ardougne (even if the cloak is not equipped or in inventory)"), new UnlockReward("Ability to toggle the Ring of life teleport to Ardougne"), new UnlockReward("Receive additional runes when crafting essence at the Ourania Altar"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails strawSteps = new PanelDetails("Ardougne Strawberries", Collections.singletonList(this.ardyStraw), new SkillRequirement(Skill.FARMING, 31), this.rake, this.strawSeeds.quantity(3), this.seedDib, this.spade);
        strawSteps.setDisplayCondition(this.notArdyStraw);
        strawSteps.setLockingStep(this.ardyStrawTask);
        allSteps.add(strawSteps);
        PanelDetails cwSteps = new PanelDetails("Castle Wars Balloon", Arrays.asList(this.moveToEntrana, this.talkToAug, this.balloonCW), new SkillRequirement(Skill.FIREMAKING, 50), this.enlightenedJourney, this.yewLog11);
        cwSteps.setDisplayCondition(new Conditions(this.notBalloonCW, this.notCWBallon2));
        cwSteps.setLockingStep(this.balloonCWTask);
        allSteps.add(cwSteps);
        PanelDetails cw2Steps = new PanelDetails("Castle Wars Balloon", Collections.singletonList(this.balloonCW), new SkillRequirement(Skill.FIREMAKING, 50), this.enlightenedJourney, this.yewLog1);
        cw2Steps.setDisplayCondition(new Conditions(this.notBalloonCW, this.notCWBallon));
        cw2Steps.setLockingStep(this.balloonCWTask);
        allSteps.add(cw2Steps);
        PanelDetails nightSteps = new PanelDetails("Cave Nightshade", Arrays.asList(this.moveToSkavid, this.caveNightshade), this.watchtower, this.lightSource, this.skavMap);
        nightSteps.setDisplayCondition(this.notCaveNightshade);
        nightSteps.setLockingStep(this.caveNightshadeTask);
        allSteps.add(nightSteps);
        PanelDetails grapSteps = new PanelDetails("Yanille Wall Grapple", Arrays.asList(this.grapYan, this.grapYan2), new SkillRequirement(Skill.AGILITY, 39), new SkillRequirement(Skill.STRENGTH, 38), new SkillRequirement(Skill.RANGED, 21), this.mithGrap, this.crossbow);
        grapSteps.setDisplayCondition(this.notGrapYan);
        grapSteps.setLockingStep(this.grapYanTask);
        allSteps.add(grapSteps);
        PanelDetails sandSteps = new PanelDetails("Claim Sand", Collections.singletonList(this.claimSand), this.handInSand);
        sandSteps.setDisplayCondition(this.notClaimSand);
        sandSteps.setLockingStep(this.claimSandTask);
        allSteps.add(sandSteps);
        PanelDetails tpSteps = new PanelDetails("Teleport to Ardougne", Collections.singletonList(this.tPArdy), new SkillRequirement(Skill.MAGIC, 51), this.plagueCity, this.normalBook, this.lawRune.quantity(2), this.waterRune.quantity(2));
        tpSteps.setDisplayCondition(this.notTPArdy);
        tpSteps.setLockingStep(this.tpArdyTask);
        allSteps.add(tpSteps);
        PanelDetails chickSteps = new PanelDetails("Kill Swordchick", Arrays.asList(this.moveToBasement, this.killSwordchick), this.towerOfLife, this.rawSword, this.rawChick, this.combatGear, this.food);
        chickSteps.setDisplayCondition(this.notKillSwordchick);
        chickSteps.setLockingStep(this.killSwordchickTask);
        allSteps.add(chickSteps);
        PanelDetails fishSteps = new PanelDetails("Fishing Platform", Arrays.asList(this.moveToPlatform, this.fishOnPlatform), this.seaSlug, this.smallFishingNet);
        fishSteps.setDisplayCondition(this.notFishOnPlatform);
        fishSteps.setLockingStep(this.fishOnPlatformTask);
        allSteps.add(fishSteps);
        PanelDetails farmerSteps = new PanelDetails("Pickpocket Master Farmer", Collections.singletonList(this.pickMasterFarmer), new SkillRequirement(Skill.THIEVING, 38));
        farmerSteps.setDisplayCondition(this.notPickMasterFarmer);
        farmerSteps.setLockingStep(this.pickMasterFarmerTask);
        allSteps.add(farmerSteps);
        PanelDetails ibanSteps = new PanelDetails("Iban Upgrade", Collections.singletonList(this.ibanUpgrade), this.undergroundPass, this.ibanStaff, this.coins.quantity(200000));
        ibanSteps.setDisplayCondition(this.notIbanUpgrade);
        ibanSteps.setLockingStep(this.ibanUpgradeTask);
        allSteps.add(ibanSteps);
        PanelDetails uniSteps = new PanelDetails("Fairy Ring to Unicorn Pen", Collections.singletonList(this.uniPen), this.fairyTaleII, this.fairyAccess);
        uniSteps.setDisplayCondition(this.notUniPen);
        uniSteps.setLockingStep(this.uniPenTask);
        allSteps.add(uniSteps);
        PanelDetails necroSteps = new PanelDetails("Fairy Ring to Necromancer Tower", Collections.singletonList(this.necroTower), this.fairyTaleII, this.fairyAccess);
        necroSteps.setDisplayCondition(this.notNecroTower);
        necroSteps.setLockingStep(this.necroTowerTask);
        allSteps.add(necroSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

