/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.ardougne;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ARDOUGNE_HARD)
public class ArdougneHard
extends ComplexStateQuestHelper {
    ItemRequirement rechargableJewelry;
    ItemRequirement earthRune;
    ItemRequirement lawRune;
    ItemRequirement rope;
    ItemRequirement smallFishingNet;
    ItemRequirement palmSap;
    ItemRequirement spade;
    ItemRequirement rake;
    ItemRequirement seedDib;
    ItemRequirement poisonIvySeed;
    ItemRequirement mithBar;
    ItemRequirement hammer;
    ItemRequirement coins;
    ItemRequirement shieldLeft;
    ItemRequirement shieldRight;
    ItemRequirement highEss;
    ItemRequirement deathAccess;
    ItemRequirement greeGree;
    ItemRequirement crystalTrink;
    ItemRequirement newKey;
    ItemRequirement mournerBoots;
    ItemRequirement mournerGloves;
    ItemRequirement mournerCloak;
    ItemRequirement mournerTop;
    ItemRequirement mournerTrousers;
    ItemRequirement mournersOutfit;
    ItemRequirement gasMask;
    ItemRequirement compost;
    ItemRequirement papaya;
    ItemRequirement papayaOrCompost;
    ItemRequirement lockpick;
    Requirement legendsQuest;
    Requirement monkeyMadness;
    Requirement watchtower;
    Requirement mourningsEndII;
    Requirement redAtDoor;
    Requirement redAtAltar;
    Requirement notRecharge;
    Requirement notMagicGuild;
    Requirement notStealChest;
    Requirement notMonkeyCage;
    Requirement notTPWatchtower;
    Requirement notRedSally;
    Requirement notPalmTree;
    Requirement notPoisonIvy;
    Requirement notMithPlate;
    Requirement notYanPOH;
    Requirement notDragSquare;
    Requirement notDeathRune;
    Requirement notYanHouse;
    Requirement notYanHouse2;
    QuestStep claimReward;
    QuestStep recharge;
    QuestStep stealChest;
    QuestStep monkeyCage;
    QuestStep tPWatchtower;
    QuestStep redSally;
    QuestStep palmTree;
    QuestStep poisonIvy;
    QuestStep mithPlate;
    QuestStep yanPOH;
    QuestStep dragSquare;
    QuestStep deathRune;
    QuestStep moveHouse;
    QuestStep moveToCastle;
    QuestStep deathMoveUp1;
    QuestStep deathMoveUp2;
    QuestStep deathMoveDown1;
    QuestStep deathMoveDown0;
    QuestStep turnKeyMirror;
    QuestStep deathAltar;
    QuestStep enterMournerHQ;
    QuestStep enterMournerBasement;
    ObjectStep magicGuild;
    Zone castle;
    Zone death0;
    Zone death1;
    Zone death2;
    Zone death12;
    Zone death02;
    Zone death;
    Zone mournerHQ;
    Zone mournerHQ2;
    ZoneRequirement inCastle;
    ZoneRequirement inDeath0;
    ZoneRequirement inDeath1;
    ZoneRequirement inDeath2;
    ZoneRequirement inDeath12;
    ZoneRequirement inDeath02;
    ZoneRequirement inDeath;
    ZoneRequirement inMournerHQ;
    ConditionalStep rechargeTask;
    ConditionalStep magicGuildTask;
    ConditionalStep stealChestTask;
    ConditionalStep monkeyCageTask;
    ConditionalStep tpWatchtowerTask;
    ConditionalStep redSallyTask;
    ConditionalStep palmTreeTask;
    ConditionalStep poisonIvyTask;
    ConditionalStep mithPlateTask;
    ConditionalStep yanPOHTask;
    ConditionalStep dragSquareTask;
    ConditionalStep deathRuneTask;
    ConditionalStep yanHouseTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doHard = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.palmTreeTask = new ConditionalStep((QuestHelper)this, this.palmTree, new Requirement[0]);
        doHard.addStep(this.notPalmTree, this.palmTreeTask);
        this.poisonIvyTask = new ConditionalStep((QuestHelper)this, this.poisonIvy, new Requirement[0]);
        doHard.addStep(this.notPoisonIvy, this.poisonIvyTask);
        this.tpWatchtowerTask = new ConditionalStep((QuestHelper)this, this.tPWatchtower, new Requirement[0]);
        doHard.addStep(this.notTPWatchtower, this.tpWatchtowerTask);
        this.yanHouseTask = new ConditionalStep((QuestHelper)this, this.moveHouse, new Requirement[0]);
        this.yanHouseTask.addStep(this.notYanHouse2, this.yanPOH);
        doHard.addStep(this.notYanPOH, this.yanHouseTask);
        this.magicGuildTask = new ConditionalStep((QuestHelper)this, (QuestStep)this.magicGuild, new Requirement[0]);
        doHard.addStep(this.notMagicGuild, this.magicGuildTask);
        this.mithPlateTask = new ConditionalStep((QuestHelper)this, this.mithPlate, new Requirement[0]);
        doHard.addStep(this.notMithPlate, this.mithPlateTask);
        this.redSallyTask = new ConditionalStep((QuestHelper)this, this.redSally, new Requirement[0]);
        doHard.addStep(this.notRedSally, this.redSallyTask);
        this.rechargeTask = new ConditionalStep((QuestHelper)this, this.recharge, new Requirement[0]);
        doHard.addStep(this.notRecharge, this.rechargeTask);
        this.monkeyCageTask = new ConditionalStep((QuestHelper)this, this.monkeyCage, new Requirement[0]);
        doHard.addStep(this.notMonkeyCage, this.monkeyCageTask);
        this.stealChestTask = new ConditionalStep((QuestHelper)this, this.moveToCastle, new Requirement[0]);
        this.stealChestTask.addStep(this.inCastle, this.stealChest);
        doHard.addStep(this.notStealChest, this.stealChestTask);
        this.dragSquareTask = new ConditionalStep((QuestHelper)this, this.dragSquare, new Requirement[0]);
        doHard.addStep(this.notDragSquare, this.dragSquareTask);
        this.deathRuneTask = new ConditionalStep((QuestHelper)this, this.enterMournerHQ, new Requirement[0]);
        this.deathRuneTask.addStep(this.inMournerHQ, this.enterMournerBasement);
        this.deathRuneTask.addStep(this.inDeath0, this.deathMoveUp1);
        this.deathRuneTask.addStep(this.inDeath1, this.deathMoveUp2);
        this.deathRuneTask.addStep(this.inDeath2, this.deathMoveDown1);
        this.deathRuneTask.addStep(this.inDeath12, this.deathMoveDown0);
        this.deathRuneTask.addStep(new Conditions(this.redAtDoor, this.inDeath02), this.turnKeyMirror);
        this.deathRuneTask.addStep(new Conditions(this.redAtAltar, this.inDeath02), this.deathRune);
        doHard.addStep(this.notDeathRune, this.deathRuneTask);
        return doHard;
    }

    @Override
    public void setupRequirements() {
        this.notRecharge = new VarplayerRequirement(1196, false, 26);
        this.notMagicGuild = new VarplayerRequirement(1196, false, 27);
        this.notStealChest = new VarplayerRequirement(1196, false, 28);
        this.notMonkeyCage = new VarplayerRequirement(1196, false, 29);
        this.notTPWatchtower = new VarplayerRequirement(1196, false, 30);
        this.notRedSally = new VarplayerRequirement(1196, false, 31);
        this.notPalmTree = new VarplayerRequirement(1197, false, 0);
        this.notPoisonIvy = new VarplayerRequirement(1197, false, 1);
        this.notMithPlate = new VarplayerRequirement(1197, false, 2);
        this.notYanPOH = new VarplayerRequirement(1197, false, 3);
        this.notDragSquare = new VarplayerRequirement(1197, false, 4);
        this.notDeathRune = new VarplayerRequirement(1197, false, 5);
        this.notYanHouse = new VarbitRequirement(2187, 6, Operation.NOT_EQUAL);
        this.notYanHouse2 = new VarbitRequirement(2187, 6);
        this.redAtDoor = new VarbitRequirement(1249, 1);
        this.redAtAltar = new VarbitRequirement(1250, 1);
        this.earthRune = new ItemRequirement("Earth rune", 557).showConditioned(this.notTPWatchtower);
        this.lawRune = new ItemRequirement("Law rune", 563).showConditioned(this.notTPWatchtower);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(new Conditions(this.notYanHouse, this.notYanPOH));
        this.mithBar = new ItemRequirement("Mithril bar", 2359).showConditioned(this.notMithPlate);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(new Conditions(LogicType.OR, this.notMithPlate, this.notDragSquare)).isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954).showConditioned(this.notRedSally).isNotConsumed();
        this.smallFishingNet = new ItemRequirement("Small fishing net", 303).showConditioned(this.notRedSally).isNotConsumed();
        this.rechargableJewelry = new ItemRequirement("Skills necklace or Combat bracelet under 4 charges", ItemCollections.RECHARGEABLE_NECK_BRACELET).showConditioned(this.notRecharge);
        this.greeGree = new ItemRequirement("Karamja monkey greegree", 4031).showConditioned(this.notMonkeyCage).isNotConsumed();
        this.lockpick = new ItemRequirement("Lockpick", 1523).showConditioned(this.notStealChest).isNotConsumed();
        this.shieldLeft = new ItemRequirement("Shield left half", 2366).showConditioned(this.notDragSquare);
        this.shieldRight = new ItemRequirement("Shield right half", 2368).showConditioned(this.notDragSquare);
        this.deathAccess = new ItemRequirement("Access to Death altar, or travel through abyss", ItemCollections.DEATHALTAR).showConditioned(this.notDeathRune).isNotConsumed();
        this.deathAccess.setTooltip("Death talisman or tiara");
        this.crystalTrink = new ItemRequirement("Crystal Trinket", 6653).showConditioned(this.notDeathRune).isNotConsumed();
        this.highEss = new ItemRequirement("Pure or Daeyalt essence", ItemCollections.ESSENCE_HIGH).showConditioned(this.notDeathRune);
        this.newKey = new KeyringRequirement("New key", this.configManager, KeyringCollection.NEW_KEY).showConditioned(this.notDeathRune).isNotConsumed();
        this.newKey.setTooltip("Another can be found on the desk in the south-east room of the Mourner HQ basement.");
        this.mournerBoots = new ItemRequirement("Mourner boots", 6069).isNotConsumed();
        this.gasMask = new ItemRequirement("Gas mask", 1506).isNotConsumed();
        this.mournerGloves = new ItemRequirement("Mourner gloves", 6068).isNotConsumed();
        this.mournerCloak = new ItemRequirement("Mourner cloak", 6070).isNotConsumed();
        this.mournerTop = new ItemRequirement("Mourner top", 6065).isNotConsumed();
        this.mournerTrousers = new ItemRequirement("Mourner trousers", 6067).isNotConsumed();
        this.mournersOutfit = new ItemRequirements("Full mourners' outfit", this.gasMask, this.mournerTop, this.mournerTrousers, this.mournerCloak, this.mournerBoots, this.mournerGloves).showConditioned(this.notDeathRune).isNotConsumed();
        this.mournersOutfit.setTooltip("Another set can be obtained at the north entrance to Arandar.");
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(new Conditions(LogicType.OR, this.notPalmTree, this.notPoisonIvy)).isNotConsumed();
        this.seedDib = new ItemRequirement("Seed dibber", 5343).showConditioned(new Conditions(LogicType.OR, this.notPalmTree, this.notPoisonIvy)).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notPalmTree).isNotConsumed();
        this.poisonIvySeed = new ItemRequirement("Poison ivy seed", 5106).showConditioned(this.notPoisonIvy);
        this.palmSap = new ItemRequirement("Palm tree sapling", 5502).showConditioned(this.notPalmTree);
        this.papaya = new ItemRequirement("Papaya fruit", 5972).showConditioned(this.notPalmTree);
        this.compost = new ItemRequirement("Compost", ItemCollections.COMPOST).showConditioned(this.notPalmTree);
        this.papayaOrCompost = new ItemRequirements(LogicType.OR, "15 Papaya fruit or Compost", this.papaya.quantity(15), this.compost).showConditioned(this.notPalmTree);
        this.inCastle = new ZoneRequirement(this.castle);
        this.inDeath0 = new ZoneRequirement(this.death0);
        this.inDeath1 = new ZoneRequirement(this.death1);
        this.inDeath2 = new ZoneRequirement(this.death2);
        this.inDeath12 = new ZoneRequirement(this.death12);
        this.inDeath02 = new ZoneRequirement(this.death02);
        this.inDeath = new ZoneRequirement(this.death);
        this.inMournerHQ = new ZoneRequirement(this.mournerHQ, this.mournerHQ2);
        this.legendsQuest = new QuestRequirement(QuestHelperQuest.LEGENDS_QUEST, QuestState.FINISHED);
        this.monkeyMadness = new QuestRequirement(QuestHelperQuest.MONKEY_MADNESS_I, QuestState.IN_PROGRESS);
        this.mourningsEndII = new QuestRequirement(QuestHelperQuest.MOURNINGS_END_PART_II, QuestState.FINISHED);
        this.watchtower = new QuestRequirement(QuestHelperQuest.WATCHTOWER, QuestState.FINISHED);
    }

    public void loadZones() {
        this.castle = new Zone(new WorldPoint(2568, 3310, 1), new WorldPoint(2591, 3282, 1));
        this.death0 = new Zone(new WorldPoint(1855, 4681, 0), new WorldPoint(2047, 4602, 0));
        this.death1 = new Zone(new WorldPoint(1855, 4681, 1), new WorldPoint(2047, 4602, 1));
        this.death2 = new Zone(new WorldPoint(1855, 4681, 2), new WorldPoint(2047, 4602, 2));
        this.death12 = new Zone(new WorldPoint(1886, 4646, 1), new WorldPoint(1896, 4632, 1));
        this.death02 = new Zone(new WorldPoint(1850, 4654, 0), new WorldPoint(1896, 4624, 0));
        this.death = new Zone(new WorldPoint(2183, 4860, 0), new WorldPoint(2232, 4815, 0));
        this.mournerHQ = new Zone(new WorldPoint(2547, 3321, 0), new WorldPoint(2555, 3327, 0));
        this.mournerHQ2 = new Zone(new WorldPoint(2542, 3324, 0), new WorldPoint(2546, 3327, 0));
    }

    public void setupSteps() {
        this.tPWatchtower = new DetailedQuestStep((QuestHelper)this, "Teleport to the Watchtower.", this.earthRune.quantity(2), this.lawRune.quantity(2));
        this.moveHouse = new NpcStep((QuestHelper)this, 3097, new WorldPoint(2638, 3293, 0), "Talk to an Estate agent and relocate your house to Yanille.", this.coins.quantity(25000));
        this.moveHouse.addDialogStep("Can you move my house please?");
        this.yanPOH = new ObjectStep((QuestHelper)this, 15482, new WorldPoint(2544, 3098, 0), "Enter your house from the portal in Yanille.", new Requirement[0]);
        this.magicGuild = new ObjectStep((QuestHelper)this, 1732, new WorldPoint(2584, 3088, 0), "Enter the Magic Guild.", true, new Requirement[0]);
        this.magicGuild.addAlternateObjects(1733);
        this.mithPlate = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(2613, 3081, 0), "Smith a Mithril platebody in Yanille.", this.mithBar.quantity(5), this.hammer);
        this.redSally = new ObjectStep((QuestHelper)this, 8990, new WorldPoint(2474, 3239, 0), "Catch a Red Salamander.", true, this.rope, this.smallFishingNet);
        this.recharge = new ObjectStep((QuestHelper)this, 2638, new WorldPoint(2729, 3378, 0), "Recharge some jewellery at the Totem pole in the Legends' Guild.", this.rechargableJewelry);
        this.monkeyCage = new NpcStep((QuestHelper)this, 5235, new WorldPoint(2607, 3277, 0), "Talk to a Monkey minder with the Karamja monkey greegree equipped.", this.greeGree.equipped());
        this.moveToCastle = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2572, 3296, 0), "Climb the stairs in the Ardougne Castle.", this.lockpick);
        this.stealChest = new ObjectStep((QuestHelper)this, 11739, new WorldPoint(2588, 3291, 1), "Attempt to steal from a chest in Ardougne Castle.", this.lockpick);
        this.dragSquare = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(2501, 3330, 0), "Smith a Dragon sq shield in West Ardougne.", this.shieldLeft, this.shieldRight, this.hammer);
        this.enterMournerHQ = new ObjectStep((QuestHelper)this, 2036, new WorldPoint(2551, 3320, 0), "Enter the Mourner HQ, or enter the Death Altar via the Abyss.", this.deathAccess, this.highEss, this.crystalTrink, this.newKey, this.gasMask.equipped(), this.mournerTop.equipped(), this.mournerTrousers.equipped(), this.mournerCloak.equipped(), this.mournerGloves.equipped(), this.mournerBoots.equipped());
        this.enterMournerBasement = new ObjectStep((QuestHelper)this, 8783, new WorldPoint(2542, 3327, 0), "Enter the Mourner HQ basement.", this.deathAccess, this.highEss, this.crystalTrink, this.newKey);
        this.deathMoveUp1 = new ObjectStep((QuestHelper)this, 10015, new WorldPoint(1903, 4639, 0), "Go up the stairs to the first floor.", this.deathAccess, this.highEss, this.crystalTrink);
        this.deathMoveUp2 = new ObjectStep((QuestHelper)this, 10017, new WorldPoint(1894, 4620, 1), "Go up the south staircase to the second floor.", this.deathAccess, this.highEss, this.crystalTrink);
        this.deathMoveDown1 = new ObjectStep((QuestHelper)this, 10016, new WorldPoint(1891, 4636, 2), "Go down to the first floor.", this.deathAccess, this.highEss, this.crystalTrink);
        this.deathMoveDown0 = new ObjectStep((QuestHelper)this, 10016, new WorldPoint(1888, 4639, 1), "Go down to the ground floor.", this.deathAccess, this.highEss, this.crystalTrink);
        this.turnKeyMirror = new ObjectStep((QuestHelper)this, 9939, new WorldPoint(1881, 4639, 0), "Enter the central area, and turn the pillar's mirror west.", new Requirement[0]);
        this.deathAltar = new ObjectStep((QuestHelper)this, 34823, new WorldPoint(1860, 4639, 0), "Enter the Death altar.", this.deathAccess, this.highEss, this.crystalTrink);
        this.deathAltar.addIcon(1456);
        this.deathRune = new ObjectStep((QuestHelper)this, 34770, new WorldPoint(2205, 4836, 0), "Craft some death runes from essence.TURN THE MIDDLE PILLAR TO POINT BACK EAST OR YOU'LL HAVE TO RETURN VIA THE UNDERGROUND PASS.", this.highEss);
        this.poisonIvy = new ObjectStep((QuestHelper)this, 7580, new WorldPoint(2618, 3226, 0), "Plant and harvest poison ivy in the Ardougne Monastery bush patch. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.rake, this.seedDib, this.poisonIvySeed);
        this.palmTree = new ObjectStep((QuestHelper)this, 7963, new WorldPoint(2490, 3180, 0), "Check the health of a palm tree near Tree Gnome Village. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.spade, this.rake, this.palmSap);
        this.claimReward = new NpcStep((QuestHelper)this, 5519, new WorldPoint(2574, 3323, 0), "Talk to Two-pints in the Flying Horse Inn at East Ardougne to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins.quantity(25000), this.earthRune.quantity(2), this.lawRune.quantity(2), this.mithBar.quantity(5), this.hammer, this.rope, this.smallFishingNet, this.rechargableJewelry, this.greeGree, this.lockpick, this.shieldLeft, this.shieldRight, this.newKey, this.crystalTrink, this.mournersOutfit, this.highEss, this.deathAccess, this.spade, this.rake, this.palmSap, this.seedDib, this.poisonIvySeed);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.papayaOrCompost);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.CONSTRUCTION, 50, false));
        reqs.add(new SkillRequirement(Skill.FARMING, 70, true));
        reqs.add(new SkillRequirement(Skill.HUNTER, 59));
        reqs.add(new SkillRequirement(Skill.MAGIC, 66));
        reqs.add(new SkillRequirement(Skill.RUNECRAFT, 65, true));
        reqs.add(new SkillRequirement(Skill.SMITHING, 68, true));
        reqs.add(new SkillRequirement(Skill.THIEVING, 72));
        reqs.add(this.monkeyMadness);
        reqs.add(this.legendsQuest);
        reqs.add(this.mourningsEndII);
        reqs.add(this.watchtower);
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Ardougne Cloak 3", 13123), new ItemReward("15,000 Exp. Lamp (Any skill over 50)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Five daily teleports to Ardougne farm patch with the Ardougne cloak 3"), new UnlockReward("150 free noted pure essence every day from Wizard Cromperty"), new UnlockReward("Ability to toggle Watchtower Teleport to the centre of Yanille"), new UnlockReward("10% increased chance of succeeding when pickpocketing around Gielinor"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails palmSteps = new PanelDetails("Tree Gnome Village Palm Tree", Collections.singletonList(this.palmTree), new SkillRequirement(Skill.FARMING, 68, true), this.spade, this.rake, this.palmSap);
        palmSteps.setDisplayCondition(this.notPalmTree);
        palmSteps.setLockingStep(this.palmTreeTask);
        allSteps.add(palmSteps);
        PanelDetails ivySteps = new PanelDetails("Monastery Poison Ivy", Collections.singletonList(this.poisonIvy), new SkillRequirement(Skill.FARMING, 70, true), this.seedDib, this.rake, this.poisonIvySeed);
        ivySteps.setDisplayCondition(this.notPoisonIvy);
        ivySteps.setLockingStep(this.poisonIvyTask);
        allSteps.add(ivySteps);
        PanelDetails watchtowerSteps = new PanelDetails("Teleport to Watchtower", Collections.singletonList(this.tPWatchtower), new SkillRequirement(Skill.MAGIC, 58), this.watchtower, this.earthRune.quantity(2), this.lawRune.quantity(2));
        watchtowerSteps.setDisplayCondition(this.notTPWatchtower);
        watchtowerSteps.setLockingStep(this.tpWatchtowerTask);
        allSteps.add(watchtowerSteps);
        PanelDetails yan2Steps = new PanelDetails("Yanille POH", Arrays.asList(this.moveHouse, this.yanPOH), new SkillRequirement(Skill.CONSTRUCTION, 50, false), this.coins.quantity(25000));
        yan2Steps.setDisplayCondition(new Conditions(this.notYanHouse, this.notYanPOH));
        yan2Steps.setLockingStep(this.yanHouseTask);
        allSteps.add(yan2Steps);
        PanelDetails yanSteps = new PanelDetails("Yanille POH", Collections.singletonList(this.yanPOH), new Requirement[0]);
        yanSteps.setDisplayCondition(new Conditions(this.notYanHouse2, this.notYanPOH));
        yan2Steps.setLockingStep(this.yanHouseTask);
        allSteps.add(yanSteps);
        PanelDetails mgSteps = new PanelDetails("Magic Guild", Collections.singletonList(this.magicGuild), new SkillRequirement(Skill.MAGIC, 66));
        mgSteps.setDisplayCondition(this.notMagicGuild);
        mgSteps.setLockingStep(this.magicGuildTask);
        allSteps.add(mgSteps);
        PanelDetails plateSteps = new PanelDetails("Mithril Platebody", Collections.singletonList(this.mithPlate), new SkillRequirement(Skill.SMITHING, 68, true), this.mithBar.quantity(5), this.hammer);
        plateSteps.setDisplayCondition(this.notMithPlate);
        plateSteps.setLockingStep(this.mithPlateTask);
        allSteps.add(plateSteps);
        PanelDetails sallySteps = new PanelDetails("Red Salamander", Collections.singletonList(this.redSally), new SkillRequirement(Skill.HUNTER, 59), this.rope, this.smallFishingNet);
        sallySteps.setDisplayCondition(this.notRedSally);
        sallySteps.setLockingStep(this.redSallyTask);
        allSteps.add(sallySteps);
        PanelDetails rechargeSteps = new PanelDetails("Recharge Jewelry", Collections.singletonList(this.recharge), this.legendsQuest, this.rechargableJewelry);
        rechargeSteps.setDisplayCondition(this.notRecharge);
        rechargeSteps.setLockingStep(this.rechargeTask);
        allSteps.add(rechargeSteps);
        PanelDetails monkeySteps = new PanelDetails("Monkey in a Cage", Collections.singletonList(this.monkeyCage), this.monkeyMadness, this.greeGree);
        monkeySteps.setDisplayCondition(this.notMonkeyCage);
        monkeySteps.setLockingStep(this.monkeyCageTask);
        allSteps.add(monkeySteps);
        PanelDetails chestSteps = new PanelDetails("Stealing from Ardougne Royalty", Arrays.asList(this.moveToCastle, this.stealChest), new SkillRequirement(Skill.THIEVING, 72), this.lockpick);
        chestSteps.setDisplayCondition(this.notStealChest);
        chestSteps.setLockingStep(this.stealChestTask);
        allSteps.add(chestSteps);
        PanelDetails dragSteps = new PanelDetails("Smith Dragon Square in West Ardougne", Collections.singletonList(this.dragSquare), new SkillRequirement(Skill.SMITHING, 60), this.shieldLeft, this.shieldRight, this.hammer);
        dragSteps.setDisplayCondition(this.notDragSquare);
        dragSteps.setLockingStep(this.dragSquareTask);
        allSteps.add(dragSteps);
        PanelDetails deathSteps = new PanelDetails("Craft Death Runes", Arrays.asList(this.enterMournerHQ, this.enterMournerBasement, this.deathMoveUp1, this.deathMoveUp2, this.deathMoveDown1, this.deathMoveDown0, this.deathAltar, this.deathRune), new SkillRequirement(Skill.RUNECRAFT, 65, true), this.mourningsEndII, this.newKey, this.crystalTrink, this.mournersOutfit, this.highEss, this.deathAccess);
        deathSteps.setDisplayCondition(this.notDeathRune);
        deathSteps.setLockingStep(this.deathRuneTask);
        allSteps.add(deathSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

