/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.ardougne;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ARDOUGNE_ELITE)
public class ArdougneElite
extends ComplexStateQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement lockpick;
    ItemRequirement yewLog;
    ItemRequirement runeBar;
    ItemRequirement hammer;
    ItemRequirement knife;
    ItemRequirement sinewOrRoot;
    ItemRequirement salveAmmy;
    ItemRequirement torstolSeed;
    ItemRequirement seedDib;
    ItemRequirement rake;
    ItemRequirement compost;
    ItemRequirement waterRune;
    ItemRequirement bloodRune;
    ItemRequirement deathRune;
    ItemRequirement sinew;
    ItemRequirement root;
    ItemRequirement imbuedSalve;
    ItemRequirement spade;
    ItemRequirement runeCrossbowU;
    ItemRequirement crossbowString;
    ItemRequirement yewStock;
    ItemRequirement runeLimbs;
    ItemRequirement food;
    Requirement desertTreasure;
    Requirement hauntedMine;
    Requirement ancientBook;
    Requirement enoughNMZPoints;
    Requirement madeString;
    Requirement madeLimbs;
    Requirement madeStock;
    Requirement madeCrossU;
    Requirement notTrawlerRay;
    Requirement notYanAgi;
    Requirement notPickHero;
    Requirement notRuneCrossbow;
    Requirement notImbueSalve;
    Requirement notPickTorstol;
    Requirement notArdyRooftops;
    Requirement notIceBarrage;
    QuestStep claimReward;
    QuestStep trawlerRay;
    QuestStep yanAgi;
    QuestStep pickHero;
    QuestStep runeCrossbow;
    QuestStep imbueSalve;
    QuestStep pickTorstol;
    QuestStep ardyRooftops;
    QuestStep iceBarrage;
    QuestStep moveToYanAgi;
    QuestStep farmMorePoints;
    QuestStep equipSalve;
    QuestStep spinString;
    QuestStep smithLimbs;
    QuestStep fletchStock;
    QuestStep moveToYan;
    QuestStep makeUnstrungCross;
    Zone yanille;
    Zone yanAgilityCave;
    Zone witchaven;
    ZoneRequirement inYanille;
    ZoneRequirement inYanAgilityCave;
    ZoneRequirement inWitchaven;
    ConditionalStep trawlerRayTask;
    ConditionalStep yanAgiTask;
    ConditionalStep pickHeroTask;
    ConditionalStep runeCrossbowTask;
    ConditionalStep imbueSalveTask;
    ConditionalStep pickTorstolTask;
    ConditionalStep ardyRooftopsTask;
    ConditionalStep iceBarrageTask;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doElite = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.pickTorstolTask = new ConditionalStep((QuestHelper)this, this.pickTorstol, new Requirement[0]);
        doElite.addStep(this.notPickTorstol, this.pickTorstolTask);
        this.iceBarrageTask = new ConditionalStep((QuestHelper)this, this.iceBarrage, new Requirement[0]);
        doElite.addStep(this.notIceBarrage, this.iceBarrageTask);
        this.yanAgiTask = new ConditionalStep((QuestHelper)this, this.moveToYanAgi, new Requirement[0]);
        this.yanAgiTask.addStep(this.inYanAgilityCave, this.yanAgi);
        doElite.addStep(this.notYanAgi, this.yanAgiTask);
        this.imbueSalveTask = new ConditionalStep((QuestHelper)this, this.farmMorePoints, new Requirement[0]);
        this.imbueSalveTask.addStep(this.enoughNMZPoints, this.imbueSalve);
        this.imbueSalveTask.addStep(this.imbuedSalve.alsoCheckBank(this.questBank), this.equipSalve);
        doElite.addStep(this.notImbueSalve, this.imbueSalveTask);
        this.trawlerRayTask = new ConditionalStep((QuestHelper)this, this.trawlerRay, new Requirement[0]);
        doElite.addStep(this.notTrawlerRay, this.trawlerRayTask);
        this.ardyRooftopsTask = new ConditionalStep((QuestHelper)this, this.ardyRooftops, new Requirement[0]);
        doElite.addStep(this.notArdyRooftops, this.ardyRooftopsTask);
        this.pickHeroTask = new ConditionalStep((QuestHelper)this, this.pickHero, new Requirement[0]);
        doElite.addStep(this.notPickHero, this.pickHeroTask);
        this.runeCrossbowTask = new ConditionalStep((QuestHelper)this, this.spinString, new Requirement[0]);
        this.runeCrossbowTask.addStep(new Conditions(this.madeString, this.crossbowString), this.moveToYan);
        this.runeCrossbowTask.addStep(new Conditions(this.inYanille, this.madeString, this.crossbowString), this.smithLimbs);
        this.runeCrossbowTask.addStep(new Conditions(this.inYanille, this.madeLimbs, this.crossbowString, this.runeLimbs), this.fletchStock);
        this.runeCrossbowTask.addStep(new Conditions(this.inYanille, this.madeStock, this.crossbowString, this.runeLimbs, this.yewStock), this.makeUnstrungCross);
        this.runeCrossbowTask.addStep(new Conditions(this.inYanille, this.madeCrossU, this.runeCrossbowU, this.crossbowString), this.runeCrossbow);
        doElite.addStep(this.notRuneCrossbow, this.runeCrossbowTask);
        return doElite;
    }

    @Override
    public void setupRequirements() {
        this.notTrawlerRay = new VarplayerRequirement(1197, false, 6);
        this.notYanAgi = new VarplayerRequirement(1197, false, 7);
        this.notPickHero = new VarplayerRequirement(1197, false, 9);
        this.notRuneCrossbow = new VarplayerRequirement(1197, false, 8);
        this.notImbueSalve = new VarplayerRequirement(1197, false, 10);
        this.notPickTorstol = new VarplayerRequirement(1197, false, 11);
        this.notArdyRooftops = new VarplayerRequirement(1197, false, 12);
        this.notIceBarrage = new VarplayerRequirement(1197, false, 13);
        this.ancientBook = new SpellbookRequirement(Spellbook.ANCIENT);
        this.enoughNMZPoints = new VarplayerRequirement(1060, 800000, Operation.GREATER_EQUAL, "800,000 Nightmare Zone reward points");
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.bloodRune = new ItemRequirement("Blood rune", 565).showConditioned(this.notIceBarrage);
        this.waterRune = new ItemRequirement("Water rune", 555).showConditioned(this.notIceBarrage);
        this.deathRune = new ItemRequirement("Death rune", 560).showConditioned(this.notIceBarrage);
        this.lockpick = new ItemRequirement("Lockpick", 1523).showConditioned(this.notYanAgi).isNotConsumed();
        this.salveAmmy = new ItemRequirement("Salve amulet", ItemCollections.IMBUABLE_SALVE_AMULET).showConditioned(this.notImbueSalve).isNotConsumed();
        this.imbuedSalve = new ItemRequirement("Salve amulet", ItemCollections.IMBUED_SALVE_AMULET).showConditioned(this.notImbueSalve).isNotConsumed();
        this.seedDib = new ItemRequirement("Seed dibber", 5343).showConditioned(this.notPickTorstol).isNotConsumed();
        this.torstolSeed = new ItemRequirement("Torstol seed", 5304).showConditioned(this.notPickTorstol);
        this.rake = new ItemRequirement("Rake", 5341).showConditioned(this.notPickTorstol).isNotConsumed();
        this.compost = new ItemRequirement("Compost", ItemCollections.COMPOST).showConditioned(this.notPickTorstol);
        this.spade = new ItemRequirement("Spade", 952).showConditioned(this.notPickTorstol).isNotConsumed();
        this.yewLog = new ItemRequirement("Yew logs", 1515).showConditioned(this.notRuneCrossbow);
        this.runeBar = new ItemRequirement("Runite bar", 2363).showConditioned(this.notRuneCrossbow);
        this.sinew = new ItemRequirement("Sinew", 9436).showConditioned(this.notRuneCrossbow);
        this.root = new ItemRequirement("Root", ItemCollections.NON_MAGIC_TREE_ROOT).showConditioned(this.notRuneCrossbow);
        this.sinewOrRoot = new ItemRequirements(LogicType.OR, "Sinew or non-magic tree root", this.root, this.sinew).showConditioned(this.notRuneCrossbow);
        this.hammer = new ItemRequirement("Hammer", 2347).showConditioned(this.notRuneCrossbow).isNotConsumed();
        this.knife = new ItemRequirement("Knife", 946).showConditioned(this.notRuneCrossbow).isNotConsumed();
        this.runeCrossbowU = new ItemRequirement("Rune crossbow (u)", 9465).showConditioned(this.notRuneCrossbow);
        this.crossbowString = new ItemRequirement("Crossbow string", 9438).showConditioned(this.notRuneCrossbow);
        this.yewStock = new ItemRequirement("Yew stock", 9452).showConditioned(this.notRuneCrossbow);
        this.runeLimbs = new ItemRequirement("Runite limbs", 9431).showConditioned(this.notRuneCrossbow);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.inYanAgilityCave = new ZoneRequirement(this.yanAgilityCave);
        this.inYanille = new ZoneRequirement(this.yanille);
        this.madeString = new ChatMessageRequirement(this.inWitchaven, "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>");
        ((ChatMessageRequirement)this.madeString).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inWitchaven), "<col=0040ff>Achievement Diary Stage Task - Current stage: 1.</col>"));
        this.madeLimbs = new ChatMessageRequirement(this.inYanille, "<col=0040ff>Achievement Diary Stage Task - Current stage: 2.</col>");
        ((ChatMessageRequirement)this.madeLimbs).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inYanille), "<col=0040ff>Achievement Diary Stage Task - Current stage: 2.</col>"));
        this.madeStock = new ChatMessageRequirement(this.inYanille, "<col=0040ff>Achievement Diary Stage Task - Current stage: 3.</col>");
        ((ChatMessageRequirement)this.madeStock).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inYanille), "<col=0040ff>Achievement Diary Stage Task - Current stage: 3.</col>"));
        this.madeCrossU = new ChatMessageRequirement(this.inYanille, "<col=0040ff>Achievement Diary Stage Task - Current stage: 4.</col>");
        ((ChatMessageRequirement)this.madeCrossU).setInvalidateRequirement(new ChatMessageRequirement(new Conditions(LogicType.NOR, this.inYanille), "<col=0040ff>Achievement Diary Stage Task - Current stage: 4.</col>"));
        this.desertTreasure = new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.FINISHED);
        this.hauntedMine = new QuestRequirement(QuestHelperQuest.HAUNTED_MINE, QuestState.FINISHED);
    }

    public void loadZones() {
        this.yanille = new Zone(new WorldPoint(2540, 3109, 0), new WorldPoint(2619, 3075, 0));
        this.yanAgilityCave = new Zone(new WorldPoint(2821, 9545, 0), new WorldPoint(2879, 9663, 0));
        this.witchaven = new Zone(new WorldPoint(2728, 3280, 0), new WorldPoint(2736, 3273, 0));
    }

    public void setupSteps() {
        this.iceBarrage = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2441, 3089, 0), "Cast Ice Barrage on a Player within Castle Wars.", this.ancientBook, this.waterRune.quantity(6), this.bloodRune.quantity(2), this.deathRune.quantity(4));
        this.moveToYanAgi = new ObjectStep((QuestHelper)this, 16664, new WorldPoint(2604, 3079, 0), "Climb down the stairs to enter the Yanille Agility Dungeon.", this.lockpick);
        this.yanAgi = new ObjectStep((QuestHelper)this, 11728, new WorldPoint(2601, 9482, 0), "Lockpick the door to the Yanille Agility Dungeon.", this.lockpick);
        this.yanAgi.addIcon(1523);
        this.farmMorePoints = new NpcStep((QuestHelper)this, 1120, new WorldPoint(2608, 3116, 0), "Farm more Nightmare Zone points. Speak with Dominic Onion and buy a dream.", this.combatGear, this.food);
        this.imbueSalve = new ObjectStep((QuestHelper)this, 26273, new WorldPoint(2609, 3119, 0), "Imbue a salve amulet at Nightmare Zone.", this.enoughNMZPoints, this.salveAmmy);
        this.equipSalve = new ItemStep((QuestHelper)this, "Equip your salve amulet.", this.imbuedSalve);
        this.trawlerRay = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2659, 3160, 0), "Catch a manta ray in the Fishing Trawler and cook it in Port Khazard.", new Requirement[0]);
        this.ardyRooftops = new ObjectStep((QuestHelper)this, 15608, new WorldPoint(2673, 3298, 0), "Complete a lap of Ardougne's rooftop agility course.", new Requirement[0]);
        this.pickHero = new NpcStep((QuestHelper)this, 3295, new WorldPoint(2630, 3292, 0), "Pickpocket a Hero in East Ardougne.", new Requirement[0]);
        this.spinString = new ObjectStep((QuestHelper)this, 8748, new WorldPoint(2731, 3278, 0), "Spin a crossbow string in Witchaven. Do not complete any other diary tasks while completing this.", this.sinewOrRoot);
        this.moveToYan = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2603, 3088, 0), "Enter Yanille to continue the task.", new Requirement[0]);
        this.smithLimbs = new ObjectStep((QuestHelper)this, 2097, new WorldPoint(2613, 3081, 0), "Smith some rune limbs in Yanille.", this.runeBar, this.hammer);
        this.fletchStock = new ItemStep((QuestHelper)this, "Use your knife on the  yew logs to make a yew stock.", this.knife.highlighted(), this.yewLog.highlighted());
        this.makeUnstrungCross = new ItemStep((QuestHelper)this, "Combine the rune limbs with the yew stock.", this.runeLimbs.highlighted(), this.yewStock.highlighted());
        this.runeCrossbow = new ItemStep((QuestHelper)this, "String the rune crossbow (u).", this.runeCrossbowU.highlighted(), this.crossbowString.highlighted());
        this.pickTorstol = new ObjectStep((QuestHelper)this, 8152, new WorldPoint(2670, 3374, 0), "Plant and harvest the Torstol from the north Ardougne herb patch. If you're waiting for it to grow and want to complete further tasks, use the tick box on panel.", this.rake, this.spade, this.seedDib, this.torstolSeed);
        this.claimReward = new NpcStep((QuestHelper)this, 5519, new WorldPoint(2574, 3323, 0), "Talk to Two-pints in the Flying Horse Inn at East Ardougne to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.waterRune.quantity(6), this.bloodRune.quantity(2), this.deathRune.quantity(4), this.lockpick, this.salveAmmy, this.sinewOrRoot, this.runeBar, this.hammer, this.knife, this.yewLog, this.rake, this.spade, this.seedDib, this.torstolSeed);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.compost);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.AGILITY, 90, true));
        reqs.add(new SkillRequirement(Skill.COOKING, 91, true));
        reqs.add(new SkillRequirement(Skill.CRAFTING, 10));
        reqs.add(new SkillRequirement(Skill.FARMING, 85));
        reqs.add(new SkillRequirement(Skill.FISHING, 81));
        reqs.add(new SkillRequirement(Skill.FLETCHING, 69));
        reqs.add(new SkillRequirement(Skill.MAGIC, 94));
        reqs.add(new SkillRequirement(Skill.SMITHING, 91, true));
        reqs.add(new SkillRequirement(Skill.THIEVING, 82, true));
        reqs.add(this.ancientBook);
        reqs.add(this.desertTreasure);
        reqs.add(this.hauntedMine);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Nightmare Zone monsters (levels vary)");
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Ardougne Cloak 4", 13124), new ItemReward("50,000 Exp. Lamp (Any skill over 70)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Unlimited teleports to Ardougne farm patch with the Ardougne cloak 4"), new UnlockReward("250 free noted pure essence every day from Wizard Cromperty"), new UnlockReward("50% more fish from Fishing Trawler"), new UnlockReward("25% more marks of grace from the Ardougne Rooftop Course"), new UnlockReward("Bert will automatically deliver 84 buckets of sand to your bank each day you log in (unless you are an Ultimate Ironman), even if you cancel membership"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails torstolSteps = new PanelDetails("Ardougne Torstol", Collections.singletonList(this.pickTorstol), new SkillRequirement(Skill.FARMING, 85), this.torstolSeed, this.compost, this.rake, this.seedDib, this.spade);
        torstolSteps.setDisplayCondition(this.notPickTorstol);
        torstolSteps.setLockingStep(this.pickTorstolTask);
        allSteps.add(torstolSteps);
        PanelDetails iceSteps = new PanelDetails("Ice Barrage in Castle Wars", Collections.singletonList(this.iceBarrage), new SkillRequirement(Skill.MAGIC, 94), this.desertTreasure, this.ancientBook, this.waterRune.quantity(6), this.bloodRune.quantity(2), this.deathRune.quantity(4));
        iceSteps.setDisplayCondition(this.notIceBarrage);
        iceSteps.setLockingStep(this.iceBarrageTask);
        allSteps.add(iceSteps);
        PanelDetails yanSteps = new PanelDetails("Yanille Agility Dungeon", Arrays.asList(this.moveToYanAgi, this.yanAgi), new SkillRequirement(Skill.THIEVING, 82, true), this.lockpick);
        yanSteps.setDisplayCondition(this.notYanAgi);
        yanSteps.setLockingStep(this.yanAgiTask);
        allSteps.add(yanSteps);
        PanelDetails salveSteps = new PanelDetails("Imbued Salve Amulet", Arrays.asList(this.farmMorePoints, this.imbueSalve), this.hauntedMine, this.salveAmmy, this.enoughNMZPoints);
        salveSteps.setDisplayCondition(this.notImbueSalve);
        salveSteps.setLockingStep(this.imbueSalveTask);
        allSteps.add(salveSteps);
        PanelDetails raySteps = new PanelDetails("Fishing Trawler Manta Ray", Collections.singletonList(this.trawlerRay), new SkillRequirement(Skill.COOKING, 91, true), new SkillRequirement(Skill.FISHING, 81));
        raySteps.setDisplayCondition(this.notTrawlerRay);
        raySteps.setLockingStep(this.trawlerRayTask);
        allSteps.add(raySteps);
        PanelDetails roofSteps = new PanelDetails("Ardougne Rooftop Agility", Collections.singletonList(this.ardyRooftops), new SkillRequirement(Skill.AGILITY, 90, true));
        roofSteps.setDisplayCondition(this.notArdyRooftops);
        roofSteps.setLockingStep(this.ardyRooftopsTask);
        allSteps.add(roofSteps);
        PanelDetails heroSteps = new PanelDetails("Pickpocket Hero", Collections.singletonList(this.pickHero), new SkillRequirement(Skill.THIEVING, 80));
        heroSteps.setDisplayCondition(this.notPickHero);
        heroSteps.setLockingStep(this.pickHeroTask);
        allSteps.add(heroSteps);
        PanelDetails crossSteps = new PanelDetails("Rune Crossbow in Yanille / Witchaven", Arrays.asList(this.spinString, this.smithLimbs, this.fletchStock, this.makeUnstrungCross, this.runeCrossbow), new SkillRequirement(Skill.CRAFTING, 10), new SkillRequirement(Skill.SMITHING, 91, true), new SkillRequirement(Skill.FLETCHING, 69), this.yewLog, this.runeBar, this.hammer, this.knife, this.sinewOrRoot);
        crossSteps.setDisplayCondition(this.notRuneCrossbow);
        crossSteps.setLockingStep(this.runeCrossbowTask);
        allSteps.add(crossSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

