/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.achievementdiaries.ardougne;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ARDOUGNE_EASY)
public class ArdougneEasy
extends ComplexStateQuestHelper {
    ItemRequirement rustySword;
    ItemRequirement silk;
    ItemRequirement coins;
    Requirement runeMysteries;
    Requirement biohazard;
    Requirement notEssMine;
    Requirement notStealCake;
    Requirement notSellSilk;
    Requirement notEastArdyAltar;
    Requirement notFishingTrawler;
    Requirement notEnterCombatCamp;
    Requirement notIdentifySword;
    Requirement notWildyLever;
    Requirement notAlecksEmporium;
    Requirement notProbitaPet;
    QuestStep claimReward;
    QuestStep essMine;
    QuestStep stealCake;
    QuestStep sellSilk;
    QuestStep eastArdyAltar;
    QuestStep fishingTrawler;
    QuestStep enterCombatCamp;
    QuestStep identifySword;
    QuestStep wildyLever;
    QuestStep alecksEmporium;
    QuestStep probitaPet;
    ConditionalStep essMineTask;
    ConditionalStep stealCakeTask;
    ConditionalStep sellSilkTask;
    ConditionalStep eastArdyAltarTask;
    ConditionalStep fishingTrawlerTask;
    ConditionalStep enterCombatCampTask;
    ConditionalStep identifySwordTask;
    ConditionalStep wildyLeverTask;
    ConditionalStep alecksEmporiumTask;
    ConditionalStep probitaPetTask;

    @Override
    public QuestStep loadStep() {
        this.setupRequirements();
        this.setupSteps();
        ConditionalStep doEasy = new ConditionalStep((QuestHelper)this, this.claimReward, new Requirement[0]);
        this.alecksEmporiumTask = new ConditionalStep((QuestHelper)this, this.alecksEmporium, new Requirement[0]);
        doEasy.addStep(this.notAlecksEmporium, this.alecksEmporiumTask);
        this.fishingTrawlerTask = new ConditionalStep((QuestHelper)this, this.fishingTrawler, new Requirement[0]);
        doEasy.addStep(this.notFishingTrawler, this.fishingTrawlerTask);
        this.identifySwordTask = new ConditionalStep((QuestHelper)this, this.identifySword, new Requirement[0]);
        doEasy.addStep(this.notIdentifySword, this.identifySwordTask);
        this.essMineTask = new ConditionalStep((QuestHelper)this, this.essMine, new Requirement[0]);
        doEasy.addStep(this.notEssMine, this.essMineTask);
        this.stealCakeTask = new ConditionalStep((QuestHelper)this, this.stealCake, new Requirement[0]);
        doEasy.addStep(this.notStealCake, this.stealCakeTask);
        this.sellSilkTask = new ConditionalStep((QuestHelper)this, this.sellSilk, new Requirement[0]);
        doEasy.addStep(this.notSellSilk, this.sellSilkTask);
        this.probitaPetTask = new ConditionalStep((QuestHelper)this, this.probitaPet, new Requirement[0]);
        doEasy.addStep(this.notProbitaPet, this.probitaPetTask);
        this.eastArdyAltarTask = new ConditionalStep((QuestHelper)this, this.eastArdyAltar, new Requirement[0]);
        doEasy.addStep(this.notEastArdyAltar, this.eastArdyAltarTask);
        this.wildyLeverTask = new ConditionalStep((QuestHelper)this, this.wildyLever, new Requirement[0]);
        doEasy.addStep(this.notWildyLever, this.wildyLeverTask);
        this.enterCombatCampTask = new ConditionalStep((QuestHelper)this, this.enterCombatCamp, new Requirement[0]);
        doEasy.addStep(this.notEnterCombatCamp, this.enterCombatCampTask);
        return doEasy;
    }

    @Override
    public void setupRequirements() {
        this.notEssMine = new VarplayerRequirement(1196, false, 0);
        this.notStealCake = new VarplayerRequirement(1196, false, 1);
        this.notSellSilk = new VarplayerRequirement(1196, false, 2);
        this.notEastArdyAltar = new VarplayerRequirement(1196, false, 4);
        this.notFishingTrawler = new VarplayerRequirement(1196, false, 5);
        this.notEnterCombatCamp = new VarplayerRequirement(1196, false, 6);
        this.notIdentifySword = new VarplayerRequirement(1196, false, 7);
        this.notWildyLever = new VarplayerRequirement(1196, false, 9);
        this.notAlecksEmporium = new VarplayerRequirement(1196, false, 11);
        this.notProbitaPet = new VarplayerRequirement(1196, false, 12);
        this.silk = new ItemRequirement("Silk", 950).showConditioned(this.notSellSilk);
        this.rustySword = new ItemRequirement("Rusty sword", 686).showConditioned(this.notIdentifySword);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS).showConditioned(this.notIdentifySword);
        this.runeMysteries = new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED);
        this.biohazard = new QuestRequirement(QuestHelperQuest.BIOHAZARD, QuestState.FINISHED);
    }

    public void setupSteps() {
        this.essMine = new NpcStep((QuestHelper)this, 8480, new WorldPoint(2683, 3326, 0), "Have Wizard Cromperty teleport you to the Rune essence mine.", new Requirement[0]);
        this.essMine.addDialogStep("Can you teleport me to the Rune Essence?");
        this.stealCake = new ObjectStep((QuestHelper)this, 11730, new WorldPoint(2668, 3311, 0), "Steal a cake from the East Ardougne market stalls.", new Requirement[0]);
        this.sellSilk = new NpcStep((QuestHelper)this, 8728, new WorldPoint(2655, 3300, 0), "Sell silk to the Silk trader in East Ardougne for 60 coins each.", new Requirement[0]);
        this.sellSilk.addDialogSteps("120 coins.", "I'll give it do you for 60.");
        this.eastArdyAltar = new ObjectStep((QuestHelper)this, 409, new WorldPoint(2618, 3309, 0), "Use the altar in East Ardougne's church (requires less than full Prayer points).", new Requirement[0]);
        this.probitaPet = new NpcStep((QuestHelper)this, 5906, new WorldPoint(2621, 3294, 0), "Check what pets you have insured with Probita in East Ardougne (right-click her to Check).", new Requirement[0]);
        this.wildyLever = new ObjectStep((QuestHelper)this, 1814, new WorldPoint(2561, 3311, 0), "Use the Ardougne lever to teleport to the Wilderness (you may pull the lever there to return). This will take you to DEEP Wilderness, bank anything you aren't willing to lose.", new Requirement[0]);
        this.enterCombatCamp = new ObjectStep((QuestHelper)this, 2041, new WorldPoint(2518, 3356, 0), "Enter the Combat Training Camp north of West Ardougne.", new Requirement[0]);
        this.fishingTrawler = new ObjectStep((QuestHelper)this, 4977, new WorldPoint(2675, 3170, 0), "Go out fishing on the Fishing Trawler.", new Requirement[0]);
        this.identifySword = new NpcStep((QuestHelper)this, 1358, new WorldPoint(2676, 3152, 0), "Have Tindel Marchant identify a rusty sword for you. Note: there is about a 1% chance this fails and you'll need another sword and more coins.", this.rustySword, this.coins.quantity(100));
        this.identifySword.addDialogStep("Ok, I'll give it a go!");
        this.alecksEmporium = new NpcStep((QuestHelper)this, 1501, new WorldPoint(2566, 3083, 0), "View Aleck's Hunter Emporium in Yanille.", new Requirement[0]);
        this.alecksEmporium.addDialogStep("Ok, let's see what you've got!");
        this.claimReward = new NpcStep((QuestHelper)this, 5519, new WorldPoint(2574, 3323, 0), "Talk to Two-pints in the Flying Horse Inn at East Ardougne to claim your reward!", new Requirement[0]);
        this.claimReward.addDialogStep("I have a question about my Achievement Diary.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.rustySword, this.silk, this.coins.quantity(100));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.THIEVING, 5));
        reqs.add(this.runeMysteries);
        reqs.add(this.biohazard);
        return reqs;
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Ardougne Cloak 1", 13121), new ItemReward("2,500 Exp. Lamp (Any skill over 30)", 4447));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Unlimited teleports to the Ardougne Monastery with the Ardougne cloak 1"), new UnlockReward("Double death runes (200) when trading in cats to civilians"), new UnlockReward("10% increased chance to successfully steal from stalls in Ardougne"), new UnlockReward("Jubster and Frogeel drops will be noted at the Tower of Life"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails aleckSteps = new PanelDetails("Aleck's Hunter Emporium", Collections.singletonList(this.alecksEmporium), new Requirement[0]);
        aleckSteps.setDisplayCondition(this.notAlecksEmporium);
        aleckSteps.setLockingStep(this.alecksEmporiumTask);
        allSteps.add(aleckSteps);
        PanelDetails trawlerSteps = new PanelDetails("Fishing Trawler", Collections.singletonList(this.fishingTrawler), new Requirement[0]);
        trawlerSteps.setDisplayCondition(this.notFishingTrawler);
        trawlerSteps.setLockingStep(this.fishingTrawlerTask);
        allSteps.add(trawlerSteps);
        PanelDetails swordSteps = new PanelDetails("Identify Sword", Collections.singletonList(this.identifySword), this.rustySword, this.coins.quantity(100));
        swordSteps.setDisplayCondition(this.notIdentifySword);
        swordSteps.setLockingStep(this.identifySwordTask);
        allSteps.add(swordSteps);
        PanelDetails essSteps = new PanelDetails("Essence Mine", Collections.singletonList(this.essMine), this.runeMysteries);
        essSteps.setDisplayCondition(this.notEssMine);
        essSteps.setLockingStep(this.essMineTask);
        allSteps.add(essSteps);
        PanelDetails cakeSteps = new PanelDetails("Steal Cake", Collections.singletonList(this.stealCake), new SkillRequirement(Skill.THIEVING, 5));
        cakeSteps.setDisplayCondition(this.notStealCake);
        cakeSteps.setLockingStep(this.stealCakeTask);
        allSteps.add(cakeSteps);
        PanelDetails silkSteps = new PanelDetails("Sell Silk", Collections.singletonList(this.sellSilk), this.silk);
        silkSteps.setDisplayCondition(this.notSellSilk);
        silkSteps.setLockingStep(this.sellSilkTask);
        allSteps.add(silkSteps);
        PanelDetails petSteps = new PanelDetails("Pet Insurance", Collections.singletonList(this.probitaPet), new Requirement[0]);
        petSteps.setDisplayCondition(this.notProbitaPet);
        petSteps.setLockingStep(this.probitaPetTask);
        allSteps.add(petSteps);
        PanelDetails altarSteps = new PanelDetails("Restore Prayer", Collections.singletonList(this.eastArdyAltar), new Requirement[0]);
        altarSteps.setDisplayCondition(this.notEastArdyAltar);
        altarSteps.setLockingStep(this.eastArdyAltarTask);
        allSteps.add(altarSteps);
        PanelDetails leverSteps = new PanelDetails("Wilderness Lever", Collections.singletonList(this.wildyLever), new Requirement[0]);
        leverSteps.setDisplayCondition(this.notWildyLever);
        leverSteps.setLockingStep(this.wildyLeverTask);
        allSteps.add(leverSteps);
        PanelDetails campSteps = new PanelDetails("Combat Camp", Collections.singletonList(this.enterCombatCamp), this.biohazard);
        campSteps.setDisplayCondition(this.notEnterCombatCamp);
        campSteps.setLockingStep(this.enterCombatCampTask);
        allSteps.add(campSteps);
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.claimReward), new Requirement[0]));
        return allSteps;
    }
}

