/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.collections;

import com.questhelper.requirements.item.KeyringRequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.client.config.ConfigManager;

public enum KeyringCollection {
    SHINY_KEY(85),
    BRASS_KEY(983),
    METAL_KEY(1839),
    WROUGHT_IRON_KEY(1843),
    DUSTY_KEY(1590),
    BATTERED_KEY(2887),
    CRYSTAL_MINE_KEY(4077),
    KEY(6792),
    MAZE_KEY(1542),
    WEAPON_STORE_KEY(759),
    BONE_KEY(605),
    ENCHANTED_KEY(6754),
    NEW_KEY(6104);

    private final int itemID;

    private KeyringCollection(int itemID) {
        this.itemID = itemID;
    }

    public String toChatText() {
        return this.name().toLowerCase().replaceAll("_", " ");
    }

    public String runeliteName() {
        return this.name().toLowerCase().replaceAll("_", "");
    }

    public static List<KeyringRequirement> allKeyRequirements(ConfigManager configManager) {
        ArrayList<KeyringRequirement> keys = new ArrayList<KeyringRequirement>();
        for (KeyringCollection keyringCollection : Collections.unmodifiableList(Arrays.asList(KeyringCollection.values()))) {
            keys.add(new KeyringRequirement(configManager, keyringCollection));
        }
        return keys;
    }

    public KeyringRequirement getRequirement(ConfigManager configManager) {
        return new KeyringRequirement(configManager, this);
    }

    public int getItemID() {
        return this.itemID;
    }
}

