/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.collections;

import com.google.common.collect.ImmutableList;
import com.questhelper.collections.ItemCollections;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public enum ItemWithCharge {
    BURNING1(21175, 1),
    BURNING2(21173, 2),
    BURNING3(21171, 3),
    BURNING4(21169, 4),
    BURNING5(21166, 5),
    CBRACE1(11124, 1),
    CBRACE2(11122, 2),
    CBRACE3(11120, 3),
    CBRACE4(11118, 4),
    CBRACE5(11974, 5),
    CBRACE6(11972, 6),
    DIGSITE1(11190, 1),
    DIGSITE2(11191, 2),
    DIGSITE3(11192, 3),
    DIGSITE4(11193, 4),
    DIGSITE5(11194, 5),
    ELYRE1(3691, 1),
    ELYRE2(6125, 2),
    ELYRE3(6126, 3),
    ELYRE4(6127, 4),
    ELYRE5(13079, 5),
    GAMES1(3867, 1),
    GAMES2(3865, 2),
    GAMES3(3863, 3),
    GAMES4(3861, 4),
    GAMES5(3859, 5),
    GAMES6(3857, 6),
    GAMES7(3855, 7),
    GAMES8(3853, 8),
    GLORY1(1706, 1),
    GLORY2(1708, 2),
    GLORY3(1710, 3),
    GLORY4(1712, 4),
    GLORY5(11976, 5),
    GLORY6(11978, 6),
    GLORYT1(10360, 1),
    GLORYT2(10358, 2),
    GLORYT3(10356, 3),
    GLORYT4(10354, 4),
    GLORYT5(11966, 5),
    GLORYT6(11964, 6),
    PASSAGE1(21155, 1),
    PASSAGE2(21153, 2),
    PASSAGE3(21151, 3),
    PASSAGE4(21149, 4),
    PASSAGE5(21146, 5),
    RETURNING1(21138, 1),
    RETURNING2(21136, 2),
    RETURNING3(21134, 3),
    RETURNING4(21132, 4),
    RETURNING5(21129, 5),
    ROD1(2566, 1),
    ROD2(2564, 2),
    ROD3(2562, 3),
    ROD4(2560, 4),
    ROD5(2558, 5),
    ROD6(2556, 6),
    ROD7(2554, 7),
    ROD8(2552, 8),
    ROS1(11873, 1),
    ROS2(11872, 2),
    ROS3(11871, 3),
    ROS4(11870, 4),
    ROS5(11869, 5),
    ROS6(11868, 6),
    ROS7(11867, 7),
    ROS8(11866, 8),
    ROW1(11988, 1),
    ROW2(11986, 2),
    ROW3(11984, 3),
    ROW4(11982, 4),
    ROW5(11980, 5),
    ROWI1(20790, 1),
    ROWI2(20789, 2),
    ROWI3(20788, 3),
    ROWI4(20787, 4),
    ROWI5(20786, 5),
    SKILLS1(11111, 1),
    SKILLS2(11109, 2),
    SKILLS3(11107, 3),
    SKILLS4(11105, 4),
    SKILLS5(11970, 5),
    SKILLS6(11968, 6),
    TCRYSTAL1(6102, 1),
    TCRYSTAL2(6101, 2),
    TCRYSTAL3(6100, 3),
    TCRYSTAL4(6099, 4),
    TCRYSTAL5(13102, 5),
    TP_ECTOPHIAL(4251, 10000000),
    FAIRY_RING_STAFF(ItemCollections.FAIRY_STAFF, 10000000);

    private final List<Integer> ids;
    private final int charges;
    private static final Map<Integer, ItemWithCharge> ID_MAP;

    private ItemWithCharge(int ids, int charges) {
        this.ids = ImmutableList.of((Object)ids);
        this.charges = charges;
    }

    private ItemWithCharge(List<Integer> ids, int charges) {
        this.ids = ids;
        this.charges = charges;
    }

    private ItemWithCharge(ItemCollections ids, int charges) {
        this.ids = ids.getItems();
        this.charges = charges;
    }

    @Nullable
    public static ItemWithCharge findItem(int itemId) {
        return ID_MAP.get(itemId);
    }

    public List<Integer> getIds() {
        return this.ids;
    }

    public int getCharges() {
        return this.charges;
    }

    static {
        ID_MAP = Arrays.stream(ItemWithCharge.values()).flatMap(item -> item.ids.stream().map(id -> new AbstractMap.SimpleEntry<Integer, ItemWithCharge>((Integer)id, (ItemWithCharge)((Object)item)))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (e1, e2) -> e1));
    }
}

