/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.bank.banktab;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.bank.QuestBank;
import com.questhelper.bank.banktab.BankTabItem;
import com.questhelper.bank.banktab.BankTabItems;
import com.questhelper.panel.PanelDetails;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.util.LogicType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;

@Singleton
public class QuestHelperBankTagService {
    @Inject
    private QuestHelperPlugin plugin;
    @Inject
    private QuestBank questBank;

    public ArrayList<Integer> itemsToTag() {
        ArrayList<BankTabItems> sortedItems = this.getPluginBankTagItemsForSections(true);
        if (sortedItems == null) {
            return null;
        }
        ArrayList<Integer> flattenedList = new ArrayList<Integer>();
        sortedItems.stream().map(BankTabItems::getItems).flatMap(Collection::stream).map(BankTabItem::getItemIDs).flatMap(Collection::stream).filter(Objects::nonNull).filter(id -> !flattenedList.contains(id)).forEach(flattenedList::add);
        return flattenedList;
    }

    public ArrayList<BankTabItems> getPluginBankTagItemsForSections(boolean onlyGetMissingItems) {
        ArrayList<BankTabItems> newList = new ArrayList<BankTabItems>();
        List<PanelDetails> questSections = this.plugin.getSelectedQuest().getPanels();
        if (questSections == null || questSections.isEmpty()) {
            return newList;
        }
        List<ItemRequirement> recommendedItems = this.plugin.getSelectedQuest().getItemRecommended();
        if (recommendedItems != null) {
            recommendedItems = recommendedItems.stream().filter(Objects::nonNull).filter(i -> (!onlyGetMissingItems || !i.check(this.plugin.getClient(), false, this.questBank.getBankItems())) && i.shouldDisplayText(this.plugin.getClient())).collect(Collectors.toList());
        }
        if (recommendedItems != null && !recommendedItems.isEmpty()) {
            BankTabItems pluginItems = new BankTabItems("Recommended items", new BankTabItem[0]);
            recommendedItems.forEach(item -> this.getItemsFromRequirement(pluginItems.getItems(), (ItemRequirement)item, (ItemRequirement)item));
            newList.add(pluginItems);
        }
        List shouldShowSections = questSections.stream().filter(panelDetail -> panelDetail.getHideCondition() == null || !panelDetail.getHideCondition().check(this.plugin.getClient())).collect(Collectors.toList());
        for (PanelDetails questSection : shouldShowSections) {
            List<Object> items = new ArrayList();
            if (questSection.getRequirements() != null) {
                items = questSection.getRequirements().stream().filter(ItemRequirement.class::isInstance).map(ItemRequirement.class::cast).filter(i -> (!onlyGetMissingItems || !i.check(this.plugin.getClient(), false, this.questBank.getBankItems())) && i.shouldDisplayText(this.plugin.getClient())).collect(Collectors.toList());
            }
            List<Object> recommendedItemsForSection = new ArrayList();
            if (questSection.getRecommended() != null) {
                recommendedItemsForSection = questSection.getRecommended().stream().filter(ItemRequirement.class::isInstance).map(ItemRequirement.class::cast).filter(i -> (!onlyGetMissingItems || !i.check(this.plugin.getClient(), false, this.questBank.getBankItems())) && i.shouldDisplayText(this.plugin.getClient())).collect(Collectors.toList());
            }
            BankTabItems pluginItems = new BankTabItems(questSection.getHeader(), new BankTabItem[0]);
            items.forEach(item -> this.getItemsFromRequirement(pluginItems.getItems(), (ItemRequirement)item, (ItemRequirement)item));
            recommendedItemsForSection.forEach(item -> this.getItemsFromRequirement(pluginItems.getRecommendedItems(), (ItemRequirement)item, (ItemRequirement)item));
            newList.add(pluginItems);
        }
        return newList;
    }

    private void getItemsFromRequirement(List<BankTabItem> pluginItems, ItemRequirement itemRequirement, ItemRequirement realItem) {
        if (itemRequirement instanceof ItemRequirements) {
            ItemRequirements itemRequirements = (ItemRequirements)itemRequirement;
            LogicType logicType = itemRequirements.getLogicType();
            ArrayList<ItemRequirement> requirements = itemRequirements.getItemRequirements();
            if (logicType == LogicType.AND) {
                requirements.forEach(req -> this.getItemsFromRequirement(pluginItems, (ItemRequirement)req, (ItemRequirement)req));
            }
            if (logicType == LogicType.OR) {
                List itemsWhichPassReq = requirements.stream().filter(r -> r.shouldDisplayText(this.plugin.getClient())).collect(Collectors.toList());
                if (itemsWhichPassReq.isEmpty()) {
                    this.getItemsFromRequirement(pluginItems, requirements.get(0).named(itemRequirements.getName()), requirements.get(0));
                } else {
                    ItemRequirement match = itemsWhichPassReq.stream().filter(r -> r.checkBank(this.plugin.getClient())).findFirst().orElse(((ItemRequirement)itemsWhichPassReq.get(0)).named(itemRequirements.getName()));
                    this.getItemsFromRequirement(pluginItems, match, match);
                }
            }
        } else if (itemRequirement.getDisplayItemId() != null) {
            pluginItems.add(new BankTabItem(realItem));
        } else if (!itemRequirement.getDisplayItemIds().contains(-1)) {
            pluginItems.add(this.makeBankTabItem(realItem));
        }
    }

    private BankTabItem makeBankTabItem(ItemRequirement item) {
        List<Integer> itemIds = item.getDisplayItemIds();
        Integer displayId = itemIds.stream().filter(this::hasItemInBank).findFirst().orElse(itemIds.get(0));
        return new BankTabItem(item, displayId);
    }

    public boolean hasItemInBank(int itemID) {
        ItemContainer bankContainer = this.plugin.getClient().getItemContainer(InventoryID.BANK);
        if (bankContainer == null) {
            return false;
        }
        return bankContainer.contains(itemID);
    }
}

