/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.bank.banktab;

import com.questhelper.QuestHelperPlugin;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ScriptEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.JagexColors;

public class QuestGrandExchangeInterface {
    private static final String VIEW_TAB = "View missing items ";
    private boolean active = false;
    private Widget parent;
    private Widget questIconWidget;
    private Widget questBackgroundWidget;
    private Widget grandExchangeTitle;
    private final Client client;
    private final QuestHelperPlugin questHelper;
    private final ClientThread clientThread;

    @Inject
    public QuestGrandExchangeInterface(Client client, QuestHelperPlugin questHelper, ClientThread clientThread) {
        this.client = client;
        this.questHelper = questHelper;
        this.clientThread = clientThread;
    }

    public void init() {
        if (this.isHidden() || this.questHelper.getSelectedQuest() == null) {
            return;
        }
        this.parent = this.client.getWidget(10616869);
        int QUEST_BUTTON_SIZE = 20;
        int QUEST_BUTTON_X = 480;
        int QUEST_BUTTON_Y = 0;
        this.questBackgroundWidget = this.createGraphic("quest helper", 195, QUEST_BUTTON_SIZE, QUEST_BUTTON_SIZE, QUEST_BUTTON_X, QUEST_BUTTON_Y);
        this.questBackgroundWidget.setAction(1, VIEW_TAB);
        this.questBackgroundWidget.setOnOpListener(new Object[]{this::handleTagTab});
        this.questIconWidget = this.createGraphic("", 835, QUEST_BUTTON_SIZE - 6, QUEST_BUTTON_SIZE - 6, QUEST_BUTTON_X + 3, QUEST_BUTTON_Y + 3);
        this.grandExchangeTitle = this.createTitle(this.parent);
        if (this.active) {
            this.active = false;
            this.activateTab();
        }
    }

    public void destroy() {
        if (this.active) {
            this.closeOptions();
        }
        this.parent = null;
        if (this.questIconWidget != null) {
            this.questIconWidget.setHidden(true);
        }
        if (this.questBackgroundWidget != null) {
            this.questBackgroundWidget.setHidden(true);
        }
        if (this.grandExchangeTitle != null) {
            this.grandExchangeTitle.setHidden(true);
        }
        this.active = false;
    }

    public boolean isHidden() {
        Widget widget = this.client.getWidget(10616869);
        return widget == null || widget.isHidden();
    }

    private void handleTagTab(ScriptEvent event) {
        if (this.active) {
            this.closeOptions();
        } else {
            this.activateTab();
        }
        this.client.playSoundEffect(2266);
    }

    public void closeOptions() {
        this.active = false;
        if (this.questBackgroundWidget != null) {
            this.questBackgroundWidget.setSpriteId(195);
            this.questBackgroundWidget.revalidate();
        }
        this.grandExchangeTitle.setHidden(true);
        this.client.setVarcStrValue(359, "");
        this.client.setVarcIntValue(5, 14);
        this.clientThread.invokeLater(() -> this.updateSearchInterface(false));
    }

    private void activateTab() {
        if (this.active) {
            return;
        }
        this.questBackgroundWidget.setSpriteId(196);
        this.questBackgroundWidget.revalidate();
        this.grandExchangeTitle.setHidden(false);
        this.active = true;
        this.client.setVarcStrValue(359, "quest-helper");
        this.client.setVarcIntValue(5, 14);
        this.clientThread.invokeLater(() -> this.updateSearchInterface(true));
    }

    private void updateSearchInterface(boolean hideSearchBox) {
        Widget geSearchBox = this.client.getWidget(0xA2002A);
        if (geSearchBox == null) {
            return;
        }
        Object[] scriptArgs = geSearchBox.getOnKeyListener();
        if (scriptArgs == null) {
            return;
        }
        this.client.runScript(scriptArgs);
        geSearchBox.setHidden(hideSearchBox);
    }

    private Widget createGraphic(Widget container, String name, int spriteId, int width, int height, int x, int y) {
        Widget widget = container.createChild(-1, 5);
        widget.setOriginalWidth(width);
        widget.setOriginalHeight(height);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        widget.setSpriteId(spriteId);
        widget.setOnOpListener(new Object[]{10003});
        widget.setHasListener(true);
        widget.setName(name);
        widget.revalidate();
        return widget;
    }

    private Widget createGraphic(String name, int spriteId, int width, int height, int x, int y) {
        return this.createGraphic(this.parent, name, spriteId, width, height, x, y);
    }

    private Widget createTitle(Widget container) {
        Widget chatbox = this.client.getWidget(0xA2002A);
        Widget widget = container.createChild(-1, 4);
        if (chatbox == null) {
            return widget;
        }
        widget.setOriginalWidth(chatbox.getWidth());
        widget.setOriginalHeight(chatbox.getHeight());
        widget.setOriginalX(0);
        widget.setOriginalY(0);
        widget.setTextShadowed(false);
        widget.setXTextAlignment(1);
        widget.setYTextAlignment(1);
        widget.setText("<col=b40000>" + this.questHelper.getSelectedQuest().getQuest().getName() + "</col> required items");
        widget.setFontId(496);
        widget.setTextColor(JagexColors.CHAT_GAME_EXAMINE_TEXT_OPAQUE_BACKGROUND.getRGB());
        if (!this.active) {
            widget.setHidden(true);
        }
        widget.revalidate();
        return widget;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public Widget getParent() {
        return this.parent;
    }

    public Widget getQuestIconWidget() {
        return this.questIconWidget;
    }

    public Widget getQuestBackgroundWidget() {
        return this.questBackgroundWidget;
    }

    public Widget getGrandExchangeTitle() {
        return this.grandExchangeTitle;
    }
}

