/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.bank.banktab;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ScriptEvent;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.bank.BankSearch;

public class QuestBankTabInterface {
    private static final String VIEW_TAB = "View tab ";
    private boolean questTabActive = false;
    private Widget parent;
    private Widget questIconWidget;
    private Widget questBackgroundWidget;
    private final Client client;
    private final BankSearch bankSearch;

    @Inject
    public QuestBankTabInterface(Client client, BankSearch bankSearch) {
        this.client = client;
        this.bankSearch = bankSearch;
    }

    public void init() {
        if (this.isHidden()) {
            return;
        }
        this.parent = this.client.getWidget(786433);
        int QUEST_BUTTON_SIZE = 25;
        int QUEST_BUTTON_X = 408;
        int QUEST_BUTTON_Y = 5;
        this.questBackgroundWidget = this.createGraphic("quest-helper", 195, QUEST_BUTTON_SIZE, QUEST_BUTTON_SIZE, QUEST_BUTTON_X, QUEST_BUTTON_Y);
        this.questBackgroundWidget.setAction(1, VIEW_TAB);
        this.questBackgroundWidget.setOnOpListener(new Object[]{this::handleTagTab});
        this.questIconWidget = this.createGraphic("", 835, QUEST_BUTTON_SIZE - 6, QUEST_BUTTON_SIZE - 6, QUEST_BUTTON_X + 3, QUEST_BUTTON_Y + 3);
        if (this.questTabActive) {
            this.questTabActive = false;
            this.activateTab();
        }
    }

    public void destroy() {
        if (this.questTabActive) {
            this.closeTab();
            this.bankSearch.reset(true);
        }
        this.parent = null;
        if (this.questIconWidget != null) {
            this.questIconWidget.setHidden(true);
        }
        if (this.questBackgroundWidget != null) {
            this.questBackgroundWidget.setHidden(true);
        }
        this.questTabActive = false;
    }

    public void handleClick(MenuOptionClicked event) {
        boolean clickedOtherTab;
        if (this.isHidden()) {
            return;
        }
        String menuOption = event.getMenuOption();
        boolean clickedTabTag = menuOption.startsWith("View tab") && !event.getMenuTarget().equals("quest-helper");
        boolean bl = clickedOtherTab = menuOption.equals("View all items") || menuOption.startsWith("View tag tab");
        if (this.questTabActive && (clickedTabTag || clickedOtherTab)) {
            this.closeTab();
        }
    }

    public void handleSearch() {
        if (this.questTabActive) {
            this.closeTab();
            this.client.setVarcStrValue(359, "");
            this.client.setVarcIntValue(5, 0);
        }
    }

    public boolean isHidden() {
        Widget widget = this.client.getWidget(786433);
        return widget == null || widget.isHidden();
    }

    private void handleTagTab(ScriptEvent event) {
        if (event.getOp() == 2) {
            this.client.setVarbit(4150, 0);
            if (this.questTabActive) {
                this.closeTab();
                this.bankSearch.reset(true);
            } else {
                this.activateTab();
            }
            this.client.playSoundEffect(2266);
        }
    }

    public void closeTab() {
        this.questTabActive = false;
        if (this.questBackgroundWidget != null) {
            this.questBackgroundWidget.setSpriteId(195);
            this.questBackgroundWidget.revalidate();
        }
    }

    public void refreshTab() {
        if (!this.questTabActive) {
            return;
        }
        this.client.setVarbit(4150, 0);
        this.bankSearch.reset(true);
        Widget searchButtonBackground = this.client.getWidget(786472);
        if (searchButtonBackground != null) {
            searchButtonBackground.setOnTimerListener((Object[])null);
            searchButtonBackground.setSpriteId(170);
        }
    }

    private void activateTab() {
        if (this.questTabActive) {
            return;
        }
        this.questBackgroundWidget.setSpriteId(196);
        this.questBackgroundWidget.revalidate();
        this.questTabActive = true;
        this.bankSearch.reset(true);
        Widget searchButtonBackground = this.client.getWidget(786472);
        if (searchButtonBackground != null) {
            searchButtonBackground.setOnTimerListener((Object[])null);
            searchButtonBackground.setSpriteId(170);
        }
    }

    private Widget createGraphic(Widget container, String name, int spriteId, int width, int height, int x, int y) {
        Widget widget = container.createChild(-1, 5);
        widget.setOriginalWidth(width);
        widget.setOriginalHeight(height);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        widget.setSpriteId(spriteId);
        widget.setOnOpListener(new Object[]{10003});
        widget.setHasListener(true);
        widget.setName(name);
        widget.revalidate();
        return widget;
    }

    private Widget createGraphic(String name, int spriteId, int width, int height, int x, int y) {
        return this.createGraphic(this.parent, name, spriteId, width, height, x, y);
    }

    public void setQuestTabActive(boolean questTabActive) {
        this.questTabActive = questTabActive;
    }

    public boolean isQuestTabActive() {
        return this.questTabActive;
    }

    public Widget getParent() {
        return this.parent;
    }

    public Widget getQuestIconWidget() {
        return this.questIconWidget;
    }

    public Widget getQuestBackgroundWidget() {
        return this.questBackgroundWidget;
    }
}

