/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.bank.banktab;

import com.google.common.primitives.Shorts;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.bank.banktab.BankTabItem;
import com.questhelper.bank.banktab.BankTabItems;
import com.questhelper.bank.banktab.BankText;
import com.questhelper.bank.banktab.BankWidget;
import com.questhelper.bank.banktab.QuestBankTabInterface;
import com.questhelper.bank.banktab.QuestGrandExchangeInterface;
import com.questhelper.requirements.item.ItemRequirement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.ScriptEvent;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GrandExchangeSearched;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;

@Singleton
public class QuestBankTab {
    private static final int ITEMS_PER_ROW = 8;
    private static final int ITEM_VERTICAL_SPACING = 36;
    private static final int ITEM_HORIZONTAL_SPACING = 48;
    private static final int ITEM_ROW_START = 51;
    private static final int LINE_VERTICAL_SPACING = 5;
    private static final int LINE_HEIGHT = 2;
    private static final int TEXT_HEIGHT = 15;
    private static final int ITEM_HEIGHT = 32;
    private static final int ITEM_WIDTH = 36;
    private static final int EMPTY_BANK_SLOT_ID = 6512;
    private static final int MAX_RESULT_COUNT = 250;
    private static final int CROSS_SPRITE_ID = 1216;
    private static final int TICK_SPRITE_ID = 1217;
    private final ArrayList<Widget> addedWidgets = new ArrayList();
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private QuestBankTabInterface questBankTabInterface;
    @Inject
    private QuestGrandExchangeInterface geButtonWidget;
    @Inject
    private QuestHelperPlugin questHelper;
    private final HashMap<Widget, BankTabItem> widgetItems = new HashMap();
    private final HashMap<BankWidget, BankWidget> fakeToRealItem = new HashMap();

    public void startUp() {
        if (this.questHelper.getSelectedQuest() != null) {
            this.clientThread.invokeLater(this.questBankTabInterface::init);
            this.clientThread.invokeLater(this.geButtonWidget::init);
        }
    }

    public void shutDown() {
        this.clientThread.invokeLater(this.questBankTabInterface::destroy);
        this.clientThread.invokeLater(this.geButtonWidget::destroy);
        if (!this.addedWidgets.isEmpty()) {
            for (Widget addedWidget : this.addedWidgets) {
                addedWidget.setHidden(true);
            }
            this.addedWidgets.clear();
        }
    }

    public void refreshBankTab() {
        this.questBankTabInterface.refreshTab();
    }

    @Subscribe
    public void onGrandExchangeSearched(GrandExchangeSearched event) {
        String QUEST_BANK_TAG;
        String input = this.client.getVarcStrValue(359);
        if (!input.equals(QUEST_BANK_TAG = "quest-helper") || this.questHelper.getSelectedQuest() == null) {
            return;
        }
        event.consume();
        this.updateGrandExchangeResults();
    }

    public void updateGrandExchangeResults() {
        List<Integer> idsList = this.questHelper.itemsToTag();
        Set ids = idsList.stream().distinct().filter(i -> this.itemManager.getItemComposition(i.intValue()).isTradeable()).limit(250L).collect(Collectors.toCollection(TreeSet::new));
        this.client.setGeSearchResultIndex(0);
        this.client.setGeSearchResultCount(ids.size());
        this.client.setGeSearchResultIds(Shorts.toArray((Collection)ids));
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        int scriptId = event.getScriptId();
        if (scriptId == 505) {
            Widget bankTitle;
            if (this.questBankTabInterface.isQuestTabActive() && (bankTitle = this.client.getWidget(786435)) != null) {
                if (this.questHelper.getSelectedQuest() != null) {
                    bankTitle.setText("Tab <col=ff0000>" + this.questHelper.getSelectedQuest().getQuest().getName() + "</col>");
                } else {
                    bankTitle.setText("Tab <col=ff0000>Quest Helper</col>");
                }
            }
        } else if (scriptId == 281) {
            this.questBankTabInterface.handleSearch();
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        String eventName = event.getEventName();
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        if ("getSearchingTagTab".equals(eventName)) {
            int n = intStack[intStackSize - 1] = this.questBankTabInterface.isQuestTabActive() ? 1 : 0;
            if (this.questBankTabInterface.isQuestTabActive()) {
                event.setEventName("getSearchingQuestHelperTab");
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 12 && this.questHelper.getSelectedQuest() != null) {
            this.questBankTabInterface.init();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (!this.questBankTabInterface.isQuestTabActive() || this.questBankTabInterface.isHidden()) {
            return;
        }
        Point mousePoint = this.client.getMouseCanvasPosition();
        if (this.fakeToRealItem.isEmpty()) {
            return;
        }
        for (BankWidget bankWidget : this.fakeToRealItem.keySet()) {
            if (!bankWidget.isPointOverWidget(mousePoint)) continue;
            bankWidget.swap(this.fakeToRealItem.get(bankWidget));
            return;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        this.questBankTabInterface.handleClick(event);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        int SEARCHBOX_LOADED = 750;
        if (event.getScriptId() == SEARCHBOX_LOADED) {
            this.geButtonWidget.init();
        }
        if (event.getScriptId() == 514) {
            if (this.questBankTabInterface.isQuestTabActive()) {
                this.client.getIntStack()[this.client.getIntStackSize() - 1] = 1;
            }
            if (!this.addedWidgets.isEmpty()) {
                for (Widget addedWidget : this.addedWidgets) {
                    addedWidget.setHidden(true);
                }
                this.addedWidgets.clear();
            }
            this.fakeToRealItem.clear();
            return;
        }
        if (event.getScriptId() != 505) {
            return;
        }
        if (!this.questBankTabInterface.isQuestTabActive()) {
            return;
        }
        Widget itemContainer = this.client.getWidget(786445);
        if (itemContainer == null) {
            return;
        }
        if (!this.addedWidgets.isEmpty()) {
            for (Widget addedWidget : this.addedWidgets) {
                addedWidget.setHidden(true);
            }
            this.addedWidgets.clear();
        }
        this.fakeToRealItem.clear();
        Widget[] containerChildren = itemContainer.getDynamicChildren();
        this.clientThread.invokeAtTickEnd(() -> {
            List<BankTabItems> tabLayout = this.questHelper.getPluginBankTagItemsForSections();
            if (tabLayout != null) {
                this.sortBankTabItems(itemContainer, containerChildren, tabLayout);
            }
        });
    }

    private void sortBankTabItems(Widget itemContainer, Widget[] containerChildren, List<BankTabItems> newLayout) {
        int totalSectionsHeight = 0;
        ArrayList<Integer> itemList = new ArrayList<Integer>();
        for (Widget itemWidget : containerChildren) {
            if (itemWidget.getSpriteId() == 897 || itemWidget.getText().contains("Tab")) {
                itemWidget.setHidden(true);
                continue;
            }
            if (itemWidget.isHidden() || itemWidget.getItemId() == -1 || itemList.contains(itemWidget.getItemId()) || itemWidget.getItemId() == 6512) continue;
            itemList.add(itemWidget.getItemId());
        }
        ArrayList<BankText> bankItemTexts = new ArrayList<BankText>();
        HashMap<Integer, BankWidget> itemIDsAdded = new HashMap<Integer, BankWidget>();
        for (BankTabItems bankTabItems : newLayout) {
            totalSectionsHeight = this.addPluginTabSection(itemContainer, bankTabItems, itemList, totalSectionsHeight, bankItemTexts, itemIDsAdded);
        }
        for (BankText bankText : bankItemTexts) {
            Widget realItemQuantityText = this.createText(itemContainer, bankText.text, Color.WHITE.getRGB(), 48, 12, bankText.x, bankText.y);
            this.addedWidgets.add(realItemQuantityText);
            if (bankText.spriteID == -1) continue;
            Widget realItemInInventorySprite = this.createIcon(itemContainer, bankText.spriteID, 10, 10, bankText.spriteX, bankText.spriteY);
            this.addedWidgets.add(realItemInInventorySprite);
        }
        totalSectionsHeight = this.addGeneralSection(itemContainer, itemList, totalSectionsHeight);
        Widget bankItemContainer = this.client.getWidget(786445);
        if (bankItemContainer == null) {
            return;
        }
        int itemContainerHeight = bankItemContainer.getHeight();
        bankItemContainer.setScrollHeight(Math.max(totalSectionsHeight, itemContainerHeight));
        int itemContainerScroll = bankItemContainer.getScrollY();
        this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{72, 786446, 786445, itemContainerScroll}));
    }

    private int addPluginTabSection(Widget itemContainer, BankTabItems items, List<Integer> itemIds, int totalSectionsHeight, List<BankText> bankItemTexts, HashMap<Integer, BankWidget> itemIDsAdded) {
        int newHeight = totalSectionsHeight;
        if (items == null || items.getItems().isEmpty() && items.getRecommendedItems().isEmpty()) {
            return newHeight;
        }
        newHeight = this.addSectionHeader(itemContainer, items.getName(), totalSectionsHeight);
        if (!items.getItems().isEmpty()) {
            newHeight = this.createPartialSection(itemContainer, items.getItems(), itemIds, newHeight, bankItemTexts, itemIDsAdded);
        }
        if (!items.getRecommendedItems().isEmpty()) {
            newHeight = this.addSubSectionHeader(itemContainer, "Recommended", newHeight);
            newHeight = this.createPartialSection(itemContainer, items.getRecommendedItems(), itemIds, newHeight, bankItemTexts, itemIDsAdded);
        }
        return newHeight;
    }

    private int createPartialSection(Widget itemContainer, List<BankTabItem> items, List<Integer> itemIds, int totalSectionsHeight, List<BankText> bankItemTexts, HashMap<Integer, BankWidget> itemIDsAdded) {
        int totalItemsAdded = 0;
        for (BankTabItem bankTabItem : items) {
            Widget fakeItemWidget;
            boolean foundItem = false;
            if (!Collections.disjoint(itemIds, bankTabItem.getItemIDs())) {
                for (Widget widget : itemContainer.getDynamicChildren()) {
                    if (widget.isHidden() || widget.getOpacity() == 150 || !bankTabItem.getItemIDs().contains(widget.getItemId())) continue;
                    foundItem = true;
                    java.awt.Point point = this.placeItem(widget, totalItemsAdded, totalSectionsHeight);
                    widget.setItemQuantityMode(1);
                    this.widgetItems.put(widget, bankTabItem);
                    if (bankTabItem.getQuantity() > 0) {
                        this.makeBankText(widget.getItemQuantity(), bankTabItem.getQuantity(), point.x, point.y, bankTabItem.getItemRequirement(), bankItemTexts);
                    }
                    ++totalItemsAdded;
                    itemIds.removeAll(Collections.singletonList(widget.getItemId()));
                    itemIDsAdded.put(widget.getItemId(), new BankWidget(widget));
                    break;
                }
            }
            if (foundItem) continue;
            int adjXOffset = totalItemsAdded % 8 * 48 + 51;
            int adjYOffset = totalSectionsHeight + totalItemsAdded / 8 * 36;
            if (Collections.disjoint(itemIDsAdded.keySet(), bankTabItem.getItemIDs())) {
                fakeItemWidget = this.createMissingItem(itemContainer, bankTabItem, adjXOffset, adjYOffset);
                itemIds.removeAll(bankTabItem.getItemIDs());
            } else {
                List result = bankTabItem.getItemIDs().stream().distinct().filter(itemIDsAdded.keySet()::contains).collect(Collectors.toList());
                BankWidget realItemWidget = itemIDsAdded.get(result.get(0));
                fakeItemWidget = this.createDuplicateItem(itemContainer, bankTabItem, realItemWidget.getItemQuantity(), adjXOffset, adjYOffset);
                this.fakeToRealItem.put(new BankWidget(fakeItemWidget), realItemWidget);
            }
            if (bankTabItem.getQuantity() > 0) {
                this.makeBankText(fakeItemWidget.getItemQuantity(), bankTabItem.getQuantity(), adjXOffset, adjYOffset, bankTabItem.getItemRequirement(), bankItemTexts);
            }
            this.widgetItems.put(fakeItemWidget, bankTabItem);
            this.addedWidgets.add(fakeItemWidget);
            ++totalItemsAdded;
        }
        int newHeight = totalSectionsHeight + totalItemsAdded / 8 * 36;
        newHeight = totalItemsAdded % 8 != 0 ? newHeight + 36 : newHeight;
        return newHeight;
    }

    private void makeBankText(int currentQuantity, int goalQuantity, int baseX, int baseY, ItemRequirement item, List<BankText> bankItemTexts) {
        String quantityString = QuantityFormatter.quantityToStackSize((long)goalQuantity);
        int requirementLength = (int)Math.round((double)quantityString.length() * 5.5);
        int extraLength = QuantityFormatter.quantityToStackSize((long)currentQuantity).length() * 6;
        int xPos = baseX + 2 + extraLength;
        int yPos = baseY - 1;
        if (extraLength + requirementLength > 20) {
            xPos = baseX;
            yPos = baseY + 9;
        }
        boolean hasItem = item.check(this.client);
        int spritePosX = xPos + requirementLength + 10;
        int spritePosY = yPos;
        if (yPos != baseY - 1) {
            spritePosX = baseX + 2 + extraLength;
            spritePosY = baseY - 1;
        }
        if (hasItem) {
            bankItemTexts.add(new BankText("/ " + quantityString, xPos, yPos, 1217, spritePosX, spritePosY));
        } else {
            bankItemTexts.add(new BankText("/ " + quantityString, xPos, yPos, 1216, spritePosX, spritePosY));
        }
    }

    private int addGeneralSection(Widget itemContainer, List<Integer> items, int totalSectionsHeight) {
        int totalItemsAdded = 0;
        if (items.isEmpty()) {
            return totalSectionsHeight;
        }
        for (Integer itemID : items) {
            for (Widget widget : itemContainer.getDynamicChildren()) {
                if (widget.isHidden() || widget.getOpacity() == 150 || widget.getItemId() != itemID.intValue()) continue;
                if (totalItemsAdded == 0) {
                    totalSectionsHeight = this.addSectionHeader(itemContainer, "General", totalSectionsHeight);
                }
                this.placeItem(widget, totalItemsAdded, totalSectionsHeight);
                ++totalItemsAdded;
            }
        }
        int newHeight = totalSectionsHeight + totalItemsAdded / 8 * 36;
        newHeight = totalItemsAdded % 8 != 0 ? newHeight + 36 : newHeight;
        return newHeight;
    }

    private int addSubSectionHeader(Widget itemContainer, String title, int totalSectionsHeight) {
        this.addedWidgets.add(this.createText(itemContainer, title, new Color(228, 216, 162).getRGB(), 435, 15, 51, totalSectionsHeight + 5));
        return totalSectionsHeight + 5 + 15;
    }

    private int addSectionHeader(Widget itemContainer, String title, int totalSectionsHeight) {
        this.addedWidgets.add(this.createGraphic(itemContainer, 897, 384, 2, 51, totalSectionsHeight));
        this.addedWidgets.add(this.createText(itemContainer, title, new Color(228, 216, 162).getRGB(), 435, 15, 51, totalSectionsHeight + 5));
        return totalSectionsHeight + 5 + 15;
    }

    private java.awt.Point placeItem(Widget widget, int totalItemsAdded, int totalSectionsHeight) {
        int adjYOffset = totalSectionsHeight + totalItemsAdded / 8 * 36;
        int adjXOffset = totalItemsAdded % 8 * 48 + 51;
        if (widget.getOriginalY() != adjYOffset) {
            widget.setOriginalY(adjYOffset);
            widget.revalidate();
        }
        if (widget.getOriginalX() != adjXOffset) {
            widget.setOriginalX(adjXOffset);
            widget.revalidate();
        }
        return new java.awt.Point(adjXOffset, adjYOffset);
    }

    private Widget createGraphic(Widget container, int spriteId, int width, int height, int x, int y) {
        Widget widget = container.createChild(-1, 5);
        widget.setOriginalWidth(width);
        widget.setOriginalHeight(height);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        widget.setSpriteId(spriteId);
        widget.revalidate();
        return widget;
    }

    private Widget createMissingItem(Widget container, BankTabItem bankTabItem, int x, int y) {
        Widget widget = container.createChild(-1, 5);
        widget.setItemQuantityMode(1);
        widget.setOriginalWidth(36);
        widget.setOriginalHeight(32);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        List<Integer> itemIDs = bankTabItem.getItemIDs();
        if (bankTabItem.getItemRequirement().getDisplayItemId() != null) {
            itemIDs = Collections.singletonList(bankTabItem.getItemRequirement().getDisplayItemId());
        }
        if (itemIDs.size() == 0) {
            itemIDs.add(7542);
        }
        widget.setItemId(itemIDs.get(0).intValue());
        widget.setName("<col=ff9040>" + bankTabItem.getText() + "</col>");
        if (bankTabItem.getDetails() != null) {
            widget.setText(bankTabItem.getDetails());
        }
        widget.setItemQuantity(0);
        widget.setOpacity(150);
        widget.setOnOpListener(new Object[]{10003});
        widget.setHasListener(true);
        this.addTabActions(widget);
        widget.revalidate();
        return widget;
    }

    private Widget createDuplicateItem(Widget container, BankTabItem bankTabItem, int quantity, int x, int y) {
        Widget widget = container.createChild(-1, 5);
        widget.setItemQuantityMode(1);
        widget.setOriginalWidth(36);
        widget.setOriginalHeight(32);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        widget.setBorderType(1);
        List<Integer> itemIDs = bankTabItem.getItemIDs();
        if (bankTabItem.getDisplayID() != null) {
            itemIDs = Collections.singletonList(bankTabItem.getDisplayID());
        }
        widget.setItemId(itemIDs.get(0).intValue());
        widget.setName("<col=ff9040>" + bankTabItem.getText() + "</col>");
        if (bankTabItem.getDetails() != null) {
            widget.setText(bankTabItem.getDetails());
        }
        widget.setItemQuantity(quantity);
        widget.setOnOpListener(new Object[]{10003});
        widget.setHasListener(true);
        widget.revalidate();
        return widget;
    }

    private void addTabActions(Widget w) {
        w.setAction(1, "Details");
        w.setOnOpListener(new Object[]{this::handleFakeItemClick});
    }

    private void handleFakeItemClick(ScriptEvent event) {
        Widget widget = event.getSource();
        if (widget.getItemId() != -1) {
            String name = widget.getName();
            BankTabItem item = this.widgetItems.get(widget);
            Object quantity = QuantityFormatter.formatNumber((long)item.getQuantity()) + " x ";
            if (item.getQuantity() == -1) {
                quantity = "some ";
            }
            ChatMessageBuilder message = new ChatMessageBuilder().append("You need ").append(ChatColorType.HIGHLIGHT).append((String)quantity).append(Text.removeTags((String)name)).append(".");
            if (!widget.getText().isEmpty()) {
                message.append(ChatColorType.NORMAL).append(" " + widget.getText() + ".");
            }
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(message.build()).build());
        }
    }

    private Widget createText(Widget container, String text, int color, int width, int height, int x, int y) {
        Widget widget = container.createChild(-1, 4);
        widget.setOriginalWidth(width);
        widget.setOriginalHeight(height);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        widget.setText(text);
        widget.setFontId(494);
        widget.setTextColor(color);
        widget.setTextShadowed(true);
        widget.revalidate();
        return widget;
    }

    private Widget createIcon(Widget container, int spriteID, int width, int height, int x, int y) {
        Widget widget = container.createChild(-1, 5);
        widget.setOriginalWidth(width);
        widget.setOriginalHeight(height);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        widget.setSpriteId(spriteID);
        widget.revalidate();
        return widget;
    }
}

