/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.bank.banktab;

import com.questhelper.requirements.item.ItemRequirement;
import java.util.Collections;
import java.util.List;

public class BankTabItem {
    private final int quantity;
    private String text;
    private final List<Integer> itemIDs;
    private final Integer displayID;
    private final String details;
    private final ItemRequirement itemRequirement;

    public BankTabItem(ItemRequirement item, int displayID) {
        this.quantity = item.getQuantity();
        this.text = item.getName();
        this.itemIDs = Collections.singletonList(displayID);
        this.details = item.getTooltip();
        this.displayID = displayID;
        this.itemRequirement = item;
    }

    public BankTabItem(ItemRequirement item) {
        this.quantity = item.getQuantity();
        this.text = item.getName();
        this.itemIDs = Collections.singletonList(item.getId());
        this.details = item.getTooltip();
        this.displayID = null;
        this.itemRequirement = item;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<Integer> getItemIDs() {
        return this.itemIDs;
    }

    public Integer getDisplayID() {
        return this.displayID;
    }

    public String getDetails() {
        return this.details;
    }

    public ItemRequirement getItemRequirement() {
        return this.itemRequirement;
    }
}

