/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.bank;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.questhelper.bank.QuestBankData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.WorldType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QuestBank {
    private static final Logger log = LoggerFactory.getLogger(QuestBank.class);
    private final ConfigManager configManager;
    private final Client client;
    private final Gson gson;
    private static final String CONFIG_GROUP = "questhelper";
    private static final String BANK_KEY = "bankitems";
    private List<Item> bankItems;
    private final QuestBankData questBankData;
    private String rsProfileKey;
    private RuneScapeProfileType worldType;
    public List<WorldType> worldTypes = Arrays.asList(WorldType.SEASONAL, WorldType.TOURNAMENT_WORLD, WorldType.DEADMAN, WorldType.NOSAVE_MODE);

    @Inject
    public QuestBank(Client client, ConfigManager configManager, Gson gson) {
        this.configManager = configManager;
        this.client = client;
        this.gson = gson;
        this.questBankData = new QuestBankData();
        this.bankItems = new ArrayList<Item>();
    }

    public List<Item> getBankItems() {
        return this.bankItems;
    }

    public void updateLocalBank(Item[] items) {
        this.questBankData.set(items);
        this.bankItems = this.questBankData.getAsList();
    }

    public void emptyState() {
        this.rsProfileKey = null;
        this.worldType = null;
        this.questBankData.setEmpty();
        this.bankItems = new ArrayList<Item>();
    }

    public void loadState() {
        if (!RuneScapeProfileType.getCurrent((Client)this.client).equals((Object)this.worldType)) {
            if (this.rsProfileKey != null) {
                this.saveBankToConfig();
            }
            this.loadBankFromConfig();
        }
    }

    private void loadBankFromConfig() {
        this.configManager.unsetConfiguration(CONFIG_GROUP, this.getCurrentKey());
        this.rsProfileKey = this.configManager.getRSProfileKey();
        this.worldType = RuneScapeProfileType.getCurrent((Client)this.client);
        String json = this.configManager.getRSProfileConfiguration(CONFIG_GROUP, BANK_KEY);
        try {
            this.questBankData.setIdAndQuantity((int[])this.gson.fromJson(json, int[].class));
        }
        catch (JsonSyntaxException err) {
            this.questBankData.setIdAndQuantity(new int[0]);
            this.saveBankToConfig();
        }
        this.bankItems = this.questBankData.getAsList();
    }

    public void saveBankToConfig() {
        if (this.rsProfileKey == null) {
            return;
        }
        this.configManager.setConfiguration(CONFIG_GROUP, this.rsProfileKey, BANK_KEY, this.gson.toJson((Object)this.questBankData.getIdAndQuantity()));
    }

    private String getCurrentKey() {
        StringBuilder key = new StringBuilder();
        EnumSet worldType = this.client.getWorldType();
        for (WorldType type : worldType) {
            if (!this.worldTypes.contains(type)) continue;
            key.append(type.name()).append(":");
        }
        if (this.client.getLocalPlayer() == null) {
            return "NULL PLAYER";
        }
        key.append(this.client.getLocalPlayer().getName());
        return key.toString();
    }
}

