/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.questhelper.QuestHelperConfig;
import com.questhelper.bank.banktab.BankTabItems;
import com.questhelper.managers.NewVersionManager;
import com.questhelper.managers.QuestBankManager;
import com.questhelper.managers.QuestManager;
import com.questhelper.managers.QuestMenuHandler;
import com.questhelper.managers.QuestOverlayManager;
import com.questhelper.panel.QuestHelperPanel;
import com.questhelper.questhelpers.QuestDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.runeliteobjects.Cheerer;
import com.questhelper.runeliteobjects.GlobalFakeObjects;
import com.questhelper.runeliteobjects.RuneliteConfigSetter;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectManager;
import com.questhelper.statemanagement.GameStateManager;
import com.questhelper.tools.Icon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.QuestState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.bank.BankSearch;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Quest Helper", description="Helps you with questing", tags={"quest", "helper", "overlay"})
public class QuestHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(QuestHelperPlugin.class);
    @Inject
    @Named(value="developerMode")
    private boolean developerMode;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    @Inject
    private BankSearch bankSearch;
    @Inject
    private ItemManager itemManager;
    @Inject
    ChatMessageManager chatMessageManager;
    @Inject
    private QuestHelperConfig config;
    @Inject
    RuneliteObjectManager runeliteObjectManager;
    @Inject
    private QuestOverlayManager questOverlayManager;
    @Inject
    private QuestBankManager questBankManager;
    @Inject
    private QuestManager questManager;
    @Inject
    private QuestMenuHandler questMenuHandler;
    @Inject
    private NewVersionManager newVersionManager;
    @Inject
    private ColorPickerManager colorPickerManager;
    @Inject
    ConfigManager configManager;
    @Inject
    GameStateManager gameStateManager;
    private QuestHelperPanel panel;
    private NavigationButton navButton;
    public Map<String, QuestHelper> backgroundHelpers = new HashMap<String, QuestHelper>();
    public SortedMap<QuestHelperQuest, List<ItemRequirement>> itemRequirements = new TreeMap<QuestHelperQuest, List<ItemRequirement>>();
    public SortedMap<QuestHelperQuest, List<ItemRequirement>> itemRecommended = new TreeMap<QuestHelperQuest, List<ItemRequirement>>();
    private int lastTickInventoryUpdated = -1;
    private int lastTickBankUpdated = -1;
    private final Collection<String> configEvents = Arrays.asList("orderListBy", "filterListBy", "questDifficulty", "showCompletedQuests", "");
    private final Collection<String> configItemEvents = Arrays.asList("highlightNeededQuestItems", "highlightNeededMiniquestItems", "highlightNeededAchievementDiaryItems");

    @Provides
    QuestHelperConfig getConfig(ConfigManager configManager) {
        return (QuestHelperConfig)configManager.getConfig(QuestHelperConfig.class);
    }

    protected void startUp() throws IOException {
        this.questBankManager.startUp(this.injector, this.eventBus);
        this.injector.injectMembers((Object)this.gameStateManager);
        this.eventBus.register((Object)this.gameStateManager);
        this.gameStateManager.startUp();
        this.eventBus.register((Object)this.runeliteObjectManager);
        this.runeliteObjectManager.startUp();
        this.scanAndInstantiate();
        this.questOverlayManager.startUp();
        BufferedImage icon = Icon.QUEST_ICON.getImage();
        this.panel = new QuestHelperPanel(this, this.questManager);
        this.questManager.startUp(this.panel);
        this.navButton = NavigationButton.builder().tooltip("Quest Helper").icon(icon).priority(7).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.clientThread.invokeLater(() -> {
            for (QuestHelperQuest questHelperQuest : QuestHelperQuest.values()) {
                questHelperQuest.getQuestHelper().setupRequirements();
            }
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.questManager.setupOnLogin();
                GlobalFakeObjects.createNpcs(this.client, this.runeliteObjectManager, this.configManager, this.config);
            }
        });
    }

    protected void shutDown() {
        this.runeliteObjectManager.shutDown();
        this.eventBus.unregister((Object)this.gameStateManager);
        this.eventBus.unregister((Object)this.runeliteObjectManager);
        this.questOverlayManager.shutDown();
        this.clientToolbar.removeNavigation(this.navButton);
        this.questManager.shutDown();
        this.questBankManager.shutDown(this.eventBus);
        GlobalFakeObjects.setInitialized(false);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.questBankManager.loadInitialStateFromConfig(this.client);
        this.questManager.updateQuestState();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.BANK)) {
            this.lastTickBankUpdated = this.client.getTickCount();
            this.questBankManager.updateLocalBank(event.getItemContainer());
        }
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY)) {
            this.lastTickInventoryUpdated = this.client.getTickCount();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState state = event.getGameState();
        if (state == GameState.LOGIN_SCREEN) {
            this.questBankManager.saveBankToConfig();
            SwingUtilities.invokeLater(() -> this.panel.refresh(Collections.emptyList(), true, new HashMap<QuestHelperQuest, QuestState>(), new QuestHelperConfig.QuestFilter[0]));
            this.questBankManager.emptyState();
            this.questManager.shutDownQuest(true);
        }
        if (state == GameState.LOGGED_IN) {
            this.newVersionManager.updateChatWithNotificationIfNewVersion();
            GlobalFakeObjects.createNpcs(this.client, this.runeliteObjectManager, this.configManager, this.config);
            this.questBankManager.setUnknownInitialState();
            this.clientThread.invokeLater(() -> this.questManager.setupOnLogin());
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.questManager.handleVarbitChanged();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.questManager.handleConfigChanged();
        if (event.getGroup().equals("questhelpervars")) {
            this.clientThread.invokeLater(this::updateQuestList);
        }
        if (!event.getGroup().equals("questhelper")) {
            return;
        }
        if (event.getKey().equals("showRuneliteObjects")) {
            this.clientThread.invokeLater(() -> {
                if (this.config.showRuneliteObjects()) {
                    GlobalFakeObjects.createNpcs(this.client, this.runeliteObjectManager, this.configManager, this.config);
                } else {
                    GlobalFakeObjects.disableNpcs(this.runeliteObjectManager);
                }
            });
        }
        if (this.configEvents.contains(event.getKey())) {
            this.clientThread.invokeLater(this::updateQuestList);
        }
        if (this.configItemEvents.contains(event.getKey())) {
            this.questManager.updateAllItemsHelper();
        }
        if ("highlightItemsBackground".equals(event.getKey())) {
            this.questManager.updateAllItemsBackgroundHelper(event.getNewValue());
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if (this.developerMode && commandExecuted.getCommand().equals("questhelperdebug")) {
            if (commandExecuted.getArguments().length == 0 || Arrays.stream(commandExecuted.getArguments()).toArray()[0].equals("disable")) {
                this.questOverlayManager.removeDebugOverlay();
            } else if (Arrays.stream(commandExecuted.getArguments()).toArray()[0].equals("enable")) {
                this.questOverlayManager.addDebugOverlay();
            }
        } else if (this.developerMode && commandExecuted.getCommand().equals("reset-cooks-helper")) {
            String step = (String)Arrays.stream(commandExecuted.getArguments()).toArray()[0];
            new RuneliteConfigSetter(this.configManager, QuestHelperQuest.COOKS_HELPER.getPlayerQuests().getConfigValue(), step).setConfigValue();
        } else if (this.developerMode && commandExecuted.getCommand().equals("qh-inv")) {
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            StringBuilder inv = new StringBuilder();
            if (inventory != null) {
                for (Item item : inventory.getItems()) {
                    inv.append(item.getId()).append("\n");
                }
            }
            System.out.println(inv);
        }
    }

    @Subscribe(priority=100.0f)
    private void onClientShutdown(ClientShutdown e) {
        this.questBankManager.saveBankToConfig();
    }

    public void refreshBank() {
        this.clientThread.invokeLater(() -> this.questBankManager.refreshBankTab());
    }

    public List<BankTabItems> getPluginBankTagItemsForSections() {
        return this.questBankManager.getBankTagService().getPluginBankTagItemsForSections(false);
    }

    public void updateQuestList() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            List filteredQuests = QuestHelperQuest.getQuestHelpers().stream().filter(this.config.filterListBy()).filter(this.config.difficulty()).filter(QuestDetails::showCompletedQuests).sorted(this.config.orderListBy()).collect(Collectors.toList());
            Map<QuestHelperQuest, QuestState> completedQuests = QuestHelperQuest.getQuestHelpers().stream().collect(Collectors.toMap(QuestHelper::getQuest, q -> q.getState(this.client)));
            SwingUtilities.invokeLater(() -> this.panel.refresh(filteredQuests, false, completedQuests, this.config.orderListBy().getSections()));
        }
    }

    public QuestHelper getSelectedQuest() {
        return this.questManager.getSelectedQuest();
    }

    public List<Integer> itemsToTag() {
        return this.questBankManager.getBankTagService().itemsToTag();
    }

    private void addCheerer() {
        Cheerer.activateCheerer(this.client, this.chatMessageManager);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        int widgetIndex = event.getActionParam0();
        int widgetID = event.getActionParam1();
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        String option = event.getOption();
        String target = Text.removeTags((String)event.getTarget());
        this.questMenuHandler.setupQuestMenuOptions(menuEntries, widgetIndex, widgetID, target, option);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.config.showFan() && chatMessage.getType() == ChatMessageType.GAMEMESSAGE && (chatMessage.getMessage().contains("Congratulations! Quest complete!") || chatMessage.getMessage().contains("you've completed a quest"))) {
            this.addCheerer();
        }
        if (this.config.autoStartQuests() && chatMessage.getType() == ChatMessageType.GAMEMESSAGE && this.questManager.getSelectedQuest() == null && chatMessage.getMessage().contains("You've started a new quest")) {
            String questName = chatMessage.getMessage().substring(chatMessage.getMessage().indexOf(">") + 1);
            questName = questName.substring(0, questName.indexOf("<"));
            this.questMenuHandler.startUpQuest(questName);
        }
    }

    public void displayPanel() {
        SwingUtilities.invokeLater(() -> {
            if (!this.navButton.isSelected()) {
                this.navButton.getOnSelect().run();
            }
        });
    }

    private void scanAndInstantiate() {
        for (QuestHelperQuest qhq : QuestHelperQuest.values()) {
            this.instantiate(qhq);
        }
    }

    private void instantiate(QuestHelperQuest quest) {
        QuestHelper questHelper = quest.getQuestHelper();
        Module questModule = binder -> {
            binder.bind(QuestHelper.class).toInstance((Object)questHelper);
            binder.install((Module)questHelper);
        };
        Injector questInjector = RuneLite.getInjector().createChildInjector(new Module[]{questModule});
        this.injector.injectMembers((Object)questHelper);
        questHelper.setInjector(questInjector);
        questHelper.setQuest(quest);
        questHelper.setConfig(this.config);
        questHelper.setQuestHelperPlugin(this);
        log.debug("Loaded quest helper {}", (Object)quest.name());
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public BankSearch getBankSearch() {
        return this.bankSearch;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public ChatMessageManager getChatMessageManager() {
        return this.chatMessageManager;
    }

    public QuestHelperConfig getConfig() {
        return this.config;
    }

    public RuneliteObjectManager getRuneliteObjectManager() {
        return this.runeliteObjectManager;
    }

    public ColorPickerManager getColorPickerManager() {
        return this.colorPickerManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GameStateManager getGameStateManager() {
        return this.gameStateManager;
    }

    public int getLastTickInventoryUpdated() {
        return this.lastTickInventoryUpdated;
    }

    public int getLastTickBankUpdated() {
        return this.lastTickBankUpdated;
    }
}

