/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper;

import com.questhelper.panel.questorders.QuestOrders;
import com.questhelper.questhelpers.QuestDetails;
import com.questhelper.questhelpers.QuestHelper;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.util.Text;

@ConfigGroup(value="questhelper")
public interface QuestHelperConfig
extends Config {
    public static final String QUEST_HELPER_GROUP = "questhelper";
    public static final String QUEST_BACKGROUND_GROUP = "questhelpervars";
    @ConfigSection(position=0, name="Item highlighting", description="Determines what items to highlight in the background")
    public static final String itemSection = "itemSection";
    @ConfigSection(position=1, name="Quest Hints", description="Determines what hints should be shown")
    public static final String hintsSection = "hintsSection";
    @ConfigSection(position=1, name="Colours", description="What colour each option can be")
    public static final String colorSection = "colorSection";
    @ConfigSection(position=2, name="Quest Filters", description="Determines which quests should be shown via the selected filter(s)")
    public static final String filterSection = "filterSection";

    @ConfigItem(keyName="autostartQuests", name="Auto start helper", description="Automatically start the quest helper when you start a quest")
    default public boolean autoStartQuests() {
        return true;
    }

    @ConfigItem(keyName="autoOpenSidebar", name="Auto open sidebar", description="Automatically opens the quest helper sidebar when you start a quest")
    default public boolean autoOpenSidebar() {
        return true;
    }

    @ConfigItem(keyName="showOverlayPanel", name="Display overlay on screen", description="Chose whether the overlay should be displayed on screen")
    default public boolean showOverlay() {
        return true;
    }

    @ConfigItem(keyName="stewBoostsPanel", name="Use Spicy stew for boosts", description="Raises the boost maximum boost for certain skills to 5")
    default public boolean stewBoosts() {
        return false;
    }

    @ConfigItem(keyName="showFan", name="Fan appears on quest completion", description="Have someone appear to celebrate whenever you complete a quest")
    default public boolean showFan() {
        return false;
    }

    @ConfigItem(keyName="showRuneliteObjects", name="Show player-made quest rewards", description="Choose whether changes from player-made quests are displayed")
    default public boolean showRuneliteObjects() {
        return true;
    }

    @ConfigItem(position=0, keyName="highlightItemsBackground", name="Always highlight needed items", description="Highlight items you need for marked content type at all times", section="itemSection")
    default public boolean highlightItemsBackground() {
        return false;
    }

    @ConfigItem(position=1, keyName="highlightNeededQuestItems", name="Highlight active quest items", description="Highlight all the active quest's items you're missing on the floor", section="itemSection")
    default public boolean highlightNeededQuestItems() {
        return true;
    }

    @ConfigItem(position=2, keyName="highlightNeededMiniquestItems", name="Highlight miniquest items", description="Highlight all miniquest items you're missing on the floor", section="itemSection")
    default public boolean highlightNeededMiniquestItems() {
        return true;
    }

    @ConfigItem(position=3, keyName="highlightNeededAchievementDiaryItems", name="Highlight achievement diary items", description="Highlight all achievement diary items you're missing on the floor", section="itemSection")
    default public boolean highlightNeededAchievementDiaryItems() {
        return true;
    }

    @ConfigItem(keyName="showTextHighlight", name="Highlight correct dialog", description="Highlight correct dialog choices", section="hintsSection")
    default public boolean showTextHighlight() {
        return true;
    }

    @ConfigItem(keyName="showSymbolOverlay", name="Display icons on NPCs and objects", description="Choose whether NPCs should have icons marking them as the current target or not", section="hintsSection")
    default public boolean showSymbolOverlay() {
        return true;
    }

    @ConfigItem(keyName="highlightStyleNpcs", name="Highlight style NPCs", description="Choose the highlight style of the target NPCs", section="hintsSection")
    default public NpcHighlightStyle highlightStyleNpcs() {
        return NpcHighlightStyle.OUTLINE;
    }

    @ConfigItem(keyName="highlightStyleObjects", name="Highlight style objects", description="Choose the highlight style of the target objects", section="hintsSection")
    default public ObjectHighlightStyle highlightStyleObjects() {
        return ObjectHighlightStyle.OUTLINE;
    }

    @ConfigItem(keyName="highlightStyleGroundItems", name="Highlight style ground items", description="Choose the highlight style of the target items", section="hintsSection")
    default public GroundItemHighlightStyle highlightStyleGroundItems() {
        return GroundItemHighlightStyle.OUTLINE;
    }

    @ConfigItem(keyName="highlightStyleInventoryItems", name="Highlight style inventory items", description="Choose the highlight style of the target inventory items", section="hintsSection")
    default public InventoryItemHighlightStyle highlightStyleInventoryItems() {
        return InventoryItemHighlightStyle.FILLED_OUTLINE;
    }

    @Range(min=0, max=50)
    @ConfigItem(keyName="outlineThickness", name="Outline thickness", description="Choose the thickness of target model outlines", section="hintsSection")
    default public int outlineThickness() {
        return 4;
    }

    @Range(min=0, max=4)
    @ConfigItem(keyName="outlineFeathering", name="Outline feathering", description="Choose how the model outline is faded out", section="hintsSection")
    default public int outlineFeathering() {
        return 4;
    }

    @ConfigItem(keyName="showMiniMapArrow", name="Display arrows on the mini-map and overworld", description="Choose whether flashing arrows point to the next objective", section="hintsSection")
    default public boolean showMiniMapArrow() {
        return true;
    }

    @ConfigItem(keyName="showWorldLines", name="Display navigation paths", description="Choose whether navigation paths are drawn to the next objective", section="hintsSection")
    default public boolean showWorldLines() {
        return true;
    }

    @ConfigItem(keyName="showWidgetHints", name="Display widget hints", description="Choose whether important widget actions are highlighted", section="hintsSection")
    default public boolean showWidgetHints() {
        return true;
    }

    @ConfigItem(keyName="textHighlightColor", name="Text highlight colour", description="Change the colour of dialog choices highlighted by the helper", section="colorSection")
    default public Color textHighlightColor() {
        return Color.BLUE;
    }

    @ConfigItem(keyName="targetOverlayColor", name="Color of target overlay", description="Change the colour which target NPCs/Objects will be highlighted with", section="colorSection")
    default public Color targetOverlayColor() {
        return Color.CYAN;
    }

    @ConfigItem(keyName="passColour", name="Colour of passed requirements/checks", description="Change the colour that will indicate a check has passed", section="colorSection")
    default public Color passColour() {
        return Color.GREEN;
    }

    @ConfigItem(keyName="failColour", name="Colour of failed requirements/checks", description="Change the colour that will indicate a check has failed", section="colorSection")
    default public Color failColour() {
        return Color.RED;
    }

    @ConfigItem(keyName="boostColour", name="Colour of boostable skill", description="Change the colour that will indicate a skill level check has passed", section="colorSection")
    default public Color boostColour() {
        return Color.ORANGE;
    }

    @ConfigItem(keyName="debugColor", name="Debug Colour", description="debug", hidden=true, section="colorSection")
    default public Color debugColor() {
        return Color.MAGENTA;
    }

    @ConfigItem(keyName="orderListBy", name="Quest order", description="Configures which way to order the quest list", position=3, section="filterSection")
    default public QuestOrdering orderListBy() {
        return QuestOrdering.A_TO_Z;
    }

    @ConfigItem(keyName="filterListBy", name="Filter", description="Configures what to filter in the quest list", position=1, section="filterSection")
    default public QuestFilter filterListBy() {
        return QuestFilter.SHOW_ALL;
    }

    @ConfigItem(keyName="questDifficulty", name="Difficulty", description="Configures what quest difficulty to show", position=2, section="filterSection")
    default public QuestDetails.Difficulty difficulty() {
        return QuestDetails.Difficulty.ALL;
    }

    @ConfigItem(keyName="showCompletedQuests", name="Show Completed Quests", description="Will include completed quests in the other filter(s) that are chosen", position=4, section="filterSection")
    default public boolean showCompletedQuests() {
        return false;
    }

    public static enum InventoryItemHighlightStyle {
        NONE,
        SQUARE,
        OUTLINE,
        FILLED_OUTLINE;

    }

    public static enum GroundItemHighlightStyle {
        NONE,
        CLICK_BOX,
        OUTLINE,
        TILE;

    }

    public static enum ObjectHighlightStyle {
        NONE,
        CLICK_BOX,
        OUTLINE;

    }

    public static enum NpcHighlightStyle {
        NONE,
        OUTLINE,
        CONVEX_HULL,
        TILE;

    }

    public static enum QuestFilter implements Predicate<QuestHelper>
    {
        SHOW_ALL(q -> true),
        SHOW_MEETS_REQS(QuestHelper::clientMeetsRequirements),
        OPTIMAL("Optimal ordering", q -> q.getQuest().getQuestType() == QuestDetails.Type.P2P || q.getQuest().getQuestType() == QuestDetails.Type.F2P || q.getQuest().getQuestType() == QuestDetails.Type.MINIQUEST || q.getQuest().getQuestType() == QuestDetails.Type.ACHIEVEMENT_DIARY, false),
        FREE_TO_PLAY(QuestDetails.Type.F2P),
        MEMBERS(QuestDetails.Type.P2P),
        QUEST("Quests", q -> q.getQuest().getQuestType() == QuestDetails.Type.P2P || q.getQuest().getQuestType() == QuestDetails.Type.F2P),
        MINIQUEST("Miniquests", QuestDetails.Type.MINIQUEST),
        ACHIEVEMENT_DIARY("Achievement diaries", QuestDetails.Type.ACHIEVEMENT_DIARY),
        GENERIC_HELPER("Generic helpers", QuestDetails.Type.GENERIC),
        SKILL_HELPER("Skill helpers", q -> q.getQuest().getQuestType() == QuestDetails.Type.SKILL_P2P || q.getQuest().getQuestType() == QuestDetails.Type.SKILL_F2P),
        SKILL_FREE_TO_PLAY(QuestDetails.Type.SKILL_F2P),
        SKILL_MEMBERS(QuestDetails.Type.SKILL_P2P),
        PLAYER_MADE_QUESTS("Player-made quests", q -> q.getQuest().getQuestType() == QuestDetails.Type.PLAYER_QUEST);

        private final Predicate<QuestHelper> predicate;
        private final String displayName;
        protected final boolean shouldDisplay;

        private QuestFilter(Predicate<QuestHelper> predicate) {
            this.predicate = predicate;
            this.displayName = Text.titleCase((Enum)this);
            this.shouldDisplay = true;
        }

        private QuestFilter(String displayName, Predicate<QuestHelper> predicate) {
            this.predicate = predicate;
            this.displayName = displayName;
            this.shouldDisplay = true;
        }

        private QuestFilter(String displayName, Predicate<QuestHelper> predicate, boolean shouldDisplay) {
            this.predicate = predicate;
            this.displayName = displayName;
            this.shouldDisplay = shouldDisplay;
        }

        @Override
        public boolean test(QuestHelper quest) {
            return this.predicate.test(quest);
        }

        public List<QuestHelper> test(Collection<QuestHelper> helpers) {
            return helpers.stream().filter(this).collect(Collectors.toList());
        }

        public static QuestFilter[] displayFilters() {
            return (QuestFilter[])Arrays.stream(QuestFilter.values()).filter(questFilter -> questFilter.shouldDisplay).toArray(QuestFilter[]::new);
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum QuestOrdering implements Comparator<QuestHelper>
    {
        A_TO_Z(QuestOrders.sortAToZ(), QuestFilter.QUEST, QuestFilter.MINIQUEST, QuestFilter.ACHIEVEMENT_DIARY, QuestFilter.SKILL_HELPER, QuestFilter.GENERIC_HELPER, QuestFilter.PLAYER_MADE_QUESTS),
        Z_TO_A(QuestOrders.sortZToA(), QuestFilter.QUEST, QuestFilter.MINIQUEST, QuestFilter.ACHIEVEMENT_DIARY, QuestFilter.SKILL_HELPER, QuestFilter.GENERIC_HELPER, QuestFilter.PLAYER_MADE_QUESTS),
        OPTIMAL(QuestOrders.sortOptimalOrder(), QuestFilter.OPTIMAL, QuestFilter.GENERIC_HELPER),
        OPTIMAL_IRONMAN(QuestOrders.sortOptimalIronmanOrder(), QuestFilter.OPTIMAL, QuestFilter.GENERIC_HELPER),
        RELEASE_DATE(QuestOrders.sortByRelease(), QuestFilter.QUEST, QuestFilter.MINIQUEST),
        QUEST_POINTS_ASC(QuestOrders.sortByQuestPointRewardAscending(), QuestFilter.QUEST),
        QUEST_POINTS_DESC(QuestOrders.sortByQuestPointRewardDescending(), QuestFilter.QUEST);

        private final Comparator<QuestHelper> comparator;
        private final QuestFilter[] sections;

        private QuestOrdering(Comparator<QuestHelper> comparator, QuestFilter ... sections) {
            this.comparator = comparator;
            this.sections = sections;
        }

        public List<QuestHelper> sort(Collection<QuestHelper> list) {
            return list.stream().sorted(this).collect(Collectors.toList());
        }

        @Override
        public int compare(QuestHelper o1, QuestHelper o2) {
            return this.comparator.compare(o1, o2);
        }

        public QuestFilter[] getSections() {
            return this.sections;
        }
    }
}

