/*
 * Decompiled with CFR 0.152.
 */
package com.UsernameScreenshot;

import com.UsernameScreenshot.DiscordWebhookBody;
import com.UsernameScreenshot.UsernameScreenshotConfig;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Provider;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Username Screenshot", description="For when you want to share OSRS usernames you see in the wild.", tags={"screenshot", "username", "players", "discord"})
public class UsernameScreenshotPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UsernameScreenshotPlugin.class);
    private static final String SCREENSHOT = "Screenshot";
    @Inject
    private Client client;
    @Inject
    private Provider<MenuManager> menuManager;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private UsernameScreenshotConfig config;
    @Inject
    private DrawManager drawManager;
    private BufferedImage menuImage;
    @Inject
    private OkHttpClient okHttpClient;

    @Provides
    UsernameScreenshotConfig provideConfig(ConfigManager configManager) {
        return (UsernameScreenshotConfig)configManager.getConfig(UsernameScreenshotConfig.class);
    }

    protected void startUp() throws Exception {
        if (this.client != null) {
            ((MenuManager)this.menuManager.get()).addPlayerMenuItem(SCREENSHOT);
        }
    }

    protected void shutDown() throws Exception {
        if (this.client != null) {
            ((MenuManager)this.menuManager.get()).removePlayerMenuItem(SCREENSHOT);
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (Arrays.stream(event.getMenuEntries()).anyMatch(entry -> entry.getOption().equals(SCREENSHOT))) {
            log.debug("Screenshot option found");
            this.drawManager.requestNextFrameListener(image -> {
                this.menuImage = (BufferedImage)image;
            });
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER && event.getMenuOption().equals(SCREENSHOT)) {
            Player player = event.getMenuEntry().getPlayer();
            if (player == null) {
                return;
            }
            double scaleFactor = this.client.getStretchedDimensions().getWidth() / this.client.getRealDimensions().getWidth();
            String target = player.getName();
            BufferedImage screenshot = new BufferedImage(this.getMenuWidth(scaleFactor), this.getMenuHeight(scaleFactor), 2);
            Graphics graphics = screenshot.getGraphics();
            if (this.menuImage != null) {
                graphics.drawImage(this.menuImage.getSubimage(this.getMenuX(scaleFactor), this.getMenuY(scaleFactor), this.getMenuWidth(scaleFactor), this.getMenuHeight(scaleFactor)), 0, 0, null);
                ImageUploadStyle style = this.config.uploadToImgur() ? ImageUploadStyle.IMGUR : ImageUploadStyle.NEITHER;
                this.imageCapture.takeScreenshot(screenshot, target + ".png", "UsernameScreenshots", false, style);
                if (this.config.uploadToDiscord()) {
                    String localName = this.client.getLocalPlayer().getName();
                    final String discordString = this.config.discordMessage().replaceAll("\\$name", localName).replaceAll("\\$target", target);
                    this.sendWebhook(new DiscordWebhookBody(){
                        {
                            this.setContent(discordString);
                        }
                    }, screenshot);
                }
            }
        }
    }

    private int getMenuWidth(double scaleFactor) {
        return (int)((double)this.client.getMenuWidth() * scaleFactor);
    }

    private int getMenuHeight(double scaleFactor) {
        return (int)((double)this.client.getMenuHeight() * scaleFactor);
    }

    private int getMenuX(double scaleFactor) {
        return (int)((double)this.client.getMenuX() * scaleFactor);
    }

    private int getMenuY(double scaleFactor) {
        return (int)((double)this.client.getMenuY() * scaleFactor);
    }

    private void sendWebhook(DiscordWebhookBody discordWebhookBody, BufferedImage image) {
        String configUrl = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        List webhookUrls = Arrays.asList(configUrl.split("\n")).stream().filter(u -> u.length() > 0).map(u -> u.trim()).collect(Collectors.toList());
        for (String webhookUrl : webhookUrls) {
            byte[] screenshotBytes;
            HttpUrl url = HttpUrl.parse((String)webhookUrl);
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody, DiscordWebhookBody.class));
            try {
                screenshotBytes = UsernameScreenshotPlugin.convertImageToByteArray(image);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])screenshotBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        }
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }
}

