/*
 * Decompiled with CFR 0.152.
 */
package com.hydratereminder;

import com.hydratereminder.HydrateReminderChatMessageType;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="hydratereminder")
public interface HydrateReminderConfig
extends Config {
    public static final int INTERVAL_LIMIT_MIN = 1;
    public static final int INTERVAL_LIMIT_MAX = 120;

    @ConfigItem(keyName="hydrateReminderWelcomeMessageEnabled", name="Welcome message", description="Sets whether or not the welcome message should be displayed", position=1)
    default public boolean hydrateReminderWelcomeMessageEnabled() {
        return false;
    }

    @Range(min=1, max=120)
    @ConfigItem(keyName="hydrateReminderInterval", name="Hydrate interval", description="The time interval between each hydrate reminder", position=2)
    @Units(value=" mins")
    default public int hydrateReminderInterval() {
        return 20;
    }

    @ConfigItem(keyName="hydrateReminderChatMessageEnabled", name="Chat notification", description="Sets the hydrate reminder to be sent as a chat message", position=3)
    default public boolean hydrateReminderChatMessageEnabled() {
        return true;
    }

    @ConfigItem(keyName="hydrateReminderChatMessageType", name="Chat type", description="Sets the type of chat message sent by hydrate reminder", position=4)
    default public HydrateReminderChatMessageType hydrateReminderChatMessageType() {
        return HydrateReminderChatMessageType.GAMEMESSAGE;
    }

    @ConfigItem(keyName="hydrateReminderComputerNotificationEnabled", name="Computer notification", description="Sets the hydrate reminder to be sent as a computer notification", position=5)
    default public boolean hydrateReminderComputerNotificationEnabled() {
        return false;
    }
}

