/*
 * Decompiled with CFR 0.152.
 */
package com.visualticks;

import com.google.inject.Provides;
import com.visualticks.VisualTicksConfig;
import com.visualticks.VisualTicksOverlay;
import javax.inject.Inject;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Visual Ticks")
public class VisualTicksPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VisualTicksPlugin.class);
    @Inject
    private VisualTicksConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private VisualTicksOverlay overlay;
    public int tick = 0;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    private void onGameTick(GameTick gameTick) {
        ++this.tick;
        if (this.tick > this.config.numberOfTicks() - 1) {
            this.tick = 0;
        }
    }

    @Provides
    VisualTicksConfig provideConfig(ConfigManager configManager) {
        return (VisualTicksConfig)configManager.getConfig(VisualTicksConfig.class);
    }
}

