/*
 * Decompiled with CFR 0.152.
 */
package com.visualticks;

import com.visualticks.VisualTicksConfig;
import com.visualticks.VisualTicksPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualTicksOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(VisualTicksOverlay.class);
    @Inject
    VisualTicksPlugin plugin;
    @Inject
    VisualTicksConfig config;

    @Inject
    public VisualTicksOverlay() {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
    }

    public Dimension render(Graphics2D graphics) {
        int row = 0;
        int position = 0;
        for (int tick = 0; tick < this.config.numberOfTicks(); ++tick) {
            int x = position * this.config.sizeOfTickShapes() + position * this.config.tickPadding();
            int y = row * this.config.sizeOfTickShapes() + row * this.config.tickPadding();
            graphics.setColor(this.plugin.tick == tick ? this.config.currentTickColour() : this.config.tickColour());
            graphics.fillOval(x, y, this.config.sizeOfTickShapes(), this.config.sizeOfTickShapes());
            if (++position <= this.config.amountPerRow() - 1) continue;
            position = 0;
            ++row;
        }
        int rowsRendered = (int)Math.ceil((double)this.config.numberOfTicks() / (double)this.config.amountPerRow());
        int height = (rowsRendered - 1) * this.config.tickPadding() + rowsRendered * this.config.sizeOfTickShapes();
        int ticksRenderedPerRow = this.config.amountPerRow() > this.config.numberOfTicks() ? this.config.numberOfTicks() : this.config.amountPerRow();
        int width = (ticksRenderedPerRow - 1) * this.config.tickPadding() + ticksRenderedPerRow * this.config.sizeOfTickShapes();
        return new Dimension(width, height);
    }
}

