/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.easyteleports.replacers;

import com.duckblade.osrs.easyteleports.EasyTeleportsConfig;
import com.duckblade.osrs.easyteleports.TeleportReplacement;
import com.duckblade.osrs.easyteleports.replacers.Replacer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.widgets.Widget;

@Singleton
public class XericsTalisman
implements Replacer {
    private static final Set<String> TALISMAN_ADVENTURE_LOG_HEADER_PREFIXES = ImmutableSet.of((Object)"The talisman has", (Object)"Xeric's Talisman teleports");
    private final List<TeleportReplacement> replacements = new ArrayList<TeleportReplacement>(5);
    private boolean enabled = false;

    @Override
    public void onConfigChanged(EasyTeleportsConfig config) {
        this.enabled = config.enableXericsTalisman();
        this.replacements.clear();
        this.replacements.add(new TeleportReplacement("Xeric's Lookout", config.replacementLookout()));
        this.replacements.add(new TeleportReplacement("Xeric's Glade", config.replacementGlade()));
        this.replacements.add(new TeleportReplacement("Xeric's Inferno", config.replacementInferno()));
        this.replacements.add(new TeleportReplacement("Xeric's Heart", config.replacementHeart()));
        this.replacements.add(new TeleportReplacement("Xeric's Honour", config.replacementHonour()));
    }

    @Override
    public List<TeleportReplacement> getReplacements() {
        return ImmutableList.copyOf(this.replacements);
    }

    @Override
    public boolean isApplicableToAdventureLog(Widget root) {
        return root != null && root.getText() != null && TALISMAN_ADVENTURE_LOG_HEADER_PREFIXES.stream().anyMatch(s -> root.getText().startsWith((String)s));
    }

    @Override
    public EquipmentInventorySlot getEquipmentSlot() {
        return EquipmentInventorySlot.AMULET;
    }

    @Inject
    public XericsTalisman() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

