/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.easyteleports.replacers;

import com.duckblade.osrs.easyteleports.EasyTeleportsConfig;
import com.duckblade.osrs.easyteleports.TeleportReplacement;
import com.duckblade.osrs.easyteleports.replacers.Replacer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.widgets.Widget;

public class SlayerRing
implements Replacer {
    private static final String SLAYER_RING_DIALOG_HEADER = "Select an Option";
    private final List<TeleportReplacement> replacements = new ArrayList<TeleportReplacement>(5);
    private boolean enabled = false;

    @Override
    public void onConfigChanged(EasyTeleportsConfig config) {
        this.enabled = config.enableSlayerRing();
        this.replacements.clear();
        this.replacements.add(new TeleportReplacement("Teleport to the Stronghold Slayer Cave", config.replacementSlayerStronghold()));
        this.replacements.add(new TeleportReplacement("Teleport to the Morytania Slayer Tower", config.replacementSlayerTower()));
        this.replacements.add(new TeleportReplacement("Teleport to the Rellekka Slayer Caves", config.replacementSlayerRellekka()));
        this.replacements.add(new TeleportReplacement("Teleport to Tarn's Lair", config.replacementTarns()));
        this.replacements.add(new TeleportReplacement("Teleport to Dark Beasts", config.replacementDarkBeasts()));
    }

    @Override
    public List<TeleportReplacement> getReplacements() {
        return ImmutableList.copyOf(this.replacements);
    }

    @Override
    public boolean isApplicableToDialog(Widget root) {
        Widget[] children = root.getChildren();
        return children != null && children.length >= 5 && SLAYER_RING_DIALOG_HEADER.equals(children[0].getText());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

