/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.easyteleports.replacers;

import com.duckblade.osrs.easyteleports.EasyTeleportsConfig;
import com.duckblade.osrs.easyteleports.TeleportReplacement;
import com.duckblade.osrs.easyteleports.replacers.Replacer;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.widgets.Widget;

@Singleton
public class RingOfShadows
implements Replacer {
    private static final String RING_OF_SHADOWS_DIALOGUE_HEADER = "Where would you like to teleport to?";
    private final List<TeleportReplacement> replacements = new ArrayList<TeleportReplacement>(6);
    private boolean enabled = false;

    @Override
    public void onConfigChanged(EasyTeleportsConfig config) {
        this.enabled = config.enableRingOfShadows();
        this.replacements.clear();
        new Color(168, 161, 42);
        this.replacements.add(new TeleportReplacement("The Ancient Vault", config.replacementAncientVault()));
        this.replacements.add(new TeleportReplacement("Ancient Vault", config.replacementAncientVault()));
        this.replacements.add(new TeleportReplacement("Ghorrock Dungeon", config.replacementGhorrockDungeon()));
        this.replacements.add(new TeleportReplacement("The Scar", config.replacementScar()));
        this.replacements.add(new TeleportReplacement("Lassar Undercity", config.replacementLassarUndercity()));
        this.replacements.add(new TeleportReplacement("The Stranglewood", config.replacementStranglewood()));
    }

    @Override
    public List<TeleportReplacement> getReplacements() {
        return ImmutableList.copyOf(this.replacements);
    }

    @Override
    public boolean isApplicableToDialog(Widget root) {
        Widget[] children = root.getChildren();
        return children != null && children.length >= 5 && RING_OF_SHADOWS_DIALOGUE_HEADER.equals(children[0].getText());
    }

    @Override
    public EquipmentInventorySlot getEquipmentSlot() {
        return EquipmentInventorySlot.RING;
    }

    @Inject
    public RingOfShadows() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

