/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.easyteleports.replacers;

import com.duckblade.osrs.easyteleports.EasyTeleportsConfig;
import com.duckblade.osrs.easyteleports.TeleportReplacement;
import com.duckblade.osrs.easyteleports.replacers.Replacer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.widgets.Widget;

@Singleton
public class PharaohSceptre
implements Replacer {
    private static final String SCEPTRE_DIALOG_HEADER = "Where would you like to teleport to?";
    private final List<TeleportReplacement> replacements = new ArrayList<TeleportReplacement>(4);
    private boolean enabled = false;

    @Override
    public void onConfigChanged(EasyTeleportsConfig config) {
        this.enabled = config.enablePharaohSceptre();
        this.replacements.clear();
        this.replacements.add(new TeleportReplacement("Jalsavrah", config.replacementJalsavrah()));
        this.replacements.add(new TeleportReplacement("Jaleustrophos", config.replacementJaleustrophos()));
        this.replacements.add(new TeleportReplacement("Jaldraocht", config.replacementJaldraocht()));
        this.replacements.add(new TeleportReplacement("Jaltevas", config.replacementJaltevas()));
    }

    @Override
    public List<TeleportReplacement> getReplacements() {
        return ImmutableList.copyOf(this.replacements);
    }

    @Override
    public boolean isApplicableToDialog(Widget root) {
        Widget[] children = root.getChildren();
        return children != null && children.length >= 5 && SCEPTRE_DIALOG_HEADER.equals(children[0].getText());
    }

    @Override
    public EquipmentInventorySlot getEquipmentSlot() {
        return EquipmentInventorySlot.WEAPON;
    }

    @Inject
    public PharaohSceptre() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

