/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.easyteleports.replacers;

import com.duckblade.osrs.easyteleports.EasyTeleportsConfig;
import com.duckblade.osrs.easyteleports.TeleportReplacement;
import com.duckblade.osrs.easyteleports.replacers.Replacer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.widgets.Widget;

@Singleton
public class KharedstMemoirs
implements Replacer {
    private static final String KHAREDST_DIALOG_HEADER = "What would you like to remember?";
    private final List<TeleportReplacement> replacements = new ArrayList<TeleportReplacement>(5);
    private boolean enabled = false;

    @Override
    public void onConfigChanged(EasyTeleportsConfig config) {
        this.enabled = config.enableKharedstsMemoirs();
        this.replacements.clear();
        this.replacements.add(new TeleportReplacement("Lunch by the Lancalliums", config.replacementLancalliums()));
        this.replacements.add(new TeleportReplacement("The Fisher's Flute", config.replacementFishers()));
        this.replacements.add(new TeleportReplacement("History and Hearsay", config.replacementHistory()));
        this.replacements.add(new TeleportReplacement("Jewellery of Jubilation", config.replacementJubilation()));
        this.replacements.add(new TeleportReplacement("A Dark Disposition", config.replacementDisposition()));
        this.replacements.add(new TeleportReplacement("'Lunch by the Lancalliums' - Hosidius", config.replacementLancalliums()));
        this.replacements.add(new TeleportReplacement("'The Fisher's Flute' - Piscarilius", config.replacementFishers()));
        this.replacements.add(new TeleportReplacement("'History and Hearsay' - Shayzien", config.replacementHistory()));
        this.replacements.add(new TeleportReplacement("'Jewellery of Jubilation' - Lovakengj", config.replacementJubilation()));
        this.replacements.add(new TeleportReplacement("'A Dark Disposition' - Arceuus", config.replacementDisposition()));
    }

    @Override
    public List<TeleportReplacement> getReplacements() {
        return ImmutableList.copyOf(this.replacements);
    }

    @Override
    public boolean isApplicableToDialog(Widget root) {
        Widget[] children = root.getChildren();
        return children != null && children.length >= 5 && KHAREDST_DIALOG_HEADER.equals(children[0].getText());
    }

    @Override
    public EquipmentInventorySlot getEquipmentSlot() {
        return EquipmentInventorySlot.SHIELD;
    }

    @Inject
    public KharedstMemoirs() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

