/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.easyteleports.replacers;

import com.duckblade.osrs.easyteleports.EasyTeleportsConfig;
import com.duckblade.osrs.easyteleports.TeleportReplacement;
import com.duckblade.osrs.easyteleports.replacers.Replacer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class DrakansMedallion
implements Replacer {
    private final List<TeleportReplacement> replacements = new ArrayList<TeleportReplacement>(5);
    private boolean enabled = false;

    @Override
    public void onConfigChanged(EasyTeleportsConfig config) {
        this.enabled = config.enableDrakans();
        this.replacements.clear();
        this.replacements.add(new TeleportReplacement("Ver Sinhaza", config.replacementVerSinhaza()));
        this.replacements.add(new TeleportReplacement("Darkmeyer", config.replacementDarkmeyer()));
        this.replacements.add(new TeleportReplacement("Slepe", config.replacementSlepe()));
    }

    @Override
    public List<TeleportReplacement> getReplacements() {
        return ImmutableList.copyOf(this.replacements);
    }

    @Override
    public boolean isApplicableToInventory(int itemId) {
        return itemId == 22400;
    }

    @Override
    public EquipmentInventorySlot getEquipmentSlot() {
        return EquipmentInventorySlot.AMULET;
    }

    @Inject
    public DrakansMedallion() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

