/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.easyteleports.replacers;

import com.duckblade.osrs.easyteleports.EasyTeleportsConfig;
import com.duckblade.osrs.easyteleports.TeleportReplacement;
import com.duckblade.osrs.easyteleports.replacers.Replacer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.widgets.Widget;

public class DiaryCape
implements Replacer {
    private static final String ADVENTURE_LOG_HEADER = "Diary Masters";
    private final List<TeleportReplacement> replacements = new ArrayList<TeleportReplacement>(5);
    private boolean enabled = false;

    @Override
    public void onConfigChanged(EasyTeleportsConfig config) {
        this.enabled = config.enableDiaryCape();
        this.replacements.clear();
        this.replacements.add(new TeleportReplacement("Ardougne: Two-pints", config.replacementArdougne()));
        this.replacements.add(new TeleportReplacement("Desert: Jarr", config.replacementDesert()));
        this.replacements.add(new TeleportReplacement("Falador: Sir Rebral", config.replacementFalador()));
        this.replacements.add(new TeleportReplacement("Fremennik: Thorodin", config.replacementFremennik()));
        this.replacements.add(new TeleportReplacement("Kandarin: Flax keeper", config.replacementKandarin()));
        this.replacements.add(new TeleportReplacement("Karamja: Pirate Jackie the Fruit", config.replacementKaramjaJackie()));
        this.replacements.add(new TeleportReplacement("Karamja: Kaleb Paramaya (retired)", config.replacementKaramjaKaleb()));
        this.replacements.add(new TeleportReplacement("Karamja: Jungle forester (retired)", config.replacementKaramjaForester()));
        this.replacements.add(new TeleportReplacement("Karamja: TzHaar-Mej (retired)", config.replacementKaramjaTzhaar()));
        this.replacements.add(new TeleportReplacement("Kourend & Kebos: Elise", config.replacementKourend()));
        this.replacements.add(new TeleportReplacement("Lumbridge & Draynor: Hatius Cosaintus", config.replacementLumbridge()));
        this.replacements.add(new TeleportReplacement("Morytania: Le-sabr\u00e8", config.replacementMorytania()));
        this.replacements.add(new TeleportReplacement("Varrock: Toby", config.replacementVarrock()));
        this.replacements.add(new TeleportReplacement("Wilderness: Lesser Fanatic", config.replacementWilderness()));
        this.replacements.add(new TeleportReplacement("Western Provinces: Elder Gnome child", config.replacementWestern()));
        this.replacements.add(new TeleportReplacement("Twiggy O'Korn", config.replacementTwiggy()));
    }

    @Override
    public List<TeleportReplacement> getReplacements() {
        return ImmutableList.copyOf(this.replacements);
    }

    @Override
    public boolean isApplicableToAdventureLog(Widget root) {
        return root != null && root.getText() != null && ADVENTURE_LOG_HEADER.equals(root.getText());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

