/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.easyteleports;

import com.duckblade.osrs.easyteleports.EasyTeleportsConfig;
import com.duckblade.osrs.easyteleports.TeleportReplacement;
import com.duckblade.osrs.easyteleports.replacers.DiaryCape;
import com.duckblade.osrs.easyteleports.replacers.DrakansMedallion;
import com.duckblade.osrs.easyteleports.replacers.KharedstMemoirs;
import com.duckblade.osrs.easyteleports.replacers.PharaohSceptre;
import com.duckblade.osrs.easyteleports.replacers.Replacer;
import com.duckblade.osrs.easyteleports.replacers.RingOfDueling;
import com.duckblade.osrs.easyteleports.replacers.RingOfShadows;
import com.duckblade.osrs.easyteleports.replacers.SlayerRing;
import com.duckblade.osrs.easyteleports.replacers.XericsTalisman;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Easy Teleports", tags={"Pharaoh's", "Sceptre", "xeric's", "talisman", "kharedst's", "memoirs"})
@Singleton
public class EasyTeleportsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EasyTeleportsPlugin.class);
    private static final Map<Integer, EquipmentInventorySlot> ACTION_PARAM_1_TO_EQUIPMENT_SLOT = ImmutableMap.builder().put((Object)25362447, (Object)EquipmentInventorySlot.HEAD).put((Object)25362448, (Object)EquipmentInventorySlot.CAPE).put((Object)25362449, (Object)EquipmentInventorySlot.AMULET).put((Object)25362457, (Object)EquipmentInventorySlot.AMMO).put((Object)25362450, (Object)EquipmentInventorySlot.WEAPON).put((Object)25362451, (Object)EquipmentInventorySlot.BODY).put((Object)25362452, (Object)EquipmentInventorySlot.SHIELD).put((Object)25362453, (Object)EquipmentInventorySlot.LEGS).put((Object)25362454, (Object)EquipmentInventorySlot.GLOVES).put((Object)25362455, (Object)EquipmentInventorySlot.BOOTS).put((Object)25362456, (Object)EquipmentInventorySlot.RING).build();
    private static final int ACTION_PARAM_1_INVENTORY = 0x950000;
    private static final int GROUP_ID_JEWELLERY_BOX = 590;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EasyTeleportsConfig config;
    @Inject
    private Set<Replacer> replacers;

    public void configure(Binder binder) {
        Multibinder<Replacer> replacers = Multibinder.newSetBinder(binder, Replacer.class);
        replacers.addBinding().to(DiaryCape.class);
        replacers.addBinding().to(DrakansMedallion.class);
        replacers.addBinding().to(KharedstMemoirs.class);
        replacers.addBinding().to(PharaohSceptre.class);
        replacers.addBinding().to(RingOfDueling.class);
        replacers.addBinding().to(RingOfShadows.class);
        replacers.addBinding().to(SlayerRing.class);
        replacers.addBinding().to(XericsTalisman.class);
    }

    protected void startUp() {
        this.propagateConfig();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals("easypharaohsceptre")) {
            this.propagateConfig();
        }
    }

    private void propagateConfig() {
        this.replacers.forEach(r -> r.onConfigChanged(this.config));
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() == WidgetInfo.DIALOG_OPTION_OPTIONS.getGroupId()) {
            this.clientThread.invokeLater(() -> this.replaceWidgetChildren(WidgetInfo.DIALOG_OPTION_OPTIONS, Replacer::isApplicableToDialog));
        }
        if (e.getGroupId() == 187) {
            this.clientThread.invokeLater(() -> {
                Widget advLogHeader = this.getAdventureLogHeader();
                this.replaceWidgetChildren(187, 3, (r, w) -> r.isApplicableToAdventureLog(advLogHeader));
            });
            return;
        }
        if (e.getGroupId() == 590) {
            this.clientThread.invokeLater(() -> {
                Widget jewelleryBoxRoot = this.client.getWidget(590, 0);
                if (jewelleryBoxRoot == null) {
                    return;
                }
                for (int i = 0; i < 6; ++i) {
                    this.replaceWidgetChildren(590, 2 + i, (r, w) -> r.isApplicableToJewelleryBox());
                }
            });
        }
    }

    private void replaceWidgetChildren(WidgetInfo widgetInfo, BiPredicate<Replacer, Widget> filterSelector) {
        this.replaceWidgetChildren(widgetInfo.getGroupId(), widgetInfo.getChildId(), filterSelector);
    }

    private void replaceWidgetChildren(int groupId, int entriesChildId, BiPredicate<Replacer, Widget> filterSelector) {
        Widget root = this.client.getWidget(groupId, entriesChildId);
        if (root == null) {
            return;
        }
        Widget[] children = root.getChildren();
        if (children == null) {
            return;
        }
        List<TeleportReplacement> applicableReplacements = this.getApplicableReplacements(r -> filterSelector.test((Replacer)r, root));
        for (Widget child : children) {
            EasyTeleportsPlugin.applyReplacement(applicableReplacements, child, Widget::getText, Widget::setText);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded e) {
        if (e.getActionParam1() == 0x950000) {
            List<TeleportReplacement> applicableReplacements = this.getApplicableReplacements(r -> r.isApplicableToInventory(e.getMenuEntry().getItemId()));
            EasyTeleportsPlugin.applyReplacement(applicableReplacements, e.getMenuEntry(), MenuEntry::getOption, MenuEntry::setOption);
            return;
        }
        EquipmentInventorySlot equipmentSlot = ACTION_PARAM_1_TO_EQUIPMENT_SLOT.get(e.getActionParam1());
        if (equipmentSlot != null) {
            List<TeleportReplacement> applicableReplacements = this.getApplicableReplacements(r -> r.getEquipmentSlot() == equipmentSlot);
            EasyTeleportsPlugin.applyReplacement(applicableReplacements, e.getMenuEntry(), MenuEntry::getOption, MenuEntry::setOption);
        }
    }

    private List<TeleportReplacement> getApplicableReplacements(Predicate<Replacer> filter) {
        return this.replacers.stream().filter(Replacer::isEnabled).filter(filter).flatMap(r -> r.getReplacements().stream()).collect(Collectors.toList());
    }

    private Widget getAdventureLogHeader() {
        Widget adventureLogRoot = this.client.getWidget(WidgetInfo.ADVENTURE_LOG);
        if (adventureLogRoot == null) {
            return null;
        }
        Widget[] children = adventureLogRoot.getChildren();
        if (children == null || children.length < 2) {
            return null;
        }
        return children[1];
    }

    @Provides
    public EasyTeleportsConfig provideConfig(ConfigManager configManager) {
        return (EasyTeleportsConfig)configManager.getConfig(EasyTeleportsConfig.class);
    }

    private static <T> void applyReplacement(List<TeleportReplacement> replacements, T entry, Function<T, String> getter, BiConsumer<T, String> setter) {
        String entryText = null;
        try {
            entryText = getter.apply(entry);
            if (Strings.isNullOrEmpty((String)entryText)) {
                return;
            }
            for (TeleportReplacement replacement : replacements) {
                if (!entryText.contains(replacement.getOriginal())) continue;
                String newText = entryText.replace(replacement.getOriginal(), replacement.getReplacement());
                setter.accept(entry, newText);
            }
        }
        catch (Exception e) {
            log.error("Failed to replace option [{}] on entry [{}]", (Object)entryText, (Object)entry.toString());
        }
    }
}

