/*
 * Decompiled with CFR 0.152.
 */
package bbp.equipmentscreenshot;

import bbp.equipmentscreenshot.EquipmentScreenshotConfig;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Point;
import net.runelite.api.SpritePixels;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;

class EquipmentScreenshotUtil {
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private EquipmentScreenshotConfig config;
    static final int EQUIPMENT_PADDING = 2;
    private Map<Integer, SpritePixels> spriteOverrides = null;
    private static final Map<EquipmentInventorySlot, java.awt.Point> EQUIPMENT_ICON_OFFSETS = new ImmutableMap.Builder().put((Object)EquipmentInventorySlot.HEAD, (Object)new java.awt.Point(6, 4)).put((Object)EquipmentInventorySlot.CAPE, (Object)new java.awt.Point(5, 1)).put((Object)EquipmentInventorySlot.AMULET, (Object)new java.awt.Point(8, 9)).put((Object)EquipmentInventorySlot.WEAPON, (Object)new java.awt.Point(4, 4)).put((Object)EquipmentInventorySlot.BODY, (Object)new java.awt.Point(2, 9)).put((Object)EquipmentInventorySlot.SHIELD, (Object)new java.awt.Point(3, 3)).put((Object)EquipmentInventorySlot.LEGS, (Object)new java.awt.Point(8, 2)).put((Object)EquipmentInventorySlot.GLOVES, (Object)new java.awt.Point(1, 2)).put((Object)EquipmentInventorySlot.BOOTS, (Object)new java.awt.Point(4, 6)).put((Object)EquipmentInventorySlot.RING, (Object)new java.awt.Point(8, 8)).put((Object)EquipmentInventorySlot.AMMO, (Object)new java.awt.Point(5, 6)).build();

    EquipmentScreenshotUtil() {
    }

    BufferedImage getImage(Item item) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(item.getId());
        return this.itemManager.getImage(item.getId(), item.getQuantity(), itemComposition.isStackable());
    }

    BufferedImage copy(BufferedImage bi) {
        return new BufferedImage(bi.getColorModel(), bi.copyData(null), bi.getColorModel().isAlphaPremultiplied(), null);
    }

    BufferedImage getImageFromSpriteID(int spriteID, boolean crop, boolean useResourcePack) {
        BufferedImage bi = null;
        this.spriteOverrides = this.client.getSpriteOverrides();
        if (useResourcePack && this.spriteOverrides.containsKey(spriteID) && this.spriteOverrides.get(spriteID) != null) {
            bi = this.copy(this.spriteOverrides.get(spriteID).toBufferedImage());
        } else {
            BufferedImage sprite = this.spriteManager.getSprite(spriteID, 0);
            if (sprite != null) {
                bi = this.copy(sprite);
            }
        }
        if (crop) {
            bi = this.trimImage(bi);
        }
        return bi;
    }

    BufferedImage getCroppedImageFromSpriteID(int spriteID, boolean useResourcePack) {
        return this.getImageFromSpriteID(spriteID, true, useResourcePack);
    }

    void drawEquipmentIcon(Graphics2D g2d, EquipmentInventorySlot eis, java.awt.Point p, Map<EquipmentInventorySlot, BufferedImage> EQUIPMENT_ICONS, boolean useResourcePack) {
        java.awt.Point iconOffset = new java.awt.Point(0, 0);
        this.spriteOverrides = this.client.getSpriteOverrides();
        boolean resourcePackLoaded = this.spriteOverrides.containsKey(156);
        if (!useResourcePack || !resourcePackLoaded) {
            iconOffset = EQUIPMENT_ICON_OFFSETS.get(eis);
        }
        BufferedImage bi = EQUIPMENT_ICONS.get(eis);
        g2d.drawImage(bi, null, p.x + 2 + iconOffset.x, p.y + 2 + iconOffset.y);
    }

    boolean isEmpty(ItemContainer ic) {
        boolean empty = true;
        for (Item i : ic.getItems()) {
            if (i.getId() == -1) continue;
            empty = false;
            break;
        }
        return empty;
    }

    private BufferedImage trimImage(BufferedImage image) {
        int y;
        int x;
        int top;
        if (image == null) {
            return null;
        }
        WritableRaster raster = image.getAlphaRaster();
        if (raster == null) {
            return image;
        }
        int width = raster.getWidth();
        int height = raster.getHeight();
        int left = 0;
        int right = width - 1;
        int bottom = height - 1;
        int minRight = width - 1;
        int minBottom = height - 1;
        block0: for (top = 0; top < bottom; ++top) {
            for (x = 0; x < width; ++x) {
                if (raster.getSample(x, top, 0) == 0) continue;
                minRight = x;
                minBottom = top;
                break block0;
            }
        }
        block2: while (left < minRight) {
            for (y = height - 1; y > top; --y) {
                if (raster.getSample(left, y, 0) == 0) continue;
                minBottom = y;
                break block2;
            }
            ++left;
        }
        block4: while (bottom > minBottom) {
            for (x = width - 1; x >= left; --x) {
                if (raster.getSample(x, bottom, 0) == 0) continue;
                minRight = x;
                break block4;
            }
            --bottom;
        }
        block6: while (right > minRight) {
            for (y = bottom; y >= top; --y) {
                if (raster.getSample(right, y, 0) != 0) break block6;
            }
            --right;
        }
        return image.getSubimage(left, top, right - left + 1, bottom - top + 1);
    }

    void tileImage(Graphics2D g2d, BufferedImage bi, java.awt.Point start, java.awt.Point finish) {
        int times;
        int y;
        int x = Math.abs(start.x - finish.x) / bi.getWidth();
        boolean horizontal = x > (y = Math.abs(start.y - finish.y) / bi.getHeight());
        int n = times = horizontal ? x : y;
        while (times >= 0) {
            g2d.drawImage(bi, null, start.x + (horizontal ? times * bi.getWidth() : 0), start.y + (!horizontal ? times * bi.getHeight() : 0));
            --times;
        }
    }

    void drawIconWithText(Graphics2D g2d, java.awt.Point d, BufferedImage bi, int spacing, String str, boolean addPlusSign) {
        java.awt.Point p = new java.awt.Point(d.getLocation());
        if (((String)str).endsWith(".0%") || ((String)str).endsWith(".0")) {
            str = ((String)str).replace(".0", "");
        }
        if (addPlusSign && ((String)str).charAt(0) != '-' && ((String)str).charAt(0) != '0') {
            str = "+" + (String)str;
        }
        FontMetrics metrics = g2d.getFontMetrics(g2d.getFont());
        int textHOffset = metrics.stringWidth((String)str) / 2;
        int imageHOffset = bi.getWidth() / 2;
        int imageVOffset = (bi.getHeight() + (!((String)str).equals("") ? metrics.getHeight() - metrics.getLeading() : 0) + spacing) / 2;
        g2d.drawImage(bi, null, p.x - imageHOffset, p.y - imageVOffset);
        p.translate(-textHOffset, -imageVOffset + bi.getHeight() + (!((String)str).equals("") ? spacing + metrics.getHeight() : 0));
        this.drawTextWithShadow(g2d, p, (String)str);
    }

    void drawIconWithText(Graphics2D g2d, java.awt.Point p, int spriteID, boolean useResourcePack, int spacing, String str, boolean addPlusSign) {
        BufferedImage bi = this.getCroppedImageFromSpriteID(spriteID, useResourcePack);
        this.drawIconWithText(g2d, p, bi, spacing, str, addPlusSign);
    }

    void drawIconWithText(Graphics2D g2d, java.awt.Point p, BufferedImage bi, int spacing, int i, boolean addPlusSign) {
        String str = Integer.toString(i);
        this.drawIconWithText(g2d, p, bi, spacing, str, addPlusSign);
    }

    void drawIconWithText(Graphics2D g2d, java.awt.Point p, int spriteID, boolean useResourcePack, int spacing, int i, boolean addPlusSign) {
        BufferedImage bi = this.getCroppedImageFromSpriteID(spriteID, useResourcePack);
        this.drawIconWithText(g2d, p, bi, spacing, i, addPlusSign);
    }

    private void drawTextWithShadow(Graphics2D g2d, java.awt.Point p, String str) {
        g2d.setColor(Color.black);
        g2d.drawString(str, p.x + 1, p.y + 1);
        g2d.setColor(this.config.fontColor());
        g2d.drawString(str, p.x, p.y);
    }

    private void drawTextWithShadow(Graphics2D g2d, java.awt.Point d, int hOffset, int vOffset, String str) {
        java.awt.Point p = new java.awt.Point(d.getLocation());
        p.translate(hOffset, vOffset);
        this.drawTextWithShadow(g2d, p, str);
    }

    void drawTextWithShadow(Graphics2D g2d, Point d, int hOffset, int vOffset, String str) {
        java.awt.Point p = new java.awt.Point(d.getX(), d.getY());
        p.translate(hOffset, vOffset);
        this.drawTextWithShadow(g2d, p, str);
    }

    void drawStatIcon(Graphics2D g2d, java.awt.Point p, BufferedImage bi, int a, int d) {
        boolean showStyleIcons = this.config.showAllOptions() || this.config.showStyleIcons();
        boolean overlapStatIcons = this.config.showAllOptions() || this.config.overlapStats();
        int spacing = overlapStatIcons ? 0 : 10;
        FontMetrics metrics = g2d.getFontMetrics(g2d.getFont());
        int imageHOffset = bi.getWidth() / 2;
        int imageVOffset = bi.getHeight() / 2;
        int unleadTextHeight = metrics.getHeight() - metrics.getLeading();
        int textVOffset = unleadTextHeight / 2 + spacing;
        if (showStyleIcons) {
            g2d.drawImage(bi, null, p.x - imageHOffset, p.y - imageVOffset);
        }
        String acc = this.intToSignedString(a);
        int text1HOffset = metrics.stringWidth(acc) / 2;
        this.drawTextWithShadow(g2d, p, -text1HOffset, -textVOffset, acc);
        String def = this.intToSignedString(d);
        int text2HOffset = metrics.stringWidth(def) / 2;
        this.drawTextWithShadow(g2d, p, -text2HOffset, textVOffset + metrics.getHeight(), def);
    }

    private String intToSignedString(int i) {
        Object str = Integer.toString(i);
        if (((String)str).charAt(0) != '-' && ((String)str).charAt(0) != '0') {
            str = "+" + (String)str;
        }
        return str;
    }

    java.awt.Point nextIconPosition(java.awt.Point p) {
        p.translate(37, 0);
        return p;
    }
}

