/*
 * Decompiled with CFR 0.152.
 */
package bbp.equipmentscreenshot;

import bbp.equipmentscreenshot.EquipmentBlowpipeOverlay;
import bbp.equipmentscreenshot.EquipmentRunepouchOverlay;
import bbp.equipmentscreenshot.EquipmentScreenshotConfig;
import bbp.equipmentscreenshot.EquipmentScreenshotUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.Point;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.Text;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Equipment Screenshot", description="Takes screenshots of inventory and equipt items", tags={"items", "inventory", "equipment", "screenshot"}, enabledByDefault=false)
public class EquipmentScreenshotPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EquipmentScreenshotPlugin.class);
    private static final int INV_ROW_SIZE = 4;
    private static final int ITEM_H_SIZE = 42;
    private static final int ITEM_V_SIZE = 36;
    private static final int SPELLBOOK_VARBIT = 4070;
    private static final int COLUMN_WIDTH = 20;
    private static final Map<EquipmentInventorySlot, java.awt.Point> EQUIPMENT_ICON_LOCATIONS = new ImmutableMap.Builder().put((Object)EquipmentInventorySlot.HEAD, (Object)new java.awt.Point(77, 4)).put((Object)EquipmentInventorySlot.CAPE, (Object)new java.awt.Point(36, 43)).put((Object)EquipmentInventorySlot.AMULET, (Object)new java.awt.Point(77, 43)).put((Object)EquipmentInventorySlot.WEAPON, (Object)new java.awt.Point(21, 82)).put((Object)EquipmentInventorySlot.BODY, (Object)new java.awt.Point(77, 82)).put((Object)EquipmentInventorySlot.SHIELD, (Object)new java.awt.Point(133, 82)).put((Object)EquipmentInventorySlot.LEGS, (Object)new java.awt.Point(77, 122)).put((Object)EquipmentInventorySlot.GLOVES, (Object)new java.awt.Point(21, 162)).put((Object)EquipmentInventorySlot.BOOTS, (Object)new java.awt.Point(77, 162)).put((Object)EquipmentInventorySlot.RING, (Object)new java.awt.Point(133, 162)).put((Object)EquipmentInventorySlot.AMMO, (Object)new java.awt.Point(118, 43)).build();
    private int dartID;
    private int dartCount;
    private int scaleCount;
    private static final Pattern BLOWPIPE_REGEX = Pattern.compile("Darts: (.*)\\. Scales: ([0-9,]+) .*");
    private static final Pattern DARTS_REGEX = Pattern.compile("(.*) x ([0-9,]+)");
    private static final Map<String, Integer> DART_IDS = new ImmutableMap.Builder().put((Object)"Bronze dart", (Object)806).put((Object)"Iron dart", (Object)807).put((Object)"Steel dart", (Object)808).put((Object)"Black dart", (Object)3093).put((Object)"Mithril dart", (Object)809).put((Object)"Adamant dart", (Object)810).put((Object)"Rune dart", (Object)811).put((Object)"Amethyst dart", (Object)25849).put((Object)"Dragon dart", (Object)11230).build();
    private static final List<Integer> SNOWFLAKE_MAGIC_WEAPONS = new ImmutableList.Builder().add((Object)2416).add((Object)2415).add((Object)2417).add((Object)8841).add((Object)24181).build();
    private static final List<Integer> SNOWFLAKE_RANGED_WEAPONS = new ImmutableList.Builder().add((Object)23983).add((Object)25865).add((Object)22550).add((Object)22547).add((Object)12926).add((Object)12924).build();
    private static final List<Integer> SALAMANDERS = new ImmutableList.Builder().add((Object)10149).add((Object)10146).add((Object)10147).add((Object)10148).build();
    private static final List<Integer> THROWN_WEAPONS = new ImmutableList.Builder().add((Object)806).add((Object)807).add((Object)808).add((Object)3093).add((Object)809).add((Object)810).add((Object)811).add((Object)25849).add((Object)11230).add((Object)812).add((Object)5629).add((Object)814).add((Object)3094).add((Object)815).add((Object)816).add((Object)817).add((Object)25851).add((Object)11231).add((Object)5628).add((Object)5636).add((Object)5630).add((Object)5631).add((Object)5632).add((Object)5633).add((Object)5634).add((Object)25855).add((Object)11233).add((Object)5635).add((Object)5636).add((Object)5637).add((Object)5638).add((Object)5639).add((Object)5640).add((Object)5641).add((Object)25857).add((Object)11234).add((Object)864).add((Object)863).add((Object)865).add((Object)869).add((Object)866).add((Object)867).add((Object)868).add((Object)22804).add((Object)870).add((Object)871).add((Object)872).add((Object)874).add((Object)873).add((Object)875).add((Object)876).add((Object)22806).add((Object)5654).add((Object)5655).add((Object)5656).add((Object)5658).add((Object)5657).add((Object)5659).add((Object)5660).add((Object)22808).add((Object)5661).add((Object)5662).add((Object)5663).add((Object)5665).add((Object)5664).add((Object)5666).add((Object)5667).add((Object)22810).add((Object)800).add((Object)801).add((Object)802).add((Object)803).add((Object)804).add((Object)805).add((Object)20849).add((Object)22634).add((Object)10033).add((Object)10034).add((Object)11959).add((Object)732).add((Object)6522).build();
    private static final Map<Integer, Double> WEIGHT_REDUCING_EQUIPMENT = new ImmutableMap.Builder().put((Object)10073, (Object)2.267).put((Object)10074, (Object)4.535).put((Object)89, (Object)4.535).put((Object)10554, (Object)4.535).put((Object)13340, (Object)4.0).put((Object)13341, (Object)4.0).put((Object)13342, (Object)4.0).put((Object)11851, (Object)3.0).put((Object)11853, (Object)4.0).put((Object)11855, (Object)5.0).put((Object)11857, (Object)6.0).put((Object)11859, (Object)3.0).put((Object)11861, (Object)4.0).put((Object)13580, (Object)3.0).put((Object)13582, (Object)4.0).put((Object)13584, (Object)5.0).put((Object)13586, (Object)6.0).put((Object)13588, (Object)3.0).put((Object)13590, (Object)4.0).put((Object)13592, (Object)3.0).put((Object)13594, (Object)4.0).put((Object)13596, (Object)5.0).put((Object)13598, (Object)6.0).put((Object)13600, (Object)3.0).put((Object)13602, (Object)4.0).put((Object)13604, (Object)3.0).put((Object)13606, (Object)4.0).put((Object)13608, (Object)5.0).put((Object)13610, (Object)6.0).put((Object)13612, (Object)3.0).put((Object)13614, (Object)4.0).put((Object)13616, (Object)3.0).put((Object)13618, (Object)4.0).put((Object)13620, (Object)5.0).put((Object)13622, (Object)6.0).put((Object)13624, (Object)3.0).put((Object)13626, (Object)4.0).put((Object)13628, (Object)3.0).put((Object)13630, (Object)4.0).put((Object)13632, (Object)5.0).put((Object)13634, (Object)6.0).put((Object)13636, (Object)3.0).put((Object)13638, (Object)4.0).put((Object)13668, (Object)3.0).put((Object)13670, (Object)4.0).put((Object)13672, (Object)5.0).put((Object)13674, (Object)6.0).put((Object)13676, (Object)3.0).put((Object)13678, (Object)4.0).put((Object)21063, (Object)3.0).put((Object)21066, (Object)4.0).put((Object)21069, (Object)5.0).put((Object)21072, (Object)6.0).put((Object)21075, (Object)3.0).put((Object)21078, (Object)4.0).put((Object)24745, (Object)3.0).put((Object)24748, (Object)4.0).put((Object)24751, (Object)5.0).put((Object)24754, (Object)6.0).put((Object)24757, (Object)3.0).put((Object)24760, (Object)4.0).put((Object)25071, (Object)3.0).put((Object)25074, (Object)4.0).put((Object)25077, (Object)5.0).put((Object)25080, (Object)6.0).put((Object)25083, (Object)3.0).put((Object)25086, (Object)4.0).build();
    private static final String MENU_TARGET = "Equipment";
    private static final String TAKE_SCREENSHOT = "Screenshot";
    private static final WidgetMenuOption FIXED_EQUIPMENT_TAB_SCREENSHOT = new WidgetMenuOption("Screenshot", "Equipment", WidgetInfo.FIXED_VIEWPORT_EQUIPMENT_TAB);
    private static final WidgetMenuOption RESIZABLE_EQUIPMENT_TAB_SCREENSHOT = new WidgetMenuOption("Screenshot", "Equipment", WidgetInfo.RESIZABLE_VIEWPORT_EQUIPMENT_TAB);
    private static final WidgetMenuOption BOTTOM_LINE_INVENTORY_SCREENSHOT = new WidgetMenuOption("Screenshot", "Equipment", WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);
    private Widget button = null;
    private boolean useResourcePack = false;
    private double preciseWeight;
    private int weaponAmagic;
    private int weaponAranged;
    private int weaponSranged;
    private boolean isSalamander;
    private boolean isSnowflakeMagicWeapon;
    private int attackStyleVarbit = -1;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private EquipmentScreenshotConfig config;
    @Inject
    private MenuManager menuManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private ClientThread clientThread;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private EquipmentRunepouchOverlay equipmentRunepouchOverlay;
    @Inject
    private EquipmentBlowpipeOverlay equipmentBlowpipeOverlay;
    @Inject
    private EquipmentScreenshotUtil util;

    @Provides
    EquipmentScreenshotConfig provideConfig(ConfigManager configManager) {
        return (EquipmentScreenshotConfig)configManager.getConfig(EquipmentScreenshotConfig.class);
    }

    protected void startUp() throws Exception {
        this.menuManager.addManagedCustomMenu(FIXED_EQUIPMENT_TAB_SCREENSHOT, null);
        this.menuManager.addManagedCustomMenu(RESIZABLE_EQUIPMENT_TAB_SCREENSHOT, null);
        this.menuManager.addManagedCustomMenu(BOTTOM_LINE_INVENTORY_SCREENSHOT, null);
        this.clientThread.invokeLater(this::createButton);
        this.useResourcePack = false;
        this.dartID = 0;
        this.dartCount = 0;
        this.scaleCount = 0;
        this.attackStyleVarbit = this.client.getVarpValue(43);
    }

    protected void shutDown() throws Exception {
        this.menuManager.removeManagedCustomMenu(FIXED_EQUIPMENT_TAB_SCREENSHOT);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_EQUIPMENT_TAB_SCREENSHOT);
        this.menuManager.removeManagedCustomMenu(BOTTOM_LINE_INVENTORY_SCREENSHOT);
        this.clientThread.invoke(this::hideButton);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.RUNELITE) {
            return;
        }
        if (event.getMenuOption().equals(TAKE_SCREENSHOT)) {
            this.screenshotEquipment();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = event.getMessage();
        if (!message.startsWith("Darts: ")) {
            return;
        }
        Matcher m = BLOWPIPE_REGEX.matcher(Text.removeTags((String)message));
        if (m.find()) {
            Matcher n = DARTS_REGEX.matcher(m.group(1));
            if (n.find()) {
                this.dartID = DART_IDS.get(n.group(1));
                this.dartCount = Integer.parseInt(n.group(2).replaceAll(",", ""));
            } else {
                this.dartID = 0;
                this.dartCount = 0;
            }
            this.scaleCount = Integer.parseInt(m.group(2).replaceAll(",", ""));
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int currentAttackStyleVarbit = this.client.getVarpValue(43);
        if (this.attackStyleVarbit != currentAttackStyleVarbit) {
            this.attackStyleVarbit = currentAttackStyleVarbit;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("equipmentscreenshot") && event.getKey().equals("button")) {
            if (this.config.button()) {
                this.clientThread.invoke(this::createButton);
            } else {
                this.clientThread.invoke(this::hideButton);
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() != 387) {
            return;
        }
        this.createButton();
    }

    private BufferedImage paintInventory(BufferedImage bi) {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null || this.util.isEmpty(itemContainer)) {
            return null;
        }
        Item[] items = itemContainer.getItems();
        Graphics2D g2d = bi.createGraphics();
        for (int i = 0; i < 28; ++i) {
            BufferedImage image;
            Item item;
            if (i >= items.length || (item = items[i]).getQuantity() <= 0) continue;
            int itemId = item.getId();
            if (this.itemManager.getItemStats(itemId, false) != null && !this.itemManager.getItemComposition(itemId).isStackable()) {
                this.preciseWeight += this.itemManager.getItemStats(itemId, false).getWeight();
            }
            if ((image = this.util.getImage(item)) == null) continue;
            int x = 16 + 42 * (i % 4);
            int y = 8 + 36 * (i / 4);
            g2d.drawImage(image, null, x, y);
            if (this.config.runepouchOverlay() && (itemId == 12791 || itemId == 24416 || itemId == 27281)) {
                this.equipmentRunepouchOverlay.renderRunepouchOverlay(g2d, new Point(x, y));
            }
            if (this.config.blowpipeOverlay() && itemId == 12926) {
                this.equipmentBlowpipeOverlay.renderBlowpipeOverlay(g2d, new Point(x, y));
            }
            g2d.setFont(FontManager.getRunescapeSmallFont());
        }
        g2d.dispose();
        return bi;
    }

    private BufferedImage paintEquipment(BufferedImage bi) {
        java.awt.Point p;
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (!this.config.showEmptyEquipment() && (itemContainer == null || this.util.isEmpty(itemContainer))) {
            return null;
        }
        BufferedImage VERTICAL_RIVETS = this.util.getCroppedImageFromSpriteID(172, this.useResourcePack);
        BufferedImage HORIZONTAL_RIVETS = this.util.getCroppedImageFromSpriteID(173, this.useResourcePack);
        if (this.useResourcePack && HORIZONTAL_RIVETS.getHeight() > 6) {
            HORIZONTAL_RIVETS = HORIZONTAL_RIVETS.getSubimage(0, 0, HORIZONTAL_RIVETS.getWidth(), 6);
        }
        BufferedImage EQUIPMENT_SLOT = this.util.getCroppedImageFromSpriteID(170, this.useResourcePack);
        Graphics2D g2d = bi.createGraphics();
        this.util.tileImage(g2d, VERTICAL_RIVETS, new java.awt.Point(92, 39), new java.awt.Point(92, 163));
        this.util.tileImage(g2d, VERTICAL_RIVETS, new java.awt.Point(36, 118), new java.awt.Point(36, 163));
        this.util.tileImage(g2d, VERTICAL_RIVETS, new java.awt.Point(148, 118), new java.awt.Point(148, 163));
        this.util.tileImage(g2d, HORIZONTAL_RIVETS, new java.awt.Point(56, 96), new java.awt.Point(134, 96));
        this.util.tileImage(g2d, HORIZONTAL_RIVETS, new java.awt.Point(71, 57), new java.awt.Point(119, 57));
        ImmutableMap EQUIPMENT_ICONS = new ImmutableMap.Builder().put((Object)EquipmentInventorySlot.HEAD, (Object)this.util.getImageFromSpriteID(156, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.CAPE, (Object)this.util.getImageFromSpriteID(157, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.AMULET, (Object)this.util.getImageFromSpriteID(158, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.WEAPON, (Object)this.util.getImageFromSpriteID(159, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.BODY, (Object)this.util.getImageFromSpriteID(161, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.SHIELD, (Object)this.util.getImageFromSpriteID(162, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.LEGS, (Object)this.util.getImageFromSpriteID(163, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.GLOVES, (Object)this.util.getImageFromSpriteID(164, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.BOOTS, (Object)this.util.getImageFromSpriteID(165, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.RING, (Object)this.util.getImageFromSpriteID(160, false, this.useResourcePack)).put((Object)EquipmentInventorySlot.AMMO, (Object)this.util.getImageFromSpriteID(166, false, this.useResourcePack)).build();
        int prayer = 0;
        int str = 0;
        int rstr = 0;
        float mdmg = 0.0f;
        int stabA = 0;
        int slashA = 0;
        int crushA = 0;
        int magicA = 0;
        int rangeA = 0;
        int stabD = 0;
        int slashD = 0;
        int crushD = 0;
        int magicD = 0;
        int rangeD = 0;
        for (EquipmentInventorySlot eis : EquipmentInventorySlot.values()) {
            p = new java.awt.Point(EQUIPMENT_ICON_LOCATIONS.get(eis).getLocation());
            g2d.drawImage(EQUIPMENT_SLOT, null, p.x, p.y);
            Item item = null;
            if (itemContainer != null) {
                item = itemContainer.getItem(eis.getSlotIdx());
            }
            if (item != null && item.getQuantity() > 0) {
                BufferedImage image;
                int itemId = item.getId();
                if (this.config.showAllOptions() || this.config.showStats()) {
                    ItemStats is = this.itemManager.getItemStats(itemId, false);
                    if (is == null) {
                        log.info("Error finding item stats for the {} slot with item {} using itemID: {}", new Object[]{eis.name().toLowerCase(), this.itemManager.getItemComposition(itemId).getName(), itemId});
                        log.info("This probably means the itemID is new and not yet cached in the Runelite item stats database");
                        continue;
                    }
                    ItemEquipmentStats ies = is.getEquipment();
                    prayer += ies.getPrayer();
                    str += ies.getStr();
                    if (!eis.equals((Object)EquipmentInventorySlot.AMMO) || itemContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx()) == null || itemContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx()) != null && !THROWN_WEAPONS.contains(itemContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx()).getId()) && !SNOWFLAKE_RANGED_WEAPONS.contains(itemContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx()).getId())) {
                        rstr += ies.getRstr();
                    }
                    mdmg += (float)ies.getMdmg();
                    stabA += ies.getAstab();
                    slashA += ies.getAslash();
                    crushA += ies.getAcrush();
                    magicA += ies.getAmagic();
                    rangeA += ies.getArange();
                    stabD += ies.getDstab();
                    slashD += ies.getDslash();
                    crushD += ies.getDcrush();
                    magicD += ies.getDmagic();
                    rangeD += ies.getDrange();
                    if (eis.equals((Object)EquipmentInventorySlot.WEAPON)) {
                        this.weaponAmagic = ies.getAmagic();
                        this.weaponAranged = ies.getArange();
                        this.weaponSranged = ies.getRstr();
                        this.isSalamander = SALAMANDERS.contains(itemId);
                        this.isSnowflakeMagicWeapon = SNOWFLAKE_MAGIC_WEAPONS.contains(itemId);
                    }
                    if (this.itemManager.getItemStats(itemId, false) != null && !this.itemManager.getItemComposition(itemId).isStackable()) {
                        this.preciseWeight = WEIGHT_REDUCING_EQUIPMENT.containsKey(itemId) ? (this.preciseWeight -= WEIGHT_REDUCING_EQUIPMENT.get(itemId).doubleValue()) : (this.preciseWeight += this.itemManager.getItemStats(itemId, false).getWeight());
                    }
                }
                if ((image = this.util.getImage(item)) == null) continue;
                g2d.drawImage(image, null, p.x + 2, p.y + 2);
                if (!this.config.blowpipeOverlay() || itemId != 12926) continue;
                this.equipmentBlowpipeOverlay.renderBlowpipeOverlay(g2d, new Point(p.x, p.y));
                continue;
            }
            this.util.drawEquipmentIcon(g2d, eis, p, (Map<EquipmentInventorySlot, BufferedImage>)EQUIPMENT_ICONS, this.useResourcePack);
        }
        if (this.config.showAllOptions() || this.config.showStats()) {
            ItemStats is;
            Item weapon;
            if (itemContainer != null) {
                Item head = itemContainer.getItem(EquipmentInventorySlot.HEAD.getSlotIdx());
                Item body = itemContainer.getItem(EquipmentInventorySlot.BODY.getSlotIdx());
                Item legs = itemContainer.getItem(EquipmentInventorySlot.LEGS.getSlotIdx());
                Item gloves = itemContainer.getItem(EquipmentInventorySlot.GLOVES.getSlotIdx());
                if (!(head == null || body == null || legs == null || gloves == null || head.getId() != 11663 && head.getId() != 24183 || body.getId() != 13072 && body.getId() != 24178 || legs.getId() != 13073 && legs.getId() != 24180 || gloves.getId() != 8842 && gloves.getId() != 24182)) {
                    mdmg = (float)((double)mdmg + 2.5);
                }
            }
            if (itemContainer != null && (weapon = itemContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx())) != null && (weapon.getId() == 12926 || weapon.getId() == 12924) && this.dartID != 0 && (is = this.itemManager.getItemStats(this.dartID, false)) != null) {
                ItemEquipmentStats ies = is.getEquipment();
                rangeA += ies.getArange();
                rstr += ies.getRstr();
            }
            g2d.setFont(FontManager.getRunescapeSmallFont());
            g2d.setColor(this.config.fontColor());
            BufferedImage MACIC_ICON = this.util.getCroppedImageFromSpriteID(202, this.useResourcePack);
            BufferedImage RANGED_ICON = this.util.getCroppedImageFromSpriteID(200, this.useResourcePack);
            BufferedImage STR_ICON = this.util.getCroppedImageFromSpriteID(198, this.useResourcePack);
            BufferedImage MDMG_ICON = new BufferedImage(28, 29, STR_ICON.getType());
            Graphics2D g = MDMG_ICON.createGraphics();
            g.drawImage(STR_ICON, null, 12, 1);
            g.drawImage(MACIC_ICON, null, 0, 6);
            g.dispose();
            BufferedImage RSTR_ICON = new BufferedImage(23, 23, STR_ICON.getType());
            Graphics2D h = RSTR_ICON.createGraphics();
            h.drawImage(RANGED_ICON, null, 0, 0);
            h.drawImage(STR_ICON, null, 6, 1);
            h.dispose();
            if (this.config.showAllOptions() || this.config.showAllStr()) {
                this.util.drawIconWithText(g2d, new java.awt.Point(50, 22), MDMG_ICON, 1, mdmg + "%", true);
                this.util.drawIconWithText(g2d, new java.awt.Point(170, 62), RSTR_ICON, 2, rstr, true);
                this.util.drawIconWithText(g2d, new java.awt.Point(19, 62), STR_ICON, 2, str, true);
            } else if (this.weaponAmagic >= 10 || this.isSnowflakeMagicWeapon || this.isSalamander && this.attackStyleVarbit == 2) {
                this.util.drawIconWithText(g2d, new java.awt.Point(50, 22), MDMG_ICON, 1, mdmg + "%", true);
            } else if (!this.isSalamander && (this.weaponAranged > 0 || this.weaponSranged > 0) || this.isSalamander && this.attackStyleVarbit == 1) {
                this.util.drawIconWithText(g2d, new java.awt.Point(50, 23), RSTR_ICON, 2, rstr, true);
            } else {
                this.util.drawIconWithText(g2d, new java.awt.Point(50, 23), STR_ICON, 2, str, true);
            }
            int spellBookID = 780;
            String spellbook = "Modern";
            switch (this.client.getVarbitValue(4070)) {
                case 1: {
                    spellBookID = 1583;
                    spellbook = "Ancient";
                    break;
                }
                case 2: {
                    spellBookID = 1584;
                    spellbook = "Lunar";
                    break;
                }
                case 3: {
                    spellBookID = 1711;
                    spellbook = "Arceuus";
                }
            }
            if (!this.config.showAllOptions() && !this.config.writeSpellbook()) {
                spellbook = "";
            }
            this.util.drawIconWithText(g2d, new java.awt.Point(136, 23), spellBookID, this.useResourcePack, 2, spellbook, false);
            if (this.config.showAllOptions() || this.config.showPrayerAndWeight()) {
                this.preciseWeight = new BigDecimal(this.preciseWeight).setScale(3, RoundingMode.HALF_UP).doubleValue();
                String weight = Double.toString(this.config.showAllOptions() || this.config.showPreciseWeight() ? this.preciseWeight : (double)this.client.getWeight());
                this.util.drawIconWithText(g2d, new java.awt.Point(59, 139), 649, this.useResourcePack, 2, weight, false);
                this.util.drawIconWithText(g2d, new java.awt.Point(130, 139), 201, this.useResourcePack, 2, prayer, true);
            }
            AsyncBufferedImage STAB_ICON = this.itemManager.getImage(1207);
            AsyncBufferedImage SLASH_ICON = this.itemManager.getImage(1325);
            AsyncBufferedImage CRUSH_ICON = this.itemManager.getImage(1339);
            p = new java.awt.Point(21, 228);
            this.util.drawStatIcon(g2d, p, (BufferedImage)STAB_ICON, stabA, stabD);
            this.util.drawStatIcon(g2d, this.util.nextIconPosition(p), (BufferedImage)SLASH_ICON, slashA, slashD);
            this.util.drawStatIcon(g2d, this.util.nextIconPosition(p), (BufferedImage)CRUSH_ICON, crushA, crushD);
            this.util.drawStatIcon(g2d, this.util.nextIconPosition(p), MACIC_ICON, magicA, magicD);
            this.util.drawStatIcon(g2d, this.util.nextIconPosition(p), RANGED_ICON, rangeA, rangeD);
        }
        g2d.dispose();
        return bi;
    }

    private void screenshotEquipment() {
        this.useResourcePack = this.config.useResourcePack() && this.isResourcePackActive();
        this.preciseWeight = 0.0;
        BufferedImage bi = this.util.getCroppedImageFromSpriteID(1031, this.useResourcePack);
        BufferedImage beq = this.util.copy(bi);
        BufferedImage binv = this.paintInventory(bi);
        BufferedImage beqpw = this.paintEquipment(beq);
        BufferedImage frankensteinsMonster = null;
        if (binv != null) {
            if (beqpw != null) {
                int columnWidth = this.config.columnBetween() ? 20 : 0;
                frankensteinsMonster = new BufferedImage(2 * binv.getWidth() + columnWidth, binv.getHeight(), 1);
                Graphics2D g2d = frankensteinsMonster.createGraphics();
                g2d.drawImage((Image)binv, 0, 0, null);
                if (this.config.columnBetween()) {
                    BufferedImage column = this.util.getCroppedImageFromSpriteID(1035, this.useResourcePack).getSubimage(0, 0, 20, binv.getHeight());
                    g2d.drawImage((Image)column, binv.getWidth(), 0, null);
                }
                g2d.drawImage((Image)beqpw, binv.getWidth() + columnWidth, 0, null);
                g2d.dispose();
            } else {
                frankensteinsMonster = binv;
            }
        } else if (beqpw != null) {
            frankensteinsMonster = beqpw;
        }
        if (frankensteinsMonster != null) {
            this.imageCapture.takeScreenshot(frankensteinsMonster, "Equipment-", this.config.notifyWhenTaken(), this.config.uploadScreenshot());
        }
    }

    private boolean isResourcePackActive() {
        String str = this.configManager.getConfiguration("runelite", "resourcepacksplugin");
        if (str == null || str.equals("false") || str.isEmpty()) {
            return false;
        }
        str = this.configManager.getConfiguration("resourcepacks", "resourcePack");
        if (str == null || str.isEmpty()) {
            return false;
        }
        switch (str) {
            case "HUB": {
                str = this.configManager.getConfiguration("resourcepacks", "selectedHubPack");
                if (str == null || str.isEmpty()) break;
                return true;
            }
            case "FIRST": {
                str = this.configManager.getConfiguration("resourcepacks", "resourcePackPath");
                if (str == null || str.isEmpty()) break;
                return true;
            }
            case "SECOND": {
                str = this.configManager.getConfiguration("resourcepacks", "resourcePack2Path");
                if (str == null || str.isEmpty()) break;
                return true;
            }
            case "THIRD": {
                str = this.configManager.getConfiguration("resourcepacks", "resourcePack3Path");
                if (str == null || str.isEmpty()) break;
                return true;
            }
        }
        return false;
    }

    private void hideButton() {
        if (this.button == null) {
            return;
        }
        this.button.setHidden(true);
        this.button = null;
    }

    private void createButton() {
        if (!this.config.button()) {
            return;
        }
        Widget parent = this.client.getWidget(WidgetInfo.EQUIPMENT);
        if (parent == null) {
            return;
        }
        this.hideButton();
        this.button = parent.createChild(-1, 5);
        this.button.setOriginalHeight(20);
        this.button.setOriginalWidth(20);
        this.button.setOriginalX(48);
        this.button.setOriginalY(14);
        this.button.setSpriteId(573);
        this.button.setAction(0, TAKE_SCREENSHOT);
        this.button.setOnOpListener(new Object[]{e -> this.clientThread.invokeLater(this::screenshotEquipment)});
        this.button.setHasListener(true);
        this.button.revalidate();
        this.button.setOnMouseOverListener(new Object[]{e -> this.button.setSpriteId(570)});
        this.button.setOnMouseLeaveListener(new Object[]{e -> this.button.setSpriteId(573)});
    }

    public int getDartID() {
        return this.dartID;
    }

    public int getDartCount() {
        return this.dartCount;
    }

    public int getScaleCount() {
        return this.scaleCount;
    }
}

