/*
 * Decompiled with CFR 0.152.
 */
package bbp.equipmentscreenshot;

import bbp.equipmentscreenshot.EquipmentScreenshotConfig;
import bbp.equipmentscreenshot.EquipmentScreenshotUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.Point;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.AsyncBufferedImage;

class EquipmentRunepouchOverlay {
    private static final int NUM_SLOTS = 4;
    private static final int[] AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
    private static final int[] RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};
    private static final Dimension IMAGE_SIZE = new Dimension(11, 11);
    private BufferedImage[] runeIcons = new BufferedImage[0];
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private EquipmentScreenshotConfig config;
    @Inject
    private EquipmentScreenshotUtil util;

    EquipmentRunepouchOverlay() {
    }

    void renderRunepouchOverlay(Graphics2D graphics, Point location) {
        boolean showIcons = true;
        if (this.configManager.getConfiguration("runepouch", "runeicons", Boolean.class) != null) {
            showIcons = (Boolean)this.configManager.getConfiguration("runepouch", "runeicons", Boolean.class);
        }
        int[] runeIds = new int[4];
        int[] amounts = new int[4];
        EnumComposition runepouchEnum = this.client.getEnum(982);
        int num = 0;
        for (int i = 0; i < 4; ++i) {
            int runeId;
            int amount;
            int amountVarbit = AMOUNT_VARBITS[i];
            amounts[i] = amount = this.client.getVarbitValue(amountVarbit);
            int runeVarbit = RUNE_VARBITS[i];
            runeIds[i] = runeId = this.client.getVarbitValue(runeVarbit);
            if (runeId == 0 || amount <= 0) continue;
            ++num;
        }
        if (num == 0) {
            return;
        }
        if (num < 4) {
            this.renderList(graphics, location, runepouchEnum, runeIds, amounts);
        } else {
            this.renderGrid(graphics, location, runepouchEnum, runeIds, amounts);
        }
    }

    private void renderList(Graphics2D graphics, Point location, EnumComposition runepouchEnum, int[] runeIds, int[] amounts) {
        graphics.setFont(FontManager.getRunescapeSmallFont());
        int runeNum = -1;
        for (int i = 0; i < 4; ++i) {
            int runeId = runeIds[i];
            int amount = amounts[i];
            if (runeId == 0 || amount <= 0) continue;
            String text = EquipmentRunepouchOverlay.formatNumber(amount);
            int textX = location.getX() + 11;
            int textY = location.getY() + 12 + (graphics.getFontMetrics().getHeight() - 1) * ++runeNum;
            graphics.setColor(Color.BLACK);
            graphics.drawString(text, textX + 1, textY + 1);
            graphics.setColor(this.config.fontColor());
            graphics.drawString(text, textX, textY);
            BufferedImage image = this.getRuneImage(runepouchEnum, runeId);
            if (image == null) continue;
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)new Point(location.getX() - 1, location.getY() + graphics.getFontMetrics().getHeight() * runeNum - 1), (BufferedImage)image);
        }
    }

    private void renderGrid(Graphics2D graphics, Point location, EnumComposition runepouchEnum, int[] runeIds, int[] amounts) {
        for (int i = 0; i < 4; ++i) {
            Color color;
            int height;
            int runeId = runeIds[i];
            int amount = amounts[i];
            if (runeId == -1 || amount <= 0) continue;
            int iconX = location.getX() + 2 + (i == 1 || i == 3 ? EquipmentRunepouchOverlay.IMAGE_SIZE.width + 2 + 2 : 0);
            int iconY = location.getY() + 5 + (i >= 2 ? EquipmentRunepouchOverlay.IMAGE_SIZE.height + 2 : 0);
            BufferedImage image = this.getRuneImage(runepouchEnum, runeId);
            if (image != null) {
                OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)new Point(iconX, iconY), (BufferedImage)image);
            }
            if (amount < 1000) {
                height = amount / 100;
                color = Color.RED;
            } else {
                height = Math.min(10, amount / 1000);
                color = Color.GREEN;
            }
            graphics.setColor(color);
            graphics.fillRect(iconX + EquipmentRunepouchOverlay.IMAGE_SIZE.width, iconY + 1 + (10 - height), 2, height);
        }
    }

    private BufferedImage getRuneImage(EnumComposition runepouchEnum, int runeId) {
        if (runeId < this.runeIcons.length && this.runeIcons[runeId] != null) {
            return this.runeIcons[runeId];
        }
        AsyncBufferedImage runeImg = this.itemManager.getImage(runepouchEnum.getIntValue(runeId));
        if (runeImg == null) {
            return null;
        }
        BufferedImage resizedImg = new BufferedImage(EquipmentRunepouchOverlay.IMAGE_SIZE.width, EquipmentRunepouchOverlay.IMAGE_SIZE.height, 2);
        Graphics2D g = resizedImg.createGraphics();
        g.drawImage((Image)runeImg, 0, 0, EquipmentRunepouchOverlay.IMAGE_SIZE.width, EquipmentRunepouchOverlay.IMAGE_SIZE.height, null);
        g.dispose();
        if (runeId >= this.runeIcons.length) {
            this.runeIcons = Arrays.copyOf(this.runeIcons, runeId + 1);
        }
        this.runeIcons[runeId] = resizedImg;
        return resizedImg;
    }

    private static String formatNumber(int amount) {
        return amount < 1000 ? String.valueOf(amount) : amount / 1000 + "K";
    }
}

